/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.types;

import de.desy.tine.endianUtils.Swap;
import de.desy.tine.types.TCompoundDataObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class FLTFLTINT
implements TCompoundDataObject {
    public float f1val;
    public float f2val;
    public int ival;
    public static final int sizeInBytes = 12;
    public static final short dFormat = 25;
    ByteArrayOutputStream dBuffer = new ByteArrayOutputStream(12);
    public byte[] hByteArray;

    public double getDoubleValue() {
        return this.f1val;
    }

    public int getIntegerValue() {
        return this.ival;
    }

    public void setValues(float newF1Value, float newF2Value, int newIValue) {
        this.ival = newIValue;
        this.f1val = newF1Value;
        this.f2val = newF2Value;
    }

    public int getSizeInBytes() {
        return 12;
    }

    public short getFormat() {
        return 25;
    }

    public void setByteArray(byte[] byteArray) {
        this.hByteArray = byteArray;
    }

    public byte[] getByteArray() {
        return this.hByteArray;
    }

    public FLTFLTINT() {
        this.f1val = 0.0f;
        this.f2val = 0.0f;
        this.ival = 0;
    }

    public FLTFLTINT(float f) {
        this.f1val = f;
        this.f2val = 0.0f;
        this.ival = 0;
    }

    public FLTFLTINT(int i) {
        this.f1val = 0.0f;
        this.f2val = 0.0f;
        this.ival = i;
    }

    public FLTFLTINT(float f1, float f2, int i) {
        this.f1val = f1;
        this.f2val = f2;
        this.ival = i;
    }

    public FLTFLTINT(FLTFLTINT instance) {
        this.f1val = instance.f1val;
        this.f2val = instance.f2val;
        this.ival = instance.ival;
    }

    public String toString() {
        return "[" + this.f1val + ", " + this.f2val + ", " + this.ival + "]";
    }

    public boolean equals(FLTFLTINT instance) {
        if (instance.ival != this.ival) {
            return false;
        }
        if (instance.f1val != this.f1val) {
            return false;
        }
        return instance.f2val == this.f2val;
    }

    public byte[] toByteArray() {
        try {
            this.dBuffer.reset();
            DataOutputStream ds = new DataOutputStream(this.dBuffer);
            byte[] b = Swap.Float(this.f1val);
            ds.write(b, 0, 4);
            b = Swap.Float(this.f2val);
            ds.write(b, 0, 4);
            ds.writeInt(Swap.Long(this.ival));
            ds.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.hByteArray = this.dBuffer.toByteArray();
        return this.hByteArray;
    }

    public void toStruct() {
        try {
            ByteArrayInputStream dis = new ByteArrayInputStream(this.hByteArray);
            DataInputStream ds = new DataInputStream(dis);
            byte[] b = new byte[4];
            ds.read(b, 0, 4);
            this.f1val = Swap.Float(b);
            ds.read(b, 0, 4);
            this.f2val = Swap.Float(b);
            this.ival = Swap.Long(ds.readInt());
            ds.close();
            dis.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + Float.floatToIntBits(this.f1val);
        result = 31 * result + Float.floatToIntBits(this.f2val);
        result = 31 * result + this.ival;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FLTFLTINT other = (FLTFLTINT)obj;
        return this.equals(other);
    }
}

