/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.traceUtils;

import de.desy.tine.structUtils.TTaggedStructure;

public class TTraceHeader
extends TTaggedStructure {
    private char[] nam = new char[64];
    private String namString = null;
    private char[] dsc = new char[256];
    private String dscString = null;
    private int[] fmt = new int[1];
    private int[] siz = new int[1];
    private int[] preTrigger = new int[1];
    private float[] scaleX = new float[1];
    private float[] offsetX = new float[1];
    private char[] unitsX = new char[16];
    private String unitsXString = null;
    private float[] plotMaxY = new float[1];
    private float[] plotMinY = new float[1];
    private char[] unitsY = new char[16];
    private String unitsYString = null;
    private byte[] reserved = new byte[256];

    private String charsToString(char[] c) {
        boolean done = false;
        for (int i = 0; i < c.length; ++i) {
            if (c[i] != '\u0000' && !done) continue;
            done = true;
            c[i] = '\u0000';
        }
        return new String(c).trim();
    }

    private void initStructure() {
        this.addField(this.nam, "channelName");
        this.addField(this.dsc, "channelDesc");
        this.addField(this.fmt, "dataFormat");
        this.addField(this.siz, "arraySize");
        this.addField(this.preTrigger, "preTrigger");
        this.addField(this.scaleX, "scaleX");
        this.addField(this.offsetX, "offsetX");
        this.addField(this.unitsX, "unitsX");
        this.addField(this.plotMaxY, "plotMaxY");
        this.addField(this.plotMinY, "plotMinY");
        this.addField(this.unitsY, "unitsY");
        this.addField(this.reserved, "reserved");
        this.initDone();
    }

    TTraceHeader() {
        super("TraceHS");
        this.initStructure();
    }

    public String getChannelName() {
        if (this.namString == null) {
            this.namString = this.charsToString(this.nam);
        }
        return this.namString;
    }

    public String getChannelDescription() {
        if (this.dscString == null) {
            this.dscString = this.charsToString(this.dsc);
        }
        return this.dscString;
    }

    public int getPreTrigger() {
        return this.preTrigger[0];
    }

    public float getXScaleFactor() {
        return this.scaleX[0];
    }

    public float getXOffset() {
        return this.offsetX[0];
    }

    public String getXUnits() {
        if (this.unitsXString == null) {
            this.unitsXString = this.charsToString(this.unitsX);
        }
        return this.unitsXString;
    }

    public float getYPlotMaxmimum() {
        return this.plotMaxY[0];
    }

    public float getYPlotMinimum() {
        return this.plotMinY[0];
    }

    public String getYUnits() {
        if (this.unitsYString == null) {
            this.unitsYString = this.charsToString(this.unitsY);
        }
        return this.unitsYString;
    }

    public int getTraceLength() {
        return this.siz[0];
    }

    public short getDataFormat() {
        return (short)this.fmt[0];
    }
}

