/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.structUtils;

import de.desy.tine.definitions.TFormat;
import de.desy.tine.endianUtils.Swap;
import de.desy.tine.server.logger.MsgLog;
import de.desy.tine.structUtils.TString;
import de.desy.tine.structUtils.TStructRegistry;
import de.desy.tine.types.TCompoundDataObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class TTaggedStructure
implements Cloneable {
    private String structName;
    private boolean registered = false;
    private int sizeInBytes;
    private ArrayList<structField> fieldArrayList = null;
    private static int indent = 0;

    public Object clone() {
        Object o = null;
        try {
            o = super.clone();
        }
        catch (CloneNotSupportedException e) {
            System.err.println("TTaggedStructure cannot clone: " + e);
        }
        return o;
    }

    public TTaggedStructure(String name) {
        this.structName = new String(name);
        this.fieldArrayList = new ArrayList();
        if (TStructRegistry.contains(this.structName)) {
            this.registered = true;
            this.sizeInBytes = TStructRegistry.getSizeInBytes(this.structName);
        } else {
            this.sizeInBytes = 0;
        }
    }

    public TTaggedStructure() {
        String name = this.getClass().getName();
        StringTokenizer t = new StringTokenizer(name, ".$");
        String lastToken = name;
        while (t.hasMoreTokens()) {
            lastToken = t.nextToken();
        }
        this.structName = new String(lastToken);
        this.fieldArrayList = new ArrayList();
        if (TStructRegistry.contains(this.structName)) {
            this.registered = true;
            this.sizeInBytes = TStructRegistry.getSizeInBytes(this.structName);
        } else {
            this.sizeInBytes = 0;
        }
    }

    public String getName() {
        return this.structName;
    }

    public int getSizeInBytes() {
        return this.sizeInBytes;
    }

    public byte[] toByteArray() {
        ByteArrayOutputStream boas = new ByteArrayOutputStream(this.getSizeInBytes());
        boas.reset();
        DataOutputStream ds = new DataOutputStream(boas);
        try {
            for (int i = 0; i < this.fieldArrayList.size(); ++i) {
                this.fieldArrayList.get(i).writeToOutputStream(ds);
            }
            ds.close();
        }
        catch (IOException e) {
            MsgLog.log("TTaggedStructure", "---Internal error: can not convert TaggedStructure: " + this.getName() + " to byte array ", 66, e, 0);
            e.printStackTrace();
            return null;
        }
        return boas.toByteArray();
    }

    public byte[] getByteArray() {
        return this.toByteArray();
    }

    public void toStruct(byte[] data) {
        ByteArrayInputStream dis = new ByteArrayInputStream(data);
        DataInputStream ds = new DataInputStream(dis);
        try {
            for (int i = 0; i < this.fieldArrayList.size(); ++i) {
                this.fieldArrayList.get(i).readFromInputStream(ds);
            }
            ds.close();
            dis.close();
        }
        catch (IOException e) {
            MsgLog.log("TTaggedStructure", "---Internal error: can not convert input data stream to TaggedStructure: " + this.getName(), 66, e, 0);
            e.printStackTrace();
        }
    }

    public synchronized String toString() {
        int i;
        StringBuffer sb = new StringBuffer("");
        String indentString = new String("");
        indent += 3;
        for (i = 0; i < indent; ++i) {
            indentString = indentString + " ";
        }
        sb.append("\n" + indentString + "Struct: " + this.getName() + "\n");
        sb.append(indentString + "{\n");
        for (i = 0; i < this.fieldArrayList.size(); ++i) {
            structField sf = this.fieldArrayList.get(i);
            sb.append(indentString + " " + sf.getName() + " ->");
            sb.append(sf.toString());
            sb.append("\n");
        }
        sb.append(indentString + "}");
        indent -= 3;
        return sb.toString();
    }

    public void initDone() {
        if (!this.registered) {
            TStructRegistry.fill(this.structName, (short)255, 1);
            this.registered = true;
        }
    }

    public void addField(byte[] field, String fieldName) {
        this.fieldArrayList.add(new byteArrayField(field, fieldName));
        if (!this.registered) {
            TStructRegistry.fill(this.structName, fieldName, (short)2, field.length);
            this.sizeInBytes += field.length;
        }
    }

    public void addField(char[] field, String fieldName) {
        this.fieldArrayList.add(new charArrayField(field, fieldName));
        if (!this.registered) {
            TStructRegistry.fill(this.structName, fieldName, (short)4, field.length);
            this.sizeInBytes += field.length;
        }
    }

    public void addField(short[] field, String fieldName) {
        this.fieldArrayList.add(new shortArrayField(field, fieldName));
        if (!this.registered) {
            TStructRegistry.fill(this.structName, fieldName, (short)1, field.length);
            this.sizeInBytes += field.length * TFormat.formatSizeOf((short)1);
        }
    }

    public void addField(int[] field, String fieldName) {
        this.fieldArrayList.add(new intArrayField(field, fieldName));
        if (this.registered) {
            return;
        }
        TStructRegistry.fill(this.structName, fieldName, (short)3, field.length);
        this.sizeInBytes += field.length * TFormat.formatSizeOf((short)3);
    }

    public void addField(float[] field, String fieldName) {
        this.fieldArrayList.add(new floatArrayField(field, fieldName));
        if (this.registered) {
            return;
        }
        TStructRegistry.fill(this.structName, fieldName, (short)5, field.length);
        this.sizeInBytes += field.length * TFormat.formatSizeOf((short)5);
    }

    public void addField(double[] field, String fieldName) {
        this.fieldArrayList.add(new doubleArrayField(field, fieldName));
        if (this.registered) {
            return;
        }
        TStructRegistry.fill(this.structName, fieldName, (short)0, field.length);
        this.sizeInBytes += field.length * TFormat.formatSizeOf((short)0);
    }

    public void addField(long[] field, String fieldName) {
        this.fieldArrayList.add(new longArrayField(field, fieldName));
        if (this.registered) {
            return;
        }
        TStructRegistry.fill(this.structName, fieldName, (short)6, field.length);
        this.sizeInBytes += field.length * TFormat.formatSizeOf((short)6);
    }

    public void addField(TString field, String fieldName) {
        this.fieldArrayList.add(new TStringField(field, fieldName));
        if (!this.registered) {
            TStructRegistry.fill(this.structName, fieldName, (short)4, field.getCapacity());
            this.sizeInBytes += field.getCapacity();
        }
    }

    public void addField(StringBuffer field, String fieldName) {
        this.fieldArrayList.add(new StringBufferField(field, fieldName));
        if (!this.registered) {
            TStructRegistry.fill(this.structName, fieldName, (short)4, field.capacity());
            this.sizeInBytes += field.capacity();
        }
    }

    public void addField(TCompoundDataObject field, String fieldName) {
        this.fieldArrayList.add(new TCompoundDataField(field, fieldName));
        if (!this.registered) {
            TStructRegistry.fill(this.structName, fieldName, field.getFormat(), 1);
            this.sizeInBytes += field.getSizeInBytes();
        }
    }

    public void addField(TCompoundDataObject[] field, String fieldName) {
        this.fieldArrayList.add(new TCompoundDataArrayField(field, fieldName));
        if (!this.registered) {
            TStructRegistry.fill(this.structName, fieldName, field[0].getFormat(), field.length);
            this.sizeInBytes += field[0].getSizeInBytes() * field.length;
        }
    }

    public void addField(TTaggedStructure field, String fieldName) {
        int size = TStructRegistry.getSizeInBytes(field.getName());
        if (size < 1) {
            MsgLog.log("TTaggedStructure", "---Error: attempt to register a field: " + fieldName + " of unknown data type: " + field.getName(), 66, null, 0);
            return;
        }
        this.fieldArrayList.add(new TaggedStructureField(field, fieldName));
        if (!this.registered) {
            TStructRegistry.fill(this.structName, fieldName, (short)7, size);
            this.sizeInBytes += size;
        }
    }

    public void addField(TTaggedStructure[] field, String fieldName) {
        int size = TStructRegistry.getSizeInBytes(field[0].getName());
        if (size < 1) {
            MsgLog.log("TTaggedStructure", "attempt to register a field: " + fieldName + " being an array of unknown data type: " + field[0].getName(), 66, null, 0);
            return;
        }
        size *= field.length;
        this.fieldArrayList.add(new TaggedStructureArrayField(field, fieldName));
        if (!this.registered) {
            TStructRegistry.fill(this.structName, fieldName, (short)7, size);
            this.sizeInBytes += size;
        }
    }

    private class TaggedStructureArrayField
    extends structField {
        TTaggedStructure[] data;

        TaggedStructureArrayField(TTaggedStructure[] data, String name) {
            this.setName(name);
            this.data = data;
        }

        void readFromInputStream(DataInputStream ds) throws IOException {
            byte[] buffer = new byte[this.data[0].getSizeInBytes()];
            for (int i = 0; i < this.data.length; ++i) {
                ds.read(buffer);
                this.data[i].toStruct(buffer);
            }
        }

        void writeToOutputStream(DataOutputStream ds) throws IOException {
            for (int i = 0; i < this.data.length; ++i) {
                ds.write(this.data[i].toByteArray());
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("");
            for (int i = 0; i < this.data.length; ++i) {
                sb.append(" " + this.data[i]);
            }
            return sb.toString();
        }
    }

    private class TaggedStructureField
    extends structField {
        TTaggedStructure data;

        TaggedStructureField(TTaggedStructure data, String name) {
            this.setName(name);
            this.data = data;
        }

        void readFromInputStream(DataInputStream ds) throws IOException {
            byte[] buffer = new byte[this.data.getSizeInBytes()];
            ds.read(buffer);
            this.data.toStruct(buffer);
        }

        void writeToOutputStream(DataOutputStream ds) throws IOException {
            ds.write(this.data.toByteArray());
        }

        public String toString() {
            return this.data.toString();
        }
    }

    private class TCompoundDataArrayField
    extends structField {
        TCompoundDataObject[] data;

        TCompoundDataArrayField(TCompoundDataObject[] data, String name) {
            this.setName(name);
            this.data = data;
        }

        void readFromInputStream(DataInputStream ds) throws IOException {
            for (int i = 0; i < this.data.length; ++i) {
                byte[] b = this.data[i].getByteArray();
                ds.read(b);
                this.data[i].toStruct();
            }
        }

        void writeToOutputStream(DataOutputStream ds) throws IOException {
            for (int i = 0; i < this.data.length; ++i) {
                ds.write(this.data[i].toByteArray());
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("");
            for (int i = 0; i < this.data.length; ++i) {
                sb.append(" " + this.data[i]);
            }
            return sb.toString();
        }
    }

    private class TCompoundDataField
    extends structField {
        TCompoundDataObject data;

        TCompoundDataField(TCompoundDataObject data, String name) {
            this.setName(name);
            this.data = data;
        }

        void readFromInputStream(DataInputStream ds) throws IOException {
            byte[] b = this.data.getByteArray();
            ds.read(b);
            this.data.toStruct();
        }

        void writeToOutputStream(DataOutputStream ds) throws IOException {
            ds.write(this.data.toByteArray());
        }

        public String toString() {
            return this.data.toString();
        }
    }

    private class StringBufferField
    extends structField {
        StringBuffer data;

        StringBufferField(StringBuffer data, String name) {
            this.setName(name);
            this.data = data;
        }

        void readFromInputStream(DataInputStream ds) throws IOException {
            for (int i = 0; i < this.data.capacity(); ++i) {
                this.data.setCharAt(i, (char)ds.readByte());
            }
        }

        void writeToOutputStream(DataOutputStream ds) throws IOException {
            for (int i = 0; i < this.data.capacity(); ++i) {
                ds.writeByte((byte)this.data.charAt(i));
            }
        }

        public String toString() {
            return this.data.toString();
        }
    }

    private class TStringField
    extends structField {
        TString data;

        TStringField(TString data, String name) {
            this.setName(name);
            this.data = data;
        }

        void readFromInputStream(DataInputStream ds) throws IOException {
            byte[] b = new byte[this.data.getCapacity()];
            ds.read(b);
            this.data.set(b);
        }

        void writeToOutputStream(DataOutputStream ds) throws IOException {
            ds.write(this.data.getBytes());
        }

        public String toString() {
            return this.data.toString();
        }
    }

    private class longArrayField
    extends structField {
        long[] data;

        longArrayField(long[] data, String name) {
            this.setName(name);
            this.data = data;
        }

        void readFromInputStream(DataInputStream ds) throws IOException {
            byte[] buffer = new byte[8];
            for (int i = 0; i < this.data.length; ++i) {
                ds.read(buffer);
                this.data[i] = Swap.DLong(buffer);
            }
        }

        void writeToOutputStream(DataOutputStream ds) throws IOException {
            for (int i = 0; i < this.data.length; ++i) {
                ds.writeLong(Swap.DLong(this.data[i]));
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("");
            for (int i = 0; i < this.data.length; ++i) {
                sb.append(" " + this.data[i]);
            }
            return sb.toString();
        }
    }

    private class doubleArrayField
    extends structField {
        double[] data;

        doubleArrayField(double[] data, String name) {
            this.setName(name);
            this.data = data;
        }

        void readFromInputStream(DataInputStream ds) throws IOException {
            byte[] buffer = new byte[8];
            for (int i = 0; i < this.data.length; ++i) {
                ds.read(buffer);
                this.data[i] = Swap.Double(buffer);
            }
        }

        void writeToOutputStream(DataOutputStream ds) throws IOException {
            for (int i = 0; i < this.data.length; ++i) {
                ds.write(Swap.Double(this.data[i]));
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("");
            for (int i = 0; i < this.data.length; ++i) {
                sb.append(" " + this.data[i]);
            }
            return sb.toString();
        }
    }

    private class floatArrayField
    extends structField {
        float[] data;

        floatArrayField(float[] data, String name) {
            this.setName(name);
            this.data = data;
        }

        void readFromInputStream(DataInputStream ds) throws IOException {
            byte[] buffer = new byte[4];
            for (int i = 0; i < this.data.length; ++i) {
                ds.read(buffer);
                this.data[i] = Swap.Float(buffer);
            }
        }

        void writeToOutputStream(DataOutputStream ds) throws IOException {
            for (int i = 0; i < this.data.length; ++i) {
                ds.write(Swap.Float(this.data[i]));
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("");
            for (int i = 0; i < this.data.length; ++i) {
                sb.append(" " + this.data[i]);
            }
            return sb.toString();
        }
    }

    private class intArrayField
    extends structField {
        int[] data;

        intArrayField(int[] data, String name) {
            this.setName(name);
            this.data = data;
        }

        void readFromInputStream(DataInputStream ds) throws IOException {
            for (int i = 0; i < this.data.length; ++i) {
                this.data[i] = Swap.Long(ds.readInt());
            }
        }

        void writeToOutputStream(DataOutputStream ds) throws IOException {
            for (int i = 0; i < this.data.length; ++i) {
                ds.writeInt(Swap.Long(this.data[i]));
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("");
            for (int i = 0; i < this.data.length; ++i) {
                sb.append(" " + this.data[i]);
            }
            return sb.toString();
        }
    }

    private class shortArrayField
    extends structField {
        short[] data;

        shortArrayField(short[] data, String name) {
            this.setName(name);
            this.data = data;
        }

        void readFromInputStream(DataInputStream ds) throws IOException {
            for (int i = 0; i < this.data.length; ++i) {
                this.data[i] = Swap.Short(ds.readShort());
            }
        }

        void writeToOutputStream(DataOutputStream ds) throws IOException {
            for (int i = 0; i < this.data.length; ++i) {
                ds.writeShort(Swap.Short(this.data[i]));
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("");
            for (int i = 0; i < this.data.length; ++i) {
                sb.append(" " + this.data[i]);
            }
            return sb.toString();
        }
    }

    private class charArrayField
    extends structField {
        char[] data;

        charArrayField(char[] data, String name) {
            this.setName(name);
            this.data = data;
        }

        void readFromInputStream(DataInputStream ds) throws IOException {
            for (int i = 0; i < this.data.length; ++i) {
                this.data[i] = (char)ds.readByte();
            }
        }

        void writeToOutputStream(DataOutputStream ds) throws IOException {
            for (int i = 0; i < this.data.length; ++i) {
                ds.writeByte((byte)this.data[i]);
            }
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("");
            for (int i = 0; i < this.data.length && this.data[i] != '\u0000'; ++i) {
                sb.append(this.data[i]);
            }
            return sb.toString().trim();
        }
    }

    private class byteArrayField
    extends structField {
        byte[] data;

        byteArrayField(byte[] data, String name) {
            this.setName(name);
            this.data = data;
        }

        void readFromInputStream(DataInputStream ds) throws IOException {
            ds.read(this.data, 0, this.data.length);
        }

        void writeToOutputStream(DataOutputStream ds) throws IOException {
            ds.write(this.data, 0, this.data.length);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer("");
            for (int i = 0; i < this.data.length; ++i) {
                int ibyte = this.data[i];
                if (ibyte < 0) {
                    ibyte += 256;
                }
                sb.append(" " + ibyte);
            }
            return sb.toString();
        }
    }

    private abstract class structField {
        private String name;

        private structField() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        abstract void writeToOutputStream(DataOutputStream var1) throws IOException;

        abstract void readFromInputStream(DataInputStream var1) throws IOException;

        public abstract String toString();
    }
}

