/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.structUtils;

import de.desy.tine.definitions.TFormat;
import de.desy.tine.endianUtils.SwapUtil;
import de.desy.tine.types.INTINT;
import de.desy.tine.types.NAME16II;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;

public class TStructDescription {
    private String tagName = "";
    private int rawLength = 0;
    private int size = 0;
    private int arraySize;
    private ArrayList<Field> myFields = new ArrayList();
    boolean fieldsComplete = false;

    public TStructDescription(String newTagName) {
        this.tagName = newTagName;
    }

    public void addField(short format, int arraySize) {
        this.addField("", format, arraySize);
    }

    public void addField(String name, short format, int arraySize) {
        if (!this.fieldsComplete) {
            Field newField = new Field(name, arraySize, format, this.rawLength, this.rawLength);
            this.rawLength += arraySize * TFormat.formatSizeOf(format);
            this.size = this.rawLength;
            this.myFields.add(newField);
        }
    }

    public void addField(int num, short format, int arraySize) {
        for (int i = 0; i < num; ++i) {
            this.addField(format, arraySize);
        }
    }

    private void clear() {
        this.arraySize = 0;
        this.rawLength = 0;
        this.fieldsComplete = false;
        this.size = 0;
        this.myFields.clear();
    }

    public void beginDefinition() {
        this.clear();
    }

    public void endDefinition() {
        this.fieldsComplete = true;
    }

    public int getArraySize() {
        return this.arraySize;
    }

    public void setArraySize(int arraySize) {
        this.arraySize = arraySize;
    }

    public String getTagName() {
        return this.tagName;
    }

    public void setTagName(String name) {
        this.tagName = name;
    }

    public int getRawLength() {
        return this.rawLength;
    }

    public boolean isFieldsComplete() {
        return this.fieldsComplete;
    }

    public int getSize() {
        return this.size;
    }

    public ArrayList getFields() {
        return this.myFields;
    }

    public Iterator getFieldIterator() {
        return this.myFields.iterator();
    }

    public int getNFields() {
        return this.myFields.size();
    }

    public Field getField(int i) {
        Field rv = null;
        if (i >= 0 && i < this.myFields.size()) {
            rv = this.myFields.get(i);
        }
        return rv;
    }

    public INTINT[] toLongIntArray() {
        int nFields = this.myFields.size();
        INTINT[] li = new INTINT[nFields + 1];
        for (int i = 0; i < nFields; ++i) {
            Field currentField = this.getField(i);
            li[i] = new INTINT(currentField.getArraySize(), currentField.getFormat() + 512);
        }
        li[nFields] = new INTINT(1, 767);
        return li;
    }

    public NAME16II[] toNameIntIntArray() {
        int nFields = this.myFields.size();
        NAME16II[] li = new NAME16II[nFields + 1];
        for (int i = 0; i < nFields; ++i) {
            Field currentField = this.getField(i);
            li[i] = new NAME16II(currentField.getName(), currentField.getArraySize(), currentField.getFormat() + 512);
        }
        li[nFields] = new NAME16II("", 1, 767);
        return li;
    }

    public String convertBytesToString(byte[] data, int offset) {
        StringBuffer buffer = new StringBuffer();
        try {
            ByteArrayInputStream dis = new ByteArrayInputStream(data, offset, this.rawLength);
            DataInputStream ds = new DataInputStream(dis);
            for (int n = 0; n < this.myFields.size(); ++n) {
                Field currentField = this.getField(n);
                int len = currentField.getArraySize();
                if (len <= 0) continue;
                buffer.append("[" + currentField.getName() + "] ->");
                switch (currentField.getFormat() % 512) {
                    case 2: {
                        for (int i = 0; i < len; ++i) {
                            buffer.append(i > 0 ? "," : " ");
                            buffer.append(ds.readByte());
                        }
                        break;
                    }
                    case 4: {
                        int nlen;
                        byte[] bstr = new byte[len];
                        ds.read(bstr, 0, len);
                        for (nlen = 0; nlen < len && bstr[nlen] != 0; ++nlen) {
                        }
                        buffer.append(new String(bstr, 0, nlen).trim());
                        break;
                    }
                    case 1: {
                        int i;
                        for (i = 0; i < len; ++i) {
                            buffer.append(i > 0 ? "," : " ");
                            buffer.append(SwapUtil.swapShort(ds.readShort()));
                        }
                        break;
                    }
                    case 3: {
                        int i;
                        for (i = 0; i < len; ++i) {
                            buffer.append(i > 0 ? "," : " ");
                            buffer.append(SwapUtil.swapInt(ds.readInt()));
                        }
                        break;
                    }
                    case 6: {
                        int i;
                        for (i = 0; i < len; ++i) {
                            buffer.append(i > 0 ? "," : " ");
                            buffer.append(SwapUtil.swapLong(ds.readLong()));
                        }
                        break;
                    }
                    case 5: {
                        int i;
                        for (i = 0; i < len; ++i) {
                            buffer.append(i > 0 ? "," : " ");
                            buffer.append(SwapUtil.swapFloat(ds.readInt()));
                        }
                        break;
                    }
                    case 0: {
                        int i;
                        for (i = 0; i < len; ++i) {
                            buffer.append(i > 0 ? "," : " ");
                            buffer.append(SwapUtil.swapDouble(ds.readLong()));
                        }
                        break;
                    }
                }
                buffer.append("\n");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return buffer.toString();
    }

    public String convertBytesToString(byte[] data) {
        return this.convertBytesToString(data, 0);
    }

    public class Field {
        int arraySize;
        int format;
        int offset;
        int address;
        String name;

        public Field() {
            this("", 0, 255, 0, 0);
        }

        public Field(int newSize, short newFormat, int newOffset, int newAddress) {
            this("", newSize, newFormat, newOffset, newAddress);
        }

        public Field(String name, int newSize, short newFormat, int newOffset, int newAddress) {
            this.arraySize = newSize;
            this.format = newFormat;
            this.offset = newOffset;
            this.address = newAddress;
            this.name = name;
        }

        public int getAddress() {
            return this.address;
        }

        public void setAddress(int address) {
            this.address = address;
        }

        public short getFormat() {
            return (short)this.format;
        }

        public void setFormat(short format) {
            this.format = format;
        }

        public int getOffset() {
            return this.offset;
        }

        public String getName() {
            return this.name;
        }

        public void setOffset(int offset) {
            this.offset = offset;
        }

        public int getArraySize() {
            return this.arraySize;
        }

        public void setArraySize(int size) {
            this.arraySize = size;
        }
    }
}

