/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.stringUtils;

import de.desy.tine.stringUtils.WildcardMatch;
import de.desy.tine.types.NAME16;
import de.desy.tine.types.NAME32;
import de.desy.tine.types.NAME64;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;

public class StringToName {
    private StringToName() {
    }

    public static NAME16[] stringSetToName16(Collection inputSet) {
        NAME16[] rv = null;
        int len = inputSet.size();
        if (len > 0) {
            rv = new NAME16[len];
            Iterator it = inputSet.iterator();
            for (int i = 0; i < len && it.hasNext(); ++i) {
                rv[i] = new NAME16((String)it.next());
            }
        }
        return rv;
    }

    public static NAME32[] stringSetToName32(Collection inputSet) {
        NAME32[] rv = null;
        int len = inputSet.size();
        if (len > 0) {
            rv = new NAME32[len];
            Iterator it = inputSet.iterator();
            for (int i = 0; i < len && it.hasNext(); ++i) {
                rv[i] = new NAME32((String)it.next());
            }
        }
        return rv;
    }

    public static NAME64[] stringSetToName64(Collection inputSet) {
        NAME64[] rv = null;
        int len = inputSet.size();
        if (len > 0) {
            rv = new NAME64[len];
            Iterator it = inputSet.iterator();
            for (int i = 0; i < len && it.hasNext(); ++i) {
                rv[i] = new NAME64((String)it.next());
            }
        }
        return rv;
    }

    public static NAME16[] stringArrayToName16(String[] inputArray) {
        NAME16[] rv = null;
        int len = inputArray.length;
        if (len > 0) {
            rv = new NAME16[len];
            for (int i = 0; i < len; ++i) {
                rv[i] = new NAME16(inputArray[i]);
            }
        }
        return rv;
    }

    public static NAME64[] stringArrayToName64(String[] inputArray) {
        NAME64[] rv = null;
        int len = inputArray.length;
        if (len > 0) {
            rv = new NAME64[len];
            for (int i = 0; i < len; ++i) {
                rv[i] = new NAME64(inputArray[i]);
            }
        }
        return rv;
    }

    public static NAME32[] stringArrayToName32(String[] inputArray) {
        NAME32[] rv = null;
        int len = inputArray.length;
        if (len > 0) {
            rv = new NAME32[len];
            for (int i = 0; i < len; ++i) {
                rv[i] = new NAME32(inputArray[i]);
            }
        }
        return rv;
    }

    public LinkedList matchStringsInSet(Collection inputSet, String pattern) {
        LinkedList<String> rv = new LinkedList<String>();
        Iterator it = inputSet.iterator();
        String element = "";
        WildcardMatch wc = new WildcardMatch(pattern);
        it = inputSet.iterator();
        while (it.hasNext()) {
            if (wc.matches(element)) {
                rv.add(element);
            }
            element = (String)it.next();
        }
        return rv;
    }

    public static String[] matchStringsInArray(String[] inputArray, String pattern) {
        LinkedList<String> rv = new LinkedList<String>();
        WildcardMatch wc = new WildcardMatch(pattern);
        for (int i = 0; i < inputArray.length; ++i) {
            if (!wc.matches(inputArray[i])) continue;
            rv.add(inputArray[i]);
        }
        int siz = rv.size();
        if (siz == 0) {
            return null;
        }
        String[] outputArray = new String[siz];
        return rv.toArray(outputArray);
    }

    public static int[] getContiguousEndpoints(NAME32[] inputArray, String pattern) {
        if (inputArray == null || inputArray.length == 0) {
            return null;
        }
        String[] strArray = new String[inputArray.length];
        for (int i = 0; i < inputArray.length; ++i) {
            strArray[i] = inputArray[i].name;
        }
        return StringToName.getContiguousEndpoints(strArray, pattern);
    }

    public static int[] getContiguousEndpoints(String[] inputArray, String pattern) {
        int[] endpoints = new int[2];
        boolean inSequence = false;
        boolean finSequence = false;
        if (pattern.compareTo("*") == 0) {
            endpoints[0] = 0;
            endpoints[1] = inputArray.length - 1;
            return endpoints;
        }
        WildcardMatch wc = new WildcardMatch(pattern);
        int n = 0;
        for (int i = 0; i < inputArray.length; ++i) {
            if (!wc.matches(inputArray[i])) {
                if (!inSequence) continue;
                finSequence = true;
                continue;
            }
            if (finSequence) {
                return null;
            }
            if (!inSequence) {
                endpoints[0] = i;
            }
            inSequence = true;
            ++n;
        }
        endpoints[1] = endpoints[0] + n - 1;
        return (int[])(n > 0 ? endpoints : null);
    }
}

