/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.server.properties;

import de.desy.tine.definitions.TGraphType;
import de.desy.tine.server.properties.TPropertyEGU;

public class TPropertyDescription {
    private short arrayType;
    private int arrayRowLength;
    private int arrayNumRows;
    private String text;
    private TPropertyEGU yRange;
    private TPropertyEGU xRange;
    private String redirection;

    public TPropertyDescription(String prpDescription) {
        this.text = prpDescription == null || prpDescription.length() == 0 ? "description not given" : prpDescription;
        this.arrayType = 0;
        this.arrayNumRows = 1;
        this.arrayRowLength = 0;
        this.yRange = new TPropertyEGU();
        this.xRange = new TPropertyEGU();
    }

    public TPropertyDescription(short newArrayType, int newArrayRowLength, int newNumRows) {
        this.arrayType = newArrayType;
        this.arrayRowLength = newArrayRowLength;
        this.arrayNumRows = newNumRows;
    }

    public TPropertyDescription() {
    }

    public TPropertyEGU getXRange() {
        return this.xRange;
    }

    public void setXRange(TPropertyEGU units) {
        if (units.getMaxValue() != units.getMinValue() && this.arrayType == 0) {
            this.arrayType = (short)32;
        }
        this.xRange = units;
    }

    public TPropertyEGU getYRange() {
        return this.yRange;
    }

    public void setYRange(TPropertyEGU units) {
        this.yRange = units;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String description) {
        this.text = description;
    }

    public String getRedirection() {
        return this.redirection;
    }

    public void setRedirection(String redirection) {
        this.redirection = redirection;
    }

    public int getArrayNumRows() {
        return this.arrayNumRows;
    }

    public void setArrayNumRows(int arrayNumRows) {
        this.arrayNumRows = arrayNumRows;
    }

    public int getArrayRowLength() {
        return this.arrayRowLength;
    }

    public void setArrayRowLength(int arrayRowLength) {
        this.arrayRowLength = arrayRowLength;
    }

    public short getArrayType() {
        return this.arrayType;
    }

    public void setArrayType(short arrayType) {
        this.arrayType = arrayType;
    }

    public void parseComplexString(String parseableDescription) {
        int stop = -1;
        if (parseableDescription == null) {
            return;
        }
        int start = parseableDescription.indexOf(91);
        if (start != -1) {
            int k;
            stop = parseableDescription.indexOf(93);
            if (stop == -1) {
                return;
            }
            TPropertyEGU yegu = new TPropertyEGU();
            int mid = stop;
            int i = parseableDescription.indexOf(33);
            if (i != -1) {
                yegu.setGraphType(TGraphType.getType(parseableDescription.substring(i + 1, stop)));
                mid = i;
            }
            if ((i = parseableDescription.indexOf(58)) != -1) {
                k = parseableDescription.substring(i + 1, mid).indexOf(32);
                k = k == -1 ? mid : (k += i + 1);
                yegu.setMinValue(new Float(parseableDescription.substring(start + 1, i)).floatValue());
                yegu.setMaxValue(new Float(parseableDescription.substring(i + 1, k)).floatValue());
                if (k != mid) {
                    yegu.setUnits(parseableDescription.substring(k + 1, mid));
                }
            }
            this.setYRange(yegu);
            start = parseableDescription.substring(stop + 1).indexOf(91);
            if (start != -1) {
                if ((stop = parseableDescription.substring(start += stop + 1).indexOf(93)) == -1) {
                    return;
                }
                TPropertyEGU xegu = new TPropertyEGU();
                mid = stop += start;
                i = parseableDescription.substring(start).indexOf(33);
                if (i != -1) {
                    mid = i + start;
                }
                if ((i = parseableDescription.substring(start).indexOf(58)) != -1) {
                    k = parseableDescription.substring((i += start) + 1, mid).indexOf(32);
                    k = k == -1 ? mid : (k += i + 1);
                    xegu.setMinValue(new Float(parseableDescription.substring(start + 1, i)).floatValue());
                    xegu.setMaxValue(new Float(parseableDescription.substring(i + 1, k)).floatValue());
                    if (k != mid) {
                        xegu.setUnits(parseableDescription.substring(k + 1, mid));
                    }
                }
                this.setXRange(xegu);
            }
        }
        this.setText(parseableDescription.substring(stop + 1));
    }
}

