/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.server.properties;

import de.desy.tine.dataUtils.TDataType;
import de.desy.tine.definitions.TStrings;
import de.desy.tine.server.properties.TPropertyDescription;
import de.desy.tine.server.properties.TPropertyEGU;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TExportProperty {
    private String name = "";
    private String alias = "";
    private int id = -1;
    private int outputSize = 0;
    private int inputSize = 0;
    private short outputFormat = 0;
    private short inputFormat = 0;
    private short accessMode = 0;
    private String outputTag = "";
    private String inputTag = "";
    private TPropertyDescription description = null;
    private ArrayList<String> prpDeviceList = null;

    public void setDeviceList(ArrayList<String> deviceList) {
        this.prpDeviceList = deviceList;
    }

    public ArrayList<String> getDeviceList() {
        return this.prpDeviceList;
    }

    public TExportProperty() {
    }

    public TExportProperty(int prpId, String prpName, short accessMode, TDataType din, TDataType dout, String prpDscr) {
        TStrings.validatePropertyName(prpName);
        this.name = prpName;
        this.outputFormat = dout.dFormat;
        this.outputSize = dout.dArrayLength;
        this.outputTag = dout.getTag();
        this.inputFormat = din.dFormat;
        this.inputSize = din.dArrayLength;
        this.inputTag = din.getTag();
        this.accessMode = accessMode;
        this.description = new TPropertyDescription(prpDscr);
        this.id = prpId;
    }

    public TExportProperty(String prpName, int outputSize, short outputFormat) {
        this.initialize(prpName, (short)1, outputSize, outputFormat, 0, (short)255);
    }

    public TExportProperty(String prpName, int outputSize, short outputFormat, int inputSize, short inputFormat) {
        this.initialize(prpName, (short)1, outputSize, outputFormat, inputSize, inputFormat);
    }

    public TExportProperty(int prpId, String prpName, short accessMode, TDataType din, TDataType dout) {
        this(prpId, prpName, accessMode, din, dout, "");
    }

    private void initialize(String prpName, short accessMode, int outputSize, short outputFormat, int inputSize, short inputFormat) {
        TStrings.validatePropertyName(prpName);
        this.name = prpName;
        this.id = 0;
        this.accessMode = accessMode;
        this.outputSize = outputSize;
        this.outputFormat = outputFormat;
        this.outputTag = "";
        this.inputSize = inputSize;
        this.inputFormat = inputFormat;
        this.inputTag = "";
        this.description = new TPropertyDescription("");
    }

    public TExportProperty(TExportProperty source) {
        this.id = source.id;
        this.name = source.name;
        this.outputFormat = source.outputFormat;
        this.outputSize = source.outputSize;
        this.outputTag = source.outputTag;
        this.inputFormat = source.inputFormat;
        this.inputSize = source.inputSize;
        this.inputTag = source.inputTag;
        this.accessMode = source.accessMode;
        this.description = new TPropertyDescription(source.description.getText());
    }

    private void initialize(int prpId, String prpName, String prpDescription, int prpSizeOut, short prpFormatOut, String prpTagOut, int prpSizeIn, short prpFormatIn, String prpTagIn) {
        TStrings.validatePropertyName(prpName);
        this.id = prpId;
        this.name = prpName;
        this.description = new TPropertyDescription(prpDescription);
        this.outputFormat = prpFormatOut;
        this.inputFormat = prpFormatIn;
        this.outputSize = prpSizeOut;
        this.inputSize = prpSizeIn;
        this.outputTag = prpTagOut;
        this.inputTag = prpTagIn;
    }

    public TExportProperty(int prpId, String prpName, String prpDescription, int prpSizeOut, short prpFormatOut, String prpTagOut, int prpSizeIn, short prpFormatIn, String prpTagIn) {
        this.initialize(prpId, prpName, prpDescription, prpSizeOut, prpFormatOut, prpTagOut, prpSizeIn, prpFormatIn, prpTagIn);
    }

    public TExportProperty(int prpId, String prpName, String prpDescription, int prpSizeOut, short prpFormatOut, int prpSizeIn, short prpFormatIn) {
        this.initialize(prpId, prpName, prpDescription, prpSizeOut, prpFormatOut, "", prpSizeIn, prpFormatIn, "");
    }

    public TExportProperty(int prpId, String prpName, String prpDescription, int prpSizeOut, short prpFormatOut) {
        this.initialize(prpId, prpName, prpDescription, prpSizeOut, prpFormatOut, "", 0, (short)255, "");
    }

    public short getAccessMode() {
        return this.accessMode;
    }

    public void setAccessMode(short accessMode) {
        this.accessMode = accessMode;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public short getInputFormat() {
        return this.inputFormat;
    }

    public void setInputFormat(short inputFormat) {
        this.inputFormat = inputFormat;
    }

    public int getInputSize() {
        return this.inputSize;
    }

    public void setInputSize(int inputSize) {
        this.inputSize = inputSize;
    }

    public String getInputTag() {
        return this.inputTag;
    }

    public void setInputTag(String inputTag) {
        this.inputTag = inputTag;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public short getOutputFormat() {
        return this.outputFormat;
    }

    public void setOutputFormat(short outputFormat) {
        this.outputFormat = outputFormat;
    }

    public int getOutputSize() {
        return this.outputSize;
    }

    public void setOutputSize(int outputSize) {
        this.outputSize = outputSize;
    }

    public String getOutputTag() {
        return this.outputTag;
    }

    public void setOutputTag(String outputTag) {
        this.outputTag = outputTag;
    }

    public TPropertyDescription getDescription() {
        return this.description;
    }

    public void setDescription(TPropertyDescription description) {
        TPropertyEGU rng = new TPropertyEGU();
        TPropertyEGU xrng = new TPropertyEGU("", 0.0f, 0.0f);
        if (description.getText() == null) {
            description.setText("description unavailable");
        }
        if (description.getYRange() == null) {
            description.setYRange(rng);
        }
        if (description.getXRange() == null) {
            description.setXRange(xrng);
        }
        if (description.getArrayNumRows() == 0) {
            description.setArrayNumRows(1);
        }
        if (this.outputSize == 1 && description.getArrayType() == 0) {
            description.setArrayType((short)1);
        }
        this.description = description;
    }
}

