/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.server.logger;

import de.desy.tine.client.TLink;
import de.desy.tine.client.TLinkCallback;
import de.desy.tine.client.TLinkFactory;
import de.desy.tine.dataUtils.TDataType;
import de.desy.tine.definitions.TErrorList;
import de.desy.tine.server.equipment.TEquipmentModuleFactory;
import de.desy.tine.server.logger.Clog;
import de.desy.tine.server.logger.ClogFilter;
import de.desy.tine.server.logger.TFecLog;
import de.desy.tine.structUtils.TTaggedStructure;
import java.io.IOException;
import java.util.Vector;

public class ClsLog
implements TLinkCallback {
    private static ClsLog instance = new ClsLog();
    private static final int nice_query_size = 1000;
    private static Clog[] clg = new Clog[1000];
    private static boolean initialized = false;

    public static synchronized int log(String text, String context, String tag, String caller, ClogPriority priority, ClogStatus status) {
        TFecLog.log(text);
        if (context == null) {
            context = TEquipmentModuleFactory.getInstance().getFecContext();
        }
        if (tag == null) {
            tag = TEquipmentModuleFactory.getInstance().getFecSubsystem();
        }
        if (caller == null) {
            caller = TLinkFactory.getInstance().getUserName();
        }
        if (caller == null) {
            caller = System.getProperty("user.name");
        }
        TTaggedStructure[] clog = new Clog[]{new Clog(text, context, tag, caller, priority.ordinal(), status.ordinal())};
        TDataType clgt = new TDataType(clog);
        TLink tl = new TLink("/SITE/CLOG/Logger", "NewEntry", null, clgt, 258);
        int id = tl.attach((short)1, (TLinkCallback)instance, 1000);
        return id < 0 ? -id : 0;
    }

    public static int log(String text) {
        ClogPriority priority = ClogPriority.CLOG_PRIORITY_USEFUL;
        ClogStatus status = ClogStatus.CLOG_STATUS_INFO;
        return ClsLog.log(text, null, null, null, priority, status);
    }

    public static int log(String text, ClogPriority priority, ClogStatus status) {
        return ClsLog.log(text, null, null, null, priority, status);
    }

    public void callback(TLink link) {
        if (link.getLinkStatus() != 0) {
            TFecLog.log("clslog missed entry : " + link.getLastError());
        }
    }

    public static Clog[] getEntries(long start, long stop) throws IOException {
        return ClsLog.getEntries(start, stop, 0);
    }

    public static Clog[] getEntries(long start, long stop, int maximumNumberOfEntries) throws IOException {
        ClogFilter[] f = new ClogFilter[]{new ClogFilter(start, stop)};
        return ClsLog.getEntries(f, maximumNumberOfEntries);
    }

    public static Clog[] getEntries(ClogFilter[] fltr) throws IOException {
        return ClsLog.getEntries(fltr, 0);
    }

    public static synchronized Clog[] getEntries(ClogFilter[] fltr, int maximumNumberOfEntries) throws IOException {
        if (!initialized) {
            for (int i = 0; i < 1000; ++i) {
                ClsLog.clg[i] = new Clog();
            }
            initialized = true;
        }
        TDataType fltt = fltr == null ? null : new TDataType(fltr);
        TDataType clgt = new TDataType(clg);
        TLink tl = new TLink("/SITE/CLOG/Logger", "Entries", clgt, fltt, 1);
        int cc = tl.execute(1000, true);
        tl.close();
        if (cc != 0) {
            throw new IOException(TErrorList.getErrorString(cc) + " while contacting the central logging server");
        }
        int siz = clgt.getCompletionLength();
        if (siz == 0) {
            return null;
        }
        boolean stopQuery = false;
        if (maximumNumberOfEntries <= 0) {
            maximumNumberOfEntries = 10000000;
        }
        Vector<Clog> v = new Vector<Clog>(siz);
        for (int i = 0; i < siz && !stopQuery; ++i) {
            clg[i].reset();
            v.add(new Clog(clg[i]));
            if (v.size() < maximumNumberOfEntries) continue;
            stopQuery = true;
        }
        while (siz == 1000 && !stopQuery) {
            long startt = clg[siz - 1].getTimeLogged();
            if (fltr == null) {
                fltr = new ClogFilter[]{new ClogFilter(startt, System.currentTimeMillis())};
            }
            for (ClogFilter f : fltr) {
                f.setTimeStart(startt);
            }
            clgt = new TDataType(clg);
            fltt = new TDataType(fltr);
            tl = new TLink("/SITE/CLOG/Logger", "Entries", clgt, fltt, 1);
            cc = tl.execute(1000, true);
            tl.close();
            if (cc != 0) {
                throw new IOException(TErrorList.getErrorString(cc) + " while contacting the central logging server");
            }
            siz = clgt.getCompletionLength();
            for (int i = 0; i < siz && !stopQuery; ++i) {
                clg[i].reset();
                v.add(new Clog(clg[i]));
                if (v.size() < maximumNumberOfEntries) continue;
                stopQuery = true;
            }
        }
        return v.toArray(new Clog[1]);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ClogPriority {
        CLOG_PRIORITY_NONE,
        CLOG_PRIORITY_USEFUL,
        CLOG_PRIORITY_IMPORTANT,
        CLOG_PRIORITY_URGENT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ClogStatus {
        CLOG_STATUS_NONE,
        CLOG_STATUS_INFO,
        CLOG_STATUS_WARN,
        CLOG_STATUS_ERR;

    }
}

