/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.server.equipment;

import de.desy.tine.client.TLink;
import de.desy.tine.csvUtils.FormatFieldHandler;
import de.desy.tine.csvUtils.IntFieldHandler;
import de.desy.tine.csvUtils.RowHandler;
import de.desy.tine.csvUtils.ShortFieldHandler;
import de.desy.tine.csvUtils.StringFieldHandler;
import de.desy.tine.csvUtils.csv;
import de.desy.tine.csvUtils.csvColumn;
import de.desy.tine.csvUtils.csvHandler;
import de.desy.tine.dataUtils.TDataTime;
import de.desy.tine.dataUtils.TDataType;
import de.desy.tine.definitions.TAccess;
import de.desy.tine.definitions.TArrayType;
import de.desy.tine.definitions.TErrorList;
import de.desy.tine.definitions.TFormat;
import de.desy.tine.definitions.TStrings;
import de.desy.tine.endianUtils.Swap;
import de.desy.tine.queryUtils.PropertyQuery;
import de.desy.tine.queryUtils.TPropertyQuery;
import de.desy.tine.queryUtils.XPropertyQuery;
import de.desy.tine.server.alarms.TAlarm;
import de.desy.tine.server.alarms.TAlarmDefinition;
import de.desy.tine.server.alarms.TAlarmDynSet;
import de.desy.tine.server.alarms.TAlarmMessage;
import de.desy.tine.server.alarms.TAlarmWatchEntry;
import de.desy.tine.server.connections.TClient;
import de.desy.tine.server.connections.TClientEntry;
import de.desy.tine.server.connections.TContractTable;
import de.desy.tine.server.devices.TDevice;
import de.desy.tine.server.devices.TDeviceList;
import de.desy.tine.server.equipment.TEquipmentBackgroundTask;
import de.desy.tine.server.equipment.TEquipmentExitRoutine;
import de.desy.tine.server.equipment.TEquipmentFunction;
import de.desy.tine.server.equipment.TEquipmentInitRoutine;
import de.desy.tine.server.equipment.TEquipmentModuleFactory;
import de.desy.tine.server.histories.THistoryRecord;
import de.desy.tine.server.histories.THistoryRecordStruct;
import de.desy.tine.server.histories.THistorySpecification;
import de.desy.tine.server.logger.DbgLog;
import de.desy.tine.server.logger.TFecLog;
import de.desy.tine.server.properties.TExportProperty;
import de.desy.tine.server.properties.TMetaProperties;
import de.desy.tine.server.properties.TPropertyDescription;
import de.desy.tine.server.properties.TPropertyEGU;
import de.desy.tine.server.properties.TPropertyHandler;
import de.desy.tine.server.properties.TPropertyList;
import de.desy.tine.server.properties.TStockProperties;
import de.desy.tine.startup.TInitializer;
import de.desy.tine.startup.TInitializerFactory;
import de.desy.tine.stringUtils.StringToName;
import de.desy.tine.stringUtils.WildcardMatch;
import de.desy.tine.structUtils.TStructRegistry;
import de.desy.tine.structUtils.TTaggedStructure;
import de.desy.tine.types.DBLDBL;
import de.desy.tine.types.FLTINT;
import de.desy.tine.types.FWINDOW;
import de.desy.tine.types.HISTORY;
import de.desy.tine.types.INTFLTINT;
import de.desy.tine.types.INTINT;
import de.desy.tine.types.NAME16;
import de.desy.tine.types.NAME16I;
import de.desy.tine.types.NAME32;
import de.desy.tine.types.NAME32I;
import de.desy.tine.types.NAME64;
import de.desy.tine.types.NAME64I;
import de.desy.tine.types.TCompoundDataObject;
import de.desy.tine.types.USTRING;
import de.desy.tine.xmlUtils.AlarmDefinitionCfg;
import de.desy.tine.xmlUtils.DeviceCfg;
import de.desy.tine.xmlUtils.EqmCfg;
import de.desy.tine.xmlUtils.FecCfg;
import de.desy.tine.xmlUtils.NameCfgList;
import de.desy.tine.xmlUtils.PropertyCfg;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentLinkedQueue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TEquipmentModule {
    private String context;
    private String subsystem;
    private String exportName = null;
    private String moduleName = null;
    private String groupName = null;
    private int groupIndex = 0;
    protected TEquipmentModuleFactory gEqmFactory = null;
    protected LinkedList<String> gRegisteredUsersList = new LinkedList();
    protected LinkedList<String> gRegisteredNetsList = new LinkedList();
    protected LinkedList<String> gGCastNetsList = new LinkedList();
    protected HashMap<Integer, TAlarmDefinition> alarmDefinitionList = new HashMap();
    protected boolean gRejectAllNets = false;
    TPropertyList stockList;
    TPropertyList propertyList = new TPropertyList();
    TDeviceList deviceList = new TDeviceList();
    protected TAlarmDynSet almDynSet = new TAlarmDynSet();
    protected String[] gPropertyNameList = null;
    protected LinkedList<TAlarmWatchEntry> gAlarmWatchList = new LinkedList();
    protected LinkedList<THistoryRecord> gLclHstList = new LinkedList();
    private boolean useHighResolutionTimestamps = false;
    private boolean useMonthlyHistoryFiles = false;
    private boolean isIdle = false;
    public boolean hasInitialized = false;
    public boolean isRegistered;
    public boolean hasCasAttached = false;
    public boolean casReadRequired = false;
    public boolean grpRegistered = false;
    private String casName;
    int numClients;
    int numContracts;
    public AccessLock accessLock = new AccessLock();
    TEquipmentFunction eqpFcn = null;
    private TEquipmentInitRoutine eqpIni;
    private TEquipmentExitRoutine eqpExi;
    private long lastHistoryCycleTime = 0L;
    private int historyCycleInterval = 1000;
    private boolean stockPropertiesRegistered = false;
    ConcurrentLinkedQueue<TEquipmentBackgroundTask> bkgTasks = new ConcurrentLinkedQueue();

    public TEquipmentModuleFactory getEquipmentModuleFactory() {
        if (this.gEqmFactory == null) {
            this.gEqmFactory = TEquipmentModuleFactory.getInstance();
        }
        return this.gEqmFactory;
    }

    public HashMap<Integer, TAlarmDefinition> getAlarmDefinitionList() {
        return this.alarmDefinitionList;
    }

    public int addAlarmDefinition(int code, TAlarmDefinition adef) {
        if (code < 0 || adef == null) {
            return 20;
        }
        this.alarmDefinitionList.put(new Integer(code), adef);
        return 0;
    }

    public int addAlarmDefinition(TAlarmDefinition adef) {
        if (adef == null) {
            return 20;
        }
        return this.addAlarmDefinition(adef.getAlarmCode(), adef);
    }

    public TAlarmDefinition getAlarmDefinition(int code) {
        return this.alarmDefinitionList.get(new Integer(code));
    }

    public TDeviceList getDeviceList() {
        return this.deviceList;
    }

    public TPropertyList getPropertyList() {
        return this.propertyList;
    }

    public int getDeviceNumber(String devName) {
        try {
            if (devName.startsWith("#")) {
                return Integer.parseInt(devName.substring(1));
            }
            return this.deviceList.getDeviceNumber(devName);
        }
        catch (Exception e) {
            return -1;
        }
    }

    public int getDeviceNumber(String devName, String devProperty) {
        try {
            ArrayList<String> lst;
            TExportProperty prp;
            if (devName == null) {
                return -20;
            }
            if (devName.startsWith("#")) {
                return Integer.parseInt(devName.substring(1));
            }
            if (this.deviceList.isPropertyOriented() && devProperty != null && (prp = this.propertyList.getFirstProperty(devProperty)) != null && (lst = prp.getDeviceList()) != null) {
                return lst.indexOf(devName);
            }
            return this.deviceList.getDeviceNumber(devName);
        }
        catch (Exception e) {
            return -1;
        }
    }

    public void setUseMSecHistoryTimestamps(boolean useMsecHistoryTimestamps) {
        this.useHighResolutionTimestamps = useMsecHistoryTimestamps;
    }

    public boolean isUseMSecHistoryTimestamps() {
        return this.useHighResolutionTimestamps;
    }

    public void setUseMonthlyHistoryFiles(boolean useMonthlyFiles) {
        this.useMonthlyHistoryFiles = useMonthlyFiles;
    }

    public boolean isUseMonthlyHistoryFiles() {
        return this.useMonthlyHistoryFiles;
    }

    THistoryRecord getLocalHistoryRecord(String Property, String Device) {
        int listsize = this.gLclHstList.size();
        THistoryRecord lhr = null;
        for (int i = 0; i < listsize; ++i) {
            lhr = this.gLclHstList.get(i);
            if (lhr.getPrp().compareTo(Property) != 0) continue;
            return lhr;
        }
        return null;
    }

    public int addLocalHistoryRecord(int recordIndex, String device, String property, int dataSize, int dataFormat) {
        return this.addLocalHistoryRecord(recordIndex, device, property, dataSize, dataFormat, 0);
    }

    public int addLocalHistoryRecord(int recordIndex, String device, String property, int dataSize, int dataFormat, int arrayType) {
        THistorySpecification spc = new THistorySpecification(1000, 1000, 600, 1, 18000, 10.0f, 0.0f, "");
        return this.addLocalHistoryRecord(recordIndex, device, property, dataSize, dataFormat, arrayType, spc);
    }

    public int addLocalHistoryRecord(int recordIndex, String device, String property, int dataSize, int dataFormat, int arrayType, THistorySpecification histSpec) {
        THistoryRecord hst = new THistoryRecord(this, device, property, dataSize, dataFormat, arrayType, recordIndex, histSpec);
        if (this.useHighResolutionTimestamps) {
            hst.setUseMinimalStorage(false);
        }
        if (this.useMonthlyHistoryFiles) {
            hst.setUseMonthlyHistoryFiles(true);
        }
        this.gLclHstList.add(hst);
        return 0;
    }

    public boolean isIdleState() {
        return this.isIdle;
    }

    public void setIdleState(boolean value) {
        this.isIdle = value;
        Iterator<TEquipmentBackgroundTask> li = this.bkgTasks.iterator();
        while (li.hasNext()) {
            li.next().setIdleState(value);
        }
    }

    public String getCasName() {
        return this.casName;
    }

    boolean isCasInClientList() {
        if (this.casName == null) {
            return false;
        }
        TClientEntry[] tce = this.getClientList();
        for (int i = 0; i < tce.length; ++i) {
            if (tce[i].cln.userName.compareTo(this.casName) != 0) continue;
            this.casReadRequired = true;
            this.hasCasAttached = true;
            return true;
        }
        return false;
    }

    public TEquipmentInitRoutine getInitializationRoutine() {
        return this.eqpIni;
    }

    public void setInitializationRoutine(TEquipmentInitRoutine initRoutine) {
        this.eqpIni = initRoutine;
    }

    public TEquipmentExitRoutine getExitRoutine() {
        return this.eqpExi;
    }

    public void setExitRoutine(TEquipmentExitRoutine exitRoutine) {
        this.eqpExi = exitRoutine;
    }

    public NAME16[] getRegisteredUsers() {
        return StringToName.stringSetToName16(this.gRegisteredUsersList);
    }

    public int addRegisteredUser(String newUser) {
        if (this.gRegisteredUsersList.contains(newUser = newUser.toUpperCase())) {
            return 135;
        }
        this.gRegisteredUsersList.add(newUser);
        return 0;
    }

    public int removeRegisteredUser(String oldUser) {
        if (!this.gRegisteredUsersList.contains(oldUser = oldUser.toUpperCase())) {
            return 141;
        }
        this.gRegisteredUsersList.remove(oldUser);
        return 0;
    }

    public void removeAllRegisteredUsers() {
        this.gRegisteredUsersList.clear();
    }

    public int addRegisteredNet(String newNet) {
        if (this.gRegisteredNetsList.contains(newNet)) {
            return 135;
        }
        this.gRegisteredNetsList.add(newNet);
        return 0;
    }

    public int removeRegisteredNet(String oldNet) {
        if (!this.gRegisteredNetsList.contains(oldNet)) {
            return 141;
        }
        this.gRegisteredNetsList.remove(oldNet);
        return 0;
    }

    public void removeAllRegisteredNets() {
        this.gRegisteredNetsList.clear();
    }

    public NAME16[] getRegisteredNets() {
        return StringToName.stringSetToName16(this.gRegisteredNetsList);
    }

    public int addGCastNet(String newNet) {
        if (this.gGCastNetsList.contains(newNet)) {
            return 135;
        }
        this.gGCastNetsList.add(newNet);
        return 0;
    }

    public int removeGCastNet(String oldNet) {
        if (!this.gGCastNetsList.contains(oldNet)) {
            return 141;
        }
        this.gGCastNetsList.remove(oldNet);
        return 0;
    }

    public void removeAllGCastNets() {
        this.gGCastNetsList.clear();
    }

    public NAME16[] getGCastNets() {
        return StringToName.stringSetToName16(this.gGCastNetsList);
    }

    public void setCompletionString(String completionString) {
        TContractTable tct = this.getTEqmFactory().getCurrentContractEntry();
        if (tct != null) {
            tct.compString = completionString;
        }
    }

    public int setLocalName(String lclName) {
        this.moduleName = lclName;
        if (lclName.length() > 6) {
            this.moduleName = lclName.substring(0, 6);
            TFecLog.log("module name " + lclName + " too long; truncating to " + this.moduleName);
        }
        TStrings.validateLocalName(this.moduleName);
        this.getEquipmentModuleFactory().registrationPending = true;
        return 0;
    }

    public String getLocalName() {
        return this.moduleName;
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public int setExportName(String expName) {
        if (this.exportName == null) {
            this.exportName = new String(expName);
            TStrings.validateExportName(this.exportName);
        }
        return 0;
    }

    public String getExportName() {
        return this.exportName;
    }

    public void setGroupName(String grpName) {
        if (this.groupName == null) {
            this.groupName = new String(grpName);
            TStrings.validateExportName(this.groupName);
            this.grpRegistered = false;
            TEquipmentModuleFactory.getInstance().registrationPending = true;
        }
    }

    public String getGroupName() {
        return this.groupName;
    }

    public void setGroupIndex(int grpIndex) {
        this.groupIndex = grpIndex;
    }

    public int getGroupIndex() {
        return this.groupIndex;
    }

    public int setContext(String expContext) {
        if (this.context == null && expContext != null) {
            this.context = expContext;
            TStrings.validateContextName(expContext);
        }
        return 0;
    }

    public String getContext() {
        return this.context;
    }

    public TEquipmentModuleFactory getTEqmFactory() {
        return this.gEqmFactory;
    }

    public TClient getCaller() {
        TContractTable tct = this.gEqmFactory.getCurrentContractEntry();
        TClientEntry tce = null;
        if (tct != null) {
            try {
                tce = (TClientEntry)tct.clt.element();
            }
            catch (NoSuchElementException e) {
                DbgLog.log("getCaller", "contract does not have a client list");
            }
        }
        return tce != null ? tce.cln : null;
    }

    public TClientEntry[] getClientList() {
        TContractTable tct = this.gEqmFactory.getCurrentContractEntry();
        return tct != null ? tct.clt.toArray(new TClientEntry[0]) : null;
    }

    protected int clearCASAlarmList() {
        String ctx = this.getContext();
        String exp = this.getExportName();
        if (ctx == null || exp == null) {
            return 141;
        }
        String devName = "/" + ctx + "/CAS/" + exp;
        int cc = 55;
        String fec = null;
        try {
            TLink lnk = new TLink(devName, "REMOVEALARMS", null, null, 2);
            cc = lnk.execute(200, true);
            fec = lnk.srvAddr.fecName;
            lnk.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (cc == 0) {
            this.casReadRequired = true;
            this.casName = fec;
            TFecLog.log("clear alarm list at " + devName + "(" + this.casName + ")");
        } else {
            TFecLog.log("this server not monitored by a central alarm server");
        }
        return cc;
    }

    private void initialize(String name, TEquipmentFunction eqpFunction) {
        this.gEqmFactory = TEquipmentModuleFactory.getInstance();
        this.moduleName = name != null ? (name.length() > 6 ? name.substring(0, 6) : name) : "";
        if (eqpFunction != null) {
            this.eqpFcn = eqpFunction;
            this.eqpFcn.setEquipmentModule(this);
        }
        this.registerStockProperties();
        this.getRegisteredUsersFromFile();
        this.getRegisteredNetsFromFile();
        this.getRegisteredAlarmDefinitionsFromFile();
        this.gEqmFactory.addEquipmentModule(this);
        if (this.gEqmFactory.isInitialized && !this.hasInitialized) {
            this.startup();
        }
        this.hasInitialized = true;
    }

    public void setHistoryCycleInterval(int cycleInterval) {
        this.historyCycleInterval = cycleInterval;
    }

    protected void historyCycle() {
        if (this.gEqmFactory.gEqpFcnBusySemaphore) {
            return;
        }
        long thisCycleTime = System.currentTimeMillis();
        THistoryRecord hst = null;
        THistorySpecification spc = null;
        TDataType dout = null;
        TDataType din = new TDataType();
        TAccess access = new TAccess(33);
        short cc = 0;
        if (thisCycleTime - this.lastHistoryCycleTime < (long)this.historyCycleInterval) {
            return;
        }
        this.lastHistoryCycleTime = thisCycleTime;
        int nHistoryRecords = this.gLclHstList.size();
        for (int i = 0; i < nHistoryRecords; ++i) {
            hst = this.gLclHstList.get(i);
            spc = hst.getHspec();
            if (spc.getDepthShort() <= 0) continue;
            hst.setArchiveFileName(thisCycleTime);
            if (thisCycleTime - hst.getTimestamp() < (long)spc.getPollngRate()) continue;
            dout = new TDataType(hst.getArraySize(), hst.getFmt());
            dout.setDataTimeStamp(TDataTime.getDataTimeStamp());
            dout.setSystemDataStamp(TEquipmentModuleFactory.getInstance().getSystemStamp());
            this.gEqmFactory.gEqpFcnBusySemaphore = true;
            cc = this.callProperty(hst.getPrp(), hst.getDev(), dout, din, access);
            this.gEqmFactory.gEqpFcnBusySemaphore = false;
            if (cc != 0) continue;
            hst.writeRecordToSTS(dout);
            if (!this.needToArchiveRecord(hst)) continue;
            hst.writeRecordToLTS(dout);
            if (!hst.isPointOfInterest()) continue;
            hst.writeRecordToPIF(dout);
        }
    }

    private boolean needToArchiveRecord(THistoryRecord hst) {
        long ts = System.currentTimeMillis();
        if (hst == null) {
            return false;
        }
        THistorySpecification spc = hst.getHspec();
        if (spc == null) {
            return false;
        }
        if (spc.getArchiveRate() < 0 || spc.getHeartbeat() < 0 || spc.getDepthLong() <= 0) {
            return false;
        }
        if (hst.getRngBufferSize() <= 0) {
            return false;
        }
        if (hst.getTimestamp() <= hst.getLastArchiveTime()) {
            return false;
        }
        if (ts < hst.getLastArchiveTime() + (long)spc.getArchiveRate()) {
            return false;
        }
        if (ts >= hst.getLastArchiveTime() + (long)(spc.getHeartbeat() * 1000)) {
            return true;
        }
        return !hst.isWithinTolerance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkAlarmsInWatchTable() {
        if (this.gEqmFactory.gEqpFcnBusySemaphore) {
            return;
        }
        TDataType dout = null;
        TDataType din = new TDataType();
        TAccess access = new TAccess(17);
        TAlarmWatchEntry awe = null;
        TAlarmDefinition adef = null;
        TAlarm alm = null;
        TDevice dev = null;
        short cc = 0;
        int cnt = 0;
        int siz = 0;
        int sev = 0;
        int code = 0;
        int asys = 0;
        float[] fvals = null;
        int[] ivals = null;
        byte[] abytes = null;
        LinkedList<TAlarmWatchEntry> linkedList = this.gAlarmWatchList;
        synchronized (linkedList) {
            int awlength = this.gAlarmWatchList.size();
            for (int i = 0; i < awlength; ++i) {
                awe = this.gAlarmWatchList.get(i);
                int chk = awe.checkNormal();
                if (chk != 0) {
                    if (chk == 1) {
                        ivals = new int[awe.getSiz()];
                    }
                    dout = new TDataType(ivals);
                    this.gEqmFactory.gEqpFcnBusySemaphore = true;
                    cc = this.callProperty(awe.getPrp(), awe.getDev(), dout, din, access);
                    this.gEqmFactory.gEqpFcnBusySemaphore = false;
                } else {
                    fvals = new float[awe.getSiz()];
                    dout = new TDataType(fvals);
                    this.gEqmFactory.gEqpFcnBusySemaphore = true;
                    cc = this.callProperty(awe.getPrp(), awe.getDev(), dout, din, access);
                    this.gEqmFactory.gEqpFcnBusySemaphore = false;
                }
                if (cc != 0) continue;
                boolean hasAlarm = false;
                int devNr = this.deviceList.getDeviceNumber(awe.getDev());
                cnt = 0;
                siz = awe.getSiz();
                for (int j = 0; j < siz; ++j) {
                    if (awe.getAtyp() == 16) {
                        devNr = j;
                    }
                    if (awe.getAtyp() != 32 && siz == this.deviceList.getNumberOfDevices()) {
                        devNr = j;
                    }
                    dev = this.deviceList.getDevice(devNr);
                    hasAlarm = false;
                    if (ivals != null) {
                        int nval = awe.getNormal();
                        if (chk == 1 && nval != (awe.getMask() & ivals[j]) || chk == -1 && nval == (awe.getMask() & ivals[j])) {
                            code = awe.getCode();
                            if (code == 0) {
                                code = 103;
                            }
                            sev = awe.getSev();
                            asys = awe.getAsys();
                            hasAlarm = true;
                        }
                        abytes = Swap.LongToBytes(ivals[j]);
                    } else if (fvals != null) {
                        if (fvals[j] > awe.getHi()) {
                            code = awe.getCode();
                            if (code == 0) {
                                code = awe.getCodeHigh();
                            }
                            if (code == 0) {
                                code = 122;
                            }
                            sev = awe.getSev();
                            asys = awe.getAsys();
                            hasAlarm = true;
                        } else if (fvals[j] > awe.getHiwarn()) {
                            code = awe.getCode();
                            if (code == 0) {
                                code = awe.getCodeHigh();
                            }
                            if (code == 0) {
                                code = 124;
                            }
                            sev = awe.getSev() - 2;
                            asys = awe.getAsys();
                            hasAlarm = true;
                        } else if (fvals[j] < awe.getLo()) {
                            code = awe.getCode();
                            if (code == 0) {
                                code = awe.getCodeLow();
                            }
                            if (code == 0) {
                                code = 123;
                            }
                            sev = awe.getSev();
                            asys = awe.getAsys();
                            hasAlarm = true;
                        } else if (fvals[j] < awe.getLowarn()) {
                            code = awe.getCode();
                            if (code == 0) {
                                code = awe.getCodeLow();
                            }
                            if (code == 0) {
                                code = 125;
                            }
                            sev = awe.getSev() - 2;
                            asys = awe.getAsys();
                            hasAlarm = true;
                        }
                        abytes = Swap.Float(fvals[j]);
                    }
                    if (!hasAlarm) {
                        dev.clearAlarm(103);
                        dev.clearAlarm(122);
                        dev.clearAlarm(123);
                        dev.clearAlarm(124);
                        dev.clearAlarm(125);
                        if (awe.getCode() > 0) {
                            dev.clearAlarm(awe.getCode());
                        }
                        if (awe.getCodeHigh() > 0) {
                            dev.clearAlarm(awe.getCodeHigh());
                        }
                        if (awe.getCodeLow() <= 0) continue;
                        dev.clearAlarm(awe.getCodeLow());
                        continue;
                    }
                    if (code == 0) continue;
                    awe.setCnt(++cnt);
                    if (dev == null || (alm = dev.setAlarm(code, abytes)) == null) continue;
                    adef = alm.getAlmDef();
                    if (sev != 0) {
                        adef.setAlarmSeverity(sev);
                    }
                    if (asys == 0) continue;
                    adef.setAlarmSystem(asys);
                }
                if (cnt != 0) continue;
                awe.setCnt(0);
            }
        }
    }

    private void updateAlarmDynSet() {
        long ts = System.currentTimeMillis();
        int tss = (int)(ts / 1000L);
        int tsu = (int)(ts % 1000L) * 1000;
        if (this.deviceList.getNumberOfAlarms() <= TAlarm.getAlmCollapseWindow()) {
            if (this.almDynSet.starttime == 0) {
                return;
            }
            if ((this.almDynSet.descriptor & 0x40) == 64) {
                return;
            }
            this.almDynSet.descriptor = (byte)64;
            this.almDynSet.timestamp = tss;
            this.almDynSet.timestampUSec = tsu;
            return;
        }
        if (this.almDynSet.descriptor == 0 || (this.almDynSet.descriptor & 0x40) == 64) {
            this.almDynSet.descriptor = 1;
            this.almDynSet.timestamp = tss;
            this.almDynSet.timestampUSec = tsu;
            this.almDynSet.starttime = this.almDynSet.timestamp;
            this.almDynSet.starttimeUSec = this.almDynSet.timestampUSec;
            return;
        }
        if (this.almDynSet.timestamp + TAlarm.getAlmHeartbeatWindow() < tss) {
            this.almDynSet.descriptor = (byte)2;
            this.almDynSet.timestamp = tss;
            this.almDynSet.timestampUSec = tsu;
            return;
        }
    }

    protected void update() {
        if (this.isIdle) {
            return;
        }
        this.accessLock.checkAccessLocks();
        this.checkAlarmsInWatchTable();
        this.deviceList.refreshAlarms();
        this.updateAlarmDynSet();
        this.historyCycle();
    }

    private int prpQueryCall(String devName, TDataType dout, TDataType din, TAccess devAccess) {
        boolean checkWildCard;
        int cc = 0;
        TDevice dev = this.getDeviceList().getDevice(devName);
        LinkedList<String> lst = null;
        boolean bl = checkWildCard = devName.compareTo("*") != 0 && devName.indexOf("*") != -1;
        if (dev != null && (lst = dev.getPropertyList()) != null) {
            String[] slst = new String[lst.size()];
            lst.toArray(slst);
            if (checkWildCard) {
                slst = StringToName.matchStringsInArray(slst, devName);
            }
            if (dout.getFormat() == 24) {
                TCompoundDataObject[] ustr = new USTRING[slst.length];
                StringBuffer sb = new StringBuffer(80);
                for (int i = 0; i < slst.length; ++i) {
                    ustr[i] = new USTRING();
                    TExportProperty prp = this.propertyList.getFirstProperty(slst[i]);
                    if (prp == null) continue;
                    char[] cha = prp.getName().toCharArray();
                    sb.insert(0, cha);
                    for (int c = cha.length; c < 32; ++c) {
                        sb.insert(c, '\u0000');
                    }
                    cha = prp.getDescription().getText().toCharArray();
                    sb.insert(32, cha);
                    ((USTRING)ustr[i]).setValues(prp.getOutputSize(), 0.0f, 0.0f, prp.getOutputFormat(), new String(sb));
                }
                cc = dout.putData(ustr);
            } else {
                cc = dout.putData(StringToName.stringArrayToName64(slst));
            }
        } else {
            String[] slst = new String[this.propertyList.countUniqueProperties()];
            this.propertyList.getPropertyNames().toArray(slst);
            if (checkWildCard) {
                slst = StringToName.matchStringsInArray(slst, devName);
            }
            if (dout.getFormat() == 24) {
                TCompoundDataObject[] ustr = new USTRING[slst.length];
                StringBuffer sb = new StringBuffer(80);
                for (int i = 0; i < slst.length; ++i) {
                    ustr[i] = new USTRING();
                    TExportProperty prp = this.propertyList.getFirstProperty(slst[i]);
                    if (prp == null) continue;
                    char[] cha = prp.getName().toCharArray();
                    sb.insert(0, cha);
                    for (int c = cha.length; c < 32; ++c) {
                        sb.insert(c, '\u0000');
                    }
                    cha = prp.getDescription().getText().toCharArray();
                    sb.insert(32, cha);
                    ((USTRING)ustr[i]).setValues(prp.getOutputSize(), 0.0f, 0.0f, prp.getOutputFormat(), new String(sb));
                }
                cc = dout.putData(ustr);
            } else {
                cc = dout.putData(StringToName.stringArrayToName64(slst));
            }
        }
        if (cc == 0 && this.propertyList.isDeviceOriented()) {
            cc = 16512;
        }
        return cc;
    }

    void registerStockProperties() {
        if (this.stockPropertiesRegistered) {
            return;
        }
        final TEquipmentModule thisEqm = this;
        if (this.gEqmFactory == null) {
            this.gEqmFactory = TEquipmentModuleFactory.getInstance();
        }
        this.stockList = new TPropertyList();
        TPropertyHandler propertiesStructHandler = new TPropertyHandler(){

            public int call(String devName, TDataType dout, TDataType din, TAccess devAccess) {
                if (dout != null) {
                    switch (dout.dFormat) {
                        case 7: {
                            if (dout.getTag().compareTo("PRPQSr4") == 0 || dout.getArrayLength() % 432 == 0) {
                                if (din != null) {
                                    String propertyName = din.toString();
                                    LinkedList propInstances = TEquipmentModule.this.propertyList.getEqualProperties(propertyName = propertyName.replace('\n', '\u0000').trim());
                                    if (propInstances == null || propInstances.size() == 0) {
                                        return 116;
                                    }
                                    THistoryRecord lhr = null;
                                    TPropertyQuery[] prpq = new TPropertyQuery[propInstances.size()];
                                    byte[] tba = new byte[prpq.length * 432];
                                    Iterator it = propInstances.iterator();
                                    for (int i = 0; it.hasNext() && i < prpq.length; ++i) {
                                        prpq[i] = new TPropertyQuery((TExportProperty)it.next(), propInstances.size() - 1);
                                        lhr = TEquipmentModule.this.getLocalHistoryRecord(prpq[i].prpName, "#0");
                                        if (lhr != null) {
                                            prpq[i].prpHistoryDepthLong = (short)lhr.getHspec().getDepthLong();
                                            prpq[i].prpHistoryDepthShort = (short)lhr.getHspec().getDepthShort();
                                        }
                                        System.arraycopy(prpq[i].toByteArray(), 0, tba, i * 432, 432);
                                    }
                                    return dout.putData(tba, "PRPQSr4");
                                }
                                String[] slst = new String[TEquipmentModule.this.propertyList.countUniqueProperties()];
                                TEquipmentModule.this.propertyList.getPropertyNames().toArray(slst);
                                TPropertyQuery[] prpq = new TPropertyQuery[slst.length];
                                if (slst.length == 0) break;
                                byte[] tba = new byte[slst.length * 432];
                                for (int i = 0; i < slst.length; ++i) {
                                    TExportProperty prp = TEquipmentModule.this.propertyList.getFirstProperty(slst[i]);
                                    prpq[i] = new TPropertyQuery(prp, 1);
                                    System.arraycopy(prpq[i].toByteArray(), 0, tba, i * 432, 432);
                                }
                                return dout.putData(tba, "PRPQSr4");
                            }
                            if (dout.getTag().compareTo("XPQS") == 0 || dout.getArrayLength() % XPropertyQuery.sizeInBytes == 0) {
                                if (din != null) {
                                    String propertyName = din.toString();
                                    LinkedList propInstances = TEquipmentModule.this.propertyList.getEqualProperties(propertyName = propertyName.replace('\n', '\u0000').trim());
                                    if (propInstances == null || propInstances.size() == 0) {
                                        return 116;
                                    }
                                    THistoryRecord lhr = null;
                                    XPropertyQuery[] xpq = new XPropertyQuery[propInstances.size()];
                                    byte[] tba = new byte[xpq.length * XPropertyQuery.sizeInBytes];
                                    Iterator it = propInstances.iterator();
                                    for (int i = 0; it.hasNext() && i < xpq.length; ++i) {
                                        xpq[i] = new XPropertyQuery((TExportProperty)it.next(), propInstances.size() - 1);
                                        lhr = TEquipmentModule.this.getLocalHistoryRecord(xpq[i].prpName, "#0");
                                        if (lhr != null) {
                                            xpq[i].prpHistoryDepthLong = (short)lhr.getHspec().getDepthLong();
                                            xpq[i].prpHistoryDepthShort = (short)lhr.getHspec().getDepthShort();
                                        }
                                        System.arraycopy(xpq[i].toByteArray(), 0, tba, i * XPropertyQuery.sizeInBytes, XPropertyQuery.sizeInBytes);
                                    }
                                    return dout.putData(tba, "XPQS");
                                }
                                String[] slst = new String[TEquipmentModule.this.propertyList.countUniqueProperties()];
                                TEquipmentModule.this.propertyList.getPropertyNames().toArray(slst);
                                XPropertyQuery[] xpq = new XPropertyQuery[slst.length];
                                if (slst.length == 0) break;
                                byte[] tba = new byte[slst.length * XPropertyQuery.sizeInBytes];
                                for (int i = 0; i < slst.length; ++i) {
                                    TExportProperty prp = TEquipmentModule.this.propertyList.getFirstProperty(slst[i]);
                                    xpq[i] = new XPropertyQuery(prp, 1);
                                    System.arraycopy(xpq[i].toByteArray(), 0, tba, i * XPropertyQuery.sizeInBytes, XPropertyQuery.sizeInBytes);
                                }
                                return dout.putData(tba, "XPQS");
                            }
                            if (dout.getTag().compareTo("PQS") != 0 && dout.getArrayLength() % PropertyQuery.sizeInBytes != 0) break;
                            if (din != null) {
                                String propertyName = din.toString();
                                LinkedList propInstances = TEquipmentModule.this.propertyList.getEqualProperties(propertyName = propertyName.replace('\n', '\u0000').trim());
                                if (propInstances == null || propInstances.size() == 0) {
                                    return 116;
                                }
                                PropertyQuery[] pqs = new PropertyQuery[1];
                                TExportProperty prp = TEquipmentModule.this.propertyList.getFirstProperty(propertyName);
                                byte[] tba = new byte[PropertyQuery.sizeInBytes];
                                pqs[0] = new PropertyQuery();
                                pqs[0].name = propertyName;
                                pqs[0].prpDesc = prp.getDescription().getText();
                                pqs[0].prpAccess = (byte)prp.getAccessMode();
                                pqs[0].prpFormat = (byte)(prp.getOutputFormat() % 512);
                                pqs[0].prpSize = (short)prp.getOutputSize();
                                System.arraycopy(pqs[0].toByteArray(), 0, tba, 0, PropertyQuery.sizeInBytes);
                                return dout.putData(tba, "PQS");
                            }
                            String[] slst = new String[TEquipmentModule.this.propertyList.countUniqueProperties()];
                            TEquipmentModule.this.propertyList.getPropertyNames().toArray(slst);
                            if (slst.length == 0) break;
                            PropertyQuery[] pqs = new PropertyQuery[slst.length];
                            byte[] tba = new byte[slst.length * PropertyQuery.sizeInBytes];
                            for (int i = 0; i < slst.length; ++i) {
                                pqs[i] = new PropertyQuery();
                                pqs[i].name = slst[i];
                                TExportProperty prp = TEquipmentModule.this.propertyList.getFirstProperty(slst[i]);
                                pqs[i].prpDesc = prp.getDescription().getText();
                                pqs[i].prpAccess = (byte)prp.getAccessMode();
                                pqs[i].prpFormat = (byte)(prp.getOutputFormat() % 512);
                                pqs[i].prpSize = (short)prp.getOutputSize();
                                System.arraycopy(pqs[i].toByteArray(), 0, tba, i * PropertyQuery.sizeInBytes, PropertyQuery.sizeInBytes);
                            }
                            return dout.putData(tba, "PQS");
                        }
                    }
                }
                return 2;
            }
        };
        TPropertyHandler alarmsStructHandler = new TPropertyHandler(){

            public int call(String devName, TDataType dout, TDataType din, TAccess devAccess) {
                int dstop;
                int dstart;
                int[] amrb;
                block25: {
                    block24: {
                        if (dout == null) {
                            return 23;
                        }
                        if (dout.dFormat != 7) {
                            return 2;
                        }
                        amrb = new int[4];
                        if (din == null) break block24;
                        switch (din.dFormat) {
                            case 7: {
                                if (din.dArrayLength != 16) {
                                    return 2;
                                }
                                byte[] bdata = din.getDataBuffer();
                                byte[] ival = new byte[4];
                                for (int i = 0; i < 3; ++i) {
                                    System.arraycopy(bdata, i * 4, ival, 0, 4);
                                    amrb[i] = Swap.Long(ival);
                                }
                                break block25;
                            }
                            case 3: {
                                din.getData(amrb);
                                break;
                            }
                            default: {
                                return 2;
                            }
                        }
                        break block25;
                    }
                    amrb[0] = 0;
                    amrb[1] = (int)(System.currentTimeMillis() / 1000L);
                    amrb[2] = 0;
                    amrb[3] = 0;
                }
                boolean collapse = false;
                int astart = amrb[0];
                int astop = amrb[1];
                int asev = amrb[2];
                if (devName == null || devName.length() == 0 || devName.startsWith("#") || devName.contains("*")) {
                    int nalms = TEquipmentModule.this.deviceList.getNumberOfAlarms();
                    if (nalms > TAlarm.getAlmCollapseWindow()) {
                        collapse = true;
                    }
                    dstart = 0;
                    dstop = TEquipmentModule.this.deviceList.getNumberOfDevices();
                } else {
                    dstart = TEquipmentModule.this.deviceList.getDeviceNumber(devName);
                    dstop = dstart + 1;
                }
                TAlarm[] alms = null;
                TAlarmMessage[] ams = null;
                int buflength = 0;
                byte[] tba = null;
                int code = 115;
                int na = 0;
                if (collapse) {
                    buflength = 1;
                    na = 1;
                    ams = new TAlarmMessage[buflength];
                    String atag = "more than " + TAlarm.getAlmCollapseWindow() + " total alarms";
                    short[] tna = new short[]{(short)TEquipmentModule.this.deviceList.getNumberOfAlarms()};
                    TDataType dt = new TDataType(tna);
                    if (TEquipmentModule.this.deviceList.getNumberOfDevices() > TAlarm.getAlmCollapseWindow()) {
                        TDevice[] tdevs = TEquipmentModule.this.deviceList.getDeviceList();
                        int n = 0;
                        for (TDevice td : tdevs) {
                            TAlarm[] as = td.getAlarmList();
                            if (as == null || as[0] == null) continue;
                            for (int i = 0; i < as.length; ++i) {
                                if (!TEquipmentModule.this.isCasInClientList()) continue;
                                as[i].allowRemoval();
                            }
                            if (code == 115) {
                                code = as[0].getCode();
                            }
                            if (code != as[0].getCode()) break;
                            ++n;
                        }
                        if (n > TAlarm.getAlmCollapseWindow()) {
                            TAlarmDefinition ad = TEquipmentModule.this.getAlarmDefinition(code);
                            atag = "" + n + " alarms: " + ad != null ? ad.getAlarmTag() : "<no defined alarm tag>";
                        }
                    }
                    ams[0] = new TAlarmMessage(thisEqm.getExportName(), thisEqm.getExportName(), atag, code, TEquipmentModule.this.deviceList.getHighestAlarmSeverity(null, 0), TEquipmentModule.this.almDynSet, dt);
                    tba = new byte[buflength * 224];
                } else {
                    int ts = 0;
                    buflength = TEquipmentModule.this.deviceList.getNumberOfAlarms();
                    ams = new TAlarmMessage[buflength];
                    tba = new byte[buflength * 224];
                    TDevice[] dlst = TEquipmentModule.this.deviceList.getDeviceList();
                    for (int i = dstart; i < dstop; ++i) {
                        alms = dlst[i].getAlarmList();
                        if (alms == null || alms.length == 0) continue;
                        for (int n = 0; n < alms.length && na < buflength; ++n) {
                            ts = alms[n].getTimeStamp();
                            if (ts < astart || ts > astop || alms[n].getSeverity() < asev) continue;
                            ams[na] = new TAlarmMessage(thisEqm, dlst[i].getName(), alms[n]);
                            System.arraycopy(ams[na].toByteArray(), 0, tba, na * 224, 224);
                            if (TEquipmentModule.this.casReadRequired && TEquipmentModule.this.isCasInClientList()) {
                                alms[n].allowRemoval();
                            }
                            ++na;
                        }
                    }
                }
                if (dout.getTag().compareTo("AMSr4") == 0) {
                    for (int i = 0; i < buflength && i < na; ++i) {
                        System.arraycopy(ams[i].toByteArray(), 0, tba, i * 224, 224);
                    }
                    if (na < dout.getArrayLength()) {
                        dout.setArrayLength(na);
                    }
                    return dout.putData(tba, "AMSr4");
                }
                return 62;
            }
        };
        TPropertyHandler alarmDefsStructHandler = new TPropertyHandler(){

            public int call(String devName, TDataType dout, TDataType din, TAccess devAccess) {
                if (dout == null) {
                    return 23;
                }
                if (dout.dFormat != 7) {
                    return 2;
                }
                int almdefsize = TEquipmentModule.this.alarmDefinitionList.size();
                int adssize = TStructRegistry.getSizeInBytes("ADSr4");
                byte[] tba = new byte[almdefsize * adssize];
                TAlarmDefinition[] adef = TEquipmentModule.this.alarmDefinitionList.values().toArray(new TAlarmDefinition[0]);
                if (dout.getTag().compareTo("ADSr4") == 0) {
                    for (int i = 0; i < almdefsize; ++i) {
                        System.arraycopy(adef[i].toByteArray(), 0, tba, i * adssize, adssize);
                    }
                    if (almdefsize < dout.getArrayLength()) {
                        dout.setArrayLength(almdefsize);
                    }
                    return dout.putData(tba, "ADSr4");
                }
                return 62;
            }
        };
        TPropertyHandler alarmWatchStructHandler = new TPropertyHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public int call(String devName, TDataType dout, TDataType din, TAccess devAccess) {
                if (dout == null) {
                    return 23;
                }
                if (dout.dFormat != 7) {
                    return 2;
                }
                LinkedList<TAlarmWatchEntry> linkedList = TEquipmentModule.this.gAlarmWatchList;
                synchronized (linkedList) {
                    int almwtblsize = TEquipmentModule.this.gAlarmWatchList.size();
                    int awssize = TStructRegistry.getSizeInBytes("AWSr4");
                    byte[] tba = new byte[almwtblsize * awssize];
                    TAlarmWatchEntry[] aws = TEquipmentModule.this.gAlarmWatchList.toArray(new TAlarmWatchEntry[0]);
                    if (devAccess.isWrite()) {
                        if (din.getFormat() != 7) {
                            return 2;
                        }
                        if (din.getTag().compareTo("AWSr4") == 0) {
                            TTaggedStructure[] awe = new TAlarmWatchEntry[]{new TAlarmWatchEntry()};
                            din.getData(awe);
                            ((TAlarmWatchEntry)awe[0]).setEquipmentModule(TEquipmentModule.this.getLocalName());
                            boolean isNew = false;
                            for (int i = 0; i < aws.length; ++i) {
                                if (!aws[i].equals(awe[0])) continue;
                                aws[i].adjustFrom((TAlarmWatchEntry)awe[0]);
                                isNew = true;
                                break;
                            }
                            if (isNew) {
                                TExportProperty p = TEquipmentModule.this.propertyList.getFirstProperty(((TAlarmWatchEntry)awe[0]).getPrp());
                                if (p == null) {
                                    return 36;
                                }
                                if (((TAlarmWatchEntry)awe[0]).getSiz() <= 0 || ((TAlarmWatchEntry)awe[0]).getSiz() > p.getOutputSize()) {
                                    ((TAlarmWatchEntry)awe[0]).setSiz(p.getOutputSize());
                                }
                                ((TAlarmWatchEntry)awe[0]).setFmt(p.getOutputFormat());
                                TEquipmentModule.this.gAlarmWatchList.add((TAlarmWatchEntry)awe[0]);
                            }
                        } else {
                            return 62;
                        }
                    }
                    if (dout.getTag().compareTo("AWSr4") == 0) {
                        for (int i = 0; i < almwtblsize; ++i) {
                            System.arraycopy(aws[i].toByteArray(), 0, tba, i * awssize, awssize);
                        }
                        if (almwtblsize < dout.getArrayLength()) {
                            dout.setArrayLength(almwtblsize);
                        }
                        return dout.putData(tba, "AWSr4");
                    }
                }
                return 62;
            }
        };
        this.stockList.addProperty(TStockProperties.NALARMS, new TPropertyHandler(){
            int nalmdefs;
            {
                this.nalmdefs = TEquipmentModule.this.alarmDefinitionList.size();
            }

            public int call(String devName, TDataType dout, TDataType din, TAccess devAccess) {
                int devnr = -1;
                if (!devName.contains("*") && !devName.startsWith("#")) {
                    devnr = TEquipmentModule.this.deviceList.getDeviceNumber(devName);
                }
                if (TEquipmentModule.this.casName != null && !TEquipmentModule.this.hasCasAttached) {
                    TEquipmentModule.this.isCasInClientList();
                }
                int[] nalms = new int[6];
                if (devnr < 0) {
                    nalms[0] = TEquipmentModule.this.deviceList.getNumberOfAlarms();
                    nalms[1] = TEquipmentModule.this.deviceList.getMostRecentAlarmTimestamp(nalms, 3);
                    nalms[2] = TEquipmentModule.this.deviceList.getHighestAlarmSeverity(nalms, 4);
                    nalms[5] = this.nalmdefs;
                    if (nalms[0] > TAlarm.getAlmCollapseWindow()) {
                        nalms[0] = 1;
                        nalms[3] = 1;
                        nalms[4] = 1;
                    }
                } else {
                    int mrts = 0;
                    int hsv = 0;
                    int nts = 0;
                    int nsv = 0;
                    TDevice[] dlst = TEquipmentModule.this.deviceList.getDeviceList();
                    if (devnr >= dlst.length) {
                        return 32;
                    }
                    TAlarm[] alms = dlst[devnr].getAlarmList();
                    nalms[0] = alms.length;
                    for (int i = 0; i < alms.length; ++i) {
                        int sv;
                        int ts = alms[i].getTimeStamp();
                        if (ts > mrts) {
                            mrts = ts;
                            nts = 0;
                        }
                        if (ts == mrts) {
                            ++nts;
                        }
                        if ((sv = alms[i].getSeverity()) > hsv) {
                            hsv = sv;
                            nsv = 0;
                        }
                        if (sv != hsv) continue;
                        ++nsv;
                    }
                    nalms[1] = mrts;
                    nalms[2] = hsv;
                    nalms[3] = nts;
                    nalms[4] = nsv;
                    nalms[5] = this.nalmdefs;
                }
                if (dout.dArrayLength > 5) {
                    nalms[5] = TEquipmentModule.this.getAlarmDefinitionList().size();
                }
                return dout.putData(nalms);
            }
        });
        this.stockList.addProperty(TStockProperties.NALARMDEFS, new TPropertyHandler(){

            public int call(String devName, TDataType dout, TDataType din, TAccess devAccess) {
                return dout.putData((short)TEquipmentModule.this.alarmDefinitionList.size());
            }
        });
        this.stockList.addProperty(TStockProperties.NALMWATCH, new TPropertyHandler(){

            public int call(String devName, TDataType dout, TDataType din, TAccess devAccess) {
                return dout.putData((short)TEquipmentModule.this.gAlarmWatchList.size());
            }
        });
        this.stockList.addProperty(TStockProperties.ALARMS, alarmsStructHandler);
        this.stockList.addProperty(TStockProperties.ALARMSEXT, alarmsStructHandler);
        this.stockList.addProperty(TStockProperties.ALARMSEXT_STRUCTIN, alarmsStructHandler);
        this.stockList.addProperty(TStockProperties.ALARMDEFS, alarmDefsStructHandler);
        this.stockList.addProperty(TStockProperties.ALMWATCHTBL, alarmWatchStructHandler);
        this.stockList.addProperty(TStockProperties.NHISTORIES, new TPropertyHandler(){

            public int call(String devName, TDataType dout, TDataType din, TAccess devAccess) {
                return dout.putData((short)TEquipmentModule.this.gLclHstList.size());
            }
        });
        this.stockList.addProperty(TStockProperties.HISTORIES, new TPropertyHandler(){

            public int call(String devName, TDataType dout, TDataType din, TAccess devAccess) {
                THistoryRecord[] hsts = TEquipmentModule.this.gLclHstList.toArray(new THistoryRecord[0]);
                TCompoundDataObject[] nams = new NAME64[hsts.length];
                for (int i = 0; i < nams.length; ++i) {
                    nams[i] = new NAME64(hsts[i].getPrp());
                }
                return dout.putData(nams);
            }
        });
        this.stockList.addProperty(TStockProperties.ADDHISTORY, new TPropertyHandler(){

            public int call(String devName, TDataType dout, TDataType din, TAccess devAccess) {
                if (devAccess.isWrite()) {
                    if (din.getFormat() != 7) {
                        return 2;
                    }
                    if (din.getTag().compareTo("HRSr4") == 0) {
                        TTaggedStructure[] hrs = new THistoryRecordStruct[]{new THistoryRecordStruct()};
                        din.getData(hrs);
                        THistoryRecord hr = TEquipmentModule.this.getLocalHistoryRecord(((THistoryRecordStruct)hrs[0]).getProperty(), ((THistoryRecordStruct)hrs[0]).getDevice());
                        if (hr != null) {
                            THistorySpecification hsp = hr.getHspec();
                            hsp.setAbsoluteTolerance(((THistoryRecordStruct)hrs[0]).getAbsoluteTolerance());
                            hsp.setPercentTolerance(((THistoryRecordStruct)hrs[0]).getPercentTolerance());
                            hsp.setArchiveRate(((THistoryRecordStruct)hrs[0]).getArchiveRate());
                            hsp.setPollngRate(((THistoryRecordStruct)hrs[0]).getPollingRate());
                            hsp.setDepthLong(((THistoryRecordStruct)hrs[0]).getDepthLong());
                            hsp.setDepthShort(((THistoryRecordStruct)hrs[0]).getDepthShort());
                            hsp.setHeartbeat(((THistoryRecordStruct)hrs[0]).getHeartbeat());
                        }
                        return 0;
                    }
                    return 62;
                }
                return 73;
            }
        });
        this.stockList.addProperty(TStockProperties.PROPERTIES, new TPropertyHandler(){

            public int call(String devName, TDataType dout, TDataType din, TAccess devAccess) {
                return TEquipmentModule.this.prpQueryCall(devName, dout, din, devAccess);
            }
        });
        this.stockList.addProperty(TStockProperties.PROPERTIES_USTRING, new TPropertyHandler(){

            public int call(String devName, TDataType dout, TDataType din, TAccess devAccess) {
                return TEquipmentModule.this.prpQueryCall(devName, dout, din, devAccess);
            }
        });
        this.stockList.addProperty(TStockProperties.PROPERTIES_STRUCT, propertiesStructHandler);
        this.stockList.addProperty(TStockProperties.PROPS, new TPropertyHandler(){

            public int call(String devName, TDataType dout, TDataType din, TAccess devAccess) {
                return TEquipmentModule.this.prpQueryCall(devName, dout, din, devAccess);
            }
        });
        this.stockList.addProperty(TStockProperties.PROPS_USTRING, new TPropertyHandler(){

            public int call(String devName, TDataType dout, TDataType din, TAccess devAccess) {
                return TEquipmentModule.this.prpQueryCall(devName, dout, din, devAccess);
            }
        });
        this.stockList.addProperty(TStockProperties.PROPS_STRUCT, propertiesStructHandler);
        this.stockList.addProperty(TStockProperties.NPROPERTIES, new TPropertyHandler(){

            public int call(String devName, TDataType dout, TDataType din, TAccess devAccess) {
                return dout.putData(TEquipmentModule.this.propertyList.countUniqueProperties());
            }
        });
        this.stockList.addProperty(TStockProperties.NPROPS, new TPropertyHandler(){

            public int call(String devName, TDataType dout, TDataType din, TAccess devAccess) {
                return dout.putData(TEquipmentModule.this.propertyList.countUniqueProperties());
            }
        });
        this.stockList.addProperty(TStockProperties.NDEVICES, new TPropertyHandler(){

            public int call(String devName, TDataType dout, TDataType din, TAccess devAccess) {
                return dout.putData(TEquipmentModule.this.deviceList.getNumberOfDevices());
            }
        });
        this.stockList.addProperty(TStockProperties.DEVICES, new TPropertyHandler(){

            public int call(String devName, TDataType dout, TDataType din, TAccess devAccess) {
                int cc;
                String[] namlst = TEquipmentModule.this.deviceList.getDeviceNameList();
                if (devName.compareTo("*") != 0 && devName.indexOf("*") != -1) {
                    namlst = StringToName.matchStringsInArray(namlst, devName);
                }
                if ((cc = dout.putData(StringToName.stringArrayToName64(namlst))) == 0 && TEquipmentModule.this.getDeviceList().isPropertyOriented()) {
                    cc = 16512;
                }
                return cc;
            }
        });
        this.stockList.addProperty(TStockProperties.DEVDESCRIPTION, new TPropertyHandler(){

            public int call(String devName, TDataType dout, TDataType din, TAccess devAccess) {
                TDevice tdv = TEquipmentModule.this.deviceList.getDevice(devName);
                if (tdv == null) {
                    return 35;
                }
                String dsc = tdv.getDescription();
                return dout.putData(dsc == null ? "" : dsc);
            }
        });
        this.stockList.addProperty(TStockProperties.SRVIDLE, new TPropertyHandler(){

            public int call(String devName, TDataType dout, TDataType din, TAccess devAccess) {
                int cc = 0;
                int[] idleState = new int[1];
                if (din != null && devAccess.isWrite()) {
                    cc = din.getData(idleState);
                    if (cc != 0) {
                        return cc;
                    }
                    TEquipmentModule.this.isIdle = idleState[0] != 0;
                }
                if (dout != null && dout.dArrayLength > 0) {
                    idleState[0] = TEquipmentModule.this.isIdle ? -1 : 0;
                    cc = dout.putData(idleState);
                }
                return cc;
            }
        });
        this.stockList.addProperty(TStockProperties.SRVINIT, new TPropertyHandler(){

            public int call(String devName, TDataType dout, TDataType din, TAccess devAccess) {
                int cc = 0;
                if (!devAccess.isWrite()) {
                    return 73;
                }
                if (TEquipmentModule.this.eqpIni == null) {
                    return 38;
                }
                cc = TEquipmentModule.this.eqpIni.initialize();
                return cc;
            }
        });
        this.stockList.addProperty(TStockProperties.USERS, new TPropertyHandler(){

            public int call(String devName, TDataType dout, TDataType din, TAccess devAccess) {
                TCompoundDataObject[] n16 = TEquipmentModule.this.getRegisteredUsers();
                if (n16 == null) {
                    n16 = new NAME16[]{new NAME16("")};
                }
                return dout.putData(n16);
            }
        });
        this.stockList.addProperty(TStockProperties.NUSERS, new TPropertyHandler(){

            public int call(String devName, TDataType dout, TDataType din, TAccess devAccess) {
                return dout.putData((short)TEquipmentModule.this.gRegisteredUsersList.size());
            }
        });
        this.stockList.addProperty(TStockProperties.ADDUSER, new TPropertyHandler(){

            public int call(String devName, TDataType dout, TDataType din, TAccess devAccess) {
                if (din != null && devAccess.isWrite()) {
                    TCompoundDataObject[] usr = new NAME16[1];
                    int cc = din.getData(usr);
                    if (cc != 0) {
                        return cc;
                    }
                    return TEquipmentModule.this.addRegisteredUser(usr.toString());
                }
                return 73;
            }
        });
        this.stockList.addProperty(TStockProperties.DELUSER, new TPropertyHandler(){

            public int call(String devName, TDataType dout, TDataType din, TAccess devAccess) {
                if (din != null && devAccess.isWrite()) {
                    TCompoundDataObject[] usr = new NAME16[1];
                    int cc = din.getData(usr);
                    if (cc != 0) {
                        return cc;
                    }
                    return TEquipmentModule.this.removeRegisteredUser(usr.toString());
                }
                return 73;
            }
        });
        this.stockList.addProperty(TStockProperties.IPNETS, new TPropertyHandler(){

            public int call(String devName, TDataType dout, TDataType din, TAccess devAccess) {
                return dout.putData(TEquipmentModule.this.getRegisteredNets());
            }
        });
        this.stockList.addProperty(TStockProperties.NIPNETS, new TPropertyHandler(){

            public int call(String devName, TDataType dout, TDataType din, TAccess devAccess) {
                return dout.putData((short)TEquipmentModule.this.gRegisteredNetsList.size());
            }
        });
        this.stockList.addProperty(TStockProperties.ACCESSLOCK, new TPropertyHandler(){

            public int call(String devName, TDataType dout, TDataType din, TAccess devAccess) {
                int cc = 0;
                if (din != null && devAccess.isWrite()) {
                    short[] svals = new short[2];
                    cc = din.getData(svals);
                    if (cc != 0) {
                        return cc;
                    }
                    cc = TEquipmentModule.this.accessLock.setAccessLock(TEquipmentModule.this.getCaller(), svals[0], svals[1]);
                    if (cc != 0) {
                        return cc;
                    }
                }
                if (dout != null) {
                    String[] s = TEquipmentModule.this.accessLock.getAccessLockAsString();
                    TCompoundDataObject[] n32 = new NAME32[]{new NAME32(s[0]), new NAME32(s[1]), new NAME32(s[2])};
                    cc = dout.putData(n32);
                }
                return cc;
            }
        });
        this.stockList.addProperty(TStockProperties.SRVSELFTEST, new TPropertyHandler(){

            protected int call(String devName, TDataType dout, TDataType din, TAccess devAccess) {
                if (dout.getFormat() != 4) {
                    return 2;
                }
                String fileName = TEquipmentModule.this.gEqmFactory.getInitializer().getFecHome() + "/" + TEquipmentModule.this.getLocalName() + "-selftest.csv";
                if (!TFecLog.fileExists(fileName)) {
                    return 42;
                }
                int nlines = dout.getArrayLength() / 80;
                return (short)dout.putData(TFecLog.getLines(fileName, nlines));
            }
        });
        this.stockPropertiesRegistered = true;
    }

    public TEquipmentModule(TEquipmentFunction eqpFunction) {
        String name = eqpFunction.getClass().getName();
        StringTokenizer t = new StringTokenizer(name, ".$");
        String lastToken = name;
        while (t.hasMoreTokens()) {
            lastToken = t.nextToken();
        }
        this.initialize(lastToken, eqpFunction);
    }

    public TEquipmentModule(String localName, TEquipmentFunction eqpFunction) {
        this.initialize(localName, eqpFunction);
    }

    public TEquipmentModule(String localName) {
        this.initialize(localName, null);
    }

    public TEquipmentModule() {
        String name = this.getClass().getName();
        StringTokenizer t = new StringTokenizer(name, ".$");
        String localName = name;
        while (t.hasMoreTokens()) {
            localName = t.nextToken();
        }
        this.initialize(localName, null);
    }

    public void setEquipmentFunction(TEquipmentFunction eqpFunction) {
        this.eqpFcn = eqpFunction;
        this.eqpFcn.setEquipmentModule(this);
    }

    public void registerProperty(String prpName, TDataType dout, TDataType din, short acc, TPropertyDescription prpDesc, int prpId) {
        TStrings.validatePropertyName(prpName);
        if (prpDesc == null) {
            prpDesc = new TPropertyDescription(null);
        }
        if (prpDesc.getArrayRowLength() == 0) {
            prpDesc.setArrayRowLength(dout.dArrayLength);
        }
        if (dout.dArrayLength == 1) {
            prpDesc.setArrayType((short)1);
        }
        TExportProperty prp = new TExportProperty(prpId, prpName, acc, din, dout);
        prp.setDescription(prpDesc);
        this.propertyList.addProperty(this, prp, null);
        if (prpName.endsWith(".NAM")) {
            this.deviceList.setPropertyOriented(true);
        }
    }

    public void registerProperty(TExportProperty prp, TPropertyHandler handler) {
        this.propertyList.addProperty(this, prp, handler);
        String aprpnam = this.gEqmFactory.getAliasFromName(prp.getName());
        if (aprpnam != null) {
            TExportProperty aprp = new TExportProperty(prp);
            aprp.setName(aprpnam);
            this.propertyList.addProperty(this, aprp, handler);
        }
        if (prp.getName().endsWith(".NAM")) {
            this.deviceList.setPropertyOriented(true);
        }
    }

    public int attachPropertyHandler(String prp, TPropertyHandler handler) {
        String aprp = this.gEqmFactory.getAliasFromName(prp);
        if (aprp != null) {
            this.propertyList.setHandler(aprp, handler);
        }
        return this.propertyList.setHandler(prp, handler);
    }

    public void registerDevices(Collection<String[]> deviceCollection) {
        int ndevs = deviceCollection.size();
        String[] devs = deviceCollection.toArray(new String[0]);
        for (int i = 0; i < ndevs; ++i) {
            TStrings.validateDeviceName(devs[i]);
            this.deviceList.addDevice(devs[i], this);
        }
    }

    public void registerDevices(String[] deviceNames) {
        if (deviceNames == null) {
            return;
        }
        for (int i = 0; i < deviceNames.length; ++i) {
            TStrings.validateDeviceName(deviceNames[i]);
            this.deviceList.addDevice(deviceNames[i], i, this);
        }
    }

    public void registerDevices(TDevice[] devices) {
        if (devices == null) {
            return;
        }
        for (int i = 0; i < devices.length; ++i) {
            devices[i].setEqm(this);
            this.deviceList.addDevice(devices[i]);
        }
    }

    public void registerDevices(int numberOfDevices) {
        if (numberOfDevices <= 0) {
            return;
        }
        TDevice[] devices = new TDevice[numberOfDevices];
        for (int i = 0; i < numberOfDevices; ++i) {
            devices[i] = new TDevice(i);
            devices[i].setEqm(this);
            this.deviceList.addDevice(devices[i]);
        }
    }

    public int registerDeviceName(String devName) {
        TStrings.validateDeviceName(devName);
        this.deviceList.addDevice(devName, this);
        String adev = this.gEqmFactory.getAliasFromName(devName);
        if (adev != null) {
            this.deviceList.addDevice(adev, this);
        }
        return this.deviceList.getDeviceNumber(devName);
    }

    public int registerDeviceName(String devName, int devNumber) {
        TStrings.validateDeviceName(devName);
        this.deviceList.addDevice(devName, devNumber, this);
        String adev = this.gEqmFactory.getAliasFromName(devName);
        if (adev != null) {
            this.deviceList.addDevice(adev, devNumber, this);
        }
        return devNumber;
    }

    public LinkedList<String> getPropertyNames() {
        LinkedList<String> rv = new LinkedList<String>();
        rv.addAll(this.propertyList.getPropertyNames());
        return rv;
    }

    private void dumpList(String text, LinkedList<String> lst) {
        System.out.println(text);
        Iterator it = lst.iterator();
        while (it.hasNext()) {
            System.out.println((String)it.next());
        }
    }

    public void dumpProperties() {
        this.dumpList("Registered Properties :", this.getPropertyNames());
    }

    public void dumpDevices() {
        this.dumpList("Registered Devices :", this.getDeviceNames());
    }

    public LinkedList<String> getDeviceNames() {
        return this.deviceList.getDeviceLinkedList();
    }

    public boolean hasStockProperty(String propertyName) {
        return this.stockList.hasProperty(propertyName);
    }

    public boolean hasProperty(String propertyName) {
        return this.propertyList.hasProperty(propertyName);
    }

    public short callStockProperty(String propertyName, String devName, TDataType dout, TDataType din, TAccess devAccess) {
        return this.stockList.callPropertyHandler(propertyName, devName, dout, din, devAccess);
    }

    public short callProperty(String propertyName, String devName, TDataType dout, TDataType din, TAccess devAccess) {
        try {
            if (this.propertyList.hasProperty(propertyName)) {
                return this.propertyList.callPropertyHandler(propertyName, devName, dout, din, devAccess);
            }
            if (this.eqpFcn != null) {
                if (TEquipmentModuleFactory.debugLevel > 1) {
                    DbgLog.log("callProperty", "call function handler for " + this.getLocalName() + "/" + devName + "[" + propertyName + "]");
                }
                return this.eqpFcn.call(propertyName, devName, dout, din, devAccess.toShort());
            }
            if (TEquipmentModuleFactory.debugLevel > 1) {
                DbgLog.log("callProperty", "no handler for " + this.getLocalName() + "/" + devName + "[" + propertyName + "]");
            }
            return 86;
        }
        catch (Exception e) {
            this.setCompletionString(e.getMessage());
            return 1066;
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public short callMetaProperty(String metaPropertyName, String devName, TDataType dout, TDataType din, TAccess devAccess) {
        try {
            if (!this.gEqmFactory.metaProps.isMetaProperty(metaPropertyName)) {
                return 36;
            }
            propertyName = this.gEqmFactory.metaProps.getTargetProperty(metaPropertyName);
            if (!this.propertyList.hasProperty(propertyName)) {
                return 36;
            }
            prp = this.propertyList.getFirstProperty(propertyName);
            switch (this.gEqmFactory.metaProps.getIndex(metaPropertyName)) {
                case 4: {
                    return (short)dout.putData(prp.getDescription().getText());
                }
                case 1: {
                    switch (dout.dFormat) {
                        case 4: 
                        case 9: 
                        case 13: 
                        case 36: {
                            return (short)dout.putData(prp.getDescription().getYRange().getUnits());
                        }
                        case 0: 
                        case 1: 
                        case 3: 
                        case 5: 
                        case 6: {
                            yrng = new float[]{prp.getDescription().getYRange().getMinValue(), prp.getDescription().getYRange().getMaxValue()};
                            return (short)dout.putData(yrng);
                        }
                        case 24: {
                            u = new USTRING[]{new USTRING(prp.getDescription().getYRange().getGraphType(), prp.getDescription().getYRange().getMinValue(), prp.getDescription().getYRange().getMaxValue(), 0, prp.getDescription().getYRange().getUnits())};
                            return (short)dout.putData(u);
                        }
                    }
                    return 2;
                }
                case 2: {
                    hst = null;
                    listsize = this.gLclHstList.size();
                    index = 0;
                    sample = 0;
                    start = 0L;
                    stop = System.currentTimeMillis() - 1000L;
                    lwr = 0.0f;
                    upr = 0.0f;
                    data /* !! */  = null;
                    dataSize = 0;
                    inputDataSize = 0;
                    isCentralArchiveRequest = false;
                    if (TMetaProperties.isCentralArchive(metaPropertyName)) {
                        isCentralArchiveRequest = true;
                    }
                    isSnapshot = TMetaProperties.isHistorySnapshot(metaPropertyName);
                    dataSize = dout.getArrayLength();
                    start = stop - (long)(dataSize * 1000);
                    if (din == null || (inputDataSize = din.getArrayLength()) <= 0) ** GOTO lbl103
                    switch (din.getFormat()) {
                        case 3: {
                            ival = (int[])din.getDataObject();
                            switch (inputDataSize) {
                                case 4: {
                                    sample = ival[3];
                                }
                                case 3: {
                                    index = ival[2];
                                }
                                case 2: {
                                    if (ival[1] < (int)(stop / 1000L)) {
                                        stop = (long)ival[1] * 1000L;
                                    }
                                }
                                case 1: {
                                    start = (long)ival[0] * 1000L;
                                }
                            }
                            if (sample < 0) {
                                sample = 0;
                                break;
                            }
                            ** GOTO lbl106
                        }
                        case 6: {
                            lval = (long[])din.getDataObject();
                            switch (inputDataSize) {
                                case 4: {
                                    sample = (int)lval[3];
                                }
                                case 3: {
                                    index = (int)lval[2];
                                }
                                case 2: {
                                    if (lval[1] < stop / 1000L) {
                                        stop = lval[1] * 1000L;
                                    }
                                }
                                case 1: {
                                    start = lval[0] * 1000L;
                                }
                            }
                            if (sample < 0) {
                                sample = 0;
                                break;
                            }
                            ** GOTO lbl106
                        }
                        case 0: {
                            dval = (double[])din.getDataObject();
                            switch (inputDataSize) {
                                case 4: {
                                    sample = (int)dval[3];
                                }
                                case 3: {
                                    index = (int)dval[2];
                                }
                                case 2: {
                                    if (dval[1] < (double)(stop / 1000L)) {
                                        stop = (long)(dval[1] * 1000.0);
                                    }
                                }
                                case 1: {
                                    start = (long)(dval[0] * 1000.0);
                                }
                            }
                            if (sample < 0) {
                                sample = 0;
                                break;
                            }
                            ** GOTO lbl106
                        }
                        case 34: {
                            fw = (FWINDOW[])din.getDataObject();
                            start = fw[0].i1val * 1000;
                            stop = fw[0].i2val * 1000;
                            lwr = fw[0].f1val;
                            upr = fw[0].f2val;
                            if (lwr < upr) {
                                sample = -1;
                                break;
                            }
                            ** GOTO lbl106
                        }
                        default: {
                            return 2;
                        }
                    }
                    ** GOTO lbl106
lbl103:
                    // 1 sources

                    if (dataSize == 1) {
                        start = stop;
                        isSnapshot = true;
                    }
lbl106:
                    // 8 sources

                    if (isSnapshot) {
                        if (start < 1L) {
                            return 20;
                        }
                        stop = start;
                        sample = 0;
                        index = 0;
                        upr = 0.0f;
                        lwr = 0.0f;
                    }
                    literalDevice = false;
                    for (i = 0; i < listsize; ++i) {
                        hst = this.gLclHstList.get(i);
                        if (hst.getPrp().compareToIgnoreCase(prp.getName()) != 0 || hst.getDev().compareTo(devName) != 0) continue;
                        literalDevice = true;
                        break;
                    }
                    for (i = 0; i < listsize; ++i) {
                        hst = this.gLclHstList.get(i);
                        if (hst.getPrp().compareToIgnoreCase(prp.getName()) != 0) continue;
                        if (hst.getDev().compareTo(devName) != 0) {
                            if (index != 0 || literalDevice) continue;
                            index = this.getDeviceList().getDeviceNumber(devName);
                        }
                        if (isCentralArchiveRequest) {
                            rmtsrv = hst.getRemoteHistoryServer();
                            if (rmtsrv == null || rmtsrv.length() == 0) {
                                return 38;
                            }
                            return (short)this.gEqmFactory.setRedirectionString(rmtsrv);
                        }
                        if (start == stop && dataSize > 1) {
                            index = 0;
                        }
                        switch (dout.dFormat) {
                            case 2: {
                                data /* !! */  = new byte[dataSize];
                                break;
                            }
                            case 1: {
                                data /* !! */  = (byte[])new short[dataSize];
                                break;
                            }
                            case 3: {
                                data /* !! */  = (byte[])new int[dataSize];
                                break;
                            }
                            case 6: {
                                data /* !! */  = (byte[])new long[dataSize];
                                break;
                            }
                            case 15: {
                                data /* !! */  = (byte[])new INTINT[dataSize];
                                break;
                            }
                            case 5: {
                                data /* !! */  = (byte[])new float[dataSize];
                                break;
                            }
                            case 14: {
                                data /* !! */  = (byte[])new FLTINT[dataSize];
                                break;
                            }
                            case 18: {
                                data /* !! */  = (byte[])new INTFLTINT[dataSize];
                                break;
                            }
                            case 0: {
                                data /* !! */  = (byte[])new double[dataSize];
                                break;
                            }
                            case 40: {
                                data /* !! */  = (byte[])new DBLDBL[dataSize];
                                break;
                            }
                            case 9: {
                                data /* !! */  = (byte[])new NAME16[dataSize];
                                break;
                            }
                            case 21: {
                                data /* !! */  = (byte[])new NAME16I[dataSize];
                                break;
                            }
                            case 13: {
                                data /* !! */  = (byte[])new NAME32[dataSize];
                                break;
                            }
                            case 22: {
                                data /* !! */  = (byte[])new NAME32I[dataSize];
                                break;
                            }
                            case 36: {
                                data /* !! */  = (byte[])new NAME64[dataSize];
                                break;
                            }
                            case 37: {
                                data /* !! */  = (byte[])new NAME64I[dataSize];
                                break;
                            }
                            case 56: {
                                data /* !! */  = (byte[])new HISTORY[dataSize];
                                f = TFormat.getFormatCode(dout.getTag());
                                if (f == 255) {
                                    return 2;
                                }
                                d = new TDataType(1, f);
                                ((HISTORY[])data /* !! */ )[0] = new HISTORY(d);
                            }
                        }
                        nr = hst.getDataFromLTS(index, start, stop, lwr, upr, data /* !! */ , dataSize, 0, sample);
                        if (nr < 0) {
                            if (nr == -121) {
                                rmtsrv = hst.getRemoteHistoryServer();
                                if (rmtsrv == null || rmtsrv.length() == 0) {
                                    return 38;
                                }
                                return (short)this.gEqmFactory.setRedirectionString(rmtsrv);
                            }
                            return (short)(-nr);
                        }
                        if (nr > 0) {
                            if (isSnapshot || nr >= dataSize - 1) {
                                dout.putData((Object)data /* !! */ );
                                dout.setDataTimeStamp(hst.getLastReadTimestamp());
                                return 0;
                            }
                            start = hst.getLastReadTimestamp() + 1L;
                            if (start == stop) {
                                return 0;
                            }
                        }
                        if ((nr = hst.getDataFromSTS(index, start, stop, lwr, upr, data /* !! */ , dataSize, nr, sample)) < 0) {
                            return (short)(-nr);
                        }
                        if (dataSize > 1 && nr < dataSize) {
                            dout.dArrayLength = nr;
                        }
                        dout.putData((Object)data /* !! */ );
                        dout.setDataTimeStamp(hst.getLastReadTimestamp());
                        return 0;
                    }
                    return 38;
                }
                case 3: {
                    slst = this.deviceList.getDeviceNameList();
                    lst = prp.getDeviceList();
                    if (lst != null && lst.size() > 0) {
                        slst = new String[lst.size()];
                        lst.toArray(slst);
                    }
                    return (short)dout.putData(StringToName.stringArrayToName16(slst));
                }
            }
            return 36;
        }
        catch (Exception e) {
            this.setCompletionString(e.getMessage());
            return 1066;
        }
    }

    public int getExportInformationFromFile() {
        return this.getExportInformationFromFile(this.moduleName);
    }

    public int getExportInformationFromFile(String eqmName) {
        TEquipmentModuleFactory.getInstance().getFecXmlDocument();
        FecCfg cfg = this.gEqmFactory.getFecXmlCfg();
        if (cfg != null) {
            LinkedList<EqmCfg> el = cfg.getEqmList();
            LinkedList<String> dv = null;
            String fctx = this.gEqmFactory.getFecContext();
            for (EqmCfg ec : el) {
                String sub;
                String ctx;
                String exp;
                if (ec.getName().compareTo(eqmName) != 0) continue;
                LinkedList<PropertyCfg> pl = ec.getPropertyList();
                for (PropertyCfg pc : pl) {
                    TExportProperty expp = new TExportProperty(pc.getId().getValue(), pc.getName(), pc.getDescription(), pc.getSizeOut().getValue(), (short)pc.getDTypeOut().getValue(), pc.getDTagOut(), pc.getSizeIn().getValue(), (short)pc.getDTypeIn().getValue(), pc.getDTagIn());
                    expp.getDescription().setArrayType((short)pc.getDArrayTypeOut());
                    expp.getDescription().setXRange(new TPropertyEGU(pc.getXEgu(), pc.getXmin().getValue(), pc.getXmax().getValue()));
                    expp.getDescription().setYRange(new TPropertyEGU(pc.getEgu(), pc.getMin().getValue(), pc.getMax().getValue()));
                    expp.getDescription().setRedirection(pc.getRedirection());
                    this.registerProperty(expp, null);
                    dv = pc.getDevices();
                    if (dv == null || dv.size() <= 0) continue;
                    int nr = 0;
                    ArrayList<String> lst = new ArrayList<String>(dv.size());
                    for (String d : dv) {
                        lst.add(nr++, d);
                    }
                    expp.setDeviceList(lst);
                    this.getDeviceList().setPropertyOriented(true);
                }
                String grp = ec.getGroup();
                if (grp != null && grp.length() > 0) {
                    this.setGroupName(grp);
                    if (ec.getGroupIndex().isValid()) {
                        this.setGroupIndex(ec.getGroupIndex().getValue());
                    }
                }
                if ((exp = ec.getServer()) != null && exp.length() > 0) {
                    this.setExportName(exp);
                }
                if (!((ctx = ec.getContext()) != null && ctx.length() != 0 || (ctx = cfg.getContext()) != null && ctx.length() != 0)) {
                    ctx = fctx;
                }
                if (fctx == null || fctx.length() == 0) {
                    this.gEqmFactory.setFecContext(ctx);
                    fctx = ctx;
                }
                if (ctx != null && ctx.length() > 0) {
                    this.setContext(ctx);
                }
                if ((sub = ec.getSubsystem()) == null || sub.length() == 0) {
                    sub = cfg.getSubsystem();
                }
                if (sub == null || sub.length() <= 0) break;
                this.setSubsystem(sub);
                break;
            }
            return 0;
        }
        TInitializer initializer = TInitializerFactory.getInstance().getInitializer();
        csvColumn[] expCols = new csvColumn[15];
        expRowHndlr expRows = new expRowHndlr(this.getLocalName());
        expCols[0] = new csvColumn("EXPORT_NAME", "", new expXnHndlr(expRows));
        expCols[1] = new csvColumn("LOCAL_NAME", "", new expLnHndlr(expRows, this.getLocalName()));
        expCols[2] = new csvColumn("PROPERTY", "", new expPrpHndlr(expRows));
        expCols[3] = new csvColumn("DESCRIPTION", "", new expPrpDescHndlr(expRows));
        expCols[4] = new csvColumn("PROPERTY_SIZE", "", new expPrpSizeHndlr(expRows));
        expCols[5] = new csvColumn("FORMAT", "", new expPrpFmtHndlr(expRows));
        expCols[6] = new csvColumn("PROPERTY_INSIZE", "", new expPrpInSizeHndlr(expRows));
        expCols[7] = new csvColumn("INFORMAT", "", new expPrpInFmtHndlr(expRows));
        expCols[8] = new csvColumn("PROPERTY_ID", "", new expPrpIdHndlr(expRows));
        expCols[9] = new csvColumn("ACCESS", "READ", new expPrpAccessHndlr(expRows));
        expCols[10] = new csvColumn("REDIRECTION", "", new expPrpRdrHndlr(expRows));
        expCols[11] = new csvColumn("GROUP", "", new expGrpHndlr());
        expCols[12] = new csvColumn("GROUP_INDEX", "", new expGrpIdxHndlr());
        expCols[13] = new csvColumn("CONTEXT", "", new expCtxHndlr());
        expCols[14] = new csvColumn("SUBSYSTEM", "", new expCtxHndlr());
        csv expFile = new csv(initializer.getExportsResource(eqmName));
        int rc = expFile.readFile(expCols, expRows);
        expFile.close();
        if (rc != 42) {
            TFecLog.log("get registered exports and properties from exports.csv : " + TErrorList.errorString[rc]);
        }
        return 0;
    }

    public int getRegisteredUsersFromFile() {
        TInitializer initializer = TInitializerFactory.getInstance().getInitializer();
        csvColumn[] usrCols = new csvColumn[]{new csvColumn("USER_NAME", "", new usrNameHndlr())};
        csv usrFile = new csv(initializer.getUsersResource());
        int rc = usrFile.readFile(usrCols);
        usrFile.close();
        if (rc != 42) {
            TFecLog.log("get registered users from users.csv : " + TErrorList.errorString[rc]);
        }
        return 0;
    }

    public int getRegisteredNetsFromFile() {
        TInitializer initializer = TInitializerFactory.getInstance().getInitializer();
        csvColumn[] netsCols = new csvColumn[]{new csvColumn("SUBNET", "", new subnetNameHndlr())};
        csv netsFile = new csv(initializer.getNetsResource());
        int rc = netsFile.readFile(netsCols);
        netsFile.close();
        if (rc == 0 && this.gRegisteredNetsList.size() == 0) {
            this.gRejectAllNets = true;
        }
        if (rc != 42) {
            TFecLog.log("get registered ip nets from ipnets.csv : " + TErrorList.errorString[rc]);
        }
        return 0;
    }

    public int getRegisteredAlarmDefinitionsFromFile() {
        FecCfg cfg = this.gEqmFactory.getFecXmlCfg();
        String eqmName = this.getLocalName();
        if (cfg != null) {
            LinkedList<EqmCfg> el = cfg.getEqmList();
            for (EqmCfg ec : el) {
                if (ec.getName().compareTo(eqmName) != 0) continue;
                LinkedList<AlarmDefinitionCfg> al = ec.getAlarmDefinitions();
                for (AlarmDefinitionCfg ac : al) {
                    this.addAlarmDefinition(ac.getAlarmCode().getValue(), new TAlarmDefinition(ac.getTag(), ac.getAlarmText(), ac.getDataText(), ac.getAlarmCode().getValue(), ac.getSeverity().getValue(), ac.getAlarmSystem().getValue()));
                }
            }
            return 0;
        }
        TInitializer initializer = TInitializerFactory.getInstance().getInitializer();
        csvColumn[] almCols = new csvColumn[11];
        almDefRowHndlr almRows = new almDefRowHndlr();
        almCols[0] = new csvColumn("ALARM_TAG", "", new StringFieldHandler(almRows, "tag"));
        almCols[1] = new csvColumn("ALARM_CODE", "", new IntFieldHandler(almRows, "code"));
        almCols[2] = new csvColumn("ALARM_MASK", "", new IntFieldHandler(almRows, "mask"));
        almCols[3] = new csvColumn("SEVERITY", "", new ShortFieldHandler(almRows, "severity"));
        almCols[4] = new csvColumn("DATA_FORMAT", "", new FormatFieldHandler(almRows, "dataFormat"));
        almCols[5] = new csvColumn("DATA_ARRAYSIZE", "", new IntFieldHandler(almRows, "dataSize"));
        almCols[6] = new csvColumn("ALARM_TEXT", "READ", new StringFieldHandler(almRows, "text"));
        almCols[7] = new csvColumn("DEVICE_TEXT", "", new StringFieldHandler(almRows, "deviceText"));
        almCols[8] = new csvColumn("DATA_TEXT", "", new StringFieldHandler(almRows, "dataText"));
        almCols[9] = new csvColumn("URL", "", new StringFieldHandler(almRows, "url"));
        almCols[10] = new csvColumn("ALARM_SYSTEM", "", new IntFieldHandler(almRows, "system"));
        csv almDefsFile = new csv(initializer.getAlmDefinitionResource(this.getLocalName()));
        int rc = almDefsFile.readFile(almCols, almRows);
        almDefsFile.close();
        if (rc != 42) {
            TFecLog.log("get alarm definitions from " + this.getLocalName() + "/alarms.csv : " + TErrorList.errorString[rc]);
        }
        return 0;
    }

    public int getRegisteredDevicesFromFile() {
        int rc;
        FecCfg cfg = this.gEqmFactory.getFecXmlCfg();
        String eqmName = this.getLocalName();
        if (cfg != null) {
            LinkedList<EqmCfg> el = cfg.getEqmList();
            for (EqmCfg ec : el) {
                if (ec.getName().compareTo(eqmName) != 0) continue;
                LinkedList<NameCfgList> nl = ec.getNameCfgList();
                TDeviceList dlst = this.getDeviceList();
                if (dlst == null) {
                    return 32;
                }
                int ndevs = dlst.getNumberOfDevices();
                if (ndevs == 0) {
                    return 32;
                }
                LinkedList<DeviceCfg> dl = ec.getDeviceList();
                for (DeviceCfg dc : dl) {
                    String deviceDescription;
                    String deviceRedirection;
                    TDevice tdv = dlst.getDevice(dc.getNumber().getValue());
                    if (tdv == null) {
                        return 32;
                    }
                    String prpSet = dc.getPropertySet();
                    if (prpSet != null && prpSet.length() > 0) {
                        for (NameCfgList nc : nl) {
                            if (nc.getName().compareToIgnoreCase(prpSet) != 0) continue;
                            tdv.setPropertyList(nc.getMembers());
                        }
                        this.propertyList.setDeviceOriented(true);
                    }
                    String oldName = tdv.getName();
                    if (dc.getName().compareTo(oldName) != 0) {
                        dlst.renameDevice(oldName, dc.getName());
                    }
                    if ((deviceRedirection = dc.getRedirection()) != null && deviceRedirection.length() > 0) {
                        tdv.setRedirection(deviceRedirection);
                        deviceRedirection = null;
                    }
                    if ((deviceDescription = dc.getDescription()) == null || deviceDescription.length() <= 0) continue;
                    tdv.setDescription(deviceDescription);
                    deviceDescription = null;
                }
            }
            return 0;
        }
        TInitializer initializer = TInitializerFactory.getInstance().getInitializer();
        csv devNamesFile = new csv(initializer.getDevicesResource(this.getLocalName()));
        int n = rc = devNamesFile == null ? 21 : this.getRegisteredDevicesFromFile(devNamesFile, new devNameRowHndlr());
        if (rc != 42) {
            TFecLog.log("get device names from " + this.getLocalName() + "-devices.csv : " + TErrorList.errorString[rc]);
        }
        return rc;
    }

    public int getRegisteredNamesFromPropertyFile(String propertyName) {
        int rc;
        TInitializer initializer = TInitializerFactory.getInstance().getInitializer();
        TExportProperty prp = this.propertyList.getFirstProperty(propertyName);
        String devFileName = propertyName + "-names.csv";
        csv devNamesFile = new csv(initializer.getFecHome() + "/" + this.getLocalName() + "/" + devFileName);
        int n = rc = devNamesFile == null ? 21 : this.getRegisteredDevicesFromFile(devNamesFile, new devNameRowHndlr(prp));
        if (rc == 42) {
            devNamesFile = new csv(initializer.getFecHome() + "/" + devFileName);
            int n2 = rc = devNamesFile == null ? 21 : this.getRegisteredDevicesFromFile(devNamesFile, new devNameRowHndlr(prp));
        }
        if (rc != 42) {
            TFecLog.log("get device names from " + devFileName + " : " + TErrorList.errorString[rc]);
        }
        return rc;
    }

    public int getRegisteredDevicesFromFile(csv csvFile, devNameRowHndlr devRows) {
        csvColumn[] devCols = new csvColumn[]{new csvColumn("DEVICE_NUMBER", "", new IntFieldHandler(devRows, "deviceNumber")), new csvColumn("DEVICE_NAME", "", new StringFieldHandler(devRows, "deviceName")), new csvColumn("MODULE_NUMBER", "", new IntFieldHandler(devRows, "deviceNumberAlt")), new csvColumn("MODULE_NAME", "", new StringFieldHandler(devRows, "deviceNameAlt")), new csvColumn("REDIRECTION", "", new StringFieldHandler(devRows, "deviceRedirection")), new csvColumn("PROPERTY_LIST", "", new StringFieldHandler(devRows, "prpListFile")), new csvColumn("DEVICE_DESCRIPTION", "", new StringFieldHandler(devRows, "deviceDescription"))};
        int rc = csvFile.readFile(devCols, devRows);
        csvFile.close();
        return rc;
    }

    public int getRegisteredPropertyListFromFile(TDevice device, String filename) {
        TInitializer initializer = TInitializerFactory.getInstance().getInitializer();
        csv csvFile = new csv(initializer.getFecHome() + "/" + filename);
        devPrpLstHndlr namhdlr = new devPrpLstHndlr();
        csvColumn[] devCols = new csvColumn[]{new csvColumn("PROPERTY_NAME", "", namhdlr)};
        int rc = csvFile.readFile(devCols, null);
        csvFile.close();
        if (rc == 0) {
            device.setPropertyList(namhdlr.prpLst);
        }
        return rc;
    }

    public boolean isDeviceSetLocal(String devName, String propertyName) {
        String tgt;
        TExportProperty prp = this.propertyList.getFirstProperty(propertyName);
        WildcardMatch wc = new WildcardMatch(devName);
        TDevice[] dlst = this.getDeviceList().getDeviceList();
        for (int i = 0; i < dlst.length; ++i) {
            tgt = dlst[i].getRedirection();
            if (tgt == null || !wc.matches(tgt)) continue;
            return false;
        }
        tgt = prp.getDescription().getRedirection();
        return tgt == null || !wc.matches(tgt);
    }

    public String getSubsystem() {
        return this.subsystem;
    }

    public void setSubsystem(String subsystem) {
        TStrings.validateSubSystemName(subsystem);
        this.subsystem = subsystem;
    }

    public int scheduleProperty(String devPropertyList) {
        if (devPropertyList == null) {
            return 20;
        }
        String[] prps = null;
        String tok = " ";
        if (!devPropertyList.contains(tok)) {
            tok = ";";
        }
        if (!devPropertyList.contains(tok)) {
            tok = ",";
        }
        if ((prps = devPropertyList.split(tok)) == null) {
            return 66;
        }
        for (int i = 0; i < prps.length; ++i) {
            if (!this.propertyList.hasProperty(prps[i])) continue;
            this.gEqmFactory.systemScheduleProperty(this, prps[i].trim());
        }
        return 0;
    }

    public int addEquipmentBackgroundTask(TEquipmentBackgroundTask tbkg) {
        if (tbkg == null) {
            return 20;
        }
        this.bkgTasks.add(tbkg);
        return this.getEquipmentModuleFactory().addEquipmentBackgroundTask(tbkg);
    }

    public int startup() {
        int rc = 0;
        this.getRegisteredDevicesFromFile();
        this.clearCASAlarmList();
        if (this.getInitializationRoutine() != null) {
            try {
                rc = this.getInitializationRoutine().initialize();
                TFecLog.log(this.getLocalName() + " initialization routine called : " + TErrorList.getErrorString(rc));
            }
            catch (Exception e) {
                TFecLog.log(this.getLocalName() + " initialization routine called : unhandled exception " + e.getMessage());
            }
        }
        this.gEqmFactory.getAlarmWatchListFromFile(this.getLocalName());
        this.gEqmFactory.getHistoryListFromFile(this.getLocalName());
        return rc;
    }

    public int shutdown() {
        int rc = 0;
        if (!this.hasInitialized) {
            return 152;
        }
        this.hasInitialized = false;
        if (this.getExitRoutine() != null) {
            try {
                rc = this.getExitRoutine().terminate();
                TFecLog.log(this.getLocalName() + " exit routined called : " + TErrorList.getErrorString(rc));
            }
            catch (Exception e) {
                TFecLog.log(this.getLocalName() + " exit routined called : unhandled exception " + e.getMessage());
            }
        }
        this.alarmDefinitionList.clear();
        this.removeAllGCastNets();
        this.removeAllRegisteredNets();
        this.removeAllRegisteredUsers();
        return rc;
    }

    class devPrpLstHndlr
    implements csvHandler {
        protected LinkedList<String> prpLst = null;

        devPrpLstHndlr() {
        }

        public int process(String strValue, int index) {
            if (strValue == null || strValue.length() == 0) {
                return 0;
            }
            if (this.prpLst == null) {
                this.prpLst = new LinkedList();
            }
            this.prpLst.add(strValue);
            return 0;
        }
    }

    class devNameRowHndlr
    implements RowHandler {
        public String deviceName = "#0";
        public String deviceNameAlt;
        public int deviceNumber = 0;
        public int deviceNumberAlt;
        private boolean isPrpOriented = false;
        public String deviceRedirection;
        public String deviceDescription;
        private TExportProperty prp = null;
        public String prpListFile = null;

        devNameRowHndlr() {
        }

        devNameRowHndlr(TExportProperty property) {
            this.deviceRedirection = null;
            this.deviceDescription = null;
            this.prp = property;
            this.isPrpOriented = this.prp != null;
        }

        public int process(int index) {
            TDeviceList dlst = TEquipmentModule.this.getDeviceList();
            if (dlst == null) {
                return 32;
            }
            int ndevs = dlst.getNumberOfDevices();
            if (ndevs == 0) {
                return 32;
            }
            if (this.deviceNumber < 0 && this.deviceNumber >= ndevs) {
                return 35;
            }
            if (!this.isPrpOriented) {
                TDevice tdv = dlst.getDevice(this.deviceNumber);
                if (tdv == null) {
                    return 32;
                }
                String oldName = tdv.getName();
                if (this.deviceName.compareTo(oldName) != 0) {
                    dlst.renameDevice(oldName, this.deviceName);
                }
                if (this.deviceRedirection != null && this.deviceRedirection.length() > 0) {
                    tdv.setRedirection(this.deviceRedirection);
                    this.deviceRedirection = null;
                }
                if (this.deviceDescription != null && this.deviceDescription.length() > 0) {
                    tdv.setDescription(this.deviceDescription);
                    this.deviceDescription = null;
                }
                if (this.prpListFile != null && this.prpListFile.length() > 0) {
                    TEquipmentModule.this.getRegisteredPropertyListFromFile(tdv, this.prpListFile);
                    TEquipmentModule.this.propertyList.setDeviceOriented(true);
                    this.prpListFile = null;
                }
            } else if (this.prp != null) {
                int prplen = this.prp.getOutputSize();
                ArrayList<String> lst = this.prp.getDeviceList();
                if (lst == null) {
                    lst = new ArrayList(prplen);
                    this.prp.setDeviceList(lst);
                }
                if (this.deviceName.length() == 0) {
                    this.deviceName = this.deviceNameAlt;
                    if (this.deviceNumber == 0) {
                        this.deviceNumber = this.deviceNumberAlt;
                    }
                }
                if (this.deviceNumber < prplen) {
                    lst.add(this.deviceNumber, this.deviceName);
                }
                dlst.setPropertyOriented(true);
            }
            return 0;
        }
    }

    class almDefRowHndlr
    implements RowHandler {
        private TAlarmDefinition adef;
        public String tag = "";
        public int code;
        public int mask;
        public short severity;
        public short dataFormat;
        public int dataSize;
        public String text = "";
        public String deviceText = "";
        public int system;
        public String dataText = "";
        public String url = "";

        public TAlarmDefinition getAlarmDefinition() {
            return this.adef;
        }

        almDefRowHndlr() {
        }

        public int process(int index) {
            this.adef = new TAlarmDefinition(this.tag, this.text, this.deviceText, this.code, this.severity, this.system, this.mask, this.dataFormat, this.dataSize, this.dataText, this.url);
            TEquipmentModule.this.addAlarmDefinition(this.code, this.adef);
            return 0;
        }
    }

    class subnetNameHndlr
    implements csvHandler {
        subnetNameHndlr() {
        }

        public int process(String strValue, int index) {
            if (strValue == null || strValue.length() == 0) {
                return 0;
            }
            TEquipmentModule.this.addRegisteredNet(strValue);
            return 0;
        }
    }

    class usrNameHndlr
    implements csvHandler {
        usrNameHndlr() {
        }

        public int process(String strValue, int index) {
            if (strValue == null || strValue.length() == 0) {
                return 0;
            }
            TEquipmentModule.this.addRegisteredUser(strValue.toUpperCase());
            return 0;
        }
    }

    class expPrpRdrHndlr
    implements csvHandler {
        private expRowHndlr rHndlr;

        expPrpRdrHndlr(expRowHndlr rowHndlr) {
            this.rHndlr = rowHndlr;
        }

        public int process(String strValue, int index) {
            if (strValue == null || strValue.length() == 0) {
                return 0;
            }
            this.rHndlr.getPropertyDescription().setRedirection(strValue);
            return 0;
        }
    }

    class expPrpAccessHndlr
    implements csvHandler {
        private expRowHndlr rHndlr;

        expPrpAccessHndlr(expRowHndlr rowHndlr) {
            this.rHndlr = rowHndlr;
        }

        public int process(String strValue, int index) {
            if (strValue == null || strValue.length() == 0) {
                return 0;
            }
            String accessString = strValue.trim().toUpperCase();
            short ta = 0;
            if (accessString.indexOf("WRITE") >= 0) {
                ta = (short)(ta | 2);
            }
            if (accessString.indexOf("READ") >= 0) {
                ta = (short)(ta | 1);
            }
            this.rHndlr.getExportProperty().setAccessMode(ta);
            return 0;
        }
    }

    class expPrpIdHndlr
    implements csvHandler {
        private expRowHndlr rHndlr;

        expPrpIdHndlr(expRowHndlr rowHndlr) {
            this.rHndlr = rowHndlr;
        }

        public int process(String strValue, int index) {
            int idx = index;
            try {
                if (strValue != null && strValue.length() > 0) {
                    idx = new Integer(strValue);
                }
            }
            catch (NumberFormatException e) {
                idx = index;
            }
            this.rHndlr.getExportProperty().setId(idx);
            return 0;
        }
    }

    class expPrpInFmtHndlr
    implements csvHandler {
        private expRowHndlr rHndlr;

        expPrpInFmtHndlr(expRowHndlr rowHndlr) {
            this.rHndlr = rowHndlr;
        }

        public int process(String strValue, int index) {
            int stop = strValue.indexOf(".");
            String fmtString = stop != -1 ? strValue.substring(0, stop) : strValue;
            short fmt = TFormat.getFormatCode(fmtString);
            this.rHndlr.getExportProperty().setInputFormat(fmt);
            if (fmt == 7) {
                this.rHndlr.getExportProperty().setInputTag(strValue.substring(stop + 1));
            }
            return 0;
        }
    }

    class expPrpInSizeHndlr
    implements csvHandler {
        private expRowHndlr rHndlr;

        expPrpInSizeHndlr(expRowHndlr rowHndlr) {
            this.rHndlr = rowHndlr;
        }

        public int process(String strValue, int index) {
            if (strValue == null || strValue.length() == 0) {
                return 0;
            }
            this.rHndlr.getExportProperty().setInputSize(new Integer(strValue));
            return 0;
        }
    }

    class expPrpFmtHndlr
    implements csvHandler {
        private expRowHndlr rHndlr;

        expPrpFmtHndlr(expRowHndlr rowHndlr) {
            this.rHndlr = rowHndlr;
        }

        public int process(String strValue, int index) {
            int stop = strValue.indexOf(".");
            String fmtString = stop != -1 ? strValue.substring(0, stop) : strValue;
            short fmt = TFormat.getFormatCode(fmtString);
            this.rHndlr.getExportProperty().setOutputFormat(fmt);
            if (stop != -1) {
                String fss = strValue.substring(stop + 1);
                if (fmt == 7) {
                    this.rHndlr.getExportProperty().setOutputTag(fss);
                } else {
                    this.rHndlr.getPropertyDescription().setArrayType(TArrayType.getType(fss));
                }
            }
            return 0;
        }
    }

    class expPrpSizeHndlr
    implements csvHandler {
        private expRowHndlr rHndlr;

        expPrpSizeHndlr(expRowHndlr rowHndlr) {
            this.rHndlr = rowHndlr;
        }

        public int process(String strValue, int index) {
            if (strValue == null || strValue.length() == 0) {
                return 0;
            }
            this.rHndlr.getExportProperty().setOutputSize(new Integer(strValue));
            return 0;
        }
    }

    class expPrpDescHndlr
    implements csvHandler {
        private expRowHndlr rHndlr;

        expPrpDescHndlr(expRowHndlr rowHndlr) {
            this.rHndlr = rowHndlr;
        }

        public int process(String strValue, int index) {
            if (strValue == null || strValue.length() == 0) {
                return 0;
            }
            this.rHndlr.getPropertyDescription().parseComplexString(strValue);
            return 0;
        }
    }

    class expPrpHndlr
    implements csvHandler {
        private expRowHndlr rHndlr;

        expPrpHndlr(expRowHndlr rowHndlr) {
            this.rHndlr = rowHndlr;
        }

        public int process(String strValue, int index) {
            this.rHndlr.getExportProperty().setName(strValue);
            return 0;
        }
    }

    class expLnHndlr
    implements csvHandler {
        private expRowHndlr rHndlr;
        private String targetLocalName = null;

        expLnHndlr(expRowHndlr rowHndlr, String targetName) {
            if (this.targetLocalName == null) {
                this.targetLocalName = targetName;
            }
            this.rHndlr = rowHndlr;
        }

        public int process(String strValue, int index) {
            this.rHndlr.setLocalName(strValue);
            if (strValue == null || strValue.length() == 0) {
                return 0;
            }
            if (this.targetLocalName != null && this.targetLocalName.compareTo(strValue) != 0) {
                return 0;
            }
            String nm = strValue.length() > 6 ? strValue.substring(0, 6) : strValue;
            TEquipmentModule.this.setLocalName(nm);
            return 0;
        }
    }

    class expGrpIdxHndlr
    implements csvHandler {
        expGrpIdxHndlr() {
        }

        public int process(String strValue, int index) {
            if (strValue == null || strValue.length() == 0) {
                return 0;
            }
            TEquipmentModule.this.setGroupIndex(Integer.valueOf(strValue));
            return 0;
        }
    }

    class expGrpHndlr
    implements csvHandler {
        expGrpHndlr() {
        }

        public int process(String strValue, int index) {
            if (strValue == null || strValue.length() == 0) {
                return 0;
            }
            TEquipmentModule.this.setGroupName(strValue);
            return 0;
        }
    }

    class expSubHndlr
    implements csvHandler {
        expSubHndlr() {
        }

        public int process(String strValue, int index) {
            if (strValue == null || strValue.length() == 0) {
                return 0;
            }
            TEquipmentModule.this.setSubsystem(strValue);
            return 0;
        }
    }

    class expCtxHndlr
    implements csvHandler {
        expCtxHndlr() {
        }

        public int process(String strValue, int index) {
            if (strValue == null || strValue.length() == 0) {
                return 0;
            }
            TEquipmentModule.this.setContext(strValue);
            String fctx = TEquipmentModule.this.gEqmFactory.getFecContext();
            if (fctx == null || fctx.length() == 0) {
                TEquipmentModule.this.gEqmFactory.setFecContext(strValue);
            }
            return 0;
        }
    }

    class expXnHndlr
    implements csvHandler {
        private expRowHndlr rHndlr;

        expXnHndlr(expRowHndlr rowHndlr) {
            this.rHndlr = rowHndlr;
        }

        public int process(String strValue, int index) {
            if (strValue == null || strValue.length() == 0) {
                return 0;
            }
            String nm = strValue.length() > 32 ? strValue.substring(0, 32) : strValue;
            this.rHndlr.setExpName(nm);
            return 0;
        }
    }

    class expRowHndlr
    implements RowHandler {
        private TExportProperty expp = new TExportProperty();
        private TPropertyDescription prpDesc = new TPropertyDescription();
        private String targetLocalName = null;
        private String localName = null;
        private String expName = null;

        public void setLocalName(String value) {
            this.localName = value;
        }

        public void setExpName(String value) {
            this.expName = value;
        }

        public TExportProperty getExportProperty() {
            return this.expp;
        }

        public TPropertyDescription getPropertyDescription() {
            return this.prpDesc;
        }

        expRowHndlr(String targetName) {
            if (this.targetLocalName == null) {
                this.targetLocalName = targetName;
            }
        }

        public int process(int index) {
            if (this.localName == null || this.localName.compareTo(TEquipmentModule.this.moduleName) != 0) {
                return 0;
            }
            if (this.targetLocalName != null && this.targetLocalName.compareTo(TEquipmentModule.this.moduleName) != 0) {
                return 0;
            }
            if (this.expName != null) {
                TEquipmentModule.this.setExportName(this.expName);
            }
            if ((2 & this.expp.getAccessMode()) == 2 && this.expp.getInputFormat() == 255 && this.expp.getOutputFormat() != 255) {
                this.expp.setInputFormat(this.expp.getOutputFormat());
            }
            this.expp.setDescription(this.prpDesc);
            TEquipmentModule.this.registerProperty(this.expp, null);
            this.expp = new TExportProperty();
            this.prpDesc = new TPropertyDescription();
            return 0;
        }
    }

    class AccessLock {
        static final int LOCK_UNLOCKED = 0;
        static final int LOCK_PREEMPTIVE = 1;
        static final int LOCK_PERSISTENT = 2;
        static final int LOCK_ABORT = 3;
        private TClient cln;
        private int lockType = 0;
        private int lockDuration = 0;
        private long lockStart;

        AccessLock() {
        }

        int getLockDuration() {
            return this.lockDuration;
        }

        int getLockType() {
            return this.lockType;
        }

        long getLockStart() {
            return this.lockStart;
        }

        void checkAccessLocks() {
            long t = System.currentTimeMillis();
            if (t > this.lockStart + (long)this.lockDuration) {
                this.lockStart = 0L;
                this.lockType = 0;
            }
        }

        boolean clientCanWrite(TClient tc) {
            if (this.lockType == 0) {
                return true;
            }
            return tc.IPaddress == this.cln.IPaddress && tc.userName.compareTo(this.cln.userName) == 0 && tc.port == this.cln.port;
        }

        int setAccessLock(TClient tc, int type, int duration) {
            boolean passed = false;
            if (type < 0 || type > 3) {
                return 37;
            }
            if (this.clientCanWrite(tc)) {
                passed = true;
            } else if (this.lockType != 2) {
                passed = true;
            }
            if (!passed) {
                return 105;
            }
            if (duration < 0) {
                duration = 0;
            }
            if (duration > 60) {
                duration = 60;
            }
            if (!TEquipmentModuleFactory.getInstance().gPutCommandsInFeclog) {
                String cmdString = "COMMAND ACCESSLOCK called by " + tc.userName + " from addr " + tc.IPaddress.getHostAddress() + " : ";
                if (this.lockType != type) {
                    TFecLog.log(cmdString);
                }
            }
            if (type == 3 || type == 0) {
                this.lockStart = 0L;
                this.lockType = 0;
            } else {
                this.cln = tc;
                this.lockType = type;
                this.lockDuration = duration;
                this.lockStart = System.currentTimeMillis();
            }
            return 0;
        }

        String[] getAccessLockAsString() {
            String[] s = new String[3];
            if (this.lockType == 0) {
                s[1] = "";
                s[0] = "";
            } else {
                int secs = (int)((this.lockStart + (long)this.lockDuration - System.currentTimeMillis()) / 1000L);
                if (secs < 0) {
                    secs = 0;
                }
                s[0] = this.cln.userName;
                s[1] = this.cln.IPaddress.getHostAddress();
                s[2] = new String("" + secs + " sec remaining");
            }
            return s;
        }
    }
}

