/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.server.equipment;

import de.desy.tine.csvUtils.IntFieldHandler;
import de.desy.tine.csvUtils.RowHandler;
import de.desy.tine.csvUtils.StringFieldHandler;
import de.desy.tine.csvUtils.csv;
import de.desy.tine.csvUtils.csvColumn;
import de.desy.tine.server.equipment.TEquipmentModule;
import de.desy.tine.server.equipment.TEquipmentModuleFactory;
import de.desy.tine.server.logger.MsgLog;
import de.desy.tine.server.properties.TStockProperties;
import de.desy.tine.structUtils.TTaggedStructure;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.util.Date;
import java.util.LinkedList;

public class TEquipmentManifest
extends TTaggedStructure
implements RowHandler {
    private static final String mfHdr = "EXPORT, CONTEXT, EQM, FEC, PORT, VERSION, FEC_HOME, LAST_STARTED";
    private static LinkedList<TEquipmentManifest> mfLst = null;
    private static String crlf = "\n";
    private char[] exp = new char[32];
    public String export;
    private char[] ctx = new char[32];
    public String context;
    private char[] eqmName = new char[8];
    public String eqm;
    private char[] fecName = new char[16];
    public String fec;
    private char[] ver = new char[16];
    public String version;
    private char[] fecHome = new char[32];
    public String fec_home;
    private char[] started = new char[32];
    public String last_started;
    private int[] portOffset = new int[1];
    public int port;

    private void pushString(String s, char[] c) {
        int len = s.length();
        if (len > c.length) {
            len = c.length;
        }
        s.getChars(0, len, c, 0);
    }

    private void initStructure() {
        this.addField(this.exp, "export");
        this.addField(this.ctx, "context");
        this.addField(this.eqmName, "eqmName");
        this.addField(this.fecName, "fecName");
        this.addField(this.ver, "version");
        this.addField(this.fecHome, "fecHome");
        this.addField(this.started, "lastStarted");
        this.addField(this.portOffset, "port");
        this.initDone();
    }

    TEquipmentManifest() {
        super("FECmf");
        this.initStructure();
    }

    TEquipmentManifest(TEquipmentManifest reference) {
        super("FECmf");
        this.initStructure();
        this.pushString(reference.export, this.exp);
        this.export = new String(this.exp).trim();
        this.pushString(reference.context, this.ctx);
        this.context = new String(this.ctx).trim();
        this.pushString(reference.eqm, this.eqmName);
        this.eqm = new String(this.eqmName).trim();
        this.pushString(reference.fec, this.fecName);
        this.fec = new String(this.fecName).trim();
        this.port = this.portOffset[0] = reference.port;
        this.pushString(reference.version, this.ver);
        this.version = new String(this.ver).trim();
        this.pushString(reference.fec_home, this.fecHome);
        this.fec_home = new String(this.fecHome).trim();
        this.pushString(reference.last_started, this.started);
        this.last_started = new String(this.started).trim();
    }

    private void replace(TEquipmentModule em) {
        TEquipmentModuleFactory tf = TEquipmentModuleFactory.getInstance();
        this.pushString(em.getExportName(), this.exp);
        this.export = new String(this.exp).trim();
        this.pushString(em.getContext(), this.ctx);
        this.context = new String(this.ctx).trim();
        this.pushString(em.getLocalName(), this.eqmName);
        this.eqm = new String(this.eqmName).trim();
        this.pushString(tf.getFecName(), this.fecName);
        this.fec = new String(this.fec).trim();
        this.portOffset[0] = tf.getPort();
        this.port = this.portOffset[0];
        this.pushString(TStockProperties.getStockSrvVersion(), this.ver);
        this.version = new String(this.ver).trim();
        this.pushString(tf.getInitializer().getFecHome(), this.fecHome);
        this.fec_home = new String(this.fecHome).trim();
        this.pushString(new Date().toString(), this.started);
        this.last_started = new String(this.started).trim();
    }

    private static String getEntryAsString(TEquipmentModule em) {
        TEquipmentModuleFactory tf = TEquipmentModuleFactory.getInstance();
        String mfEntry = em.getExportName().trim();
        mfEntry = mfEntry + ", " + em.getContext().trim();
        mfEntry = mfEntry + ", " + em.getLocalName().trim();
        mfEntry = mfEntry + ", " + tf.getFecName().trim();
        mfEntry = mfEntry + ", " + tf.getPort();
        mfEntry = mfEntry + ", " + TStockProperties.getStockSrvVersion().trim();
        mfEntry = mfEntry + ", " + tf.getInitializer().getFecHome().trim();
        mfEntry = mfEntry + ", " + new Date().toString().trim();
        mfEntry = mfEntry + crlf;
        return mfEntry;
    }

    private static String getEntryAsString(TEquipmentManifest tem) {
        String mfEntry = tem.export.trim();
        mfEntry = mfEntry + ", " + tem.context.trim();
        mfEntry = mfEntry + ", " + tem.eqm.trim();
        mfEntry = mfEntry + ", " + tem.fec.trim();
        mfEntry = mfEntry + ", " + tem.port;
        mfEntry = mfEntry + ", " + tem.version.trim();
        mfEntry = mfEntry + ", " + tem.fec_home.trim();
        mfEntry = mfEntry + ", " + tem.last_started.trim();
        mfEntry = mfEntry + crlf;
        return mfEntry;
    }

    public static synchronized int update(TEquipmentModule em) {
        String mfFilePath;
        if (mfLst != null) {
            mfLst.clear();
        }
        csvColumn[] mfCols = new csvColumn[8];
        TEquipmentManifest mfRows = new TEquipmentManifest();
        mfCols[0] = new csvColumn("EXPORT", "", new StringFieldHandler(mfRows, "export"));
        mfCols[1] = new csvColumn("CONTEXT", "", new StringFieldHandler(mfRows, "context"));
        mfCols[2] = new csvColumn("EQM", "", new StringFieldHandler(mfRows, "eqm"));
        mfCols[3] = new csvColumn("FEC", "", new StringFieldHandler(mfRows, "fec"));
        mfCols[4] = new csvColumn("PORT", "", new IntFieldHandler(mfRows, "port"));
        mfCols[5] = new csvColumn("VERSION", "", new StringFieldHandler(mfRows, "version"));
        mfCols[6] = new csvColumn("FEC_HOME", "", new StringFieldHandler(mfRows, "fec_home"));
        mfCols[7] = new csvColumn("LAST_STARTED", "", new StringFieldHandler(mfRows, "last_started"));
        if (File.separatorChar == '/') {
            mfFilePath = "/var/tmp";
        } else if (File.separatorChar == '\\') {
            mfFilePath = System.getenv("SystemDrive");
            if (mfFilePath == null) {
                mfFilePath = "C:";
            }
            crlf = "\r\n";
        } else {
            mfFilePath = ".";
        }
        mfFilePath = mfFilePath + File.separator + "tine" + File.separator + "cache";
        String mfFileName = mfFilePath + File.separator + "fec.mf";
        csv mfFile = new csv(mfFileName);
        int rc = mfFile.readFile(mfCols, mfRows);
        mfFile.close();
        if (rc != 0) {
            File mf = new File(mfFilePath);
            mf.mkdirs();
            try {
                BufferedWriter mfout = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(mfFileName)));
                mfout.write(mfHdr.trim() + crlf);
                mfout.write(TEquipmentManifest.getEntryAsString(em));
                mfout.close();
                return 0;
            }
            catch (Exception e) {
                MsgLog.log("TEquipmentManifest", "cannot update FEC manifest !", 21, e, 0);
                return 21;
            }
        }
        try {
            String mfTempName = mfFilePath + File.separator + "fec.tmp";
            BufferedReader mfin = new BufferedReader(new InputStreamReader(new FileInputStream(mfFileName)));
            BufferedWriter mfout = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(mfTempName)));
            String hdr = mfin.readLine();
            mfout.write(hdr + crlf);
            boolean found = false;
            int nfecs = mfLst.size();
            for (int i = 0; i < nfecs; ++i) {
                TEquipmentManifest tem = mfLst.get(i);
                if (tem.export.compareToIgnoreCase(em.getExportName()) == 0 && tem.context.compareToIgnoreCase(em.getContext()) == 0) {
                    found = true;
                    tem.replace(em);
                }
                mfout.write(TEquipmentManifest.getEntryAsString(tem));
            }
            if (!found) {
                mfout.write(TEquipmentManifest.getEntryAsString(em));
            }
            mfin.close();
            mfout.close();
            File mf = new File(mfFileName);
            mf.delete();
            mf = new File(mfTempName);
            mf.renameTo(new File(mfFileName));
        }
        catch (Exception e) {
            // empty catch block
        }
        return 0;
    }

    public int process(int index) {
        if (mfLst == null) {
            mfLst = new LinkedList();
        }
        mfLst.add(new TEquipmentManifest(this));
        return 0;
    }
}

