/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.server.devices;

import de.desy.tine.types.NAME16;
import de.desy.tine.types.NAME32;
import java.util.HashMap;

public class TExportDeviceTable {
    private int numDevices;
    private HashMap<String, Integer> devList = new HashMap(211);

    public TExportDeviceTable(int size) {
        this.numDevices = size;
    }

    public int getNumberOfDevices() {
        return this.devList.size();
    }

    public NAME32[] getExportLongDeviceNames() {
        int i;
        if (this.numDevices == 0) {
            return null;
        }
        Object[] o = this.devList.keySet().toArray();
        Object[] v = this.devList.values().toArray();
        NAME32[] dn = new NAME32[this.numDevices];
        for (i = 0; i < v.length; ++i) {
            dn[((Integer)v[i]).intValue()] = new NAME32((String)o[i]);
        }
        for (i = 0; i < this.numDevices; ++i) {
            if (dn[i] != null) continue;
            dn[i] = new NAME32("#" + i);
        }
        return dn;
    }

    public NAME32[] getExportLongDeviceNames(String pattern) {
        if (pattern.compareTo("*") == 0) {
            return this.getExportLongDeviceNames();
        }
        if (this.numDevices == 0) {
            return null;
        }
        Object[] o = this.devList.keySet().toArray();
        NAME32[] dn = new NAME32[this.numDevices];
        String lhs = null;
        String rhs = null;
        String mid = null;
        int p = -1;
        p = pattern.indexOf("*");
        if (p != -1) {
            if (p == 0) {
                if (pattern.endsWith("*")) {
                    mid = pattern.substring(1, pattern.length() - 2);
                } else {
                    rhs = pattern.substring(1, pattern.length() - 1);
                }
            } else {
                lhs = pattern.substring(0, p - 1);
                if (!pattern.endsWith("*")) {
                    rhs = pattern.substring(p + 1, pattern.length() - 1);
                }
            }
        }
        int n = 0;
        for (int i = 0; i < o.length && n < this.numDevices; ++i) {
            String ps = (String)o[i];
            if (rhs != null && !ps.endsWith(rhs) || lhs != null && !ps.startsWith(lhs) || mid != null && ps.indexOf(mid) < 0 || p == -1 && ps.compareTo(pattern) != 0) continue;
            dn[n++] = new NAME32(ps);
        }
        return dn;
    }

    public NAME16[] getExportDeviceNames() {
        int i;
        if (this.numDevices == 0) {
            return null;
        }
        Object[] o = this.devList.keySet().toArray();
        Object[] v = this.devList.values().toArray();
        NAME16[] dn = new NAME16[this.numDevices];
        for (i = 0; i < v.length; ++i) {
            dn[((Integer)v[i]).intValue()] = new NAME16((String)o[i]);
        }
        for (i = 0; i < this.numDevices; ++i) {
            if (dn[i] != null) continue;
            dn[i] = new NAME16("#" + i);
        }
        return dn;
    }

    public NAME16[] getExportDeviceNames(String pattern) {
        if (pattern.compareTo("*") == 0) {
            return this.getExportDeviceNames();
        }
        if (this.numDevices == 0) {
            return null;
        }
        Object[] o = this.devList.keySet().toArray();
        NAME16[] dn = new NAME16[this.numDevices];
        String lhs = null;
        String rhs = null;
        String mid = null;
        int p = -1;
        p = pattern.indexOf("*");
        if (p != -1) {
            if (p == 0) {
                if (pattern.endsWith("*")) {
                    mid = pattern.substring(1, pattern.length() - 2);
                } else {
                    rhs = pattern.substring(1, pattern.length() - 1);
                }
            } else {
                lhs = pattern.substring(0, p - 1);
                if (!pattern.endsWith("*")) {
                    rhs = pattern.substring(p + 1, pattern.length() - 1);
                }
            }
        }
        int n = 0;
        for (int i = 0; i < o.length && n < this.numDevices; ++i) {
            String ps = (String)o[i];
            if (rhs != null && !ps.endsWith(rhs) || lhs != null && !ps.startsWith(lhs) || mid != null && ps.indexOf(mid) < 0 || p == -1 && ps.compareTo(pattern) != 0) continue;
            dn[n++] = new NAME16(ps);
        }
        return dn;
    }

    int addDevice(NAME16 devName, int devNumber) {
        return this.addDevice(devName.toString(), devNumber);
    }

    int addDevice(NAME32 devName, int devNumber) {
        return this.addDevice(devName.toString(), devNumber);
    }

    int addDevice(String devName, int devNumber) {
        if (this.devList.containsKey(devName)) {
            return 0;
        }
        if (devNumber >= this.numDevices) {
            return -1;
        }
        this.devList.put(devName, new Integer(devNumber));
        return 0;
    }

    int rmvDevice(NAME16 devName) {
        return 0;
    }

    int rmvDevice(NAME32 devName) {
        return 0;
    }

    int rmvDevice(String devName) {
        return 0;
    }

    int getDeviceNumber(String device) {
        if (!this.devList.containsKey(device)) {
            return -1;
        }
        return this.devList.get(device);
    }
}

