/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.server.alarms;

import de.desy.tine.server.alarms.TAlarmWatchThreshold;
import de.desy.tine.server.equipment.TEquipmentModule;
import de.desy.tine.server.equipment.TEquipmentModuleFactory;
import de.desy.tine.structUtils.TTaggedStructure;
import java.util.Arrays;

public class TAlarmWatchEntry
extends TTaggedStructure {
    private TEquipmentModule eqm;
    private String devString = null;
    private String prpString = null;
    private String eqmString = null;
    private char[] eqmName = new char[8];
    private char[] dev = new char[64];
    private char[] prp = new char[64];
    private int[] siz = new int[1];
    private int[] fmt = new int[1];
    private int[] atyp = new int[1];
    private int[] asys = new int[1];
    private int[] sev = new int[1];
    private int[] hisev = new int[1];
    private int[] hiwarnsev = new int[1];
    private int[] losev = new int[1];
    private int[] lowarnsev = new int[1];
    private int[] chkNormal = new int[1];
    private int[] mask = new int[1];
    private int[] normal = new int[1];
    private int[] cnt = new int[1];
    private int[] cntThreshold = new int[1];
    private float[] hi = new float[1];
    private float[] lo = new float[1];
    private float[] hiwarn = new float[1];
    private float[] lowarn = new float[1];
    private int code;
    private int codeHigh;
    private int codeLow;

    private void pushString(String s, char[] c) {
        if (s != null) {
            int len = s.length();
            if (len > c.length) {
                len = c.length;
            }
            s.getChars(0, len, c, 0);
        }
    }

    private void initStructure() {
        this.addField(this.eqmName, "eqmName");
        this.addField(this.dev, "device");
        this.addField(this.prp, "property");
        this.addField(this.siz, "size");
        this.addField(this.fmt, "format");
        this.addField(this.atyp, "arrayType");
        this.addField(this.asys, "alarmSystem");
        this.addField(this.sev, "genSeverity");
        this.addField(this.hisev, "hiSeverity");
        this.addField(this.hiwarnsev, "hiWarnSeverity");
        this.addField(this.losev, "loSeverity");
        this.addField(this.lowarnsev, "loWarnSeverity");
        this.addField(this.chkNormal, "valueCheck");
        this.addField(this.mask, "valueMask");
        this.addField(this.normal, "valueNormal");
        this.addField(this.cnt, "cnts");
        this.addField(this.cntThreshold, "cntsThreshold");
        this.addField(this.hi, "hiThreshold");
        this.addField(this.lo, "loThreshold");
        this.addField(this.hiwarn, "hiWarnThreshold");
        this.addField(this.lowarn, "loWarnThreshold");
        this.initDone();
    }

    public TAlarmWatchEntry() {
        super("AWSr4");
        this.initStructure();
    }

    public TAlarmWatchEntry(TEquipmentModule equipmentModule, String devName, String devProperty, int size, int format, int arrayType, int almSystem, int almSeverity, TAlarmWatchThreshold almThreshold) {
        super("AWSr4");
        this.initStructure();
        this.eqm = equipmentModule;
        this.pushString(this.eqm.getLocalName(), this.eqmName);
        this.pushString(devName, this.dev);
        this.pushString(devProperty, this.prp);
        this.siz[0] = size;
        this.fmt[0] = format;
        this.atyp[0] = arrayType;
        this.asys[0] = almSystem;
        this.sev[0] = almSeverity;
        this.cnt[0] = 0;
        this.cntThreshold[0] = almThreshold.getCnt();
        this.hi[0] = almThreshold.getHi();
        this.lo[0] = almThreshold.getLo();
        this.hiwarn[0] = almThreshold.getHiwarn();
        this.lowarn[0] = almThreshold.getLowarn();
        this.mask[0] = almThreshold.getValueMask();
        this.normal[0] = almThreshold.getValueNormal();
        this.hisev[0] = this.sev[0];
        this.hiwarnsev[0] = this.sev[0] > 2 ? this.sev[0] - 2 : this.sev[0];
        this.losev[0] = this.sev[0];
        int n = this.lowarnsev[0] = this.sev[0] > 2 ? this.sev[0] - 2 : this.sev[0];
        if (this.mask[0] != 0) {
            this.chkNormal[0] = almThreshold.isNormalAlarm() ? -1 : 1;
        }
    }

    public TAlarmWatchEntry(TEquipmentModule equipmentModule, String devName, String devProperty, int size, int format, int arrayType, int almSystem, int almSeverity, int code, int codeHigh, int codeLow, TAlarmWatchThreshold almThreshold) {
        super("AWSr4");
        this.initStructure();
        this.eqm = equipmentModule;
        this.pushString(this.eqm.getLocalName(), this.eqmName);
        this.pushString(devName, this.dev);
        this.pushString(devProperty, this.prp);
        this.siz[0] = size;
        this.fmt[0] = format;
        this.atyp[0] = arrayType;
        this.asys[0] = almSystem;
        this.sev[0] = almSeverity;
        this.cnt[0] = 0;
        this.cntThreshold[0] = almThreshold.getCnt();
        this.hi[0] = almThreshold.getHi();
        this.lo[0] = almThreshold.getLo();
        this.hiwarn[0] = almThreshold.getHiwarn();
        this.lowarn[0] = almThreshold.getLowarn();
        this.mask[0] = almThreshold.getValueMask();
        this.normal[0] = almThreshold.getValueNormal();
        this.hisev[0] = this.sev[0];
        this.hiwarnsev[0] = this.sev[0] > 2 ? this.sev[0] - 2 : this.sev[0];
        this.losev[0] = this.sev[0];
        this.lowarnsev[0] = this.sev[0] > 2 ? this.sev[0] - 2 : this.sev[0];
        this.code = code;
        this.codeHigh = codeHigh;
        this.codeLow = codeLow;
        if (this.mask[0] != 0) {
            this.chkNormal[0] = almThreshold.isNormalAlarm() ? -1 : 1;
        }
    }

    public void adjustFrom(TAlarmWatchEntry reference) {
        this.asys[0] = reference.asys[0];
        this.sev[0] = reference.sev[0];
        this.cntThreshold[0] = reference.cntThreshold[0];
        this.hi[0] = reference.hi[0];
        this.lo[0] = reference.lo[0];
        this.hiwarn[0] = reference.hiwarn[0];
        this.lowarn[0] = reference.lowarn[0];
        this.mask[0] = reference.mask[0];
        this.normal[0] = reference.normal[0];
        if (this.mask[0] != 0) {
            this.chkNormal[0] = reference.chkNormal[0];
        }
    }

    public void setEquipmentModule(String eqmName) {
        TEquipmentModule eq = TEquipmentModuleFactory.getInstance().getEquipmentModule(eqmName);
        if (eq == null) {
            return;
        }
        this.setEquipmentModule(eq);
    }

    public void setEquipmentModule(TEquipmentModule eqm) {
        this.eqm = eqm;
        this.pushString(eqm.getLocalName(), this.eqmName);
    }

    public int getAsys() {
        return this.asys[0];
    }

    public int getAtyp() {
        return this.atyp[0];
    }

    public int getCnt() {
        return this.cnt[0];
    }

    public void setCnt(int count) {
        this.cnt[0] = count;
    }

    public int getCntThreshold() {
        return this.cntThreshold[0];
    }

    public String getDev() {
        if (this.devString == null) {
            this.devString = new String(this.dev).trim();
        }
        return this.devString;
    }

    public TEquipmentModule getEqm() {
        return this.eqm;
    }

    public int getFmt() {
        return this.fmt[0];
    }

    public void setFmt(int format) {
        this.fmt[0] = format % 256;
    }

    public float getHi() {
        return this.hi[0];
    }

    public float getHiwarn() {
        return this.hiwarn[0];
    }

    public float getLo() {
        return this.lo[0];
    }

    public float getLowarn() {
        return this.lowarn[0];
    }

    public String getPrp() {
        if (this.prpString == null) {
            this.prpString = new String(this.prp).trim();
        }
        return this.prpString;
    }

    public String getEquipmentModule() {
        if (this.eqmString == null) {
            this.eqmString = new String(this.eqmName).trim();
        }
        return this.eqmString;
    }

    public int getSev() {
        return this.sev[0];
    }

    public int getSiz() {
        return this.siz[0];
    }

    public void setSiz(int size) {
        this.siz[0] = size;
    }

    public int checkNormal() {
        return this.chkNormal[0];
    }

    public int getMask() {
        return this.mask[0];
    }

    public int getNormal() {
        return this.normal[0];
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.dev);
        result = 31 * result + Arrays.hashCode(this.eqmName);
        result = 31 * result + Arrays.hashCode(this.prp);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TAlarmWatchEntry other = (TAlarmWatchEntry)obj;
        if (!Arrays.equals(this.dev, other.dev)) {
            return false;
        }
        if (!Arrays.equals(this.eqmName, other.eqmName)) {
            return false;
        }
        return Arrays.equals(this.prp, other.prp);
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public int getCodeHigh() {
        return this.codeHigh;
    }

    public void setCodeHigh(int codeHigh) {
        this.codeHigh = codeHigh;
    }

    public int getCodeLow() {
        return this.codeLow;
    }

    public void setCodeLow(int codeLow) {
        this.codeLow = codeLow;
    }
}

