/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.server.alarms;

import de.desy.tine.client.TLinkFactory;
import de.desy.tine.dataUtils.TDataType;
import de.desy.tine.server.alarms.TAlarmDescriptor;
import de.desy.tine.structUtils.TTaggedStructure;

public class TAlarmMessageStructure
extends TTaggedStructure {
    private char[] server = new char[32];
    private String serverString;
    private char[] device = new char[64];
    private String deviceString;
    private char[] alarmTag = new char[32];
    private String alarmTagString;
    private int[] alarmCode = new int[1];
    private int[] timestamp = new int[1];
    private int[] timestampUSec = new int[1];
    private int[] starttime = new int[1];
    private int[] starttimeUSec = new int[1];
    private int[] alarmMask = new int[1];
    private byte[] alarmData = new byte[64];
    private byte[] alarmDataFormat = new byte[1];
    private byte[] alarmDataArraySize = new byte[1];
    private TDataType tAlarmData;
    private byte[] severity = new byte[1];
    private byte[] descriptor = new byte[1];
    private short[] alarmSystem = new short[1];
    private byte[] reserved = new byte[2];

    public int getAlarmCode() {
        return this.alarmCode[0];
    }

    public int getAlarmSeverity() {
        return this.severity[0];
    }

    public int getAlarmDescriptor() {
        return this.descriptor[0];
    }

    public String getAlarmDescriptorAsString() {
        return TAlarmDescriptor.toLongString(this.descriptor[0]);
    }

    public int getAlarmSystem() {
        return this.alarmSystem[0];
    }

    public long getTimeStamp() {
        return this.timestamp[0] * 1000 + this.timestampUSec[0] / 1000;
    }

    public int getStartTime() {
        return this.starttime[0] * 1000 + this.starttimeUSec[0] / 1000;
    }

    public int getAlarmMask() {
        return this.alarmMask[0];
    }

    public boolean hasData() {
        return this.alarmDataArraySize[0] > 0;
    }

    public TDataType getAlarmData() {
        if (this.tAlarmData == null) {
            byte dsiz = this.alarmDataArraySize[0];
            short dfmt = this.alarmDataFormat[0];
            this.tAlarmData = new TDataType(dsiz, dfmt);
            if (dsiz > 0 && dfmt != 255) {
                this.tAlarmData.pushBytes(this.alarmData);
                TLinkFactory.getInstance().fillinIncomingData(this.tAlarmData);
            }
        }
        return this.tAlarmData;
    }

    public String getServer() {
        if (this.serverString == null) {
            this.serverString = new String(this.server).trim();
        }
        return this.serverString;
    }

    public String getDevice() {
        if (this.deviceString == null) {
            this.deviceString = new String(this.device).trim();
        }
        return this.deviceString;
    }

    public String getAlarmTag() {
        if (this.alarmTagString == null) {
            this.alarmTagString = new String(this.alarmTag).trim();
        }
        return this.alarmTagString;
    }

    public TAlarmMessageStructure() {
        super("AMSr4");
        this.addField(this.server, "server");
        this.addField(this.device, "device");
        this.addField(this.alarmTag, "alarmTag");
        this.addField(this.alarmCode, "alarmCode");
        this.addField(this.timestamp, "timestamp");
        this.addField(this.timestampUSec, "timestampUSec");
        this.addField(this.starttime, "starttime");
        this.addField(this.starttimeUSec, "starttimeUSec");
        this.addField(this.alarmMask, "alarmMask");
        this.addField(this.alarmData, "alarmData");
        this.addField(this.alarmDataFormat, "alarmDataFormat");
        this.addField(this.alarmDataArraySize, "alarmDataArraySize");
        this.addField(this.severity, "severity");
        this.addField(this.descriptor, "descriptor");
        this.addField(this.alarmSystem, "alarmSystem");
        this.addField(this.reserved, "reserved");
        this.initDone();
    }
}

