/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.queryUtils;

import de.desy.tine.server.properties.TExportProperty;
import de.desy.tine.stringUtils.StringToBytes;
import de.desy.tine.structUtils.TStructBase;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class TPropertyQuery
extends TStructBase {
    public String prpName;
    public String prpDescription;
    public String prpRedirection;
    public String prpTag;
    public String prpTagIn;
    public String prpUnits;
    public float prpMinValue;
    public float prpMaxValue;
    public int prpSize;
    public int prpSizeIn;
    public int prpNumOverloads;
    public short prpHistoryDepthShort;
    public short prpHistoryDepthLong;
    public byte prpFormat;
    public byte prpFormatIn;
    public byte prpAccess;
    public byte prpGraphType;
    public String rngUnits;
    public float rngMinValue;
    public float rngMaxValue;
    public short numRows;
    public short rowSize;
    public short prpArrayType;
    public byte[] reserved = new byte[6];
    public static final int sizeInBytes = 432;
    ByteArrayOutputStream dBuffer = new ByteArrayOutputStream(432);

    public TPropertyQuery() {
        this.prpName = new String(new StringBuffer(64));
        this.prpDescription = new String(new StringBuffer(64));
        this.prpRedirection = new String(new StringBuffer(192));
        this.prpTag = new String(new StringBuffer(16));
        this.prpTagIn = new String(new StringBuffer(16));
        this.prpUnits = new String(new StringBuffer(16));
        this.rngUnits = new String(new StringBuffer(16));
    }

    public TPropertyQuery(TExportProperty prp, int numOverloads) {
        this.numRows = (short)prp.getDescription().getArrayNumRows();
        this.prpAccess = (byte)prp.getAccessMode();
        this.prpArrayType = prp.getDescription().getArrayType();
        this.prpDescription = prp.getDescription().getText();
        this.prpFormat = (byte)prp.getOutputFormat();
        this.prpFormatIn = (byte)prp.getInputFormat();
        this.prpGraphType = (byte)prp.getDescription().getYRange().getGraphType();
        this.prpHistoryDepthLong = 0;
        this.prpHistoryDepthShort = 0;
        this.prpMaxValue = prp.getDescription().getYRange().getMaxValue();
        this.prpMinValue = prp.getDescription().getYRange().getMinValue();
        this.prpName = prp.getName();
        this.prpNumOverloads = numOverloads;
        this.prpRedirection = prp.getDescription().getRedirection();
        if (this.prpRedirection == null) {
            this.prpRedirection = "";
        }
        this.prpSize = prp.getOutputSize();
        this.prpSizeIn = prp.getInputSize();
        this.prpTag = prp.getOutputTag();
        this.prpTagIn = prp.getInputTag();
        this.prpUnits = prp.getDescription().getYRange().getUnits();
        this.rngMaxValue = prp.getDescription().getXRange().getMaxValue();
        this.rngMinValue = prp.getDescription().getXRange().getMinValue();
        this.rngUnits = prp.getDescription().getXRange().getUnits();
        this.rowSize = (short)prp.getDescription().getArrayRowLength();
    }

    public void writeData(DataOutput dout) throws IOException {
        dout.write(StringToBytes.stringToFixedBytes(this.prpName, 64));
        dout.write(StringToBytes.stringToFixedBytes(this.prpDescription, 64));
        dout.write(StringToBytes.stringToFixedBytes(this.prpRedirection, 192));
        dout.write(StringToBytes.stringToFixedBytes(this.prpTag, 16));
        dout.write(StringToBytes.stringToFixedBytes(this.prpTagIn, 16));
        dout.write(StringToBytes.stringToFixedBytes(this.prpUnits, 16));
        dout.writeFloat(this.prpMinValue);
        dout.writeFloat(this.prpMaxValue);
        dout.writeInt(this.prpSize);
        dout.writeInt(this.prpSizeIn);
        dout.writeInt(this.prpNumOverloads);
        dout.writeShort(this.prpHistoryDepthShort);
        dout.writeShort(this.prpHistoryDepthLong);
        dout.writeByte(this.prpFormat);
        dout.writeByte(this.prpFormatIn);
        dout.writeByte(this.prpAccess);
        dout.writeByte(this.prpGraphType);
        dout.write(StringToBytes.stringToFixedBytes(this.rngUnits, 16));
        dout.writeFloat(this.rngMinValue);
        dout.writeFloat(this.rngMaxValue);
        dout.writeShort(this.numRows);
        dout.writeShort(this.rowSize);
        dout.writeShort(this.prpArrayType);
        dout.write(this.reserved);
    }

    public void readData(DataInput din) throws IOException {
        this.prpName = StringToBytes.readFixedString(din, 64);
        this.prpDescription = StringToBytes.readFixedString(din, 64);
        this.prpRedirection = StringToBytes.readFixedString(din, 192);
        this.prpTag = StringToBytes.readFixedString(din, 16);
        this.prpTagIn = StringToBytes.readFixedString(din, 16);
        this.prpUnits = StringToBytes.readFixedString(din, 16);
        this.prpMinValue = din.readFloat();
        this.prpMaxValue = din.readFloat();
        this.prpSize = din.readInt();
        this.prpSizeIn = din.readInt();
        this.prpNumOverloads = din.readInt();
        this.prpHistoryDepthShort = din.readShort();
        this.prpHistoryDepthLong = din.readShort();
        this.prpFormat = din.readByte();
        this.prpFormatIn = din.readByte();
        this.prpAccess = din.readByte();
        this.prpGraphType = din.readByte();
        this.rngUnits = StringToBytes.readFixedString(din, 16);
        this.rngMinValue = din.readFloat();
        this.rngMaxValue = din.readFloat();
        this.numRows = din.readShort();
        this.rowSize = din.readShort();
        this.prpArrayType = din.readShort();
        din.readFully(this.reserved, 0, 6);
    }
}

