/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.endianUtils;

public class SwapUtil {
    public static short swapShort(short value) {
        return (short)(value >> 8 & 0xFF | (value & 0xFF) << 8);
    }

    public static int swapInt(int value) {
        return value >> 24 & 0xFF | value >> 8 & 0xFF00 | (value & 0xFF00) << 8 | (value & 0xFF) << 24;
    }

    public static long swapLong(long value) {
        return value >> 56 & 0xFFL | value >> 40 & 0xFF00L | value >> 24 & 0xFF0000L | value >> 8 & 0xFFFFFFFFFF000000L | (value & 0xFFFFFFFFFF000000L) << 8 | (value & 0xFF0000L) << 24 | (value & 0xFF00L) << 40 | (value & 0xFFL) << 56;
    }

    public static double swapDouble(double value) {
        return Double.longBitsToDouble(SwapUtil.swapLong(Double.doubleToLongBits(value)));
    }

    public static double swapDouble(long value) {
        return Double.longBitsToDouble(SwapUtil.swapLong(value));
    }

    public static float swapFloat(float value) {
        return Float.intBitsToFloat(SwapUtil.swapInt(Float.floatToIntBits(value)));
    }

    public static float swapFloat(int value) {
        return Float.intBitsToFloat(SwapUtil.swapInt(value));
    }

    private SwapUtil() {
    }
}

