/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.endianUtils;

import de.desy.tine.server.logger.MsgLog;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class Swap {
    public static short Short(short sval) {
        int ival = sval;
        if (ival < 0) {
            ival += 65536;
        }
        int tmp = ival << 8 | ival >>> 8 & 0xFFFF;
        return (short)tmp;
    }

    public static short Short(int ival) {
        if ((ival &= 0xFFFF) > Short.MAX_VALUE) {
            ival -= 65536;
        }
        int tmp = ival << 8 | ival >>> 8 & 0xFFFF;
        return (short)tmp;
    }

    public static int Long(int ival) {
        int tmp = ival >>> 24 | ival << 24 | (ival & 0xFF00) << 8 | (ival & 0xFF0000) >>> 8;
        return tmp;
    }

    public static int Long(long lval) {
        if (lval > Integer.MAX_VALUE) {
            lval -= 0x100000000L;
        }
        long tmp = lval >>> 24 | lval << 24 | (lval & 0xFF00L) << 8 | (lval & 0xFF0000L) >>> 8;
        return (int)(tmp &= 0xFFFFFFFFFFFFFFFFL);
    }

    public static int Long(byte[] barr) {
        int ival = 0;
        byte b1 = barr[0];
        byte b2 = barr[1];
        barr[0] = barr[3];
        barr[1] = barr[2];
        barr[2] = b2;
        barr[3] = b1;
        try {
            ByteArrayInputStream bs = new ByteArrayInputStream(barr);
            DataInputStream ds = new DataInputStream(bs);
            ival = ds.readInt();
            ds.close();
            bs.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            MsgLog.log("Swap", "could not read int value from stream", 66, e, 0);
            return 0;
        }
        return ival;
    }

    public static long DLong(byte[] barr) {
        long lv = 0L;
        try {
            byte b1 = barr[0];
            byte b2 = barr[1];
            byte b3 = barr[2];
            byte b4 = barr[3];
            barr[0] = barr[7];
            barr[1] = barr[6];
            barr[2] = barr[5];
            barr[3] = barr[4];
            barr[4] = b4;
            barr[5] = b3;
            barr[6] = b2;
            barr[7] = b1;
            ByteArrayInputStream bs = new ByteArrayInputStream(barr);
            DataInputStream ds = new DataInputStream(bs);
            lv = ds.readLong();
            ds.close();
            bs.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return lv;
    }

    public static long DLong(long lval) {
        byte[] lba = Swap.DLongToBytes(lval);
        long lv = 0L;
        try {
            ByteArrayInputStream bs = new ByteArrayInputStream(lba);
            DataInputStream ds = new DataInputStream(bs);
            lv = ds.readLong();
            ds.close();
            bs.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return lv;
    }

    public static byte[] DLongToBytes(long lval) {
        byte[] barr;
        try {
            ByteArrayOutputStream bs = new ByteArrayOutputStream(8);
            DataOutputStream ds = new DataOutputStream(bs);
            ds.writeLong(lval);
            barr = bs.toByteArray();
            byte b1 = barr[0];
            byte b2 = barr[1];
            byte b3 = barr[2];
            byte b4 = barr[3];
            barr[0] = barr[7];
            barr[1] = barr[6];
            barr[2] = barr[5];
            barr[3] = barr[4];
            barr[4] = b4;
            barr[5] = b3;
            barr[6] = b2;
            barr[7] = b1;
            ds.close();
            bs.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            MsgLog.log("Swap", "could not read double value from stream", 66, e, 0);
            return null;
        }
        return barr;
    }

    public static byte[] LongToBytes(int ival) {
        byte[] barr;
        try {
            ByteArrayOutputStream bs = new ByteArrayOutputStream(4);
            DataOutputStream ds = new DataOutputStream(bs);
            ds.writeInt(ival);
            barr = bs.toByteArray();
            byte b1 = barr[0];
            byte b2 = barr[1];
            barr[0] = barr[3];
            barr[1] = barr[2];
            barr[2] = b2;
            barr[3] = b1;
            ds.close();
            bs.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            MsgLog.log("Swap", "could not read int value from stream", 66, e, 0);
            return null;
        }
        return barr;
    }

    public static byte[] ShortToBytes(int ival) {
        byte[] barr;
        if ((ival &= 0xFFFF) > Short.MAX_VALUE) {
            ival -= 65536;
        }
        short sval = (short)ival;
        try {
            ByteArrayOutputStream bs = new ByteArrayOutputStream(2);
            DataOutputStream ds = new DataOutputStream(bs);
            ds.writeShort(sval);
            barr = bs.toByteArray();
            byte b1 = barr[0];
            barr[0] = barr[1];
            barr[1] = b1;
            ds.close();
            bs.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            MsgLog.log("Swap", "could not read int value from stream", 66, e, 0);
            return null;
        }
        return barr;
    }

    public static byte[] Float(float fval) {
        byte[] barr;
        try {
            ByteArrayOutputStream bs = new ByteArrayOutputStream(4);
            DataOutputStream ds = new DataOutputStream(bs);
            ds.writeFloat(fval);
            barr = bs.toByteArray();
            byte b1 = barr[0];
            byte b2 = barr[1];
            barr[0] = barr[3];
            barr[1] = barr[2];
            barr[2] = b2;
            barr[3] = b1;
            ds.close();
            bs.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            MsgLog.log("Swap", "could not read float value from stream", 66, e, 0);
            return null;
        }
        return barr;
    }

    public static float Float(byte[] barr) {
        int len = 4;
        for (int i = 0; i < len; i += 4) {
            byte b1 = barr[i];
            byte b2 = barr[i + 1];
            barr[i] = barr[i + 3];
            barr[i + 1] = barr[i + 2];
            barr[i + 2] = b2;
            barr[i + 3] = b1;
        }
        float fltval = 0.0f;
        try {
            ByteArrayInputStream bs = new ByteArrayInputStream(barr);
            DataInputStream ds = new DataInputStream(bs);
            fltval = ds.readFloat();
            ds.close();
            bs.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            MsgLog.log("Swap", "could not read float value from stream", 66, e, 0);
            return 0.0f;
        }
        return fltval;
    }

    public static byte[] Double(double dval) {
        byte[] barr;
        try {
            ByteArrayOutputStream bs = new ByteArrayOutputStream(8);
            DataOutputStream ds = new DataOutputStream(bs);
            ds.writeDouble(dval);
            barr = bs.toByteArray();
            byte b1 = barr[0];
            byte b2 = barr[1];
            byte b3 = barr[2];
            byte b4 = barr[3];
            barr[0] = barr[7];
            barr[1] = barr[6];
            barr[2] = barr[5];
            barr[3] = barr[4];
            barr[4] = b4;
            barr[5] = b3;
            barr[6] = b2;
            barr[7] = b1;
            ds.close();
            bs.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            MsgLog.log("Swap", "could not read double value from stream", 66, e, 0);
            return null;
        }
        return barr;
    }

    public static double Double(byte[] barr) {
        int len = 8;
        for (int i = 0; i < len; i += 8) {
            byte b1 = barr[i];
            byte b2 = barr[i + 1];
            byte b3 = barr[i + 2];
            byte b4 = barr[i + 3];
            barr[i] = barr[i + 7];
            barr[i + 1] = barr[i + 6];
            barr[i + 2] = barr[i + 5];
            barr[i + 3] = barr[i + 4];
            barr[i + 4] = b4;
            barr[i + 5] = b3;
            barr[i + 6] = b2;
            barr[i + 7] = b1;
        }
        double dblval = 0.0;
        try {
            ByteArrayInputStream bs = new ByteArrayInputStream(barr);
            DataInputStream ds = new DataInputStream(bs);
            dblval = ds.readDouble();
            ds.close();
            bs.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            MsgLog.log("Swap", "could not read double value from stream", 66, e, 0);
            return 0.0;
        }
        return dblval;
    }

    public static void Bytes(byte[] barr, int bounds) {
        if (bounds <= 0) {
            return;
        }
        if (barr.length % bounds != 0) {
            return;
        }
        int len = barr.length;
        switch (bounds) {
            default: {
                return;
            }
            case 2: {
                for (int i = 0; i < len; i += 2) {
                    byte b1 = barr[i];
                    barr[i] = barr[i + 1];
                    barr[i + 1] = b1;
                }
                return;
            }
            case 4: {
                for (int i = 0; i < len; i += 4) {
                    byte b1 = barr[i];
                    byte b2 = barr[i + 1];
                    barr[i] = barr[i + 3];
                    barr[i + 1] = barr[i + 2];
                    barr[i + 2] = b2;
                    barr[i + 3] = b1;
                }
                return;
            }
            case 8: 
        }
        for (int i = 0; i < len; i += 8) {
            byte b1 = barr[i];
            byte b2 = barr[i + 1];
            byte b3 = barr[i + 2];
            byte b4 = barr[i + 3];
            barr[i] = barr[i + 7];
            barr[i + 1] = barr[i + 6];
            barr[i + 2] = barr[i + 5];
            barr[i + 3] = barr[i + 4];
            barr[i + 4] = b4;
            barr[i + 5] = b3;
            barr[i + 6] = b2;
            barr[i + 7] = b1;
        }
    }

    public static void Bytes(byte[] barr, short fmt) {
        switch (fmt) {
            default: {
                break;
            }
            case 0: 
            case 6: 
            case 40: {
                Swap.Bytes(barr, 8);
                break;
            }
            case 1: {
                Swap.Bytes(barr, 2);
                break;
            }
            case 3: {
                Swap.Bytes(barr, 4);
                break;
            }
            case 5: {
                Swap.Bytes(barr, 4);
                break;
            }
            case 28: {
                if (barr.length < 96) {
                    return;
                }
                int len = barr.length;
                for (int i = 20; i < len; i += 4) {
                    byte b1 = barr[i];
                    byte b2 = barr[i + 1];
                    barr[i] = barr[i + 3];
                    barr[i + 1] = barr[i + 2];
                    barr[i + 2] = b2;
                    barr[i + 3] = b1;
                }
                break;
            }
            case 24: {
                if (barr.length % 96 != 0) {
                    return;
                }
                int len = barr.length;
                for (int i = 0; i < len; i += 96) {
                    byte b1 = barr[i];
                    byte b2 = barr[i + 1];
                    barr[i] = barr[i + 3];
                    barr[i + 1] = barr[i + 2];
                    barr[i + 2] = b2;
                    barr[i + 3] = b1;
                    b1 = barr[i + 4];
                    b2 = barr[i + 5];
                    barr[i + 4] = barr[i + 7];
                    barr[i + 5] = barr[i + 6];
                    barr[i + 6] = b2;
                    barr[i + 7] = b1;
                    b1 = barr[i + 8];
                    b2 = barr[i + 9];
                    barr[i + 8] = barr[i + 11];
                    barr[i + 9] = barr[i + 10];
                    barr[i + 10] = b2;
                    barr[i + 11] = b1;
                    b1 = barr[i + 12];
                    b2 = barr[i + 13];
                    barr[i + 12] = barr[i + 15];
                    barr[i + 13] = barr[i + 14];
                    barr[i + 14] = b2;
                    barr[i + 15] = b1;
                }
                break;
            }
            case 10: {
                if (barr.length % 24 != 0) {
                    return;
                }
                int len = barr.length;
                for (int i = 0; i < len; i += 24) {
                    byte b1 = barr[i + 16];
                    byte b2 = barr[i + 17];
                    barr[i + 16] = barr[i + 19];
                    barr[i + 17] = barr[i + 18];
                    barr[i + 18] = b2;
                    barr[i + 19] = b1;
                    b1 = barr[i + 20];
                    b2 = barr[i + 21];
                    barr[i + 20] = barr[i + 23];
                    barr[i + 21] = barr[i + 22];
                    barr[i + 22] = b2;
                    barr[i + 23] = b1;
                }
                break;
            }
            case 14: {
                Swap.Bytes(barr, 4);
                break;
            }
            case 15: {
                Swap.Bytes(barr, 4);
                break;
            }
            case 25: {
                Swap.Bytes(barr, 4);
                break;
            }
            case 18: {
                Swap.Bytes(barr, 4);
                break;
            }
            case 27: {
                Swap.Bytes(barr, 4);
            }
        }
    }

    public static void Bytes(byte[] barr, String tag) {
        if (tag.compareTo("AESNOT") == 0) {
            int bounds = 272;
            if (barr.length % bounds != 0) {
                return;
            }
            for (int i = 0; i < barr.length; i += bounds) {
                for (int j = 0; j < 16; j += 4) {
                    byte b1 = barr[i + j];
                    byte b2 = barr[i + j + 1];
                    barr[i + j] = barr[i + j + 3];
                    barr[i + j + 1] = barr[i + j + 2];
                    barr[i + j + 2] = b2;
                    barr[i + j + 3] = b1;
                }
            }
            return;
        }
        if (tag.compareTo("AESCON") == 0) {
            int bounds = 32;
            if (barr.length % bounds != 0) {
                return;
            }
            for (int i = 0; i < barr.length; i += bounds) {
                for (int j = 0; j < 16; j += 4) {
                    byte b1 = barr[i + j];
                    byte b2 = barr[i + j + 1];
                    barr[i + j] = barr[i + j + 3];
                    barr[i + j + 1] = barr[i + j + 2];
                    barr[i + j + 2] = b2;
                    barr[i + j + 3] = b1;
                }
            }
            return;
        }
        if (tag.compareTo("AES") == 0) {
            int bounds = 296;
            if (barr.length % bounds != 0) {
                return;
            }
            for (int i = 0; i < barr.length; i += bounds) {
                for (int j = 0; j < 8; j += 4) {
                    byte b1 = barr[i + j];
                    byte b2 = barr[i + j + 1];
                    barr[i + j] = barr[i + j + 3];
                    barr[i + j + 1] = barr[i + j + 2];
                    barr[i + j + 2] = b2;
                    barr[i + j + 3] = b1;
                }
            }
            return;
        }
        if (tag.compareTo("AIB") == 0) {
            int bounds = 72;
            if (barr.length % bounds != 0) {
                return;
            }
            int j = 0;
            for (int i = 0; i < barr.length; i += bounds) {
                byte b1;
                for (j = 0; j < 4; j += 2) {
                    b1 = barr[i + j];
                    barr[i + j] = barr[i + j + 1];
                    barr[i + j + 1] = b1;
                }
                int offset = j;
                while (j < 4 + offset) {
                    b1 = barr[i + j];
                    byte b2 = barr[i + j + 1];
                    barr[i + j] = barr[i + j + 3];
                    barr[i + j + 1] = barr[i + j + 2];
                    barr[i + j + 2] = b2;
                    barr[i + j + 3] = b1;
                    j += 4;
                }
            }
            return;
        }
        if (tag.compareTo("PIB") == 0) {
            int bounds = 56;
            if (barr.length % bounds != 0) {
                return;
            }
            int j = 0;
            for (int i = 0; i < barr.length; i += bounds) {
                byte b2;
                byte b1;
                for (j = 0; j < 20; j += 4) {
                    b1 = barr[i + j];
                    b2 = barr[i + j + 1];
                    barr[i + j] = barr[i + j + 3];
                    barr[i + j + 1] = barr[i + j + 2];
                    barr[i + j + 2] = b2;
                    barr[i + j + 3] = b1;
                }
                int offset = j + 16;
                while (j < 16 + offset) {
                    b1 = barr[i + j];
                    b2 = barr[i + j + 1];
                    byte b3 = barr[i + j + 2];
                    byte b4 = barr[i + j + 3];
                    barr[i + j] = barr[i + j + 7];
                    barr[i + j + 1] = barr[i + j + 6];
                    barr[i + j + 2] = barr[i + j + 5];
                    barr[i + j + 3] = barr[i + j + 4];
                    barr[i + j + 4] = b4;
                    barr[i + j + 5] = b3;
                    barr[i + j + 6] = b2;
                    barr[i + j + 7] = b1;
                    j += 8;
                }
                offset = j;
                while (j < 4 + offset) {
                    b1 = barr[i + j];
                    barr[i + j] = barr[i + j + 1];
                    barr[i + j + 1] = b1;
                    j += 2;
                }
            }
            return;
        }
        if (tag.compareTo("DHS") == 0) {
            int bounds = 344;
            if (barr.length % bounds != 0) {
                return;
            }
            int j = 0;
            for (int i = 0; i < barr.length; i += bounds) {
                byte b2;
                byte b1;
                int offset = 32;
                while (j < 4 + offset) {
                    b1 = barr[i + j];
                    b2 = barr[i + j + 1];
                    barr[i + j] = barr[i + j + 3];
                    barr[i + j + 1] = barr[i + j + 2];
                    barr[i + j + 2] = b2;
                    barr[i + j + 3] = b1;
                    j += 4;
                }
                offset = j;
                while (j < 4 + offset) {
                    b1 = barr[i + j];
                    barr[i + j] = barr[i + j + 1];
                    barr[i + j + 1] = b1;
                    j += 2;
                }
                offset = j;
                while (j < 20 + offset) {
                    b1 = barr[i + j];
                    b2 = barr[i + j + 1];
                    barr[i + j] = barr[i + j + 3];
                    barr[i + j + 1] = barr[i + j + 2];
                    barr[i + j + 2] = b2;
                    barr[i + j + 3] = b1;
                    j += 4;
                }
                offset = j + 16;
                while (j < 8 + offset) {
                    b1 = barr[i + j];
                    b2 = barr[i + j + 1];
                    barr[i + j] = barr[i + j + 3];
                    barr[i + j + 1] = barr[i + j + 2];
                    barr[i + j + 2] = b2;
                    barr[i + j + 3] = b1;
                    j += 4;
                }
            }
            return;
        }
        if (tag.compareTo("ADRB") == 0) {
            int bounds = 64;
            if (barr.length % bounds != 0) {
                return;
            }
            int j = 0;
            for (int i = 0; i < barr.length; i += bounds) {
                byte b1;
                int offset = j;
                while (j < 12 + offset) {
                    b1 = barr[i + j];
                    byte b2 = barr[i + j + 1];
                    barr[i + j] = barr[i + j + 3];
                    barr[i + j + 1] = barr[i + j + 2];
                    barr[i + j + 2] = b2;
                    barr[i + j + 3] = b1;
                    j += 4;
                }
                offset = j + 48;
                while (j < 4 + offset) {
                    b1 = barr[i + j];
                    barr[i + j] = barr[i + j + 1];
                    barr[i + j + 1] = b1;
                    j += 2;
                }
            }
            return;
        }
    }
}

