/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.definitions;

public final class TArrayType {
    public static final short AT_UNKNOWN = 0;
    public static final short AT_SCALAR = 1;
    public static final short AT_SINGLE = 2;
    public static final short AT_DOUBLE = 4;
    public static final short AT_BOOLEAN = 8;
    public static final short AT_CHANNEL = 16;
    public static final short AT_SPECTRUM = 32;
    public static final short AT_TRACE = 32;
    public static final short AT_WAVEFORM = 32;
    public static final short AT_STRUCTURED = 64;
    public static final short AT_COLLECTION = 64;
    public static final short AT_UNSTRUCTURED = 128;
    public static final short AT_BLOB = 128;
    public static final short AT_IMAGE = 128;
    public static final short AT_JPEG = 256;
    public static final short AT_MPEG = 512;
    public static final short AT_BMP = 1024;
    public static final short AT_GIF = 2048;
    public static final short AT_WAV = 4096;
    public static final short AT_MP3 = 8192;
    private short value;

    public static String toString(short type) {
        String add = "";
        String bool = "";
        if ((type & 8) == 8) {
            bool = "boolean ";
        }
        if ((type & 0x10) == 16) {
            add = "channel ";
        }
        if ((type & 0x20) == 32) {
            add = "spectrum ";
        }
        if ((type & 0x40) == 64) {
            add = "collection ";
        }
        if ((type & 0x48) == 128) {
            add = "unstructured ";
        }
        switch (type & 7) {
            default: {
                return "unknown";
            }
            case 1: {
                return "scalar" + bool;
            }
            case 2: {
                return "single " + bool + add + "array";
            }
            case 4: 
        }
        return "double " + bool + add + "array";
    }

    public static short getType(String typeString) {
        short at = 0;
        if (typeString != null) {
            String ts = typeString.trim();
            if (ts.compareToIgnoreCase("SCALAR") == 0) {
                at = (short)(at | 1);
            } else if (ts.compareToIgnoreCase("SINGLE") == 0) {
                at = (short)(at | 2);
            } else if (ts.compareToIgnoreCase("DOUBLE") == 0) {
                at = (short)(at | 4);
            }
            if (ts.compareToIgnoreCase("BOOLEAN") == 0) {
                at = (short)(at | 8);
            }
            if (ts.compareToIgnoreCase("CHANNEL") == 0) {
                at = (short)(at | 0x10);
            } else if (ts.compareToIgnoreCase("SPECTRUM") == 0 || ts.compareToIgnoreCase("TRACE") == 0 || ts.compareToIgnoreCase("WAVEFORM") == 0) {
                at = (short)(at | 0x20);
            } else if (ts.compareToIgnoreCase("STRUCTURED") == 0 || ts.compareToIgnoreCase("COLLECTION") == 0) {
                at = (short)(at | 0x40);
            } else if (ts.compareToIgnoreCase("UNSTRUCTURED") == 0 || ts.compareToIgnoreCase("BLOB") == 0) {
                at = (short)(at | 0x80);
            } else if (ts.compareToIgnoreCase("IMAGE") == 0) {
                at = (short)(at | 0x80);
            }
            if (ts.compareToIgnoreCase("JPEG") == 0) {
                at = (short)(at | 0x100);
            }
            if (ts.compareToIgnoreCase("MPEG") == 0) {
                at = (short)(at | 0x200);
            }
            if (ts.compareToIgnoreCase("BMP") == 0) {
                at = (short)(at | 0x400);
            }
            if (ts.compareToIgnoreCase("GIF") == 0) {
                at = (short)(at | 0x800);
            }
            if (ts.compareToIgnoreCase("WAV") == 0) {
                at = (short)(at | 0x1000);
            }
            if (ts.compareToIgnoreCase("MP3") == 0) {
                at = (short)(at | 0x2000);
            }
        }
        return at;
    }

    public static TArrayType valueOf(short val) {
        return new TArrayType(val);
    }

    private TArrayType(short val) {
        this.value = val;
    }

    public String toString() {
        return TArrayType.toString(this.value);
    }

    public short getValue() {
        return this.value;
    }

    public boolean isChannel() {
        return (this.value & 0x10) == 16;
    }

    public static boolean isChannel(int arrayType) {
        return (arrayType & 0x10) == 16;
    }

    public boolean isScalar() {
        return (this.value & 1) == 1;
    }

    public static boolean isScalar(int arrayType) {
        return (arrayType & 1) == 1;
    }

    public boolean isVector() {
        return (this.value & 0x10) == 16;
    }

    public static boolean isVector(int arrayType) {
        return (arrayType & 0x10) == 16;
    }

    public boolean isTrace() {
        return (this.value & 0x20) == 32;
    }

    public static boolean isTrace(int arrayType) {
        return (arrayType & 0x20) == 32;
    }

    public boolean isMatrix() {
        return (this.value & 1) == 1;
    }

    public static boolean isMatrix(int arrayType) {
        return (arrayType & 4) == 4;
    }
}

