/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.definitions;

public final class TAccess {
    private short mode;
    public static final short CA_NULL = 0;
    public static final short CA_READ = 1;
    public static final short CA_WRITE = 2;
    public static final short CA_REPEAT = 4;
    public static final short CA_SYNC = 8;
    public static final short CA_ALARM = 16;
    public static final short CA_HIST = 32;
    public static final short CA_FIRST = 64;
    public static final short CA_LAST = 128;
    public static final short CA_RETRY = 256;
    public static final short CA_NETWORK = 512;
    public static final short CA_QUERY = 1024;
    public static final short CA_LOCKED = 2048;
    public static final short CA_NORETRY = 4096;
    public static final short CA_CONNECT = 8192;
    public static final short CA_MUTABLE = 16384;

    public TAccess(int newMode) {
        this.mode = (short)newMode;
    }

    public TAccess() {
        this(0);
    }

    public void clear() {
        this.mode = 0;
    }

    public static short toBase(short access) {
        return (short)(access & 3);
    }

    public static TAccess valueOf(short mode) {
        return new TAccess(mode);
    }

    public String toString() {
        return TAccess.toString(this.mode);
    }

    public static String toString(short access) {
        String add = "";
        if ((access & 8) == 8) {
            add = "sync ";
        }
        switch (access & 3) {
            case 0: {
                return "none";
            }
            case 1: {
                return add + "read only";
            }
            case 2: {
                return add + "write";
            }
        }
        return add + "read/write";
    }

    public short toShort() {
        return this.mode;
    }

    public boolean includes(short pattern) {
        return (this.mode & pattern) == pattern;
    }

    public boolean isRead() {
        return (this.mode & 1) != 0;
    }

    public static boolean isRead(byte access) {
        short uaccess = access;
        if (uaccess < 0) {
            uaccess = (short)(uaccess + 256);
        }
        return (access & 1) != 0;
    }

    public boolean isWrite() {
        return (this.mode & 2) != 0;
    }

    public static boolean isWrite(byte access) {
        short uaccess = access;
        if (uaccess < 0) {
            uaccess = (short)(uaccess + 256);
        }
        return (access & 2) != 0;
    }

    public boolean isFirst() {
        return (this.mode & 0x40) != 0;
    }

    public static boolean isFirst(byte access) {
        short uaccess = access;
        if (uaccess < 0) {
            uaccess = (short)(uaccess + 256);
        }
        return (access & 0x40) != 0;
    }

    public boolean isLast() {
        return (this.mode & 0x80) != 0;
    }

    public static boolean isLast(byte access) {
        short uaccess = access;
        if (uaccess < 0) {
            uaccess = (short)(uaccess + 256);
        }
        return (access & 0x80) != 0;
    }

    public static byte removeBits(byte access, short bits) {
        short uaccess = access;
        if (uaccess < 0) {
            uaccess = (short)(uaccess + 256);
        }
        uaccess = (short)(uaccess & ~bits);
        return (byte)uaccess;
    }

    public static boolean isSynchronous(byte access) {
        short uaccess = access;
        if (uaccess < 0) {
            uaccess = (short)(uaccess + 256);
        }
        return (access & 0xC0) == 192;
    }

    public boolean isNull() {
        return this.mode == 0;
    }

    public boolean canRetry() {
        return (this.mode & 0x100) != 0;
    }

    public boolean equals(TAccess acc) {
        return this.mode == acc.mode;
    }

    public boolean includes(TAccess acc) {
        return this.includes(acc.mode);
    }

    public void add(short mode) {
        this.mode = (short)(this.mode | mode);
    }

    public void add(TAccess acc) {
        this.mode = (short)(this.mode | acc.mode);
    }
}

