/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.dataUtils;

import de.desy.tine.server.equipment.TEquipmentModuleFactory;
import java.util.Calendar;
import java.util.Date;

public final class TDataTime {
    private static Calendar calendar = Calendar.getInstance();

    public static double getDataTimeStamp() {
        long ts = System.currentTimeMillis() + TEquipmentModuleFactory.getInstance().getDataTimeStampOffset();
        return TDataTime.getDataTimeStamp(ts);
    }

    public static long getLongDataTimeStamp() {
        return System.currentTimeMillis() + TEquipmentModuleFactory.getInstance().getDataTimeStampOffset();
    }

    public static long getLongDataTimeStamp(double timeStamp) {
        return (long)(timeStamp * 1000.0);
    }

    public static double getDataTimeStamp(long longtimestamp) {
        return (double)longtimestamp / 1000.0;
    }

    public static String toString(long lTimeStamp) {
        Date d = new Date(lTimeStamp);
        calendar.setTimeInMillis(lTimeStamp);
        int mm = calendar.get(2) + 1;
        int yy = calendar.get(1) % 100;
        StringBuffer sb = new StringBuffer(64);
        String ts = d.toString();
        sb.append(ts.substring(8, 10) + (mm < 10 ? ".0" + mm : "." + mm) + (yy < 10 ? ".0" + yy : "." + yy));
        sb.append(ts.substring(10, 19));
        int msec = (int)(lTimeStamp % 1000L);
        if (msec < 10) {
            sb.append(".00" + msec);
        } else if (msec < 100) {
            sb.append(".0" + msec);
        } else {
            sb.append("." + msec);
        }
        sb.append(" " + calendar.getTimeZone().getDisplayName(calendar.getTimeZone().inDaylightTime(d), 0));
        return sb.toString();
    }

    public static String toString(double dTimeStamp) {
        long lTimeStamp = (long)(dTimeStamp * 1000.0);
        return TDataTime.toString(lTimeStamp);
    }

    public final String toString() {
        return TDataTime.toString(new Date().getTime());
    }
}

