/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.csvUtils;

import de.desy.tine.csvUtils.RowHandler;
import de.desy.tine.csvUtils.csvColumn;
import de.desy.tine.server.logger.MsgLog;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;

public final class csv {
    private BufferedReader in;

    public csv(BufferedReader reader) {
        this.in = reader;
    }

    public csv(String csvFile) {
        try {
            this.in = new BufferedReader(new InputStreamReader(new FileInputStream(csvFile)));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String readLine() {
        if (this.in == null) {
            return null;
        }
        try {
            return this.in.readLine();
        }
        catch (IOException e) {
            return null;
        }
    }

    public int readFile(csvColumn[] csvCols) {
        return this.readFile(csvCols, null);
    }

    public int readFile(csvColumn[] csvCols, RowHandler csvRowHndlr) {
        boolean headerRead = false;
        boolean haltIteration = false;
        int i = 0;
        int idx = 0;
        if (this.in == null) {
            return 42;
        }
        try {
            String s;
            while ((s = this.in.readLine()) != null) {
                if (s.length() == 0 || s.startsWith("#") || s.startsWith(";") || s.startsWith("%")) continue;
                if (!headerRead) {
                    for (i = 0; i < csvCols.length; ++i) {
                        if (csvCols[i] == null) continue;
                        csvCols[i].setColumnPosition(this.findcol(s, csvCols[i].getColumnName()));
                        if (csvCols[i].getColumnPosition() != -1 || csvCols[i].getColumnDefaultValue() != null) continue;
                        throw new NoSuchFieldException();
                    }
                    headerRead = true;
                    continue;
                }
                for (i = 0; i < csvCols.length; ++i) {
                    if (csvCols[i] == null) continue;
                    String strValue = csvCols[i].getColumnDefaultValue();
                    if (csvCols[i].getColumnPosition() != -1) {
                        strValue = this.colptr(csvCols[i].getColumnPosition(), s);
                    }
                    if (csvCols[i].getColumnHandler().process(strValue.trim(), idx) == 0) continue;
                    haltIteration = true;
                }
                if (!(haltIteration || csvRowHndlr != null && csvRowHndlr.process(idx) != 0)) {
                    ++idx;
                    continue;
                }
                break;
            }
        }
        catch (NoSuchFieldException e) {
            MsgLog.log("csv readFile", "looking for " + csvCols[i].getColumnName() + " in corrupt file !", 50, e, 0);
            return 50;
        }
        catch (IOException e) {
            // empty catch block
        }
        return 0;
    }

    public void close() {
        try {
            if (this.in != null) {
                this.in.close();
            }
        }
        catch (IOException e) {
            MsgLog.log("csv readFile", "Cannot close file!", 21, e, 0);
            System.out.println("Cannot close file !");
            e.printStackTrace();
        }
    }

    public int findcol(String line, String ColumnEntry) {
        int i;
        String s = line.toUpperCase();
        String e = ColumnEntry.toUpperCase();
        String altEntry1 = null;
        String altEntry2 = null;
        String[] altPieces = null;
        char brkc = '\u0000';
        char altc = '\u0000';
        if (e.indexOf(32) > 0) {
            brkc = ' ';
            altc = '_';
        } else if (e.indexOf(95) > 0) {
            brkc = '_';
            altc = ' ';
        }
        if (brkc != '\u0000') {
            altEntry1 = e.replace(brkc, altc);
            altPieces = e.split(String.valueOf(brkc));
            altEntry2 = new String(altPieces[0]);
            for (i = 1; i < altPieces.length; ++i) {
                altEntry2 = altEntry2.concat(altPieces[i]);
            }
        }
        i = 0;
        int col = 0;
        while (i < s.length()) {
            String subs;
            int n = s.indexOf(44, i);
            if (n < 0) {
                n = s.length();
            }
            if ((subs = s.substring(i, n).trim()).compareTo(e) == 0) {
                return col;
            }
            if (brkc != '\u0000') {
                if (subs.compareTo(altEntry1) == 0) {
                    return col;
                }
                if (subs.compareTo(altEntry2) == 0) {
                    return col;
                }
            }
            if ((i = n + 1) >= s.length()) {
                return -1;
            }
            ++col;
        }
        return -1;
    }

    public int namcmp(String targetString, String searchString, int column) {
        String s = this.colptr(column, searchString);
        if (s == null) {
            return -1;
        }
        return s.compareTo(targetString);
    }

    public String colptr(int column, String line) {
        String s = line;
        int i = 0;
        int col = 0;
        while (i < s.length()) {
            String subs;
            int n;
            if (s.charAt(i) == '\"') {
                n = s.indexOf(34, i + 1);
                if (n < 0 || n >= s.length()) break;
                subs = s.substring(i + 1, n).trim();
                i = n;
                n = s.indexOf(44, i);
            } else {
                n = s.indexOf(44, i);
                if (n == -1) {
                    n = s.length();
                }
                subs = s.substring(i, n).trim();
            }
            if (col == column) {
                return subs;
            }
            i = n + 1;
            if (i >= s.length()) break;
            ++col;
        }
        return "";
    }

    public static float getFloatFromString(String s) {
        float fval = 0.0f;
        try {
            fval = Float.parseFloat(s);
        }
        catch (NumberFormatException e) {
            fval = 0.0f;
        }
        return fval;
    }

    public static int getIntFromString(String s) {
        int ival = 0;
        try {
            ival = s.startsWith("0x") || s.startsWith("0X") ? Integer.parseInt(s.substring(2), 16) : Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            ival = 0;
        }
        return ival;
    }
}

