/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.client;

import de.desy.tine.addrUtils.TFecEntry;
import de.desy.tine.bitfieldUtils.TBitfield;
import de.desy.tine.bitfieldUtils.TBitfieldRegistry;
import de.desy.tine.client.TCallback;
import de.desy.tine.client.TLink;
import de.desy.tine.client.TLinkCallback;
import de.desy.tine.client.TLinkGroup;
import de.desy.tine.client.TLinkHook;
import de.desy.tine.client.TWatchdogLink;
import de.desy.tine.client.TWildcardLink;
import de.desy.tine.console.TConsole;
import de.desy.tine.dataUtils.TDataTime;
import de.desy.tine.dataUtils.TDataType;
import de.desy.tine.definitions.TAccess;
import de.desy.tine.definitions.TErrorList;
import de.desy.tine.definitions.TFormat;
import de.desy.tine.definitions.TMode;
import de.desy.tine.endianUtils.Swap;
import de.desy.tine.headers.TContract;
import de.desy.tine.headers.TGlobalsHdr;
import de.desy.tine.headers.TPHdr;
import de.desy.tine.headers.TSubscription;
import de.desy.tine.io.TBucket;
import de.desy.tine.io.TPacket;
import de.desy.tine.queryUtils.TQuery;
import de.desy.tine.server.equipment.TEquipmentModuleFactory;
import de.desy.tine.server.logger.DbgLog;
import de.desy.tine.server.logger.MsgLog;
import de.desy.tine.server.logger.TFecLog;
import de.desy.tine.startup.TInitializer;
import de.desy.tine.startup.TInitializerFactory;
import de.desy.tine.structUtils.TTaggedStructure;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.Socket;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;

public class TLinkFactory {
    private static TInitializer initializerInstance = TInitializerFactory.getInstance().getInitializer();
    private static boolean gSystemRunningStandAlone = false;
    private static Hashtable<String, RedirectedItem> RdrLst = new Hashtable();
    private static Hashtable<String, RelinkedItem> ReLnkLst = new Hashtable();
    private static Hashtable<String, BlackListedItem> BlackLnkLst = new Hashtable();
    private static Hashtable<String, AccessLockListItem> LockedLnkLst = new Hashtable();
    public static final int DEFAULT_PROTOCOL_LEVEL = 6;
    private static final int RENEWAL_REMINDER = 10;
    private static final int RENEWAL_URGENT = 5;
    private static final int RETRY_THRESHOLD = 2;
    private static final int TIMEOUT_GRACE_INTERVAL = 500;
    private static final int BLACKLIST_FLUSH_INTERVAL = 300;
    private static TLinkFactory instance = new TLinkFactory();
    public boolean alwaysRetry = true;
    boolean active;
    public boolean terminate;
    private boolean autoLinkWatchdogs = true;
    Date date = new Date();
    int time;
    private static String tineUserName = System.getProperty("user.name");
    private TPacket atp;
    private TPacket stp;
    private TPacket qtp;
    private TPacket nmtp;
    private TPacket gtp;
    private TPacket amtp;
    private static int sckBufferSize;
    private static int sckTimeToLive;
    TPHdr pHdr;
    TGlobalsHdr glbHdr;
    public static int debugLevel;
    private int totalLinkTimeouts = 0;
    private int totalConnectionArrivals = 0;
    private boolean useConnectedSockets = false;
    private static int numberTLinksInTable;
    private static int maximumNumberTLinks;
    private static int HEARTBEAT;
    private TLinkHook tLinkHook = null;
    private static final TLink tNullLink;
    private static TLink[] linkTable;
    public static final int adjustLinkTableRemove = 0;
    public static final int adjustLinkTableAdd = 1;
    public static final int adjustLinkTableReplace = 2;
    boolean isInsideCallback = false;
    private LinkedList<TWildcardLink> wcList = null;
    private Hashtable<String, TWatchdogLink> wdList = null;
    private static Hashtable<Object, TLinkGroup> grpList;
    private TFactoryThread atfThrd;
    private TFactoryThread stfThrd;
    private TFactoryThread qtfThrd;
    private TFactoryGlobalsThread gtfThrd;
    private TFactoryThread mtfThrd;
    private TFactoryThread ntfThrd;
    final TFactoryWatchdogThread tfwdThrd = new TFactoryWatchdogThread();
    static final int maximumNumberTBuckets = 10;
    static final int maximumNumberGlobals = 25;
    private TLinkBucket[] bucketTable = new TLinkBucket[10];
    private TInitializer initializer = TInitializerFactory.getInstance().getInitializer();
    private static boolean factoryHasInitialzed;
    Thread factoryShutdownHook = new TLinkFactoryShutdown();
    private ByteArrayOutputStream sndLnkByteStream = null;

    public boolean isRunningStandAlone() {
        return gSystemRunningStandAlone;
    }

    public static String getLinkKey(TLink lnk) {
        if (lnk == null) {
            return null;
        }
        return "/" + lnk.cntName + "/" + lnk.expName + "/" + lnk.devName + "[" + lnk.devProperty + "]";
    }

    public void redirectLink(TLink lnk) {
        String key = TLinkFactory.getLinkKey(lnk);
        if (key == null) {
            return;
        }
        if (RdrLst.containsKey(key)) {
            RedirectedItem rdr = RdrLst.get(key);
            lnk.cntName = rdr.getDstContext();
            lnk.expName = rdr.getDstServer();
            lnk.devName = rdr.getDstDevice();
            lnk.devProperty = rdr.getDstProperty();
        }
    }

    public void flushRedirectionList() {
        RdrLst.clear();
    }

    public void addLinkToRedirectionList(TLink lnk, String context, String server, String device, String property) {
        String key = TLinkFactory.getLinkKey(lnk);
        RdrLst.put(key, new RedirectedItem(lnk, context, server, device, property));
        lnk.isRedirected = true;
    }

    public void reLinkLink(TLink lnk) {
        if (lnk.dOutput.getTag().length() > 0) {
            return;
        }
        String key = TLinkFactory.getLinkKey(lnk);
        if (key == null) {
            return;
        }
        if (ReLnkLst.containsKey(key)) {
            RelinkedItem rlnk = ReLnkLst.get(key);
            TBitfield bf = rlnk.getBitfield();
            lnk.dOutput.setTag(bf.getName());
            lnk.dOutput.dFormat = bf.getFormat();
            lnk.dOutput.setBitField(bf);
        }
    }

    public void flushReLinkList() {
        ReLnkLst.clear();
    }

    public void addLinkToReLinkList(TLink lnk, TBitfield bitfield) {
        String key = TLinkFactory.getLinkKey(lnk);
        ReLnkLst.put(key, new RelinkedItem(lnk, bitfield));
    }

    public void addLinkToBlackList(TLink lnk) {
        if (lnk.linkBlacklists++ > 2) {
            return;
        }
        String key = TLinkFactory.getLinkKey(lnk);
        BlackLnkLst.put(key, new BlackListedItem(lnk));
        lnk.linkStatus = 113;
    }

    public boolean isLinkBlackListed(TLink lnk) {
        String key = TLinkFactory.getLinkKey(lnk);
        if (key == null) {
            return false;
        }
        return BlackLnkLst.containsKey(key);
    }

    public int getBlackListedLinkStatus(TLink lnk) {
        String key = TLinkFactory.getLinkKey(lnk);
        if (key != null && BlackLnkLst.containsKey(key)) {
            BlackListedItem bllnk = BlackLnkLst.get(key);
            return bllnk.getLinkStatus();
        }
        return 58;
    }

    public void flushBlackList() {
        if (BlackLnkLst.size() == 0) {
            return;
        }
        if (debugLevel > 0) {
            DbgLog.log("flushBlackList", "flushing the current link black list");
        }
        BlackLnkLst.clear();
        for (int i = 0; i < numberTLinksInTable; ++i) {
            if (linkTable[i] == null || TLinkFactory.linkTable[i].linkStatus != 113) continue;
            TLinkFactory.linkTable[i].linkStatus = 45;
            TLinkFactory.linkTable[i].linkBlacklists = 0;
        }
    }

    public static int setAccessLock(String context, String server, AccessLockType lockType, int lockDuration) {
        AccessLockListItem all;
        String key = "/" + context + "/" + server + "/[ACCESSLOCK]";
        if (LockedLnkLst.containsKey(key)) {
            all = LockedLnkLst.get(key);
        } else {
            TLinkFactory tLinkFactory = TLinkFactory.getInstance();
            tLinkFactory.getClass();
            all = tLinkFactory.new AccessLockListItem(context, server, lockType, lockDuration);
            if (lockType.ordinal() > 0) {
                LockedLnkLst.put(key, all);
            }
        }
        int lid = all.lockLink.attach((short)1, (TLinkCallback)all, 500);
        all.lastSent = System.currentTimeMillis();
        return lid < 0 ? -lid : 0;
    }

    public static void removeAccessLock(String context, String server) {
        if (context != null && server != null) {
            String key = "/" + context + "/" + server + "/[ACCESSLOCK]";
            if (!LockedLnkLst.containsKey(key)) {
                return;
            }
            LockedLnkLst.remove(key);
            TLinkFactory.setAccessLock(context, server, AccessLockType.LOCK_UNLOCKED, 0);
        } else {
            Enumeration<AccessLockListItem> lst = LockedLnkLst.elements();
            while (lst.hasMoreElements()) {
                AccessLockListItem all = lst.nextElement();
                TLinkFactory.setAccessLock(all.lockLink.cntName, all.lockLink.expName, AccessLockType.LOCK_UNLOCKED, 0);
            }
            LockedLnkLst.clear();
        }
    }

    private void checkAccessLockItems() {
        long t = System.currentTimeMillis();
        Enumeration<AccessLockListItem> lst = LockedLnkLst.elements();
        while (lst.hasMoreElements()) {
            AccessLockListItem all = lst.nextElement();
            if (all.lockType != AccessLockType.LOCK_PERSISTENT.ordinal() || all.lockLinkStatus != 0 || t < all.lockDuration * 1000L + all.lastSent - 5000L) continue;
            all.lockLink.attach((short)1, (TLinkCallback)all, 500);
            all.lastSent = System.currentTimeMillis();
        }
    }

    public void setAlwaysRetry(boolean value) {
        this.alwaysRetry = value;
    }

    public boolean getAlwaysRetry() {
        return this.alwaysRetry;
    }

    public void SetAutoLinkWatchdogs(boolean value) {
        this.autoLinkWatchdogs = value;
    }

    public boolean GetAutoLinkWatchdogs() {
        return this.autoLinkWatchdogs;
    }

    public String getUserName() {
        return tineUserName;
    }

    public void setUserName(String userName) {
        tineUserName = new String(userName);
    }

    public TPacket getGlobalsSocket() {
        return this.gtp;
    }

    public TPacket getMulticastSocket() {
        return this.amtp;
    }

    public static int getSckBufferSize() {
        return sckBufferSize;
    }

    public static void setSckBufferSize(int bufferSize) {
        if (bufferSize > 4096) {
            sckBufferSize = bufferSize;
        }
    }

    public static int getSckTimeToLive() {
        return sckTimeToLive;
    }

    public static void setTimeToLive(int timeToLive) {
        if (timeToLive > 1) {
            sckTimeToLive = timeToLive;
        }
    }

    public boolean isUseConnectedSockets() {
        return this.useConnectedSockets;
    }

    public void setUseConnectedSockets(boolean useConnectedSockets) {
        this.useConnectedSockets = useConnectedSockets;
    }

    public int getTotalLinkTimeouts() {
        return this.totalLinkTimeouts;
    }

    public int getTotalConnectionArrivals() {
        return this.totalConnectionArrivals;
    }

    public int getNumberTLinksInTable() {
        return numberTLinksInTable;
    }

    public static int getMaximumNumberOfLinks() {
        return maximumNumberTLinks;
    }

    public static int setMaximumNumberOfLinks(int numberOfLinks) {
        if (numberOfLinks > 10) {
            maximumNumberTLinks = numberOfLinks;
        }
        linkTable = Arrays.copyOf(linkTable, maximumNumberTLinks);
        return maximumNumberTLinks;
    }

    public void setTLinkHook(TLinkHook hook) {
        this.tLinkHook = hook;
    }

    public TLinkHook getTLinkHook() {
        return this.tLinkHook;
    }

    public TLink[] getLinkTable() {
        return linkTable;
    }

    public static void dumpLinkTable() {
        System.out.println("\nCurrent Connection Table");
        for (int i = 0; i < numberTLinksInTable; ++i) {
            if (linkTable[i] == null || linkTable[i] == tNullLink) continue;
            System.out.println(linkTable[i].toString());
        }
        System.out.println("");
    }

    public int getLinkTableId(TLink lnk) {
        for (int i = 0; i < numberTLinksInTable; ++i) {
            if (linkTable[i] != lnk) continue;
            return i;
        }
        return -1;
    }

    public static synchronized int adjustLinkTable(TLink lnk, int direction) {
        if (lnk == null) {
            return -20;
        }
        switch (direction) {
            case 0: {
                int i;
                if (lnk == null || (i = lnk.linkId) < 0) {
                    return -20;
                }
                if (i == 0) {
                    return 0;
                }
                if (linkTable[i] == null) {
                    return 0;
                }
                if (debugLevel > 1) {
                    DbgLog.log("adjustLinkTable", "removing link " + linkTable[i]);
                }
                TLinkFactory.linkTable[i].terminate = false;
                if (lnk.tb == null) {
                    TLinkFactory.linkTable[i] = null;
                    while (numberTLinksInTable > 1 && linkTable[numberTLinksInTable - 1] == null) {
                        if (debugLevel > 1) {
                            DbgLog.log("adjustLinkTable", "decrement number of entries in link table");
                        }
                        --numberTLinksInTable;
                    }
                }
                if (lnk.twcl == null || lnk.twcl.parent == null) break;
                lnk.twcl.parent.terminate = true;
                break;
            }
            case 1: {
                int i;
                String srv = lnk.getDeviceServer();
                String ctx = lnk.getContext();
                if (srv != null && (ctx == null || ctx.length() == 0 || ctx.compareTo("DEFAULT") == 0) && srv.startsWith("ENS")) {
                    if (numberTLinksInTable == 0) {
                        if (debugLevel > 1) {
                            DbgLog.log("adjustLinkTable", "add ENS entry to link table");
                        }
                        ++numberTLinksInTable;
                    }
                    return 0;
                }
                int freeslot = 0;
                for (i = 1; i < numberTLinksInTable && (linkTable[i] != lnk || linkTable[i] == tNullLink); ++i) {
                    if (freeslot != 0 || linkTable[i] != null) continue;
                    freeslot = i;
                }
                if (i < numberTLinksInTable) {
                    TLinkFactory.linkTable[i].terminate = false;
                    return i;
                }
                if (freeslot > 0) {
                    TLinkFactory.linkTable[freeslot] = lnk;
                    lnk.linkId = freeslot;
                    return freeslot;
                }
                if (numberTLinksInTable == maximumNumberTLinks) {
                    return -77;
                }
                if (debugLevel > 1) {
                    DbgLog.log("adjustLinkTable", "increment number of entries in link table");
                }
                lnk.linkId = i;
                TLinkFactory.linkTable[i] = lnk;
                ++numberTLinksInTable;
                return i;
            }
            case 2: {
                int i;
                if (lnk == null || (i = lnk.linkId) < 0) {
                    return -20;
                }
                if (lnk == null) {
                    return -20;
                }
                if (i == 0) {
                    return 0;
                }
                if (debugLevel > 1) {
                    DbgLog.log("adjustLinkTable", "replace link " + linkTable[i]);
                }
                TLinkFactory.linkTable[i] = lnk;
                break;
            }
        }
        return 0;
    }

    public TLink[] getActiveLinks() {
        int n = 0;
        for (int i = 1; i < numberTLinksInTable; ++i) {
            if (linkTable[i] == null || !TLinkFactory.linkTable[i].active) continue;
            ++n;
        }
        if (n == 0) {
            return null;
        }
        TLink[] tbl = new TLink[n];
        n = 0;
        for (int i = 1; i < numberTLinksInTable; ++i) {
            if (linkTable[i] != null && TLinkFactory.linkTable[i].active) {
                tbl[n++] = linkTable[i];
            }
            if (n >= tbl.length) break;
        }
        return tbl;
    }

    public boolean hasWatchdogLink(String key) {
        if (this.wdList == null) {
            return false;
        }
        return this.wdList.contains(key.toUpperCase());
    }

    public TWatchdogLink getWatchdogLink(String key) {
        if (this.wdList == null) {
            return null;
        }
        return this.wdList.get(key.toUpperCase());
    }

    public void addWatchdogLink(String key, TWatchdogLink lnk) {
        if (this.wdList == null) {
            this.wdList = new Hashtable();
        }
        if (key != null && lnk != null) {
            this.wdList.put(key.toUpperCase(), lnk);
        }
    }

    public void rmvWatchdogLink(String key) {
        if (this.wdList == null) {
            this.wdList = new Hashtable();
        }
        if (key != null) {
            this.wdList.remove(key.toUpperCase());
        }
    }

    public TLinkGroup getGroup(TLinkCallback cb) {
        TLinkGroup grp = null;
        if (grpList == null) {
            grpList = new Hashtable();
        }
        if (grpList.containsKey(cb)) {
            return grpList.get(cb);
        }
        if (debugLevel > 0) {
            DbgLog.log("getGroup", "adding new group to group table");
        }
        grp = new TLinkGroup();
        grpList.put(cb, grp);
        return grp;
    }

    public TLinkGroup getGroup(TCallback cb) {
        TLinkGroup grp = null;
        if (grpList == null) {
            grpList = new Hashtable();
        }
        if (grpList.containsKey(cb)) {
            return grpList.get(cb);
        }
        grp = new TLinkGroup();
        grpList.put(cb, grp);
        return grp;
    }

    public TWildcardLink getWildcardLink() {
        TWildcardLink wc = null;
        if (this.wcList != null) {
            for (int i = 0; i < this.wcList.size(); ++i) {
                wc = this.wcList.get(i);
                if (wc.parent != null) continue;
                return wc;
            }
        } else {
            this.wcList = new LinkedList();
        }
        wc = new TWildcardLink();
        this.wcList.add(wc);
        return wc;
    }

    public int getWildcardLinkId(TWildcardLink wc) {
        if (wc == null || this.wcList == null) {
            return -1;
        }
        for (int i = 0; i < this.wcList.size(); ++i) {
            if (this.wcList.get(i) != wc) continue;
            return i;
        }
        return -1;
    }

    public void rmvWildcardLink(TWildcardLink wc) {
        if (wc == null || this.wcList == null) {
            return;
        }
        for (int i = 0; i < this.wcList.size(); ++i) {
            if (this.wcList.get(i) != wc) continue;
            wc.links = null;
            wc.list = null;
            wc.status = null;
            wc.parent = null;
        }
    }

    public TFactoryThread getAsynchronousLinkThread() {
        return this.atfThrd;
    }

    public TFactoryThread getSynchronousLinkThread() {
        return this.stfThrd;
    }

    public TFactoryThread getQueryLinkThread() {
        return this.qtfThrd;
    }

    public TFactoryGlobalsThread getGlobalsLinkThread() {
        return this.gtfThrd;
    }

    public TFactoryThread getMulticastLinkThread() {
        return this.mtfThrd;
    }

    public TFactoryThread getNetcastLinkThread() {
        return this.ntfThrd;
    }

    public TInitializer getInitializer() {
        return this.initializer;
    }

    public void startGlobalsListener() {
        if (this.gtp == null) {
            this.gtp = new TPacket(this.initializer.getGCastPort());
        }
        if (this.gtfThrd == null) {
            this.gtfThrd = new TFactoryGlobalsThread(this.gtp);
            this.gtfThrd.start();
        }
    }

    public void startMulticastListener(int rcvBufferSize, int timeToLive) {
        if (this.amtp == null) {
            this.amtp = new TPacket(this.initializer.getMCastPort(), rcvBufferSize, timeToLive);
        }
        if (this.mtfThrd == null) {
            this.mtfThrd = new TFactoryThread(this.amtp, true);
            this.mtfThrd.start();
        }
    }

    public TBucketThread makeBucketThread(TLinkBucket tb) {
        return new TBucketThread(tb);
    }

    public TBucketThread getTBucketThread(int index) {
        for (int i = 0; i < 10; ++i) {
            if (this.bucketTable[i] == null || this.bucketTable[i].getBucketPort() != this.initializer.getTCPPort() + TLinkFactory.linkTable[index].srvAddr.fecAddr.fecPortOffset || this.bucketTable[i].getBucketEndpoint() != TLinkFactory.linkTable[index].srvAddr.fecAddr.fecHost) continue;
            return (TBucketThread)this.bucketTable[i].getBucketThread();
        }
        return null;
    }

    public int putBucketThread(TLinkBucket tb) {
        for (int i = 0; i < 10; ++i) {
            if (this.bucketTable[i] != null) continue;
            this.bucketTable[i] = tb;
            return 0;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int removeBucketThread(TLinkBucket tb) {
        int i;
        if (tb == null) {
            return -1;
        }
        for (i = 0; i < numberTLinksInTable; ++i) {
            if (linkTable[i] == null || tb.getBucketPort() != this.initializer.getTCPPort() + TLinkFactory.linkTable[i].srvAddr.fecAddr.fecPortOffset || tb.getBucketEndpoint() != TLinkFactory.linkTable[i].srvAddr.fecAddr.fecHost) continue;
            TLinkFactory.linkTable[i].active = false;
            TLinkFactory.linkTable[i].tb = null;
            TLinkFactory.linkTable[i].terminate = true;
        }
        for (i = 0; i < 10; ++i) {
            if (this.bucketTable[i] == null || this.bucketTable[i] != tb) continue;
            this.bucketTable[i].setBucketPort(0);
        }
        try {
            Socket sck = tb.getSocket();
            sck.shutdownInput();
            sck.shutdownOutput();
            sck.close();
        }
        catch (IOException e) {
            MsgLog.log("removeBucketThread", " IOException : " + e, 15, e, 1);
        }
        finally {
            tb.isDeactivating = false;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int NotifyDeferredCallbacks() {
        for (int i = 0; i < numberTLinksInTable; ++i) {
            if (linkTable[i] == null || linkTable[i] == tNullLink) continue;
            TLink lnk = linkTable[i];
            if (!lnk.needsNotification) continue;
            TLink tLink = lnk;
            synchronized (tLink) {
                if (!lnk.terminate) {
                    this.fireCallbackEvent("NotifyDeferredCallbacks", lnk);
                }
                lnk.needsNotification = false;
            }
            lnk.notifyAll();
        }
        return 0;
    }

    public int fillinIncomingData(TLink lnk) {
        return this.fillinIncomingData(lnk.dOutput);
    }

    public int fillinIncomingData(TDataType dtype) {
        Object hDataObject = dtype.getDataObject();
        String bff = null;
        switch (dtype.getFormat()) {
            case 57: {
                dtype.getData((String[])hDataObject);
                break;
            }
            case 2: 
            case 7: {
                Object hStructObject;
                byte[] hBytes = (byte[])hDataObject;
                if (hBytes != null) {
                    dtype.getData(hBytes);
                }
                if ((hStructObject = dtype.getStructObject()) instanceof TTaggedStructure) {
                    ((TTaggedStructure)hStructObject).toStruct(hBytes);
                    break;
                }
                if (!(hStructObject instanceof TTaggedStructure[])) break;
                TTaggedStructure[] tts = (TTaggedStructure[])hStructObject;
                int dsiz = tts[0].getSizeInBytes();
                byte[] hb = new byte[dsiz];
                for (int i = 0; i < tts.length; ++i) {
                    System.arraycopy(hBytes, i * dsiz, hb, 0, dsiz);
                    tts[i].toStruct(hb);
                }
                break;
            }
            case 50: 
            case 51: 
            case 52: 
            case 53: {
                bff = dtype.getField();
            }
            default: {
                if (hDataObject != null) {
                    dtype.getData(hDataObject);
                }
                if (bff == null) break;
                dtype.applyBitField();
            }
        }
        return 0;
    }

    public int fillinIncomingDataWithErrValue(TLink lnk) {
        if (lnk.linkStatus == 0) {
            return 0;
        }
        if (lnk.useErrObject) {
            lnk.dOutput.dataCopy(lnk.dError);
            return 0;
        }
        if (lnk.useErrValue) {
            lnk.dOutput.dataFill(lnk.linkErrValue);
            if (lnk.linkErrString != null) {
                lnk.dOutput.dataFill(lnk.linkErrString);
            }
        }
        return 0;
    }

    private void fireCallbackEvent(String msg, TLink lnk) {
        if (!lnk.isWithinTolerance()) {
            lnk.isInsideCallback = true;
            try {
                if (lnk.tcb != null) {
                    lnk.tcb.callback(lnk.callbackId, lnk.linkStatus);
                } else if (lnk.tlcb != null) {
                    lnk.tlcb.callback(lnk);
                }
            }
            catch (Throwable e) {
                MsgLog.log(msg, "unhandled exception " + e.getMessage() + " inside link callback", 17, e, 0);
                e.printStackTrace();
            }
            lnk.isInsideCallback = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int InterpretIncomingData(byte[] data, int length, InetAddress addr, int port, boolean deferCallbacks) {
        int n = 0;
        TLink[] lnks = null;
        TPHdr tPHdr = this.pHdr;
        synchronized (tPHdr) {
            lnks = this.pHdr.toStruct(addr, port, data, length);
        }
        if (lnks == null) {
            return 0;
        }
        long ltime = System.currentTimeMillis();
        if (debugLevel > 1) {
            DbgLog.log("InterpretIncomingData", "recv " + length + " bytes " + lnks.length + " contracts");
        }
        for (int i = 0; i < lnks.length; ++i) {
            TLink lnk = lnks[i];
            if (debugLevel > 1) {
                String dbgstr = "link " + lnk.linkId + "(" + "/" + lnk.cntName + "/" + lnk.expName + "/" + lnk.devName + "[" + lnk.devProperty + "] : " + (lnk.active ? "active" : "inactive") + (lnk.linkStale ? " stale" : " not stale -> " + lnk.dOutput.blksin + " blks in from " + lnk.dOutput.numblks + " <" + lnk.linkStatus + ">");
                DbgLog.log("InterpretIncomingData", dbgstr);
            }
            if (!lnk.active || !lnk.linkStale) continue;
            lnk.linkStale = false;
            lnk.linkPeer = addr;
            if (lnk.dOutput.blksin != lnk.dOutput.numblks) continue;
            ++n;
            lnk.sub.linkLastTime = ltime;
            if (lnk.adjustDefaultValues) {
                int fmtsize = TFormat.formatSizeOf(lnk.dOutput.dFormat);
                int dretsize = lnk.dOutput.bytesin;
                if (lnk.linkStatus != 0) {
                    dretsize -= TDataType.RPCERR_SIZE;
                }
                if (dretsize > 0 && fmtsize > 0) {
                    lnk.dOutput.dArrayLength = dretsize / fmtsize;
                }
                lnk.adjustDefaultValues = false;
            }
            lnk.pending = false;
            if (lnk.linkStatus == 119) continue;
            boolean hasData = lnk.linkStatus == 0 || (lnk.linkStatus & 0x4000) == 16384;
            if (hasData) {
                if (debugLevel > 1) {
                    DbgLog.log("InterpretIncomingData", "call getData for link " + lnk.linkId + " format " + TFormat.toString(lnk.dOutput.getFormat()) + " " + TDataTime.toString(System.currentTimeMillis()));
                }
                this.fillinIncomingData(lnk);
            } else {
                this.fillinIncomingDataWithErrValue(lnk);
            }
            if (lnk.isGrouped()) {
                if (lnk.getGroup().getNumberPending() > 0) continue;
                if (debugLevel > 0) {
                    DbgLog.log("InterpretIncomingData", "all members of group have updated");
                }
                lnk.getGroup().reset();
            }
            if (lnk.linkStatus >= 0) {
                if (lnk.linkStatus == 36 || lnk.linkStatus == 8 || lnk.linkStatus == 86 || lnk.linkStatus == 87) {
                    boolean blacklistIt;
                    boolean bl = blacklistIt = !lnk.isWildcardLink;
                    if (lnk.linkStatus == 86 && lnk.linkTimeouts > 0) {
                        blacklistIt = false;
                    }
                    if (blacklistIt) {
                        this.addLinkToBlackList(lnk);
                        if (debugLevel > 0) {
                            DbgLog.log("InterpretIncomingData", "add link " + lnk.getFullDeviceName() + " " + lnk.getProperty() + " to black list");
                        }
                    } else if (debugLevel > 0) {
                        DbgLog.log("InterpretIncomingData", "link " + lnk.getFullDeviceName() + " " + lnk.getProperty() + " returned " + TErrorList.getErrorString(lnk.linkStatus));
                    }
                } else {
                    lnk.linkBlacklists = 0;
                }
                lnk.pending = true;
                if (lnk.dOutput.timestamp == 0) {
                    lnk.dOutput.timestamp = (int)(ltime / 1000L);
                    lnk.dOutput.timestampMSEC = (int)(ltime % 1000L);
                }
                lnk.linkTimeouts = 0;
                if (lnk.sub.mode == 0) {
                    lnk.active = false;
                }
                if (lnk.linkStatusLastNotification != lnk.linkStatus) {
                    MsgLog.log("TFactoryWatchdogThread", lnk.getFullDeviceName() + "[" + lnk.getProperty() + "] link status changed from " + TErrorList.getErrorString(lnk.linkStatusLastNotification) + " to " + TErrorList.getErrorString(lnk.linkStatus), lnk.linkStatus, null, 1);
                    lnk.linkStatusLastNotification = lnk.linkStatus;
                }
                lnk.needsNotification = true;
                TLink blacklistIt = lnk;
                synchronized (blacklistIt) {
                    if (lnk.linkStatus == 119) {
                        continue;
                    }
                    try {
                        if (lnk.active) {
                            if (!deferCallbacks || lnk.isWildcardLink) {
                                this.isInsideCallback = true;
                                if (lnk.hasDependencies()) {
                                    LinkedList<TLink> xlst = lnk.getDependencies();
                                    for (int k = 0; k < xlst.size(); ++k) {
                                        TLink xlnk = xlst.get(k);
                                        if (xlnk == null || xlnk.sub == null) continue;
                                        TDataType xlnkData = xlnk.getOutputDataObject();
                                        if (xlnkData != null) {
                                            xlnkData.dataCopy(lnk.dOutput);
                                            xlnkData.setDataTimeStamp(lnk.dOutput.getDataTimeStamp());
                                        }
                                        xlnk.sub.linkLastTime = lnk.sub.linkLastTime;
                                        xlnk.linkStatus = lnk.linkStatus;
                                        this.fireCallbackEvent("InterpretIncomingData", xlnk);
                                    }
                                }
                                if (!lnk.isCancelledWithDependencies()) {
                                    this.fireCallbackEvent("InterpretIncomingData", lnk);
                                }
                                this.isInsideCallback = false;
                            }
                            lnk.needsNotification = false;
                        } else {
                            lnk.sub.mode = 0;
                        }
                        lnk.notifyAll();
                        if (!lnk.hasNotifiedOnce && this.autoLinkWatchdogs && TWatchdogLink.isWatchableLink(lnk)) {
                            lnk.needsToStartLinkWatchdog = true;
                        }
                        lnk.hasNotifiedOnce = true;
                    }
                    catch (Throwable e) {
                        MsgLog.log("InterpretIncomingData", "unexpected exception", 66, e, 0);
                        e.printStackTrace();
                    }
                }
                if ((lnk.devAccess & 8) != 0 && TMode.getBaseMode(lnk.sub.mode) == 1) {
                    if (debugLevel > 1) {
                        DbgLog.log("InterpretIncomingData", "Thread " + this + " cancel single link " + lnk.linkId);
                    }
                    if ((lnk.sub.mode & 0x2000) == 8192) {
                        lnk.sub.mode = (short)8192;
                    } else {
                        lnk.sub.mode = 0;
                        lnk.active = false;
                        if (lnk.removeOnClose) {
                            if (debugLevel > 1) {
                                DbgLog.log("InterpretIncomingData", "mark link " + lnk.linkId + " for termination");
                            }
                            lnk.terminate = true;
                        }
                    }
                }
                if (lnk.sub.mode == 1) {
                    if (debugLevel > 1) {
                        DbgLog.log("InterpretIncomingData", "de-activate link " + lnk.linkId);
                    }
                    lnk.active = false;
                }
            }
            if (debugLevel > 1) {
                DbgLog.log("InterpretIncomingData", "Thread " + this + " Link counter: " + lnk.linkCounter + " at " + ltime);
            }
            if (TMode.getBaseMode(lnk.sub.mode) > 1 && lnk.linkCounter > 0 && lnk.linkCounter < 10 && lnk.linkStatus != 113) {
                if (lnk.hasRenewed && lnk.linkCounter >= 5) continue;
                lnk.hasRenewed = true;
                int sts = lnk.linkStatus;
                if (debugLevel > 1) {
                    DbgLog.log("InterpretIncomingData", "Thread " + this + " renewing link ...");
                }
                this.sendLinkRequest(lnk);
                lnk.linkStatus = sts;
                continue;
            }
            lnk.hasRenewed = false;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int InterpretIncomingGlobalsData(InetAddress gaddr, byte[] data, int length, boolean deferCallbacks) {
        TLink[] lnks = null;
        TGlobalsHdr tGlobalsHdr = this.glbHdr;
        synchronized (tGlobalsHdr) {
            lnks = this.glbHdr.toStruct(gaddr, data, length);
        }
        if (lnks == null) {
            return 0;
        }
        if (debugLevel > 0) {
            DbgLog.log("InterpretIncomingGlobalsData", "glb recv " + length + " bytes, " + lnks.length + " global links");
        }
        for (int i = 0; i < lnks.length; ++i) {
            TLink glb = lnks[i];
            if (glb.sub.mode != 5) continue;
            glb.sub.linkLastTime = System.currentTimeMillis();
            glb.pending = false;
            if (debugLevel > 1) {
                DbgLog.log("InterpretIncomingGlobalsData", "call getData for format " + glb.dOutput.getFormat());
            }
            if (glb.linkStatus < 0 || glb.pending) continue;
            glb.pending = true;
            glb.dOutput.timestamp = this.time;
            glb.linkTimeouts = 0;
            glb.needsNotification = true;
            TLink tLink = glb;
            synchronized (tLink) {
                try {
                    if (!glb.terminate) {
                        this.isInsideCallback = true;
                        if (glb.hasDependencies()) {
                            LinkedList<TLink> xlst = glb.getDependencies();
                            for (int k = 0; k < xlst.size(); ++k) {
                                TLink xlnk = xlst.get(k);
                                TDataType xlnkData = xlnk.getOutputDataObject();
                                if (xlnkData != null) {
                                    xlnkData.dataCopy(glb.dOutput);
                                    xlnkData.setDataTimeStamp(glb.dOutput.getDataTimeStamp());
                                }
                                xlnk.sub.linkLastTime = glb.sub.linkLastTime;
                                xlnk.linkStatus = glb.linkStatus;
                                this.fireCallbackEvent("InterpretIncomingGlobalsData", xlnk);
                            }
                        }
                        if (!glb.isCancelledWithDependencies()) {
                            glb.isInsideCallback = true;
                            try {
                                if (glb.tcb != null) {
                                    glb.tcb.callback(glb.callbackId, glb.linkStatus);
                                } else if (glb.tlcb != null) {
                                    glb.tlcb.callback(glb);
                                }
                            }
                            catch (Throwable e) {
                                MsgLog.log("InterpretIncomingGlobalsData", "unhandled exception " + e.getMessage() + " inside link callback", 17, e, 0);
                            }
                            glb.isInsideCallback = false;
                        }
                        this.isInsideCallback = false;
                    }
                    glb.notifyAll();
                }
                catch (Exception e) {
                    MsgLog.log("InterpretIncomingGlobalsData", "unhandled execption" + e.getMessage(), 17, e, 0);
                    e.printStackTrace();
                }
                continue;
            }
        }
        return 0;
    }

    private TLinkFactory() {
        this.initFactory();
    }

    private void initFactory() {
        String env;
        if (factoryHasInitialzed) {
            return;
        }
        MsgLog.log("initFactory", "TLink factory initializing ...", 0, null, 1);
        sckBufferSize = initializerInstance.getClnRcvBufferSize();
        sckTimeToLive = initializerInstance.getSckTimeToLive();
        this.atp = new TPacket(sckBufferSize, sckTimeToLive);
        this.stp = new TPacket(sckBufferSize, sckTimeToLive);
        this.qtp = new TPacket();
        this.nmtp = new TPacket();
        this.pHdr = new TPHdr(this);
        this.glbHdr = new TGlobalsHdr(this);
        this.stfThrd = new TFactoryThread(this.stp, false);
        this.qtfThrd = new TFactoryThread(this.qtp, false);
        this.atfThrd = new TFactoryThread(this.atp, true);
        this.gtfThrd = null;
        this.active = true;
        this.stfThrd.start();
        this.qtfThrd.start();
        this.atfThrd.start();
        this.tfwdThrd.start();
        String dbglvlStr = System.getProperty("debug.level");
        if (dbglvlStr != null) {
            debugLevel = Integer.parseInt(dbglvlStr);
        }
        if ((env = System.getProperty("tine.transport")) == null) {
            env = System.getenv("TINE_TRANSPORT");
        }
        if (env != null && env.substring(0, 3).compareToIgnoreCase("TCP") == 0) {
            this.useConnectedSockets = true;
        }
        if ((env = System.getenv("TINE_STANDALONE")) != null && env.compareToIgnoreCase("TRUE") == 0) {
            gSystemRunningStandAlone = true;
            MsgLog.log("TLink Factory", "is running in stand-alone mode", 0, null, 0);
        }
        Runtime.getRuntime().addShutdownHook(this.factoryShutdownHook);
        factoryHasInitialzed = true;
    }

    public synchronized int cancel(TLink lnk) {
        short bmode;
        if (lnk == null || lnk.sub == null) {
            if (lnk != null) {
                lnk.active = false;
            }
            return 0;
        }
        InetAddress g = lnk.getMulticastGroup();
        if (g != null) {
            if (this.numLinksInMulticastGroup(g) == 1) {
                this.detachMulticastGroup(lnk.isGlobalsLink, g);
            }
            lnk.setMulticastGroup(null);
            if (lnk.isGlobalsLink) {
                lnk.active = false;
            }
        }
        TLink thisLnk = lnk;
        if (lnk.isBound()) {
            lnk.active = false;
            thisLnk = lnk.getBoundLink();
            thisLnk.rmvDependency(lnk);
            if (!thisLnk.hasDependencies()) {
                if (!thisLnk.isCancelledWithDependencies()) {
                    return 0;
                }
            } else {
                return 0;
            }
        }
        if (thisLnk.hasDependencies()) {
            thisLnk.cancelledWithDependencies = true;
            return 0;
        }
        if (thisLnk.isWildcardLink && thisLnk.twcl != null) {
            TWildcardLink wc = thisLnk.twcl;
            thisLnk.twcl = null;
            wc.list = null;
            if (wc.length > 0) {
                for (int i = 0; i < wc.length; ++i) {
                    wc.links[i].close();
                }
                wc.length = 0;
                thisLnk.active = false;
                thisLnk.terminate = true;
                thisLnk.pending = false;
                return 0;
            }
        }
        if (TMode.canClose(bmode = TMode.getBaseMode(thisLnk.sub.mode))) {
            MsgLog.log("cancel", "cancel link (" + thisLnk.linkId + ") " + thisLnk.getFullDeviceName() + " mode was " + TMode.toString(thisLnk.sub.mode), 0, null, 1);
            thisLnk.sub.mode = (thisLnk.sub.mode & 0x2000) == 8192 ? (short)8192 : (short)0;
            if (thisLnk.active) {
                this.sendLinkRequest(thisLnk);
            }
        }
        thisLnk.active = false;
        if (thisLnk.linkId == 0) {
            thisLnk.removeOnClose = false;
        } else {
            thisLnk.terminate = true;
        }
        thisLnk.pending = false;
        return 0;
    }

    TLink getExistingLink(String devname, String devproperty, TDataType dout, TDataType din, short devaccess) {
        for (int i = 1; i < numberTLinksInTable; ++i) {
            if (linkTable[i] == null || linkTable[i] == tNullLink || !TLinkFactory.linkTable[i].active || linkTable[i].getFullDeviceName().compareToIgnoreCase(devname) != 0 || linkTable[i].getProperty().compareToIgnoreCase(devproperty) != 0 || TAccess.toBase(TLinkFactory.linkTable[i].devAccess) != TAccess.toBase(devaccess) || !linkTable[i].getOutputDataObject().equals(false, dout) || !linkTable[i].getInputDataObject().equals(true, din)) continue;
            return linkTable[i];
        }
        return null;
    }

    public TLink simpleLink(String devname, String devproperty, TDataType dout, TDataType din, short devaccess) {
        int i;
        if (devname.startsWith("ENS")) {
            i = 0;
            TLinkFactory.adjustLinkTable(new TLink(0, devname, devproperty, dout, din, devaccess), 1);
        } else {
            i = TLinkFactory.adjustLinkTable(new TLink(0, devname, devproperty, dout, din, devaccess), 1);
            if (i < 0) {
                return null;
            }
        }
        if (debugLevel > 1) {
            DbgLog.log("simpleLink", "creating TLink " + linkTable[i] + " (" + i + ")");
        }
        if (debugLevel > 0) {
            linkTable[i].setDebugLevel(debugLevel);
        }
        if (i == 0) {
            TLinkFactory.linkTable[0].removeOnClose = false;
        }
        return linkTable[i];
    }

    private boolean isQueryLink(TLink eqm) {
        if (eqm == null) {
            return false;
        }
        if (eqm.expName.startsWith("ENS") || eqm.expName.startsWith("GENS")) {
            return true;
        }
        if (eqm.devProperty.indexOf("PROPS") >= 0 || eqm.devProperty.indexOf("PROPERTIES") >= 0) {
            return true;
        }
        return eqm.devProperty.indexOf("DEVICES") >= 0;
    }

    private void detachMulticastGroup(boolean isGlobalLink, InetAddress g) {
        block3: {
            if (g.equals(this.initializer.getMCastAddress()) || g.equals(this.initializer.getGCastAddress())) {
                return;
            }
            try {
                TPacket tp = isGlobalLink ? this.getGlobalsSocket() : this.getMulticastSocket();
                tp.getSocket().leaveGroup(g);
            }
            catch (Exception e) {
                if (debugLevel <= 0) break block3;
                DbgLog.log("detachMulticastGroup", "could not detach from multicast group :\n" + e.getMessage());
            }
        }
    }

    private int numLinksInMulticastGroup(InetAddress g) {
        int n = 0;
        for (int i = 0; i < numberTLinksInTable; ++i) {
            InetAddress mcg;
            if (linkTable[i] == null || (mcg = linkTable[i].getMulticastGroup()) == null || !mcg.equals(g)) continue;
            ++n;
        }
        return n;
    }

    synchronized int sendLinkRequest(TLink lnk) {
        TFecEntry srv;
        boolean isServiceRequest;
        if (lnk == null || lnk == tNullLink) {
            lnk.linkStatus = 8;
            return 8;
        }
        if (lnk.linkStatus == 113) {
            lnk.sub.linkLastTime = System.currentTimeMillis();
            return 113;
        }
        if (lnk.delayEstablishLink) {
            return 0;
        }
        boolean isSynchronous = (lnk.devAccess & 8) != 0;
        boolean isQuery = this.isQueryLink(lnk);
        if (lnk.sub.contract == null || lnk.sub.contract.eqmName == null) {
            return 65;
        }
        boolean bl = isServiceRequest = lnk.sub.contract.eqmName.compareTo("_SRV__") == 0;
        if (lnk.linkId < 0) {
            lnk.linkStatus = 51;
            return 51;
        }
        if (lnk.active && lnk.linkStatus == -1) {
            return 0;
        }
        lnk.linkStatus = -1;
        if ((lnk.sub.mode & 5) == 5) {
            lnk.isGlobalsLink = true;
            if (lnk.dOutput == null) {
                return -1;
            }
            if (this.getGlobalsLinkThread() == null) {
                this.startGlobalsListener();
            }
            if (lnk.srvAddr.fecAddr != null) {
                try {
                    String[] mcaddr = this.initializer.getGCastAddress().split("\\.");
                    String[] ipaddr = lnk.srvAddr.fecAddr.fecHost.getHostAddress().split("\\.");
                    String ip = mcaddr[0] + "." + mcaddr[1] + "." + ipaddr[2] + "." + ipaddr[3];
                    InetAddress mcastGrp = InetAddress.getByName(ip);
                    if (this.numLinksInMulticastGroup(mcastGrp) == 0) {
                        this.getGlobalsSocket().getSocket().joinGroup(mcastGrp);
                    }
                    lnk.setMulticastGroup(mcastGrp);
                }
                catch (Exception e) {
                    MsgLog.log("sendLinkRequest", "exception " + e.getMessage(), 66, e, 1);
                    return 66;
                }
            }
            lnk.dOutput.blksin = 0;
            lnk.dOutput.timestamp = this.time;
            lnk.active = true;
            return 0;
        }
        if ((lnk.sub.mode & 0x200) == 512) {
            try {
                if (this.mtfThrd == null) {
                    this.startMulticastListener(sckBufferSize, sckTimeToLive);
                }
                String[] mcaddr = this.initializer.getMCastAddress().split("\\.");
                String[] ipaddr = lnk.srvAddr.fecAddr.fecHost.getHostAddress().split("\\.");
                String ip = mcaddr[0] + "." + mcaddr[1] + "." + ipaddr[2] + "." + ipaddr[3];
                InetAddress mcastGrp = InetAddress.getByName(ip);
                if (this.numLinksInMulticastGroup(mcastGrp) == 0) {
                    this.getMulticastSocket().getSocket().joinGroup(mcastGrp);
                }
                lnk.setMulticastGroup(mcastGrp);
            }
            catch (Exception e) {
                if (debugLevel > 0) {
                    DbgLog.log("sendLinkRequest", "exception " + e.getMessage());
                }
                return 137;
            }
        }
        if (this.useConnectedSockets) {
            lnk.sub.mode = (short)(lnk.sub.mode | 0x2000);
        }
        if ((srv = lnk.srvAddr.fecAddr) == null) {
            if (debugLevel > 0) {
                DbgLog.log("sendLinkRequest", "establish link : can't resolve server address");
            }
            lnk.active = false;
            return 87;
        }
        if (lnk.srvAddr.fecAddr.getTineProtocol() == 0) {
            lnk.srvAddr.fecAddr.setTineProtocol(6);
        }
        if (lnk.srvAddr.fecAddr.getTineProtocol() < 6 && !lnk.sub.isLegacy) {
            short mode = lnk.sub.mode;
            lnk.setTineProtocol(lnk.srvAddr.fecAddr.getTineProtocol());
            TContract c = lnk.sub.contract;
            c.setLegacy(lnk);
            lnk.sub = new TSubscription(c, lnk);
            lnk.sub.mode = mode;
        }
        int hdrSize = lnk.sub.isLegacy ? 20 : 24;
        int conSize = lnk.sub.isLegacy ? 84 : 180;
        lnk.dInput.resetCounters(lnk.getTineProtocol());
        lnk.sub.resetCounters();
        for (int n = 0; n < lnk.dInput.numblks; ++n) {
            byte[] subbytes = lnk.sub.toByteArray();
            lnk.reqHdr.setMsgSizeInBytes((short)(conSize + hdrSize + lnk.sub.nextDataSizeInBytes));
            byte[] hdrbytes = lnk.reqHdr.toByteArray();
            if (debugLevel > 0) {
                DbgLog.log("sendLinkRequest", "trying to establish link " + lnk.linkId + "(" + (n + 1) + " of " + lnk.dInput.numblks + " " + lnk.reqHdr.getMsgSizeInBytes() + " bytes)" + " : " + lnk.expName + " " + lnk.devName + " " + lnk.devProperty + " " + lnk.devTimeout + " msec");
            }
            try {
                if (this.sndLnkByteStream == null) {
                    this.sndLnkByteStream = new ByteArrayOutputStream(1472);
                }
                ByteArrayOutputStream bs = this.sndLnkByteStream;
                bs.reset();
                DataOutputStream ds = new DataOutputStream(bs);
                ds.write(hdrbytes);
                ds.write(subbytes);
                if (lnk.sub.contract.dBuffer == null) {
                    if (debugLevel > 0) {
                        DbgLog.log("sendLinkRequest", "establish link : no address data returned");
                    }
                    lnk.active = false;
                    return 86;
                }
                if (lnk.sub.contract.eqmName.length() == 0 || lnk.sub.msgSizeInBytes == 0) {
                    if (debugLevel > 0) {
                        DbgLog.log("sendLinkRequest", "establish link : header corrupt");
                    }
                    lnk.active = false;
                    return 66;
                }
                if (debugLevel > 0) {
                    DbgLog.log("sendLinkRequest", "send to : " + lnk.srvAddr.fecAddr.fecHost.getHostAddress() + ":" + lnk.srvAddr.fecAddr.fecPortOffset);
                }
                ds.write(lnk.sub.contract.toByteArray());
                if (lnk.dInput.getArrayLength() > 0) {
                    ds.write(lnk.dInput.getDataBuffer(n));
                }
                if (this.isInsideCallback && TMode.getBaseMode(lnk.sub.mode) == 1) {
                    lnk.sub.mode = (short)(lnk.sub.mode & 0xFFFFDFFF);
                }
                if ((lnk.sub.mode & 0x2000) == 8192) {
                    if (lnk.tb == null) {
                        lnk.tb = new TLinkBucket(lnk.linkId);
                    }
                    if (lnk.tb.isDeactivating) {
                        return 109;
                    }
                    if (lnk.tb.getSocket() != null) {
                        OutputStream os = lnk.tb.getOutputStream();
                        os.write(bs.toByteArray());
                        os.flush();
                    }
                } else if (isSynchronous && isQuery) {
                    this.qtp.dpOut = new DatagramPacket(bs.toByteArray(), bs.size(), srv.fecHost, this.initializer.getSrvPort() + srv.fecPortOffset);
                    this.qtp.getSocket().send(this.qtp.dpOut);
                } else if (isSynchronous) {
                    this.stp.dpOut = isServiceRequest ? new DatagramPacket(bs.toByteArray(), bs.size(), srv.fecHost, this.initializer.getNetCastPort()) : new DatagramPacket(bs.toByteArray(), bs.size(), srv.fecHost, this.initializer.getSrvPort() + srv.fecPortOffset);
                    this.stp.getSocket().send(this.stp.dpOut);
                } else {
                    this.atp.dpOut = new DatagramPacket(bs.toByteArray(), bs.size(), srv.fecHost, this.initializer.getSrvPort() + srv.fecPortOffset);
                    this.atp.getSocket().send(this.atp.dpOut);
                }
                lnk.dOutput.blksin = 0;
                lnk.dOutput.timestamp = this.time;
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
                if (debugLevel > 0) {
                    DbgLog.log("sendLinkRequest", "establish link : IO Exception");
                }
                return 28;
            }
        }
        if (debugLevel > 0) {
            DbgLog.log("sendLinkRequest", "establish link : success");
        }
        lnk.active = true;
        return 0;
    }

    public TLink findLink(InetAddress inetAddr, int port) {
        for (int i = 0; i < numberTLinksInTable; ++i) {
            InetAddress ia;
            TFecEntry fec;
            if (linkTable[i] == null || linkTable[i] == tNullLink || linkTable[i].getTineProtocol() < 6 || (fec = TLinkFactory.linkTable[i].srvAddr.fecAddr) == null || (ia = fec.fecHost).getHostAddress().compareTo(inetAddr.getHostAddress()) != 0 || port != this.initializer.getSrvPort() + fec.fecPortOffset) continue;
            return linkTable[i];
        }
        return null;
    }

    public int findTLink(TLink link) {
        for (int i = 0; i < numberTLinksInTable; ++i) {
            if (linkTable[i] != link) continue;
            return i;
        }
        return -1;
    }

    public TLink findTLink(int linkid, int linkstarttime) {
        if (linkstarttime == 255) {
            for (int i = 0; i < numberTLinksInTable; ++i) {
                if (linkTable[i] == null || linkTable[i] == tNullLink || TLinkFactory.linkTable[i].srvId != linkid) continue;
                return linkTable[i];
            }
            return null;
        }
        if (linkstarttime == 4096) {
            if (linkTable[0] != null && TLinkFactory.linkTable[0].sub.id != linkid) {
                return null;
            }
            TLinkFactory.linkTable[0].removeOnClose = false;
            return linkTable[0];
        }
        if (debugLevel > 2) {
            DbgLog.log("findTLink", "find incoming link id " + linkid + " start time " + linkstarttime + " among " + numberTLinksInTable + " registered links");
        }
        if (linkid < 0 || linkid >= numberTLinksInTable) {
            return null;
        }
        if (linkTable[linkid] == null || TLinkFactory.linkTable[linkid].sub == null) {
            return null;
        }
        if (debugLevel > 2) {
            DbgLog.log("findTLink", "link table id " + linkid + " : start time " + TLinkFactory.linkTable[linkid].sub.starttime);
        }
        if (TLinkFactory.linkTable[linkid].sub.starttime != linkstarttime) {
            return null;
        }
        if (debugLevel > 1) {
            DbgLog.log("findTLink", "returning link " + linkid + " " + linkTable[linkid].getFullDeviceName());
        }
        return linkTable[linkid];
    }

    public TLink findTLink(InetAddress gaddr, String keyword) {
        keyword = keyword.trim();
        if (debugLevel > 2) {
            DbgLog.log("findTLink", "looking for global link " + keyword + " amoung " + numberTLinksInTable + " registered links");
        }
        for (int i = 0; i < numberTLinksInTable; ++i) {
            if (linkTable[i] == null || linkTable[i] == tNullLink) continue;
            if (TLinkFactory.linkTable[i].sub.mode != 5) {
                if (debugLevel <= 3) continue;
                DbgLog.log("findTLink", TLinkFactory.linkTable[i].devProperty + " is not a global");
                continue;
            }
            if (debugLevel > 2) {
                DbgLog.log("findTLink", "Compare " + keyword + " against " + TLinkFactory.linkTable[i].devProperty);
            }
            if (gaddr != null && TLinkFactory.linkTable[i].expName.compareToIgnoreCase("SITE") != 0 && !TLinkFactory.linkTable[i].srvAddr.fecAddr.fecHost.equals(gaddr) || keyword.compareToIgnoreCase(TLinkFactory.linkTable[i].devProperty) != 0) continue;
            if (debugLevel > 0) {
                DbgLog.log("findTLink", "returning link " + i + " : " + linkTable[i].getFullDeviceName());
            }
            return linkTable[i];
        }
        if (debugLevel > 0) {
            DbgLog.log("findTLink", "not found : data discarded");
        }
        return null;
    }

    public static TLinkFactory getInstance() {
        if (instance == null) {
            instance = new TLinkFactory();
        }
        return instance;
    }

    public void activateLink(TLink link) {
        TLinkFactory.linkTable[link.linkId] = link;
        if (debugLevel > 0) {
            DbgLog.log("activateLink", "creating TLink " + linkTable[link.linkId] + " (" + link.linkId + ")");
        }
    }

    public int registerLink(TLink link) {
        int i = link.expName.startsWith("ENS") && (link.cntName.startsWith("DEFAULT") || link.cntName.length() == 0) ? TLinkFactory.adjustLinkTable(link, 1) : TLinkFactory.adjustLinkTable(tNullLink, 1);
        return i;
    }

    private void removeTLink(TLink lnk) {
        TLinkFactory.adjustLinkTable(lnk, 0);
    }

    public void shutdown() {
        this.active = false;
    }

    public int setDebugLevel(int level) {
        return TLinkFactory.setOutputDebugLevel(level);
    }

    public int getDebugLevel() {
        return debugLevel;
    }

    public static int setOutputDebugLevel(int level) {
        TEquipmentModuleFactory.setDebugLevel(level);
        debugLevel = level;
        if (level > 0) {
            TConsole.getInstance().show();
        }
        return debugLevel;
    }

    public static int getOutputDebugLevel() {
        return debugLevel;
    }

    static {
        numberTLinksInTable = 1;
        maximumNumberTLinks = 1024;
        HEARTBEAT = 60000;
        tNullLink = new TLink();
        linkTable = new TLink[maximumNumberTLinks];
        grpList = null;
        factoryHasInitialzed = false;
    }

    public class TFactoryGlobalsThread
    extends Thread {
        TPacket tp;
        boolean isWaiting = false;

        TFactoryGlobalsThread(TPacket tPacket) {
            this.tp = tPacket;
            String s = null;
            MulticastSocket sck = this.tp.getSocket();
            s = sck != null ? new String("globals port (multicast listener) " + sck.getLocalPort()) : new String("globals unbound socket ?");
            this.setName("Link Factory " + s);
        }

        public synchronized void run() {
            MsgLog.log("TFactoryGlobalsThread", "Link Factory Thread " + this.getName() + " started ...", 0, null, 1);
            MulticastSocket sck = this.tp.getSocket();
            while (TLinkFactory.this.active && !TLinkFactory.this.terminate) {
                if (debugLevel > 1) {
                    DbgLog.log("TFactoryGlobalsThread", "Waiting for globals data ...");
                }
                try {
                    this.isWaiting = true;
                    this.tp.dpIn.setLength(1472);
                    sck.receive(this.tp.dpIn);
                    this.isWaiting = false;
                    TLinkFactory.this.InterpretIncomingGlobalsData(this.tp.dpIn.getAddress(), this.tp.dpIn.getData(), this.tp.dpIn.getLength(), false);
                }
                catch (IOException e) {
                    if (debugLevel <= 1) continue;
                    DbgLog.log("TFactoryGlobalsThread", "IO exception: " + e.getMessage());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    MsgLog.log("TFactoryGlobalsThread", "unhandled exception " + e.getMessage(), 66, e, 0);
                }
            }
        }
    }

    public class TFactoryThread
    extends Thread {
        TPacket tp;
        boolean isWaiting = false;
        boolean canCallback = false;

        TFactoryThread(TPacket tPacket, boolean callback) {
            this.tp = tPacket;
            this.canCallback = callback;
            String s = null;
            MulticastSocket sck = this.tp.getSocket();
            if (sck != null) {
                String dsc = this.tp.isMulticastListener() ? "(multicast listener) " : "";
                s = new String("datagram port " + dsc + sck.getLocalPort());
            } else {
                s = new String("unbound socket ?");
            }
            this.setName("Link Factory " + s);
        }

        public synchronized void run() {
            DbgLog.log("TFactoryThread", "Link Factory Thread " + this.getName() + " started ...");
            MulticastSocket sck = this.tp.getSocket();
            while (TLinkFactory.this.active && !TLinkFactory.this.terminate) {
                if (debugLevel > 1) {
                    DbgLog.log("TFactoryThread", "Waiting for data ...");
                }
                try {
                    this.isWaiting = true;
                    this.tp.dpIn.setLength(64000);
                    if (sck != null) {
                        sck.receive(this.tp.dpIn);
                    }
                    TLinkFactory.this.totalConnectionArrivals++;
                    this.isWaiting = false;
                    if (debugLevel > 1) {
                        DbgLog.log("TFactoryThread", "examine " + this.tp.dpIn.getLength() + " bytes");
                    }
                    TLinkFactory.this.InterpretIncomingData(this.tp.dpIn.getData(), this.tp.dpIn.getLength(), this.tp.dpIn.getAddress(), this.tp.dpIn.getPort(), !this.canCallback);
                }
                catch (Exception e) {
                    if (debugLevel <= 1) continue;
                    e.printStackTrace();
                }
            }
        }
    }

    public class TFactoryWatchdogThread
    extends Thread {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void run() {
            this.setName("Link Factory watchdog");
            DbgLog.log("TFactoryWatchdogThread", "Thread " + this.getName() + " started ...");
            long ltime = System.currentTimeMillis();
            int lasttime = TLinkFactory.this.time = (int)(ltime / 1000L);
            boolean linkHasStatus = false;
            boolean suppressNotify = false;
            boolean isGlobalLink = false;
            while (TLinkFactory.this.active && !TLinkFactory.this.terminate) {
                try {
                    TFactoryWatchdogThread.sleep(100L);
                    ltime = System.currentTimeMillis();
                    TLinkFactory.this.time = (int)(ltime / 1000L);
                    if (lasttime != TLinkFactory.this.time) {
                        if (lasttime % 300 == 0) {
                            TLinkFactory.this.flushBlackList();
                        }
                        if (LockedLnkLst.size() > 0) {
                            TLinkFactory.this.checkAccessLockItems();
                        }
                        lasttime = TLinkFactory.this.time;
                    }
                    for (int i = 0; i < numberTLinksInTable; ++i) {
                        if (linkTable[i] == null || linkTable[i] == tNullLink) continue;
                        TLink lnk = linkTable[i];
                        if (lnk.linkId != i) {
                            DbgLog.log("TFactoryWatchdogThread", "link table id does not match entry index !");
                        }
                        if (lnk.delayEstablishLink) {
                            lnk.delayEstablishLink = false;
                            TLinkFactory.this.sendLinkRequest(lnk);
                            continue;
                        }
                        if (lnk.needsToStartLinkWatchdog) {
                            lnk.needsToStartLinkWatchdog = false;
                            new TWatchdogLink(lnk);
                        }
                        if (lnk.terminate && lnk.linkId > 0 && lnk.sub.starttime < TLinkFactory.this.time) {
                            if (debugLevel > 1) {
                                DbgLog.log("TFactoryWatchdogThread", "remove terminated link " + lnk.linkId + " /" + lnk.cntName + "/" + lnk.expName + "/" + lnk.devName + " " + lnk.devProperty);
                            }
                            TLink tLink = lnk;
                            synchronized (tLink) {
                                lnk.notifyAll();
                            }
                            TLinkFactory.this.removeTLink(lnk);
                        }
                        if (!lnk.active) continue;
                        if (lnk.linkStatus == 157) {
                            String[] parts;
                            String tag = lnk.dOutput.getTag();
                            int cc = TQuery.AcquireAndRegisterBitfieldInfo(lnk.cntName, lnk.expName, tag, lnk.dOutput.dFormat);
                            if (cc != 0) {
                                lnk.linkStatus = cc;
                                lnk.linkStale = true;
                                continue;
                            }
                            lnk.dOutput.dFormat = TFormat.getBitfieldFormat(lnk.dOutput.dFormat);
                            TBitfield bf = TBitfieldRegistry.getBitfield(tag);
                            if (bf == null) {
                                lnk.linkStatus = 62;
                                lnk.linkStale = true;
                                continue;
                            }
                            boolean fieldKnown = false;
                            String dev = lnk.devName;
                            String prp = lnk.devProperty;
                            if (!fieldKnown && (parts = lnk.devProperty.split("\\.")).length > 1 && bf.isField(parts[parts.length - 1])) {
                                prp = lnk.devProperty.substring(0, lnk.devProperty.indexOf(parts[parts.length - 1]) - 1);
                                fieldKnown = true;
                            }
                            if (!fieldKnown && (parts = lnk.devName.split("\\.")).length > 1 && bf.isField(parts[parts.length - 1])) {
                                dev = lnk.devName.substring(0, lnk.devName.indexOf(parts[parts.length - 1]) - 1);
                                fieldKnown = true;
                            }
                            if (fieldKnown) {
                                TLinkFactory.this.addLinkToReLinkList(lnk, bf);
                                lnk.devName = dev;
                                lnk.devProperty = prp;
                                lnk.dOutput.setBitField(bf);
                            } else {
                                lnk.linkStatus = 136;
                                continue;
                            }
                        }
                        if (lnk.linkStatus == 121 || lnk.linkStatus == 157) {
                            short mod = lnk.sub.mode;
                            lnk.con = new TContract(lnk);
                            lnk.sub = new TSubscription(lnk.con, lnk);
                            lnk.sub.mode = mod;
                            TLinkFactory.this.sendLinkRequest(lnk);
                            lnk.linkStatus = 0;
                            continue;
                        }
                        if (lnk.linkStatus == 94) {
                            if (lnk.getTineProtocol() == 6) {
                                lnk.setTineProtocol(5);
                                short mod = lnk.sub.mode;
                                lnk.sub = new TSubscription(lnk.con, lnk);
                                lnk.sub.mode = mod;
                                TLinkFactory.this.sendLinkRequest(lnk);
                                lnk.linkStatus = 0;
                                lnk.sub.linkLastTime = ltime;
                                continue;
                            }
                            lnk.sub.mode = 0;
                            MsgLog.log("TFactoryWatchdogThread", "link " + lnk.linkId + " protocol level " + lnk.getTineProtocol() + " is invalid", 94, null, 1);
                        }
                        linkHasStatus = false;
                        short baseMode = (short)(lnk.sub.mode & 0xFF);
                        long tcpIdlePeriod = 3000L;
                        long deltatime = ltime - lnk.sub.linkLastTime;
                        long gracePeriod = 500L;
                        if ((baseMode == 2 || baseMode == 6) && lnk.linkTimeouts == 0) {
                            gracePeriod += (long)HEARTBEAT;
                        }
                        boolean bl = isGlobalLink = baseMode == 5;
                        if (deltatime > (long)lnk.devTimeout + gracePeriod && TMode.canTimeOut(baseMode)) {
                            linkHasStatus = true;
                            if (lnk.linkStatus == -1) {
                                lnk.linkStatus = 45;
                                continue;
                            }
                            TLinkFactory.this.totalLinkTimeouts++;
                            ++lnk.linkTimeouts;
                            boolean bl2 = suppressNotify = lnk.retryOnTimeoutError && lnk.linkTimeouts < 2;
                            if (debugLevel > 0) {
                                DbgLog.log("TFactoryWatchdogThread", "link " + lnk.linkId + " link timeout " + lnk.devTimeout + " exceeded : " + ltime + " vs " + lnk.sub.linkLastTime + " timeout counter : " + lnk.linkTimeouts);
                                if (suppressNotify) {
                                    DbgLog.log("TFactoryWatchdogThread", "suppressing link timeout notification");
                                }
                            }
                            lnk.pending = false;
                            lnk.dOutput.timestamp = TLinkFactory.this.time;
                            if (lnk.linkStatus != 113) {
                                lnk.linkStatus = 45;
                            } else {
                                linkHasStatus = false;
                            }
                            if (!isGlobalLink) {
                                TPHdr cc = TLinkFactory.this.pHdr;
                                synchronized (cc) {
                                    TLinkFactory.this.pHdr.lnkCounter = 0;
                                }
                            }
                            if (lnk.isGrouped()) {
                                if (lnk.getGroup().getNumberPending() > 0) {
                                    suppressNotify = true;
                                } else {
                                    lnk.getGroup().reset();
                                }
                            }
                            if (lnk.isInsideCallback) continue;
                            if (!suppressNotify && lnk.linkStatusLastNotification != lnk.linkStatus) {
                                String msg = baseMode > 1 ? "link status changed from " + TErrorList.getErrorString(lnk.linkStatusLastNotification) + " to " + TErrorList.getErrorString(lnk.linkStatus) : TErrorList.getErrorString(lnk.linkStatus);
                                MsgLog.log("TFactoryWatchdogThread", lnk.getFullDeviceName() + "[" + lnk.getProperty() + "] " + msg, lnk.linkStatus, null, 1);
                                lnk.linkStatusLastNotification = lnk.linkStatus;
                            }
                            if (!suppressNotify && baseMode > 1) {
                                TLink tLink = lnk;
                                synchronized (tLink) {
                                    lnk.needsNotification = true;
                                    if (!lnk.terminate) {
                                        TLinkFactory.this.fireCallbackEvent("TFactoryWatchdogThread", lnk);
                                        lnk.needsNotification = false;
                                    }
                                    lnk.notifyAll();
                                    lnk.sub.linkLastTime = ltime;
                                }
                            }
                            if (isGlobalLink) {
                                if (lnk.expName.compareToIgnoreCase("CYCLER") != 0) continue;
                                lnk.linkStatus = 0;
                                continue;
                            }
                            if (baseMode > 1) {
                                lnk.sub.linkLastTime = ltime;
                                TLinkFactory.this.sendLinkRequest(lnk);
                            } else if (baseMode == 1) {
                                if (suppressNotify) {
                                    lnk.sub.mode = (short)(lnk.sub.mode | 0x800);
                                    lnk.sub.linkLastTime = ltime;
                                    TLinkFactory.this.sendLinkRequest(lnk);
                                } else {
                                    lnk.needsNotification = true;
                                    TLink tLink = lnk;
                                    synchronized (tLink) {
                                        if (!lnk.terminate) {
                                            TLinkFactory.this.fireCallbackEvent("TFactoryWatchdogThread", lnk);
                                            lnk.needsNotification = false;
                                        }
                                        if (debugLevel > 1) {
                                            DbgLog.log("TFactoryWatchdogThread", " cancel single link " + lnk.linkId + " from watchdog" + " " + TDataTime.toString(ltime));
                                        }
                                        if ((lnk.sub.mode & 0x2000) == 8192) {
                                            tcpIdlePeriod = 0L;
                                            lnk.sub.mode = (short)8192;
                                        } else {
                                            lnk.sub.mode = 0;
                                        }
                                        lnk.active = false;
                                        lnk.pending = false;
                                        lnk.linkTimeouts = 0;
                                        lnk.notifyAll();
                                    }
                                }
                            }
                        }
                        if (deltatime > (long)lnk.devTimeout + tcpIdlePeriod && lnk.sub.mode == 8192 && lnk.linkBlacklists == 0 && ((TLinkBucket)lnk.tb).getActiveLinks() == 0) {
                            TLinkFactory.this.removeBucketThread((TLinkBucket)lnk.tb);
                        }
                        if (lnk.sub.mode == 0 && !lnk.active && lnk.linkStatus != -1 && debugLevel > 1) {
                            DbgLog.log("TFactoryWatchdogThread", "watchdog ignoring cancelled link " + lnk.linkId);
                        }
                        if (debugLevel <= 3 && (debugLevel <= 2 || !linkHasStatus)) continue;
                        DbgLog.log("TFactoryWatchdogThread", "link : /" + lnk.cntName + "/" + lnk.expName + "/" + lnk.devName + " " + lnk.devProperty + " : linkStatus " + lnk.linkStatus + " Link active : " + lnk.active + " terminate : " + lnk.terminate + " " + TDataTime.toString(ltime));
                    }
                }
                catch (InterruptedException e) {
                    if (debugLevel <= 1) continue;
                    DbgLog.log("TFactoryWatchdogThread", " Watchdog Thread : " + TLinkFactory.this.active + " terminate : " + TLinkFactory.this.terminate);
                }
                catch (Exception e) {
                    if (debugLevel <= 1) continue;
                    e.printStackTrace();
                }
            }
            TLinkFactory.removeAccessLock(null, null);
        }
    }

    public class TLinkFactoryShutdown
    extends Thread {
        public synchronized void run() {
            DbgLog.log("TLinkFactoryShutdown", "shutting down link factory");
            this.setName("Link Factory shutdown");
            for (int i = 0; i < numberTLinksInTable; ++i) {
                if (linkTable[i] == null || linkTable[i] == tNullLink) continue;
                linkTable[i].close();
            }
        }
    }

    public class TBucketThread
    extends Thread {
        TLinkBucket tb;
        boolean isWaiting = false;

        public TLinkBucket getBucket() {
            return this.tb;
        }

        public TBucketThread(TLinkBucket tBucket) {
            this.tb = tBucket;
            this.tb.active = true;
            String s = null;
            Socket sck = this.tb.getSocket();
            s = sck != null ? new String("tcp port " + sck.getLocalPort()) : new String("tcp unbound socket ?");
            this.setName("Link Factory " + s);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void run() {
            byte[] wa = new byte[64000];
            byte[] msgsizb = new byte[2];
            TFecLog.log("TBucketThread", "Link Factory Thread " + this.getName() + " started ...");
            try {
                InputStream is = this.tb.getInputStream();
                while (this.tb.active && !TLinkFactory.this.terminate) {
                    if (debugLevel > 2) {
                        DbgLog.log("TBucketThread", "Waiting for steam data ...");
                    }
                    this.isWaiting = true;
                    int nread = is.read(wa, 0, 64000);
                    if (nread == -1) {
                        this.tb.isDeactivating = true;
                        break;
                    }
                    TLinkFactory.this.totalConnectionArrivals++;
                    int nleft = nread;
                    int waptr = 0;
                    while (nleft > 0) {
                        if (this.tb.getBucketPointer() == 0) {
                            System.arraycopy(wa, waptr, msgsizb, 0, 2);
                            this.tb.setBucketSize(Swap.Short(new DataInputStream(new ByteArrayInputStream(msgsizb)).readShort()));
                        }
                        int ptr = this.tb.getBucketPointer();
                        int siz = this.tb.getBucketSize();
                        byte[] buf = this.tb.getBucketBuffer();
                        int n = siz - ptr;
                        if (nleft >= n) {
                            System.arraycopy(wa, waptr, buf, ptr, n);
                            TLinkFactory.this.InterpretIncomingData(buf, siz, this.tb.getBucketEndpoint(), this.tb.getBucketPort(), false);
                            waptr += n;
                            nleft -= n;
                            ptr = 0;
                        } else {
                            System.arraycopy(wa, waptr, buf, ptr, nleft);
                            ptr += nleft;
                            nleft = 0;
                        }
                        this.tb.setBucketPointer(ptr);
                    }
                }
                this.tb.getSocket().close();
            }
            catch (Exception e) {
                if (debugLevel > 1) {
                    e.printStackTrace();
                }
            }
            finally {
                TLinkFactory.this.removeBucketThread(this.tb);
            }
        }
    }

    public class TLinkBucket
    extends TBucket {
        public TLinkBucket(int index) {
            if (index < 0 || index >= TLinkFactory.getMaximumNumberOfLinks()) {
                return;
            }
            if (linkTable[index].getBucket() != null) {
                return;
            }
            TBucketThread tfBckThrd = TLinkFactory.this.getTBucketThread(index);
            if (tfBckThrd != null) {
                TLinkBucket tb = tfBckThrd.getBucket();
                this.setSocket(tb.getSocket());
                this.setOutputStream(tb.getOutputStream());
                this.setInputStream(tb.getInputStream());
                return;
            }
            this.initBucket(linkTable[index].srvAddr.fecAddr.fecHost, TLinkFactory.this.getInitializer().getTCPPort() + linkTable[index].srvAddr.fecAddr.fecPortOffset, new TBucketThread(this));
            TLinkFactory.this.putBucketThread(this);
            this.activate();
        }

        public int getActiveLinks() {
            int n = 0;
            for (int i = 0; i < numberTLinksInTable; ++i) {
                if (linkTable[i] == null || !linkTable[i].active || linkTable[i].tb != this) continue;
                ++n;
            }
            return n;
        }
    }

    public class AccessLockListItem
    implements TLinkCallback {
        private String key;
        TLink lockLink;
        int lockType;
        int lockLinkStatus;
        long lockDuration;
        long lastSent;

        public AccessLockListItem(String context, String server, AccessLockType lockType, int lockDuration) {
            short[] lvals = new short[]{(short)lockType.ordinal(), (short)lockDuration};
            TDataType din = new TDataType(lvals);
            TLink lnk = new TLink("/" + context + "/" + server, "ACCESSLOCK", null, din, 258);
            this.key = TLinkFactory.getLinkKey(lnk);
            this.lockType = lockType.ordinal();
            this.lockDuration = lockDuration;
            this.lockLink = lnk;
        }

        public void callback(TLink link) {
            this.lockLinkStatus = link.linkStatus;
            if (this.lockLinkStatus != 0 && debugLevel > 0) {
                DbgLog.log("AccessLockListItem", "access lock " + this.key + " : " + link.linkErrString);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AccessLockType {
        LOCK_UNLOCKED,
        LOCK_PREEMPTIVE,
        LOCK_PERSISTENT,
        LOCK_ABORT;

    }

    public class BlackListedItem {
        private String srcKey;
        private int status = 0;

        public BlackListedItem(TLink lnk) {
            this.srcKey = TLinkFactory.getLinkKey(lnk);
            this.status = lnk.linkStatus;
        }

        public int getLinkStatus() {
            return this.status;
        }

        public String getSrcKey() {
            return this.srcKey;
        }
    }

    public class RelinkedItem {
        private String srcKey;
        private TBitfield dstBf;

        public RelinkedItem(TLink lnk, TBitfield bitfield) {
            this.srcKey = TLinkFactory.getLinkKey(lnk);
            this.dstBf = bitfield;
        }

        public TBitfield getBitfield() {
            return this.dstBf;
        }

        public String getSrcKey() {
            return this.srcKey;
        }
    }

    public class RedirectedItem {
        private String srcKey;
        private String dstCtx;
        private String dstSrv;
        private String dstDev;
        private String dstPrp;

        public RedirectedItem(TLink lnk, String context, String server, String device, String property) {
            this.srcKey = TLinkFactory.getLinkKey(lnk);
            this.dstCtx = context == null ? lnk.cntName : context;
            this.dstSrv = server == null ? lnk.expName : server;
            this.dstDev = device == null ? lnk.devName : device;
            this.dstPrp = property == null ? lnk.devProperty : property;
        }

        public String getDstContext() {
            return this.dstCtx;
        }

        public void setDstContext(String context) {
            this.dstCtx = context;
        }

        public String getDstDevice() {
            return this.dstDev;
        }

        public void setDstDevice(String device) {
            this.dstDev = device;
        }

        public String getDstProperty() {
            return this.dstPrp;
        }

        public void setDstProperty(String property) {
            this.dstPrp = property;
        }

        public String getDstServer() {
            return this.dstSrv;
        }

        public void setDstServer(String server) {
            this.dstSrv = server;
        }

        public String getSrcKey() {
            return this.srcKey;
        }
    }
}

