/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.client;

import de.desy.tine.addrUtils.TSrvEntry;
import de.desy.tine.bitfieldUtils.TBitfield;
import de.desy.tine.bitfieldUtils.TBitfieldRegistry;
import de.desy.tine.client.TCallback;
import de.desy.tine.client.TLinkCallback;
import de.desy.tine.client.TLinkFactory;
import de.desy.tine.client.TLinkGroup;
import de.desy.tine.client.TLinkHook;
import de.desy.tine.client.TWatchdogLink;
import de.desy.tine.client.TWildcardLink;
import de.desy.tine.dataUtils.TDataTolerance;
import de.desy.tine.dataUtils.TDataType;
import de.desy.tine.definitions.TErrorList;
import de.desy.tine.definitions.TFormat;
import de.desy.tine.definitions.TMode;
import de.desy.tine.headers.TContract;
import de.desy.tine.headers.TPHdr;
import de.desy.tine.headers.TReqHdr;
import de.desy.tine.headers.TSubscription;
import de.desy.tine.io.TBucket;
import de.desy.tine.queryUtils.TQuery;
import de.desy.tine.server.logger.DbgLog;
import de.desy.tine.server.logger.MsgLog;
import de.desy.tine.server.properties.TPropertyList;
import de.desy.tine.server.properties.TStockProperties;
import java.net.InetAddress;
import java.util.Date;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TLink {
    public String cntName;
    public String expName;
    public String devName;
    public String devProperty;
    public TDataType dOutput;
    public TDataType dInput;
    public TDataType dError;
    private static int maxOutputBufferSize = 65535;
    private String arrayDelimiter;
    public short devAccess;
    public short devTimeout;
    public static int defaultTimeout = 500;
    public short srvId;
    private InetAddress mcastGrp = null;
    private int tineProtocol = 6;
    boolean active;
    boolean terminate;
    boolean delayEstablishLink = false;
    boolean needsNotification = false;
    boolean isInsideCallback = false;
    boolean isWildcardLink = false;
    boolean isGlobalsLink = false;
    boolean isQuery = false;
    boolean useErrValue = false;
    boolean useErrObject = false;
    boolean isRedirected = false;
    TLinkHook hook = null;
    Object hookObj = null;
    public boolean adjustDefaultValues = false;
    public boolean retryOnTimeoutError = true;
    public boolean removeOnClose = false;
    public boolean hasRenewed = false;
    public boolean hasNotifiedOnce = false;
    public boolean isBeingWatched = false;
    public boolean needsToStartLinkWatchdog = false;
    public TSrvEntry srvAddr;
    TContract con;
    TSubscription sub;
    TPHdr pHdr;
    TReqHdr reqHdr;
    TLink boundTo = null;
    boolean cancelledWithDependencies = false;
    private TLinkGroup grp = null;
    LinkedList<TLink> dependencies = null;
    public int linkStatusLastNotification = 0;
    public int linkStatus;
    public int linkCounter;
    public boolean linkStale;
    public double linkErrValue;
    public String linkErrString;
    public byte[] linkStatusStringBuffer = new byte[192];
    public InetAddress linkPeer;
    TCallback tcb;
    int callbackId;
    TLinkCallback tlcb;
    TWildcardLink twcl;
    private TDataTolerance dtf = null;
    Date date = new Date();
    public int linkId;
    int linkBlacklists = 0;
    int linkTimeouts = 0;
    boolean pending = false;
    public TLinkFactory tf;
    TBucket tb;

    protected void finalize() throws Throwable {
        if (this.active) {
            MsgLog.log("finalize TLink", "closing active link to /" + this.cntName + "/" + this.expName + "/" + this.devName + "[" + this.devProperty + "] in finalizer", 0, null, 1);
            this.close();
        }
        super.finalize();
    }

    public InetAddress getMulticastGroup() {
        return this.mcastGrp;
    }

    public void setMulticastGroup(InetAddress group) {
        this.mcastGrp = group;
    }

    public String toString() {
        String s = this.getFullDeviceName() + " [" + this.getProperty() + "] ";
        s = s + TMode.toString(this.sub.mode) + " @" + this.sub.pollingRate + " msec";
        s = s + " <" + this.linkStatus + "> ";
        return s;
    }

    public TSubscription getSubscription() {
        return this.sub;
    }

    public boolean isGrouped() {
        return this.grp != null;
    }

    public TLinkGroup getGroup() {
        return this.grp;
    }

    public LinkedList<TLink> getDependencies() {
        return this.dependencies;
    }

    public boolean hasDependencies() {
        return this.dependencies != null && this.dependencies.size() > 0;
    }

    public boolean isBound() {
        return this.boundTo != null;
    }

    public TLink getBoundLink() {
        return this.boundTo;
    }

    public boolean isCancelledWithDependencies() {
        return this.cancelledWithDependencies;
    }

    public void addDependency(TLink tlink) {
        if (this.dependencies == null) {
            this.dependencies = new LinkedList();
        }
        this.dependencies.add(tlink);
    }

    public void rmvDependency(TLink tlink) {
        if (this.dependencies == null) {
            return;
        }
        this.dependencies.remove(tlink);
    }

    public TDataTolerance getNotificationTolerance() {
        return this.dtf;
    }

    public void setNotificationTolerance(float absoluteValue, float percentValue) {
        this.dtf = new TDataTolerance(absoluteValue, percentValue);
    }

    public void setNotificationTolerance(double absoluteValue, double percentValue) {
        this.dtf = new TDataTolerance((float)absoluteValue, (float)percentValue);
    }

    public void setNotificationTolerance(int absoluteValue, int percentValue) {
        this.dtf = new TDataTolerance(absoluteValue, percentValue);
    }

    public boolean isWithinTolerance() {
        if (this.dtf == null) {
            return false;
        }
        if (this.dOutput == null) {
            return false;
        }
        if (this.isGrouped()) {
            return false;
        }
        TDataType dRef = this.dtf.getReference();
        if (dRef == null) {
            dRef = new TDataType(this.dOutput.getArrayLength(), this.dOutput.getFormat());
            dRef.dataCopy(this.dOutput);
            this.dtf.setReference(dRef);
            return false;
        }
        int len = this.dOutput.getArrayLength();
        float abs = this.dtf.absolute;
        float pcn = (float)((double)this.dtf.percent / 100.0);
        switch (this.dOutput.getFormat()) {
            case 2: {
                byte[] athis = (byte[])this.dOutput.getDataObject();
                byte[] alast = (byte[])dRef.getDataObject();
                for (int i = 0; i < len; ++i) {
                    if (!((float)Math.abs(athis[i] - alast[i]) > abs + pcn * (float)alast[i])) continue;
                    dRef.dataCopy(this.dOutput);
                    return false;
                }
                break;
            }
            case 1: {
                short[] athis = (short[])this.dOutput.getDataObject();
                short[] alast = (short[])dRef.getDataObject();
                for (int i = 0; i < len; ++i) {
                    if (!((float)Math.abs(athis[i] - alast[i]) > abs + pcn * (float)alast[i])) continue;
                    dRef.dataCopy(this.dOutput);
                    return false;
                }
                break;
            }
            case 3: {
                int[] athis = (int[])this.dOutput.getDataObject();
                int[] alast = (int[])dRef.getDataObject();
                for (int i = 0; i < len; ++i) {
                    if (!((float)Math.abs(athis[i] - alast[i]) > abs + pcn * (float)alast[i])) continue;
                    dRef.dataCopy(this.dOutput);
                    return false;
                }
                break;
            }
            case 5: {
                float[] athis = (float[])this.dOutput.getDataObject();
                float[] alast = (float[])dRef.getDataObject();
                for (int i = 0; i < len; ++i) {
                    if (!(Math.abs(athis[i] - alast[i]) > abs + pcn * alast[i])) continue;
                    dRef.dataCopy(this.dOutput);
                    return false;
                }
                break;
            }
            case 0: {
                double[] athis = (double[])this.dOutput.getDataObject();
                double[] alast = (double[])dRef.getDataObject();
                for (int i = 0; i < len; ++i) {
                    if (!(Math.abs(athis[i] - alast[i]) > (double)(abs + pcn * (float)alast[i]))) continue;
                    dRef.dataCopy(this.dOutput);
                    return false;
                }
                break;
            }
            case 6: {
                long[] athis = (long[])this.dOutput.getDataObject();
                long[] alast = (long[])dRef.getDataObject();
                for (int i = 0; i < len; ++i) {
                    if (!((float)Math.abs(athis[i] - alast[i]) > abs + pcn * (float)alast[i])) continue;
                    dRef.dataCopy(this.dOutput);
                    return false;
                }
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    public int getLinkAccessMode() {
        if (this.sub != null) {
            return this.sub.mode;
        }
        return 0;
    }

    public int getLinkPollingInterval() {
        if (this.sub != null) {
            return this.sub.pollingRate;
        }
        return 0;
    }

    public int getLinkStatus() {
        return this.linkStatus < 0 ? 0 : this.linkStatus;
    }

    public String getContext() {
        return this.cntName;
    }

    public String getDeviceServer() {
        return this.expName;
    }

    public String getDeviceName() {
        return this.devName;
    }

    public String getProperty() {
        return this.devProperty;
    }

    public String getFullDeviceName() {
        return new String("/" + this.cntName + "/" + this.expName + "/" + this.devName);
    }

    public TDataType getOutputDataObject() {
        return this.dOutput;
    }

    public TDataType getInputDataObject() {
        return this.dInput;
    }

    public long getLastTimeStamp() {
        return (long)this.dOutput.timestamp * 1000L + (long)this.dOutput.timestampMSEC;
    }

    public double getLastDataTimeStamp() {
        return (double)this.dOutput.timestamp + (double)this.dOutput.timestampMSEC / 1000.0;
    }

    public String getLastError() {
        return this.getError(this.linkStatus);
    }

    public String getError(int code) {
        if (code >= 512) {
            return new String(this.linkStatusStringBuffer).trim();
        }
        return TErrorList.getErrorString(code);
    }

    public int setErrorValue(double errValue) {
        if (this.sub.mode == 0) {
            return 99;
        }
        this.linkErrValue = errValue;
        this.useErrValue = true;
        return 0;
    }

    public int setErrorValue(String errString) {
        if (this.sub.mode == 0) {
            return 99;
        }
        this.linkErrString = errString;
        this.useErrValue = true;
        return 0;
    }

    public int setDebugLevel(int level) {
        return this.tf.setDebugLevel(level);
    }

    public int getDebugLevel() {
        return this.tf.getDebugLevel();
    }

    public String getModuleAddressInfo() {
        return this.srvAddr.toString(this.expName, this.cntName);
    }

    private TLink getExistingTLink(String devname, String devproperty, TDataType dout, TDataType din, short devaccess) {
        return this.tf.getExistingLink(devname, devproperty, dout, din, devaccess);
    }

    private void redirectLink() {
        this.tf.redirectLink(this);
    }

    private void relinkLink() {
        this.tf.reLinkLink(this);
    }

    private boolean isBlackListed() {
        return this.tf.isLinkBlackListed(this);
    }

    private void splitDeviceName(String fullname) {
        int indx = fullname.indexOf(47);
        this.cntName = "DEFAULT";
        this.devName = "";
        if (indx == 0) {
            indx = (fullname = fullname.substring(1)).indexOf(47);
            if (indx == -1) {
                this.cntName = fullname;
                this.expName = "GLOBALS";
                return;
            }
        } else {
            this.expName = fullname;
            if (indx > 0) {
                this.expName = fullname.substring(0, indx);
                this.devName = fullname.substring(indx + 1);
            }
            return;
        }
        this.cntName = fullname.substring(0, indx);
        fullname = fullname.substring(indx + 1);
        indx = fullname.indexOf(47);
        if (indx == -1) {
            this.expName = fullname;
            this.devName = "";
        } else {
            this.expName = fullname.substring(0, indx);
            this.devName = fullname.substring(indx + 1);
        }
    }

    private void remapStringArrayToStringBuffer(TDataType d, boolean hasInputData) {
        d.setTag("" + d.dArrayLength);
        int dlen = d.dArrayLength * 128;
        if (hasInputData) {
            // empty if block
        }
        d.dArrayLength = dlen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int makeLink(String devname, String devproperty, TDataType dout, TDataType din, short devaccess) {
        TPropertyList pl;
        String fullname;
        if (devproperty == null) {
            return 20;
        }
        if (devname == null) {
            devname = "/SITE";
        }
        this.tf = TLinkFactory.getInstance();
        if (this.hook == null) {
            this.hook = this.tf.getTLinkHook();
        }
        if (this.hook != null && (fullname = this.hook.getLinkName(devname)) != null) {
            Object objOut = dout == null ? null : dout.getDataObject();
            Object objIn = din == null ? null : din.getDataObject();
            this.dOutput = dout != null ? dout : new TDataType();
            this.dInput = din != null ? din : new TDataType();
            this.hookObj = this.hook.create(fullname, devproperty, objOut, objIn);
            this.devName = new String(fullname);
            this.devProperty = new String(devproperty);
            this.expName = "cdi";
            this.cntName = "localhost";
            return 0;
        }
        fullname = new String(devname);
        this.active = true;
        this.dOutput = dout != null ? dout : new TDataType();
        this.dInput = din != null ? din : new TDataType();
        if (this.arrayDelimiter != null) {
            this.dOutput.setArrayDelimiter(this.arrayDelimiter);
        }
        this.splitDeviceName(fullname);
        this.devProperty = new String(devproperty);
        this.devAccess = devaccess;
        this.devTimeout = (short)1000;
        if (this.dOutput.dFormat == 57) {
            this.remapStringArrayToStringBuffer(this.dOutput, false);
        }
        if (this.dInput.dFormat == 57) {
            this.remapStringArrayToStringBuffer(this.dInput, true);
        }
        if (this.dOutput.dArrayLength == 0) {
            this.devAccess = (short)(this.devAccess & 0xFFFFFFFE);
            this.dOutput.dFormat = (short)255;
        }
        boolean bl = this.isQuery = (pl = TStockProperties.getPropertyList()) != null ? TStockProperties.getPropertyList().hasProperty(this.devProperty) : false;
        if (this.isBlackListed()) {
            if (TLinkFactory.debugLevel > 0) {
                DbgLog.log("makeLink", "link " + this.getFullDeviceName() + " " + this.getProperty() + " has been black listed");
            }
            this.linkStatus = 113;
            return this.linkStatus;
        }
        this.redirectLink();
        this.relinkLink();
        this.remapIfBitfield();
        boolean bl2 = this.isGlobalsLink = this.expName.compareToIgnoreCase("GLOBALS") == 0 && !TQuery.isStockProperty(this.devProperty);
        if (this.expName.compareToIgnoreCase("CYCLER") == 0 && this.devProperty.compareToIgnoreCase("CycleNumber") == 0) {
            this.isGlobalsLink = true;
        }
        this.srvAddr = new TSrvEntry(this.expName, this.cntName);
        if (this.srvAddr.fecAddr == null && !this.isGlobalsLink) {
            this.linkStatus = 55;
            this.tf.addLinkToBlackList(this);
            String msg = "Could not resolve address for " + this.getFullDeviceName() + " : " + TErrorList.getErrorString(this.linkStatus);
            RuntimeException e = new RuntimeException(msg);
            MsgLog.log("makeLink", msg, 55, e, 1);
            throw e;
        }
        TLink xlnk = this.getExistingTLink(this.getFullDeviceName(), this.devProperty, dout, din, devaccess);
        if (xlnk != null) {
            TLink e = this;
            synchronized (e) {
                this.boundTo = xlnk;
                this.sub = xlnk.sub;
                this.con = xlnk.con;
                this.reqHdr = xlnk.reqHdr;
                this.linkId = xlnk.linkId;
                TDataType xlnkData = xlnk.getOutputDataObject();
                if (xlnkData != null && dout != null) {
                    if (dout.acquireDefaultFormat) {
                        TDataType tDataType = xlnkData;
                        synchronized (tDataType) {
                            dout.dFormat = xlnkData.dFormat;
                            dout.dArrayLength = xlnkData.dArrayLength;
                            dout.dCompletionLength = xlnkData.dCompletionLength;
                        }
                    }
                    dout.setDataObject(dout.dArrayLength, dout.dFormat);
                    dout.dataCopy(xlnkData);
                    dout.setDataTimeStamp(xlnkData.getDataTimeStamp());
                }
                xlnk.addDependency(this);
            }
            return 0;
        }
        this.linkId = this.tf.registerLink(this);
        if (this.linkId < 0) {
            this.linkStatus = 77;
            DbgLog.log("makeLink", "link table is full, please close some links and try again!");
            return this.linkStatus;
        }
        this.tineProtocol = this.srvAddr.isLegacy ? 5 : 6;
        this.con = new TContract(this);
        this.sub = new TSubscription(this.con, this);
        this.reqHdr = new TReqHdr(this.tf.getUserName(), this.tineProtocol);
        String defaultTimeoutStr = System.getProperty("default.timeout");
        if (defaultTimeoutStr != null) {
            defaultTimeout = Integer.parseInt(defaultTimeoutStr);
        }
        this.tf.activateLink(this);
        return 0;
    }

    public TLink(String deviceName, String deviceProperty, TDataType dout, TDataType din, short devaccess) {
        this.makeLink(deviceName, deviceProperty, dout, din, devaccess);
    }

    public TLink(String devname, String devproperty, TDataType dout, TDataType din, int devaccess) {
        this.makeLink(devname, devproperty, dout, din, (short)devaccess);
    }

    public TLink(String fullDeviceNameAndProperty, TDataType dout, TDataType din, short devaccess) {
        if (fullDeviceNameAndProperty == null) {
            return;
        }
        int cnt = 1;
        int indx = fullDeviceNameAndProperty.indexOf(47);
        if (indx == 0) {
            cnt = 3;
        }
        for (int i = 0; i < cnt; ++i) {
            indx += fullDeviceNameAndProperty.substring(indx + 1).indexOf(47) + 1;
        }
        String devname = new String(fullDeviceNameAndProperty.substring(0, indx));
        String devproperty = new String(fullDeviceNameAndProperty.substring(indx + 1));
        this.makeLink(devname, devproperty, dout, din, devaccess);
    }

    public TLink(String deviceName, String deviceProperty) {
        TDataType dout = new TDataType(maxOutputBufferSize, 254);
        TDataType din = new TDataType();
        this.makeLink(deviceName, deviceProperty, dout, din, (short)1);
    }

    public static String[] splitDeviceAndPropertyFromName(String fullDeviceNameAndProperty) {
        String[] names = new String[2];
        int cnt = 1;
        if (fullDeviceNameAndProperty == null) {
            return names;
        }
        int indx = fullDeviceNameAndProperty.indexOf(91);
        if (indx > 0) {
            names[0] = new String(fullDeviceNameAndProperty.substring(0, indx));
            names[1] = new String(fullDeviceNameAndProperty.substring(indx + 1, fullDeviceNameAndProperty.length()));
        } else {
            indx = fullDeviceNameAndProperty.indexOf(47);
            if (indx == 0) {
                cnt = 3;
            }
            for (int i = 0; i < cnt; ++i) {
                indx += fullDeviceNameAndProperty.substring(indx + 1).indexOf(47) + 1;
            }
            names[0] = new String(fullDeviceNameAndProperty.substring(0, indx));
            names[1] = new String(fullDeviceNameAndProperty.substring(indx + 1));
        }
        return names;
    }

    public TLink(String fullDeviceNameAndProperty) {
        if (fullDeviceNameAndProperty == null) {
            return;
        }
        String[] names = TLink.splitDeviceAndPropertyFromName(fullDeviceNameAndProperty);
        String devname = names[0];
        String devproperty = names[1];
        TDataType dout = new TDataType(maxOutputBufferSize, 254);
        TDataType din = new TDataType();
        this.makeLink(devname, devproperty, dout, din, (short)1);
    }

    public TLink(String globalKeyword, TDataType dout) {
        this.makeLink(null, globalKeyword, dout, null, (short)1);
    }

    public int attach(int mode, TCallback f) {
        return this.attach(mode, f, 1000, -1);
    }

    public int attach(short mode, TCallback f) {
        return this.attach((int)mode, f);
    }

    public synchronized int Twait() {
        if (this.sub.id < 0) {
            return -1;
        }
        try {
            while (!this.terminate) {
                this.wait();
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return -1;
    }

    public int execute() {
        return this.execute(1000);
    }

    public int execute(int timeout, short appendMode) {
        boolean retry = (this.devAccess & 0x100) == 256;
        return this.execute(timeout, appendMode, retry);
    }

    public int execute(int timeout, boolean retryOnError) {
        return this.execute(timeout, (short)0, retryOnError);
    }

    public synchronized int execute(int timeout, short appendMode, boolean retryOnError) {
        if (TLinkFactory.debugLevel > 0) {
            DbgLog.log("execute", "execute link (" + this.linkId + ") " + this.getFullDeviceName() + "[" + this.getProperty() + "]");
        }
        if (this.hookObj != null) {
            return this.hook.execute(this.hookObj, timeout);
        }
        if (this.isBlackListed()) {
            MsgLog.log("execute", "link execution error " + this.getFullDeviceName() + " (" + this.linkId + ")", 113, null, 1);
            return 113;
        }
        if (this.sub == null) {
            if (this.linkStatus == 77) {
                MsgLog.log("execute", "\nLink Table (" + this.tf.getLinkTable().length + " elements) is full", this.linkStatus, null, 0);
            } else {
                MsgLog.log("execute", this.getFullDeviceName() + " [" + this.getProperty() + "] has a null subscription <" + this.linkStatus + ">", this.linkStatus, null, 0);
            }
            return this.linkStatus == 0 ? 66 : this.linkStatus;
        }
        short bmode = TMode.getBaseMode(this.sub.mode);
        if (this.isGlobalsLink) {
            if (TLinkFactory.debugLevel > 0) {
                DbgLog.log("execute", "remove globals attribute from synchronous link");
            }
            this.isGlobalsLink = false;
        }
        if (this.isBound()) {
            bmode = TMode.getBaseMode(this.boundTo.sub.mode);
            if (bmode > 0 && bmode < 4) {
                while (this.boundTo.linkStatus == -1) {
                    try {
                        Thread.sleep(1L);
                    }
                    catch (InterruptedException e) {}
                }
                this.getOutputDataObject().pushBytes(this.boundTo.getOutputDataObject().getDataBuffer());
                return this.boundTo.getLinkStatus();
            }
            this.linkStatus = 114;
            this.linkErrString = "link is bound to an inactive link";
            return 114;
        }
        int sts = 0;
        if (this.linkId < 0) {
            this.linkStatus = 51;
            sts = 51;
            return sts;
        }
        if (timeout < 100) {
            timeout = 100;
        }
        this.devTimeout = (short)timeout;
        long ltime = System.currentTimeMillis();
        this.dOutput.timestamp = (int)(ltime / 1000L);
        this.sub.linkStartTime = ltime;
        this.sub.linkLastTime = ltime;
        if (bmode == 4 || bmode <= 1) {
            this.sub.mode = 1;
            this.devAccess = (short)(this.devAccess | 8);
        }
        if ((appendMode & 0x2000) == 8192) {
            this.sub.mode = (short)(this.sub.mode | appendMode);
        }
        if (retryOnError) {
            this.devAccess = (short)(this.devAccess | 0x100);
        }
        if (this.tf.alwaysRetry) {
            retryOnError = true;
        }
        if ((this.devAccess & 0x1000) == 4096) {
            retryOnError = false;
        }
        if ((this.devAccess & 0x100) == 256) {
            retryOnError = true;
        }
        this.retryOnTimeoutError = retryOnError;
        this.linkStatus = 45;
        if (this.devName.indexOf("*") >= 0 && !TQuery.isStockProperty(this.devProperty)) {
            TWildcardLink wc = this.tf.getWildcardLink();
            wc.parent = this;
            wc.format = this.dOutput.dFormat;
            this.tlcb = wc.scb;
            this.twcl = wc;
            this.isWildcardLink = true;
        }
        if ((sts = this.tf.sendLinkRequest(this)) != 0) {
            MsgLog.log("execute", "can't establish link", sts, null, 1);
            this.devAccess = (short)(this.devAccess & 0xFFFFFFF7);
            return sts;
        }
        TLinkFactory.adjustLinkTable(this, 1);
        if (TLinkFactory.debugLevel > 2) {
            DbgLog.log("execute", "link (" + this.linkId + ") is " + (this.removeOnClose ? "non-persistent" : "persistent"));
        }
        for (int i = 0; i < 3; ++i) {
            try {
                do {
                    this.wait();
                } while (this.twcl != null && !this.twcl.canNotify);
                if (bmode == 1) {
                    this.active = false;
                }
                this.devAccess = (short)(this.devAccess & 0xFFFFFFF7);
                if (this.linkStatus != 0 && (this.linkStatus & 0x4000) != 16384) {
                    MsgLog.log("execute", "link execution error " + this.getFullDeviceName() + " (" + this.linkId + ")", this.linkStatus, null, 1);
                }
                return this.linkStatus;
            }
            catch (InterruptedException e) {
                this.linkStatus = 28;
                MsgLog.log("execute", "Interrupted io on " + this.getFullDeviceName() + " (" + this.linkId + ")", this.linkStatus, e, 1);
                continue;
            }
        }
        this.devAccess = (short)(this.devAccess & 0xFFFFFFF7);
        if (this.linkStatus != 0 && (this.linkStatus & 0x4000) != 16384) {
            MsgLog.log("execute", "link execution error " + this.getFullDeviceName() + " (" + this.linkId + ")", this.linkStatus, null, 1);
        }
        return this.linkStatus;
    }

    public int execute(int timeout) {
        return this.execute(timeout, (short)0);
    }

    public int cancel() {
        TWatchdogLink wdl;
        if (this.hookObj != null) {
            this.hook.close(this.hookObj);
        }
        if (this.dInput != null) {
            this.dInput.isLocked = false;
        }
        if (this.isBeingWatched && (wdl = this.tf.getWatchdogLink("/" + this.cntName + "/" + this.expName)) != null) {
            wdl.remove(this);
        }
        return this.tf.cancel(this);
    }

    public int close() {
        return this.cancel();
    }

    public TBucket getBucket() {
        return this.tb;
    }

    private void remapIfBitfield() {
        if (this.dOutput == null || !TFormat.isBitfield(this.dOutput.dFormat)) {
            return;
        }
        String tag = this.dOutput.getTag();
        if (tag.length() == 0) {
            return;
        }
        TQuery.AcquireAndRegisterBitfieldInfo(this.cntName, this.expName, tag, this.dOutput.dFormat);
        TBitfield bf = TBitfieldRegistry.getBitfield(this.cntName, this.expName, tag);
        if (bf == null) {
            return;
        }
        String fld = null;
        String[] parts = this.devProperty.split("\\.");
        if (parts.length > 1 && bf.isField(fld = parts[parts.length - 1])) {
            this.dOutput.setBitField(bf);
            this.dOutput.setField(fld);
            this.devProperty = this.devProperty.substring(0, this.devProperty.indexOf(fld) - 1);
            return;
        }
        parts = this.devName.split("\\.");
        if (parts.length > 1 && bf.isField(fld = parts[parts.length - 1])) {
            this.dOutput.setBitField(bf);
            this.dOutput.setField(fld);
            this.devName = this.devName.substring(0, this.devName.indexOf(fld) - 1);
            return;
        }
    }

    TLink() {
    }

    protected TLink(int tid, String devname, String devproperty, TDataType dout, TDataType din, short devaccess) {
        String fullname = new String(devname);
        this.active = true;
        this.dOutput = dout != null ? dout : new TDataType();
        this.dInput = din;
        this.tf = TLinkFactory.getInstance();
        this.splitDeviceName(fullname);
        this.devProperty = new String(devproperty);
        this.devAccess = devaccess;
        this.devTimeout = (short)500;
        this.remapIfBitfield();
        this.linkId = tid = this.tf.registerLink(this);
        if (TLinkFactory.debugLevel > 0) {
            DbgLog.log("TLink", "assigned link id " + this.linkId + " to /" + this.cntName + "/" + this.expName);
        }
        this.srvAddr = new TSrvEntry(this.expName, this.cntName);
        if (this.srvAddr.fecAddr == null && TLinkFactory.debugLevel > 0) {
            DbgLog.log("TLink", "Cannot resolve Server Address for /" + this.cntName + "/" + this.expName);
        }
        this.tineProtocol = this.srvAddr.isLegacy ? 5 : 6;
        this.con = new TContract(this);
        this.sub = new TSubscription(this.con, this);
        this.reqHdr = new TReqHdr(System.getProperty("user.name"), this.tineProtocol);
        this.tf.activateLink(this);
        if (tid == 0) {
            this.removeOnClose = false;
        }
    }

    public int attach(int mode, TCallback f, int pollrate) {
        return this.attach(mode, f, pollrate, -1);
    }

    public int attach(short mode, TCallback f, int pollrate) {
        return this.attach((int)mode, f, pollrate);
    }

    public synchronized int attach(int mode, TCallback f, int pollrate, int notificationId) {
        short bmode = TMode.getBaseMode(mode);
        String msg = "attach link (" + this.linkId + ") " + this.getFullDeviceName() + "[" + this.getProperty() + "]" + " : " + TMode.toString((short)mode);
        if (bmode > 1) {
            MsgLog.log("attach", msg, 0, null, 1);
        } else if (TLinkFactory.debugLevel > 0) {
            DbgLog.log("attach", msg);
        }
        if (this.hookObj != null) {
            return this.hook.attach(this.hookObj, pollrate, (short)mode, f, notificationId);
        }
        if (this.isBlackListed()) {
            this.linkStatus = 113;
            return -1;
        }
        if (this.sub == null || this.linkId < 0) {
            if (this.linkStatus == 77) {
                MsgLog.log("attach", "\nLink Table (" + this.tf.getLinkTable().length + " elements) is full", this.linkStatus, null, 0);
            } else {
                MsgLog.log("attach", this.getFullDeviceName() + " [" + this.getProperty() + "] has a null subscription <" + this.linkStatus + ">", this.linkStatus, null, 0);
            }
            return this.linkStatus == 0 ? -66 : -this.linkStatus;
        }
        if (this.dInput != null && bmode > 1) {
            this.dInput.isLocked = true;
        }
        if (this.isGlobalsLink) {
            mode = this.ensureGlobalsMode(mode);
        }
        this.sub.mode = (short)mode;
        this.tcb = f;
        if (notificationId >= 0) {
            this.callbackId = notificationId;
        } else if (this.callbackId <= 0) {
            this.callbackId = this.sub.id;
        }
        if (pollrate < 100) {
            pollrate = 100;
        }
        this.devTimeout = (short)pollrate;
        this.sub.pollingRate = this.devTimeout;
        if (this.isBound()) {
            return this.sub.id;
        }
        if (this.devName.indexOf("*") >= 0 && !TQuery.isStockProperty(this.devProperty)) {
            TWildcardLink wc = this.tf.getWildcardLink();
            wc.tcb = f;
            wc.parent = this;
            wc.format = this.dOutput.dFormat;
            this.tlcb = wc.scb;
            this.twcl = wc;
            this.isWildcardLink = true;
            this.sub.mode = (short)(this.sub.mode & 0xFFFFEFFF);
        }
        if (this.tf.sendLinkRequest(this) != 0) {
            return -1;
        }
        long ltime = System.currentTimeMillis();
        this.dOutput.timestamp = (int)(ltime / 1000L);
        this.sub.linkStartTime = ltime;
        this.sub.linkLastTime = ltime;
        if (this.tf.alwaysRetry) {
            this.retryOnTimeoutError = true;
        }
        if ((this.devAccess & 0x1000) == 4096) {
            this.retryOnTimeoutError = false;
        }
        if ((this.devAccess & 0x100) == 256) {
            this.retryOnTimeoutError = true;
        }
        if ((this.sub.mode & 0x1000) == 4096) {
            if (this.grp == null) {
                this.grp = this.tf.getGroup(f);
            }
            this.grp.addMember(this);
        }
        if ((mode & 0x400) == 1024) {
            this.dError = (TDataType)this.dOutput.clone();
            if (this.dError != null) {
                this.useErrObject = true;
            }
        }
        if ((mode & 0x4000) == 16384) {
            this.waitForLinkCompletion();
        }
        TLinkFactory.adjustLinkTable(this, 1);
        if (TLinkFactory.debugLevel > 0) {
            DbgLog.log("attach", "link " + this.linkId + " is " + (this.removeOnClose ? "non-persistent" : "persistent"));
        }
        return this.sub.id;
    }

    public int attach(short mode, TCallback f, int pollrate, int notificationId) {
        return this.attach((int)mode, f, pollrate, notificationId);
    }

    private int ensureGlobalsMode(int thisMode) {
        short bmode = TMode.getBaseMode((short)thisMode);
        if (bmode == 3 || bmode == 2) {
            thisMode &= 0xFFFFFFFC;
            thisMode |= 5;
        }
        return thisMode;
    }

    public synchronized int attach(int mode, TLinkCallback f, int pollrate) {
        short bmode = TMode.getBaseMode(mode);
        String msg = "attach link (" + this.linkId + ") " + this.getFullDeviceName() + "[" + this.getProperty() + "]" + " : " + TMode.toString((short)mode);
        if (bmode > 1) {
            MsgLog.log("attach", msg, 0, null, 1);
            if (bmode == 2 && this.dtf == null) {
                this.setNotificationTolerance(0, 0);
                MsgLog.log("attach", "suppressing null-change notification", 0, null, 1);
            }
        } else if (TLinkFactory.debugLevel > 0) {
            DbgLog.log("attach", msg);
        }
        if (this.hookObj != null) {
            return this.hook.attach(this.hookObj, pollrate, (short)mode, f, this);
        }
        if (this.isBlackListed()) {
            this.linkStatus = 113;
            return -1;
        }
        if (this.sub == null || this.linkId < 0) {
            if (this.linkStatus == 77) {
                MsgLog.log("attach", "\nLink Table (" + this.tf.getLinkTable().length + " elements) is full", this.linkStatus, null, 0);
            } else {
                MsgLog.log("attach", this.getFullDeviceName() + " [" + this.getProperty() + "] has a null subscription <" + this.linkStatus + ">", this.linkStatus, null, 0);
            }
            return this.linkStatus == 0 ? -66 : -this.linkStatus;
        }
        this.tlcb = f;
        if (this.isGlobalsLink) {
            mode = this.ensureGlobalsMode(mode);
        }
        if (this.dInput != null && bmode > 1) {
            this.dInput.isLocked = true;
        }
        if (pollrate < 50) {
            pollrate = 50;
        }
        this.devTimeout = (short)pollrate;
        boolean setMode = true;
        if (this.isBound()) {
            if (!this.boundTo.active) {
                this.boundTo.sub.mode = (short)mode;
                this.boundTo.sub.pollingRate = pollrate;
                this.boundTo.cancelledWithDependencies = true;
                this.boundTo.active = true;
                this.boundTo.devAccess = this.devAccess;
                long ltime = System.currentTimeMillis();
                this.tf.sendLinkRequest(this.boundTo);
                this.dOutput.timestamp = (int)(ltime / 1000L);
                this.boundTo.sub.linkLastTime = ltime;
                this.boundTo.tlcb = this.tlcb;
                this.boundTo.tcb = this.tcb;
            } else {
                bmode = TMode.getBaseMode(this.boundTo.sub.mode);
                if (TMode.getBaseMode(mode) == 3 && bmode != 3) {
                    long ltime = System.currentTimeMillis();
                    int pmode = this.boundTo.sub.mode & ~bmode | 3;
                    this.boundTo.sub.mode = (short)pmode;
                    if (pollrate < this.boundTo.sub.pollingRate) {
                        this.boundTo.sub.pollingRate = pollrate;
                    }
                    this.tf.sendLinkRequest(this.boundTo);
                    if (!this.boundTo.hasNotifiedOnce) {
                        this.dOutput.timestamp = (int)(ltime / 1000L);
                    }
                    this.boundTo.sub.linkLastTime = ltime;
                } else {
                    this.sub.mode = (short)mode;
                    this.sub.pollingRate = pollrate;
                }
            }
            return this.sub.id;
        }
        this.sub.mode = (short)mode;
        this.sub.pollingRate = pollrate;
        if (this.devName.indexOf("*") >= 0 && !TQuery.isStockProperty(this.devProperty)) {
            TWildcardLink wc = this.tf.getWildcardLink();
            wc.tlcb = f;
            wc.parent = this;
            wc.format = this.dOutput.dFormat;
            this.tlcb = wc.scb;
            this.twcl = wc;
            this.isWildcardLink = true;
            this.sub.mode = (short)(this.sub.mode & 0xFFFFEFFF);
        }
        if (this.tf.sendLinkRequest(this) != 0) {
            return -1;
        }
        long ltime = System.currentTimeMillis();
        this.dOutput.timestamp = (int)(ltime / 1000L);
        this.sub.linkStartTime = ltime;
        this.sub.linkLastTime = ltime;
        if (this.tf.alwaysRetry) {
            this.retryOnTimeoutError = true;
        }
        if ((this.devAccess & 0x1000) == 4096) {
            this.retryOnTimeoutError = false;
        }
        if ((this.devAccess & 0x100) == 256) {
            this.retryOnTimeoutError = true;
        }
        if ((this.sub.mode & 0x1000) == 4096) {
            if (this.grp == null) {
                this.grp = this.tf.getGroup(f);
            }
            this.grp.addMember(this);
        }
        if ((mode & 0x400) == 1024) {
            this.dError = (TDataType)this.dOutput.clone();
            if (this.dError != null) {
                this.useErrObject = true;
            }
        }
        if ((mode & 0x4000) == 16384) {
            this.waitForLinkCompletion();
        }
        TLinkFactory.adjustLinkTable(this, 1);
        if (TLinkFactory.debugLevel > 0) {
            DbgLog.log("attach", "link " + this.linkId + " is " + (this.removeOnClose ? "non-persistent" : "persistent"));
        }
        return this.sub.id;
    }

    public int attach(short mode, TLinkCallback f, int pollrate) {
        return this.attach((int)mode, f, pollrate);
    }

    public synchronized int receive(TCallback f) {
        return this.attach((short)5, f, 1000);
    }

    public synchronized int receive(TCallback f, int notificationId) {
        return this.attach((short)5, f, 1000, notificationId);
    }

    public synchronized int receive(TLinkCallback f) {
        return this.attach((short)5, f, 1000);
    }

    public void waitForLinkCompletion() {
        try {
            while (this.linkStatus < 0) {
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException e) {
            DbgLog.log("waitForLinkCompletion", " waitForLinkCompletion : " + e);
        }
    }

    public String getArrayDelimiter() {
        return this.arrayDelimiter;
    }

    public void setArrayDelimiter(String delimiter) {
        if (this.arrayDelimiter != null && this.arrayDelimiter.compareTo(delimiter) == 0) {
            return;
        }
        this.arrayDelimiter = new String(delimiter);
        this.dOutput.setArrayDelimiter(this.arrayDelimiter);
    }

    public int getTineProtocol() {
        return this.tineProtocol;
    }

    public void setTineProtocol(int protocolLevel) {
        this.tineProtocol = protocolLevel;
        if (this.reqHdr != null) {
            this.reqHdr.setTineProtocol(protocolLevel);
        }
        if (this.dInput != null) {
            this.dInput.resetCounters(protocolLevel);
        }
        if (this.dOutput != null) {
            this.dOutput.resetCounters(protocolLevel);
        }
        if (this.sub != null && this.tineProtocol < 6) {
            this.sub.isLegacy = true;
        }
    }
}

