/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.addrUtils;

import de.desy.tine.addrUtils.FECAddr;
import de.desy.tine.addrUtils.NameCache;
import de.desy.tine.addrUtils.SrvAddr;
import de.desy.tine.addrUtils.TFecEntry;
import de.desy.tine.client.TLink;
import de.desy.tine.client.TLinkFactory;
import de.desy.tine.csvUtils.csv;
import de.desy.tine.dataUtils.TDataType;
import de.desy.tine.definitions.TErrorList;
import de.desy.tine.server.logger.DbgLog;
import de.desy.tine.startup.TInitializer;
import de.desy.tine.startup.TInitializerFactory;
import de.desy.tine.types.NAME;
import de.desy.tine.types.NAME16;
import de.desy.tine.types.TCompoundDataObject;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;

public final class TSrvEntry {
    private static TInitializer initializer = TInitializerFactory.getInstance().getInitializer();
    private static final String fecHdr = "FecName, FecNetwork, FecNode, IPAddr, PortOffset, TineProtocol";
    private static final String srvHdr = "Name, FecName, EqpModule, Context, SubSystem";
    private static String crlf;
    private static String cacheFilePath;
    private static final int CACHE_TABLE_LENGTH = 1000;
    public static final String SRVEQM_NAME = "_SRV__";
    public static final String SRVFEC_NAME = "NETWORK";
    public static final String SRVEXP_NAME = "NETWORK";
    private static BufferedReader fecR;
    private static BufferedReader ensR;
    private static BufferedReader srvR;
    private static BufferedReader fecCacheR;
    private static BufferedWriter fecCacheW;
    private static BufferedWriter srvCacheW;
    private static String fecCacheFile;
    private static String srvCacheFile;
    private static boolean initialized;
    private static boolean initializing;
    private static int ensSrvCacheIndex;
    private static int ensDevCacheIndex;
    public String devName;
    public String eqmName;
    public String fecName;
    public String cntName;
    static NameCache[] devNameCache;
    static String[] modNameCache;
    static TFecEntry[] fecAddrCache;
    static int modNameCacheLength;
    static int fecAddrCacheLength;
    static int NameCacheLength;
    static int numConfiguredNameServers;
    static int currentConfiguredNameServer;
    public static String currentConfiguredNameServerTag;
    public TFecEntry fecAddr;
    private csv srvFile;
    static int debugLevel;
    public boolean isLegacy = false;

    public static void reset() {
        if (modNameCacheLength > 2) {
            modNameCacheLength = 2;
        }
        if (fecAddrCacheLength > 2) {
            fecAddrCacheLength = 2;
        }
        if (NameCacheLength > 2) {
            NameCacheLength = 2;
        }
    }

    public String toString(String srvName, String ctxName) {
        if (this.eqmName == null) {
            return new String("module does not exist");
        }
        this.StaticAddress(srvName, ctxName);
        String modstr = new String("");
        modstr = modstr + "Local Equipment Module : " + this.eqmName.trim();
        modstr = modstr + "\nFront End Computer :" + this.fecName.trim();
        if (this.fecAddr != null && this.fecAddr.fecHost != null) {
            modstr = modstr + "\nIP Address : " + this.fecAddr.fecHost.getHostAddress();
            modstr = modstr + "\nPort Offset : " + this.fecAddr.fecPortOffset;
            modstr = modstr + "\nHost Name : " + this.fecAddr.fecHost.getHostName();
        }
        return modstr;
    }

    void StaticAddress(String srvName, String ctxName) {
        int i;
        if (srvName == null || ctxName == null) {
            this.eqmName = "";
            this.fecName = "";
            this.cntName = "";
            return;
        }
        for (i = 0; i < NameCacheLength; ++i) {
            if (ctxName.length() > 0 && ctxName.compareToIgnoreCase("DEFAULT") != 0 && ctxName.compareToIgnoreCase(TSrvEntry.devNameCache[i].cntName) != 0 || srvName.compareToIgnoreCase(TSrvEntry.devNameCache[i].devName) != 0) continue;
            this.eqmName = modNameCache[TSrvEntry.devNameCache[i].modNameIndex];
            this.fecName = TSrvEntry.fecAddrCache[TSrvEntry.devNameCache[i].srvNameIndex].fecName;
            this.fecAddr = fecAddrCache[TSrvEntry.devNameCache[i].srvNameIndex];
            return;
        }
        if (srvName.startsWith("ENS")) {
            this.eqmName = new String("ENSEQM");
            this.fecName = new String("ENS");
            this.cntName = new String("SITE");
        }
        if (srvName.compareTo("NAMEQRY") == 0) {
            this.eqmName = new String("ENSEQM");
            this.fecName = new String("ENS");
            this.cntName = new String("SITE");
        }
        if (srvName.startsWith("GENS")) {
            this.eqmName = new String("GRPEQM");
            this.fecName = new String("GENS");
            this.cntName = new String("SITE");
        }
        if (this.eqmName == null) {
            return;
        }
        if (modNameCacheLength >= 1000) {
            return;
        }
        if (fecAddrCacheLength >= 1000) {
            return;
        }
        if (NameCacheLength < 1000) {
            TSrvEntry.devNameCache[TSrvEntry.NameCacheLength] = new NameCache();
        }
        for (i = 0; i < modNameCacheLength && this.eqmName.compareTo(modNameCache[i]) != 0; ++i) {
        }
        if (i == modNameCacheLength) {
            TSrvEntry.modNameCache[TSrvEntry.modNameCacheLength++] = this.eqmName;
        }
        TSrvEntry.devNameCache[TSrvEntry.NameCacheLength].modNameIndex = i;
        for (i = 0; i < fecAddrCacheLength && this.fecName.compareTo(TSrvEntry.fecAddrCache[i].fecName) != 0; ++i) {
        }
        if (i == fecAddrCacheLength) {
            TSrvEntry.fecAddrCache[TSrvEntry.fecAddrCacheLength] = new TFecEntry(this.fecName);
            this.fecAddr = fecAddrCache[fecAddrCacheLength++];
            if (this.fecName.startsWith("ENS")) {
                ++numConfiguredNameServers;
            }
        }
        TSrvEntry.devNameCache[TSrvEntry.NameCacheLength].srvNameIndex = i;
        TSrvEntry.devNameCache[TSrvEntry.NameCacheLength].devName = srvName;
        TSrvEntry.devNameCache[TSrvEntry.NameCacheLength].cntName = this.cntName;
        if (NameCacheLength < 1000) {
            ++NameCacheLength;
        }
    }

    static int addNameServerToServerCache(TFecEntry sa) {
        if (fecAddrCacheLength > 1000 || NameCacheLength > 1000 || numConfiguredNameServers > 10) {
            return -1;
        }
        if (debugLevel > 1) {
            DbgLog.log("addNameServerToServerCache", "Adding ENS " + numConfiguredNameServers + " to address cache");
        }
        if (ensSrvCacheIndex == -1) {
            ensSrvCacheIndex = fecAddrCacheLength;
        }
        if (ensDevCacheIndex == -1) {
            ensDevCacheIndex = NameCacheLength;
        }
        TSrvEntry.fecAddrCache[TSrvEntry.fecAddrCacheLength] = sa;
        TSrvEntry.devNameCache[TSrvEntry.NameCacheLength] = new NameCache();
        TSrvEntry.devNameCache[TSrvEntry.NameCacheLength].srvNameIndex = fecAddrCacheLength++;
        TSrvEntry.devNameCache[TSrvEntry.NameCacheLength].modNameIndex = modNameCacheLength;
        TSrvEntry.devNameCache[TSrvEntry.NameCacheLength].devName = sa.fecName;
        TSrvEntry.devNameCache[TSrvEntry.NameCacheLength].cntName = "SITE";
        TSrvEntry.modNameCache[TSrvEntry.modNameCacheLength] = "ENSEQM";
        ++modNameCacheLength;
        ++NameCacheLength;
        if (++numConfiguredNameServers == 1) {
            currentConfiguredNameServerTag = new String(sa.fecName);
        }
        return 0;
    }

    static int addGroupServerToServerCache(TFecEntry sa) {
        if (fecAddrCacheLength > 1000 || NameCacheLength > 1000 || numConfiguredNameServers > 10) {
            return -1;
        }
        if (debugLevel > 1) {
            DbgLog.log("addGroupServerToServerCache", "Adding GENS " + numConfiguredNameServers + " to address cache");
        }
        TSrvEntry.fecAddrCache[TSrvEntry.fecAddrCacheLength] = sa;
        TSrvEntry.devNameCache[TSrvEntry.NameCacheLength] = new NameCache();
        TSrvEntry.devNameCache[TSrvEntry.NameCacheLength].srvNameIndex = fecAddrCacheLength++;
        TSrvEntry.devNameCache[TSrvEntry.NameCacheLength].modNameIndex = modNameCacheLength;
        TSrvEntry.devNameCache[TSrvEntry.NameCacheLength].devName = sa.fecName;
        TSrvEntry.devNameCache[TSrvEntry.NameCacheLength].cntName = "SITE";
        TSrvEntry.modNameCache[TSrvEntry.modNameCacheLength] = "GRPEQM";
        ++NameCacheLength;
        ++modNameCacheLength;
        return 0;
    }

    static int addNameServer(String ip) {
        SrvAddr da = new SrvAddr();
        da.fecName = new String("ENS#" + numConfiguredNameServers);
        da.eqmContext = new String("SITE");
        da.eqmName = new String("ENSEQM");
        da.ipAddr = new String(ip);
        da.portOffset = 0;
        da.inetProtocol = 8;
        da.tineProtocol = 6;
        TFecEntry sa = new TFecEntry(da);
        if (!sa.fecRegistered) {
            return -1;
        }
        TSrvEntry.addNameServerToServerCache(sa);
        da.fecName = new String("GENS#" + numConfiguredNameServers);
        da.eqmName = new String("GRPEQM");
        da.portOffset = 101;
        sa = new TFecEntry(da);
        if (!sa.fecRegistered) {
            return -1;
        }
        TSrvEntry.addGroupServerToServerCache(sa);
        return 0;
    }

    static synchronized void SetAddrFileLocation() {
        try {
            if (fecR.ready() && srvR.ready() && TLinkFactory.debugLevel > 1) {
                DbgLog.log("SetAddrFileLocation", "static database readers ready");
            }
        }
        catch (Exception e) {
            fecR = initializer.getAddressResource();
            srvR = initializer.getEquipmentResource();
        }
        if (initialized) {
            return;
        }
        if (initializing) {
            return;
        }
        initializing = true;
        currentConfiguredNameServerTag = new String("ENS");
        for (int i = 0; i < 5; ++i) {
            TFecEntry sa;
            String ensName = new String("ENS#" + i);
            if (debugLevel > 1) {
                DbgLog.log("SetAddrFileLocation", "ENS: looking for " + ensName);
            }
            if ((ensR = initializer.getHostsResource()) != null) {
                sa = new TFecEntry(ensR, ensName);
                if (!sa.fecRegistered) {
                    sa = new TFecEntry(ensR, "ENS");
                }
            } else {
                TSrvEntry.findNameServerOnNetwork();
                if (numConfiguredNameServers > 0) break;
                TSrvEntry.findNameServerFromDNS();
                if (numConfiguredNameServers > 0) break;
                sa = new TFecEntry("ENS");
            }
            if (!sa.fecRegistered) {
                if (debugLevel <= 1) continue;
                DbgLog.log("SetAddrFileLocation", ensName + " Not Registered");
                continue;
            }
            TSrvEntry.addNameServerToServerCache(sa);
            if (ensR == null) break;
        }
        if (File.separatorChar == '/') {
            cacheFilePath = "/var/tmp";
        } else if (File.separatorChar == '\\') {
            cacheFilePath = System.getenv("SystemDrive");
            if (cacheFilePath == null) {
                cacheFilePath = "C:";
            }
            crlf = "\r\n";
        } else {
            cacheFilePath = ".";
        }
        cacheFilePath = cacheFilePath + File.separator + "tine" + File.separator + "cache" + File.separator;
        srvCacheFile = cacheFilePath + "eqpdbase.csv";
        fecCacheFile = cacheFilePath + "fecaddr.csv";
        initialized = true;
        initializing = false;
    }

    public TSrvEntry() {
        this.eqmName = "";
        this.devName = "";
        this.cntName = "";
        this.fecName = "";
        TSrvEntry.SetAddrFileLocation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isInSrvFile(SrvAddr srv) {
        boolean hasEntry = false;
        csv csvf = new csv(srvCacheFile);
        try {
            String s;
            int srv_col = -1;
            int eqn_col = -1;
            int fec_col = -1;
            int ctx_col = -1;
            boolean done = false;
            while ((s = csvf.readLine()) != null) {
                if (s.length() == 0 || s.startsWith("#") || s.startsWith(";") || s.startsWith("%")) continue;
                if (!done) {
                    String hdr = s;
                    srv_col = csvf.findcol(hdr, "NAME");
                    if (srv_col < 0) {
                        throw new NoSuchFieldException();
                    }
                    eqn_col = csvf.findcol(hdr, "EQPMODULE");
                    if (eqn_col < 0) {
                        throw new NoSuchFieldException();
                    }
                    fec_col = csvf.findcol(hdr, "FECNAME");
                    if (fec_col < 0) {
                        throw new NoSuchFieldException();
                    }
                    ctx_col = csvf.findcol(hdr, "CONTEXT");
                    if (ctx_col < 0) {
                        throw new NoSuchFieldException();
                    }
                    done = true;
                    continue;
                }
                if (csvf.namcmp(srv.expName, s, srv_col) != 0 || csvf.namcmp(srv.eqmName, s, eqn_col) != 0 || csvf.namcmp(srv.fecName, s, fec_col) != 0 || csvf.namcmp(srv.eqmContext, s, ctx_col) != 0) continue;
                hasEntry = true;
                break;
            }
        }
        catch (Exception e) {
            hasEntry = false;
        }
        finally {
            csvf.close();
        }
        return hasEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isInFecFile(SrvAddr srv) {
        boolean hasEntry = false;
        csv csvf = new csv(fecCacheFile);
        try {
            String s;
            int fec_col = -1;
            int ip_col = -1;
            int port_col = -1;
            int prot_col = -1;
            boolean done = false;
            while ((s = csvf.readLine()) != null) {
                if (s.length() == 0 || s.startsWith("#") || s.startsWith(";") || s.startsWith("%")) continue;
                if (!done) {
                    String hdr = s;
                    fec_col = csvf.findcol(hdr, "FEC_NAME");
                    if (fec_col < 0) {
                        throw new NoSuchFieldException();
                    }
                    ip_col = csvf.findcol(hdr, "IP_ADDR");
                    if (ip_col < 0) {
                        throw new NoSuchFieldException();
                    }
                    port_col = csvf.findcol(hdr, "PORT_OFFSET");
                    if (port_col < 0) {
                        throw new NoSuchFieldException();
                    }
                    prot_col = csvf.findcol(hdr, "TINE_PROTOCOL");
                    done = true;
                    continue;
                }
                if (csvf.namcmp(srv.fecName, s, fec_col) != 0 || csvf.namcmp(srv.ipAddr, s, ip_col) != 0 || srv.portOffset != Integer.parseInt(csvf.colptr(port_col, s)) || prot_col < 0 || srv.tineProtocol != Integer.parseInt(csvf.colptr(prot_col, s))) continue;
                hasEntry = true;
                break;
            }
        }
        catch (Exception e) {
            hasEntry = false;
        }
        finally {
            csvf.close();
        }
        return hasEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean addToSrvFile(SrvAddr srv) {
        boolean hasEntry = false;
        boolean needHeader = true;
        csv csvr = new csv(srvCacheFile);
        try {
            String s;
            File csvw = new File(cacheFilePath);
            csvw.mkdirs();
            srvCacheW = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(srvCacheFile + ".tmp")));
            int srv_col = -1;
            int ctx_col = -1;
            boolean done = false;
            while ((s = csvr.readLine()) != null) {
                if (s.length() == 0 || s.startsWith("#") || s.startsWith(";") || s.startsWith("%")) continue;
                if (!done) {
                    String hdr = s;
                    srv_col = csvr.findcol(hdr, "NAME");
                    if (srv_col < 0) {
                        throw new NoSuchFieldException();
                    }
                    ctx_col = csvr.findcol(hdr, "CONTEXT");
                    if (ctx_col < 0) {
                        throw new NoSuchFieldException();
                    }
                    srvCacheW.write(srvHdr.trim() + crlf);
                    needHeader = false;
                    done = true;
                    continue;
                }
                if (csvr.namcmp(srv.expName, s, srv_col) == 0 && csvr.namcmp(srv.eqmContext, s, ctx_col) == 0) {
                    s = srv.expName.trim() + ", " + srv.fecName.trim() + ", " + srv.eqmName.trim() + ", " + srv.eqmContext.trim() + ", " + srv.subSystem.trim();
                    hasEntry = true;
                }
                srvCacheW.write(s + crlf);
            }
            if (needHeader) {
                srvCacheW.write(srvHdr.trim() + crlf);
            }
            if (!hasEntry) {
                s = srv.expName.trim() + "," + srv.fecName.trim() + "," + srv.eqmName.trim() + "," + srv.eqmContext.trim() + "," + srv.subSystem.trim();
                srvCacheW.write(s + crlf);
            }
            srvCacheW.close();
            csvr.close();
            csvw = new File(srvCacheFile);
            csvw.delete();
            File srvf = new File(srvCacheFile + ".tmp");
            srvf.renameTo(new File(srvCacheFile));
        }
        catch (Exception e) {
            hasEntry = false;
        }
        finally {
            csvr.close();
        }
        return hasEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean addToFecFile(SrvAddr srv) {
        boolean needHeader = true;
        boolean hasEntry = false;
        csv csvr = new csv(fecCacheFile);
        try {
            String s;
            File csvw = new File(cacheFilePath);
            csvw.mkdirs();
            fecCacheW = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(fecCacheFile + ".tmp")));
            int fec_col = -1;
            boolean done = false;
            while ((s = csvr.readLine()) != null) {
                if (s.length() == 0 || s.startsWith("#") || s.startsWith(";") || s.startsWith("%")) continue;
                if (!done) {
                    String hdr = s;
                    fec_col = csvr.findcol(hdr, "FEC_NAME");
                    if (fec_col < 0) {
                        throw new NoSuchFieldException();
                    }
                    fecCacheW.write(fecHdr.trim() + crlf);
                    done = true;
                    needHeader = false;
                    continue;
                }
                if (csvr.namcmp(srv.fecName, s, fec_col) == 0) {
                    s = srv.fecName.trim() + ",00000000,000000000000," + srv.ipAddr.trim() + "," + srv.portOffset + "," + srv.tineProtocol;
                    hasEntry = true;
                }
                fecCacheW.write(s + crlf);
            }
            if (needHeader) {
                fecCacheW.write(fecHdr.trim() + crlf);
            }
            if (!hasEntry) {
                s = srv.fecName.trim() + ",00000000,000000000000," + srv.ipAddr.trim() + "," + srv.portOffset + "," + srv.tineProtocol;
                fecCacheW.write(s + crlf);
            }
            csvr.close();
            fecCacheW.close();
            csvw = new File(fecCacheFile);
            csvw.delete();
            File fecf = new File(fecCacheFile + ".tmp");
            fecf.renameTo(new File(fecCacheFile));
        }
        catch (Exception e) {
            hasEntry = false;
        }
        finally {
            csvr.close();
        }
        return hasEntry;
    }

    public static void addAddressToCacheFile(SrvAddr srv) {
        if (srv == null) {
            return;
        }
        if (!TSrvEntry.isInSrvFile(srv)) {
            TSrvEntry.addToSrvFile(srv);
        }
        if (!TSrvEntry.isInFecFile(srv)) {
            TSrvEntry.addToFecFile(srv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int fillinAddressFromFileCache(String srvName, String ctxName) {
        int cc = 8;
        try {
            int i;
            block22: {
                String s;
                int nam_col = -1;
                int eqn_col = -1;
                int srv_col = -1;
                int ctxt_col = -1;
                boolean done = false;
                while ((s = this.srvFile.readLine()) != null) {
                    if (s.length() == 0 || s.startsWith("#") || s.startsWith(";") || s.startsWith("%")) continue;
                    if (!done) {
                        String hdr = s;
                        nam_col = this.srvFile.findcol(hdr, "NAME");
                        if (nam_col < 0) {
                            throw new NoSuchFieldException();
                        }
                        eqn_col = this.srvFile.findcol(hdr, "EQPMODULE");
                        if (eqn_col < 0) {
                            throw new NoSuchFieldException();
                        }
                        srv_col = this.srvFile.findcol(hdr, "FECNAME");
                        if (srv_col < 0) {
                            throw new NoSuchFieldException();
                        }
                        ctxt_col = this.srvFile.findcol(hdr, "CONTEXT");
                        if (ctxt_col < 0) {
                            throw new NoSuchFieldException();
                        }
                        done = true;
                        continue;
                    }
                    if (this.srvFile.namcmp(srvName, s, nam_col) != 0) continue;
                    this.eqmName = this.srvFile.colptr(eqn_col, s);
                    this.fecName = this.srvFile.colptr(srv_col, s);
                    this.cntName = this.srvFile.colptr(ctxt_col, s);
                    if (ctxName != null && ctxName.compareToIgnoreCase(this.cntName) != 0) {
                        continue;
                    }
                    break block22;
                }
                return cc;
            }
            if (modNameCacheLength >= 1000) {
                return cc;
            }
            if (fecAddrCacheLength >= 1000) {
                return cc;
            }
            if (NameCacheLength < 1000) {
                TSrvEntry.devNameCache[TSrvEntry.NameCacheLength] = new NameCache();
            }
            for (i = 0; i < modNameCacheLength && this.eqmName.compareTo(modNameCache[i]) != 0; ++i) {
            }
            if (i == modNameCacheLength) {
                TSrvEntry.modNameCache[TSrvEntry.modNameCacheLength++] = this.eqmName;
            }
            TSrvEntry.devNameCache[TSrvEntry.NameCacheLength].modNameIndex = i;
            for (i = 0; i < fecAddrCacheLength && this.fecName.compareToIgnoreCase(TSrvEntry.fecAddrCache[i].fecName) != 0; ++i) {
            }
            if (i == fecAddrCacheLength) {
                fecCacheR = new BufferedReader(new InputStreamReader(new FileInputStream(fecCacheFile)));
                TSrvEntry.fecAddrCache[TSrvEntry.fecAddrCacheLength] = new TFecEntry(fecCacheR, this.fecName);
                if (!TSrvEntry.fecAddrCache[TSrvEntry.fecAddrCacheLength].fecRegistered) {
                    TSrvEntry.fecAddrCache[TSrvEntry.fecAddrCacheLength] = new TFecEntry(fecR, this.fecName);
                }
                if (!TSrvEntry.fecAddrCache[TSrvEntry.fecAddrCacheLength].fecRegistered) {
                    this.fecAddr = null;
                    cc = 87;
                    return cc;
                }
                this.fecAddr = fecAddrCache[fecAddrCacheLength++];
            }
            TSrvEntry.devNameCache[TSrvEntry.NameCacheLength].srvNameIndex = i;
            TSrvEntry.devNameCache[TSrvEntry.NameCacheLength].devName = srvName;
            TSrvEntry.devNameCache[TSrvEntry.NameCacheLength].cntName = ctxName;
            if (NameCacheLength < 1000) {
                ++NameCacheLength;
            }
            cc = 0;
            return cc;
        }
        catch (Exception e) {
            cc = 75;
            return cc;
        }
        finally {
            this.srvFile.close();
        }
    }

    int getAddressFromFileCache(String srvName, String ctxName) {
        TSrvEntry.SetAddrFileLocation();
        if (debugLevel > 1) {
            DbgLog.log("getAddressFromFileCache", "FILE lookup: looking for \\" + ctxName + "\\" + srvName);
        }
        String lkupname = srvName.startsWith("ENS") && numConfiguredNameServers > 0 ? currentConfiguredNameServerTag : (srvName.startsWith("GENS") && numConfiguredNameServers > 0 ? "G" + currentConfiguredNameServerTag : srvName);
        for (int i = 0; i < NameCacheLength; ++i) {
            if (ctxName.length() > 0 && ctxName.compareToIgnoreCase("DEFAULT") != 0 && ctxName.compareToIgnoreCase(TSrvEntry.devNameCache[i].cntName) != 0 || lkupname.compareToIgnoreCase(TSrvEntry.devNameCache[i].devName) != 0) continue;
            this.eqmName = modNameCache[TSrvEntry.devNameCache[i].modNameIndex];
            this.fecName = TSrvEntry.fecAddrCache[TSrvEntry.devNameCache[i].srvNameIndex].fecName;
            this.fecAddr = fecAddrCache[TSrvEntry.devNameCache[i].srvNameIndex];
            return 0;
        }
        this.srvFile = new csv(srvCacheFile);
        int cc = this.fillinAddressFromFileCache(srvName, ctxName);
        if (cc != 0) {
            this.srvFile = new csv(srvR);
            cc = this.fillinAddressFromFileCache(srvName, ctxName);
        }
        return cc;
    }

    public TSrvEntry(String fname, String srvName, String ctxName) {
        this.getAddressFromFileCache(srvName, ctxName);
    }

    public TSrvEntry(String srvName, String ctxName) {
        this.getAddress(srvName, ctxName);
    }

    public synchronized void getAddress(String srvName, String ctxName) {
        int i;
        boolean isENSRequest;
        debugLevel = TLinkFactory.debugLevel;
        if (TLinkFactory.debugLevel > 1) {
            DbgLog.log("getAddress", "TModAddress() has been called from factory");
        }
        if (srvName.compareToIgnoreCase("GLOBAL") == 0) {
            return;
        }
        TSrvEntry.SetAddrFileLocation();
        if (TLinkFactory.debugLevel > 1) {
            DbgLog.log("getAddress", "looking for /" + ctxName + "/" + srvName);
        }
        boolean bl = isENSRequest = srvName.startsWith("ENS") && ctxName.compareToIgnoreCase("DEFAULT") == 0;
        if (isENSRequest && numConfiguredNameServers == 0) {
            if (TLinkFactory.debugLevel > 1) {
                DbgLog.log("getAddress", "add static ENS address");
            }
            this.StaticAddress(srvName, ctxName);
            return;
        }
        String dnam = srvName;
        if (srvName.compareTo("GENS") == 0) {
            dnam = "G" + currentConfiguredNameServerTag;
            if (TLinkFactory.debugLevel > 1) {
                DbgLog.log("getAddress", "setting GENS entry to " + dnam);
            }
            int idx = 0;
            idx = dnam.indexOf(35);
            if (idx != -1) {
                dnam = dnam.substring(0, idx);
            }
        }
        for (i = 0; i < NameCacheLength; ++i) {
            if (ctxName.length() > 0 && ctxName.compareToIgnoreCase("DEFAULT") != 0 && ctxName.compareToIgnoreCase(TSrvEntry.devNameCache[i].cntName) != 0 || dnam.compareToIgnoreCase(TSrvEntry.devNameCache[i].devName) != 0) continue;
            this.eqmName = modNameCache[TSrvEntry.devNameCache[i].modNameIndex];
            this.fecName = TSrvEntry.fecAddrCache[TSrvEntry.devNameCache[i].srvNameIndex].fecName;
            this.fecAddr = fecAddrCache[TSrvEntry.devNameCache[i].srvNameIndex];
            boolean bl2 = this.isLegacy = this.fecAddr.getTineProtocol() < 6;
            if (TLinkFactory.debugLevel > 1) {
                DbgLog.log("getAddress", "found it in cache");
            }
            return;
        }
        if (isENSRequest) {
            i = ensDevCacheIndex == -1 ? 0 : ensDevCacheIndex;
            this.eqmName = modNameCache[TSrvEntry.devNameCache[i].modNameIndex];
            this.fecName = TSrvEntry.fecAddrCache[TSrvEntry.devNameCache[i].srvNameIndex].fecName;
            this.fecAddr = fecAddrCache[TSrvEntry.devNameCache[i].srvNameIndex];
            return;
        }
        if (srvName.compareTo("NETWORK") == 0) {
            if (NameCacheLength < 1000 && modNameCacheLength < 1000 && fecAddrCacheLength < 1000) {
                SrvAddr srv = new SrvAddr();
                srv.ipAddr = TLinkFactory.getInstance().getInitializer().getNetCastAddress();
                srv.portOffset = 0;
                srv.fecName = "NETWORK";
                srv.eqmContext = "";
                srv.eqmName = SRVEQM_NAME;
                srv.expName = "NETWORK";
                TSrvEntry.fecAddrCache[TSrvEntry.fecAddrCacheLength] = new TFecEntry(srv);
                TSrvEntry.modNameCache[TSrvEntry.modNameCacheLength] = SRVEQM_NAME;
                TSrvEntry.devNameCache[TSrvEntry.NameCacheLength] = new NameCache();
                TSrvEntry.devNameCache[TSrvEntry.NameCacheLength].cntName = "";
                TSrvEntry.devNameCache[TSrvEntry.NameCacheLength].devName = "NETWORK";
                TSrvEntry.devNameCache[TSrvEntry.NameCacheLength].modNameIndex = modNameCacheLength++;
                TSrvEntry.devNameCache[TSrvEntry.NameCacheLength].srvNameIndex = fecAddrCacheLength;
                this.fecAddr = fecAddrCache[fecAddrCacheLength];
                this.fecName = TSrvEntry.fecAddrCache[TSrvEntry.fecAddrCacheLength].fecName;
                this.eqmName = SRVEQM_NAME;
                ++NameCacheLength;
                ++fecAddrCacheLength;
            }
            return;
        }
        if (numConfiguredNameServers == 0) {
            if (TLinkFactory.debugLevel > 1) {
                DbgLog.log("getAddress", "No configured ENS");
            }
            return;
        }
        if (this.getAddressFromENS(srvName, ctxName) != 0) {
            this.getAddressFromFileCache(srvName, ctxName);
        }
    }

    private static synchronized SrvAddr getSrvAddrFromENS(String dname, String cname) {
        int cc = 0;
        String tagName = new String(currentConfiguredNameServerTag + "/");
        tagName = cname.length() > 0 ? tagName.concat(cname) : tagName.concat("#2");
        SrvAddr srv = new SrvAddr();
        TDataType d_null = new TDataType();
        TDataType d_srv = new TDataType(srv.toByteArray(), "");
        TLink ma = TLinkFactory.getInstance().simpleLink(tagName, dname, d_srv, d_null, (short)1);
        if (ma == null) {
            if (TLinkFactory.debugLevel > 1) {
                DbgLog.log("getAddress", "cannot create link to ENS");
            }
            return null;
        }
        cc = ma.execute(200, true);
        ma.cancel();
        if (cc == 0) {
            srv.toStruct();
            if (srv.tineProtocol == 0) {
                srv.tineProtocol = 6;
            }
            return srv;
        }
        if (TLinkFactory.debugLevel > 1) {
            DbgLog.log("getAddress", "link to ENS : " + TErrorList.toString(cc));
        }
        return null;
    }

    private synchronized int getAddressFromENS(String srvName, String ctxName) {
        if (TLinkFactory.getInstance().isRunningStandAlone()) {
            return 92;
        }
        int n = 0;
        do {
            SrvAddr srv;
            if ((srv = TSrvEntry.getSrvAddrFromENS(srvName, ctxName)) != null) {
                int i;
                if (modNameCacheLength >= 1000) {
                    return 77;
                }
                if (fecAddrCacheLength >= 1000) {
                    return 77;
                }
                if (NameCacheLength < 1000) {
                    TSrvEntry.devNameCache[TSrvEntry.NameCacheLength] = new NameCache();
                }
                this.eqmName = srv.eqmName;
                for (i = 0; i < modNameCacheLength && this.eqmName.compareTo(modNameCache[i]) != 0; ++i) {
                }
                if (i == modNameCacheLength) {
                    if (modNameCacheLength >= 999) {
                        return 77;
                    }
                    TSrvEntry.modNameCache[TSrvEntry.modNameCacheLength++] = this.eqmName;
                }
                TSrvEntry.devNameCache[TSrvEntry.NameCacheLength].modNameIndex = i;
                this.fecName = srv.fecName;
                for (i = 0; i < fecAddrCacheLength && this.fecName.compareToIgnoreCase(TSrvEntry.fecAddrCache[i].fecName) != 0; ++i) {
                }
                if (i == fecAddrCacheLength) {
                    if (fecAddrCacheLength >= 999) {
                        return 77;
                    }
                    TSrvEntry.fecAddrCache[TSrvEntry.fecAddrCacheLength++] = new TFecEntry(srv);
                }
                this.fecAddr = fecAddrCache[i];
                TSrvEntry.devNameCache[TSrvEntry.NameCacheLength].srvNameIndex = i;
                TSrvEntry.devNameCache[TSrvEntry.NameCacheLength].devName = srvName;
                TSrvEntry.devNameCache[TSrvEntry.NameCacheLength].cntName = ctxName;
                boolean bl = this.isLegacy = srv.tineProtocol < 6;
                if (NameCacheLength < 1000) {
                    ++NameCacheLength;
                }
                TSrvEntry.addAddressToCacheFile(srv);
                if (TLinkFactory.debugLevel > 1) {
                    DbgLog.log("getAddress", "ENS success");
                }
                return 0;
            }
            currentConfiguredNameServer = (currentConfiguredNameServer + 1) % numConfiguredNameServers;
            currentConfiguredNameServerTag = new String("ENS#" + currentConfiguredNameServer);
            if (TLinkFactory.debugLevel <= 1) continue;
            DbgLog.log("getAddress", "trying ENS " + currentConfiguredNameServerTag);
        } while (++n < numConfiguredNameServers);
        if (TLinkFactory.debugLevel > 1) {
            DbgLog.log("getAddress", "ens failure");
        }
        return 55;
    }

    private static int findNameServerFromDNS() {
        int cc = 0;
        if (numConfiguredNameServers > 0) {
            return 0;
        }
        try {
            InetAddress iaddr = Inet4Address.getByName("tineens");
            TSrvEntry.addNameServer(iaddr.getHostAddress());
        }
        catch (UnknownHostException e) {
            cc = 108;
        }
        return cc;
    }

    private static int findNameServerOnNetwork() {
        int cc = 0;
        FECAddr fec = new FECAddr();
        SrvAddr srv = new SrvAddr();
        if (numConfiguredNameServers > 0) {
            return 0;
        }
        cc = TSrvEntry.findServerOnNetwork("", "ENSEQM", "", fec, srv);
        if (cc == 0) {
            TSrvEntry.addNameServer(fec.ipAddr);
        }
        return cc;
    }

    private static int findServerOnNetwork(String context, String eqmName, String exportName, FECAddr fec, SrvAddr srv) {
        int cc = 0;
        TCompoundDataObject[] n16in = new NAME16[3];
        TCompoundDataObject[] n16out = new NAME16[5];
        n16in[0] = new NAME16(context);
        n16in[1] = new NAME16(eqmName);
        n16in[2] = new NAME16(exportName);
        TDataType dout = new TDataType(n16out);
        TDataType din = new TDataType(n16in);
        TLink tl = new TLink("NETWORK", "SRVADDR", dout, din, 1);
        cc = tl.execute(500, true);
        if (cc == 0) {
            if (fec != null) {
                int p = Integer.valueOf(((NAME)((Object)n16out[0])).getName());
                fec.fecName = ((NAME)((Object)n16out[1])).getName();
                fec.portOffset = p;
                System.arraycopy(tl.linkPeer.getAddress(), 0, fec.ipHAddr, 0, 4);
                fec.ipAddr = tl.linkPeer.getHostAddress();
            }
            if (srv != null) {
                srv.fecName = ((NAME)((Object)n16out[1])).getName();
                srv.eqmContext = ((NAME)((Object)n16out[2])).getName();
                srv.eqmName = ((NAME)((Object)n16out[3])).getName();
                srv.expName = ((NAME)((Object)n16out[4])).getName();
            }
        }
        return cc;
    }

    public TFecEntry getFecAddr() {
        return this.fecAddr;
    }

    public String getContextName() {
        return this.cntName;
    }

    public String getDeviceName() {
        return this.devName;
    }

    public String getEqmName() {
        return this.eqmName;
    }

    public String getFecName() {
        return this.fecName;
    }

    static {
        fecR = null;
        ensR = null;
        srvR = null;
        fecCacheR = null;
        fecCacheW = null;
        srvCacheW = null;
        fecCacheFile = null;
        srvCacheFile = null;
        initialized = false;
        initializing = false;
        ensSrvCacheIndex = -1;
        ensDevCacheIndex = -1;
        devNameCache = new NameCache[1000];
        modNameCache = new String[1000];
        fecAddrCache = new TFecEntry[1000];
        modNameCacheLength = 0;
        fecAddrCacheLength = 0;
        NameCacheLength = 0;
        numConfiguredNameServers = 0;
        currentConfiguredNameServer = 0;
        debugLevel = 0;
    }
}

