/*
 * Decompiled with CFR 0.152.
 */
package de.desy.tine.addrUtils;

import de.desy.tine.addrUtils.FECAddr;
import de.desy.tine.addrUtils.FECInfo;
import de.desy.tine.addrUtils.SrvAddr;
import de.desy.tine.addrUtils.TSrvEntry;
import de.desy.tine.client.TLink;
import de.desy.tine.dataUtils.TDataType;
import de.desy.tine.queryUtils.TQuery;
import de.desy.tine.types.NAME;
import de.desy.tine.types.NAME16;
import de.desy.tine.types.NAME32;
import de.desy.tine.types.NAME64;
import de.desy.tine.types.TCompoundDataObject;

public class ENSTools {
    public static int sendExportInformationToENS(FECAddr fec, FECInfo info, SrvAddr da) {
        if (fec == null || info == null || da == null) {
            return 20;
        }
        if (TSrvEntry.currentConfiguredNameServerTag == null) {
            TQuery.getModuleAddressInfo("ENS", "DEFAULT");
        }
        fec.setPortOffset(fec.portOffset);
        byte[] expAddr = new byte[SrvAddr.sizeInBytes + FECInfo.getSizeInBytes()];
        System.arraycopy(da.toByteArray(), 0, expAddr, 0, SrvAddr.sizeInBytes);
        System.arraycopy(info.toByteArray(), 0, expAddr, SrvAddr.sizeInBytes, FECInfo.getSizeInBytes());
        TDataType din = new TDataType(expAddr, "");
        TDataType dout = new TDataType(expAddr, "");
        if (TSrvEntry.currentConfiguredNameServerTag != null) {
            TLink expLnk = new TLink(TSrvEntry.currentConfiguredNameServerTag, "EXPORT", dout, din, 2);
            int cc = expLnk.execute(500, true);
            expLnk.close();
            return cc;
        }
        return 90;
    }

    public static int sendExportInformationToENS(SrvAddr da, FECInfo info) {
        if (info == null || da == null) {
            return 20;
        }
        if (TSrvEntry.currentConfiguredNameServerTag == null) {
            TQuery.getModuleAddressInfo("ENS", "DEFAULT");
        }
        byte[] expAddr = new byte[SrvAddr.sizeInBytes + FECInfo.getSizeInBytes()];
        System.arraycopy(da.toByteArray(), 0, expAddr, 0, SrvAddr.sizeInBytes);
        System.arraycopy(info.toByteArray(), 0, expAddr, SrvAddr.sizeInBytes, FECInfo.getSizeInBytes());
        TDataType din = new TDataType(expAddr, "");
        TDataType dout = new TDataType(expAddr, "");
        if (TSrvEntry.currentConfiguredNameServerTag != null) {
            TLink expLnk = new TLink(TSrvEntry.currentConfiguredNameServerTag, "EXPORT", dout, din, 2);
            int cc = expLnk.execute(500, true);
            expLnk.close();
            return cc;
        }
        return 90;
    }

    public static int removeFECFromENS(String fecName) {
        if (fecName == null) {
            return 20;
        }
        if (TSrvEntry.currentConfiguredNameServerTag == null) {
            TQuery.getModuleAddressInfo("ENS", "DEFAULT");
        }
        TCompoundDataObject[] fn = new NAME16[]{new NAME16(fecName)};
        TDataType din = new TDataType(fn);
        if (TSrvEntry.currentConfiguredNameServerTag != null) {
            String dn = TSrvEntry.currentConfiguredNameServerTag + "/FEC";
            TLink rmvLnk = new TLink(dn, "REMOVE", null, din, 2);
            int cc = rmvLnk.execute(500, true);
            rmvLnk.close();
            return cc;
        }
        return 90;
    }

    public static int removeDeviceServerFromENS(String context, String deviceServer) {
        if (context == null || deviceServer == null) {
            return 20;
        }
        if (TSrvEntry.currentConfiguredNameServerTag == null) {
            TQuery.getModuleAddressInfo("ENS", "DEFAULT");
        }
        TCompoundDataObject[] sn = new NAME32[]{new NAME32(deviceServer)};
        TDataType din = new TDataType(sn);
        if (TSrvEntry.currentConfiguredNameServerTag != null) {
            String dn = TSrvEntry.currentConfiguredNameServerTag + "/" + context;
            TLink rmvLnk = new TLink(dn, "REMOVE", null, din, 2);
            int cc = rmvLnk.execute(500, true);
            rmvLnk.close();
            return cc;
        }
        return 90;
    }

    public static String[] getGroupsFromGENS(String context) {
        if (context == null || context.length() == 0) {
            return null;
        }
        if (TSrvEntry.currentConfiguredNameServerTag == null) {
            TQuery.getModuleAddressInfo("GENS", "SITE");
        }
        TCompoundDataObject[] sn = new NAME64[512];
        TDataType dout = new TDataType(sn);
        if (TSrvEntry.currentConfiguredNameServerTag != null) {
            TLink grpsLnk = new TLink("/SITE/GENS", "GROUPS", dout, null, 1);
            int cc = grpsLnk.execute(500, true);
            grpsLnk.close();
            int len = dout.getCompletionLength();
            if (cc == 0 && len > 0) {
                String[] st = new String[len];
                int n = 0;
                for (int i = 0; i < len; ++i) {
                    String[] parts = ((NAME)((Object)sn[i])).getName().split("/");
                    if (parts.length <= 2 || parts[1].compareToIgnoreCase(context) != 0) continue;
                    st[n++] = parts[2];
                }
                String[] s = new String[n];
                for (int i = 0; i < n; ++i) {
                    s[i] = st[i];
                }
                return s;
            }
        }
        return null;
    }

    public static String[] getGroupMembersFromGENS(String context, String group) {
        if (context == null || context.length() == 0) {
            return null;
        }
        if (group == null || group.length() == 0) {
            return null;
        }
        if (TSrvEntry.currentConfiguredNameServerTag == null) {
            TQuery.getModuleAddressInfo("GENS", "SITE");
        }
        TCompoundDataObject[] cn = new NAME32[]{new NAME32(context)};
        TCompoundDataObject[] sn = new NAME64[512];
        TDataType dout = new TDataType(sn);
        TDataType din = new TDataType(cn);
        if (TSrvEntry.currentConfiguredNameServerTag != null) {
            TLink grpsLnk = new TLink("/SITE/GENS/" + group, "MEMBERS", dout, din, 1);
            int cc = grpsLnk.execute(500, true);
            grpsLnk.close();
            int len = dout.getCompletionLength();
            if (cc == 0 && len > 0) {
                String[] st = new String[len];
                for (int i = 0; i < len; ++i) {
                    st[i] = ((NAME)((Object)sn[i])).getName();
                }
                return st;
            }
        }
        return null;
    }

    public static int removeDeviceServerFromGroup(String context, String deviceServer, String group) {
        if (context == null || deviceServer == null || group == null) {
            return 20;
        }
        if (context.length() == 0 || deviceServer.length() == 0 || group.length() == 0) {
            return 20;
        }
        if (TSrvEntry.currentConfiguredNameServerTag == null) {
            TQuery.getModuleAddressInfo("GENS", "SITE");
        }
        TCompoundDataObject[] sn = new NAME32[]{new NAME32(deviceServer), new NAME32(group), new NAME32(context)};
        TDataType din = new TDataType(sn);
        if (TSrvEntry.currentConfiguredNameServerTag != null) {
            TLink rmvLnk = new TLink("/SITE/GENS", "SEPARATE", null, din, 2);
            int cc = rmvLnk.execute(500, true);
            rmvLnk.close();
            return cc;
        }
        return 90;
    }

    public static int addDeviceServerToGroup(String context, String deviceServer, String group, String subSystem, int groupIndex) {
        if (context == null || deviceServer == null || group == null) {
            return 20;
        }
        if (context.length() == 0 || deviceServer.length() == 0 || group.length() == 0) {
            return 20;
        }
        if (TSrvEntry.currentConfiguredNameServerTag == null) {
            TQuery.getModuleAddressInfo("GENS", "SITE");
        }
        int len = 5;
        TCompoundDataObject[] sn = new NAME32[5];
        sn[0] = new NAME32(deviceServer);
        sn[1] = new NAME32(group);
        sn[2] = new NAME32(context);
        sn[3] = new NAME32(Integer.toString(groupIndex));
        if (subSystem != null || subSystem.length() > 0) {
            sn[4] = new NAME32(subSystem);
        } else {
            len = 4;
        }
        TDataType din = new TDataType(sn, len);
        if (TSrvEntry.currentConfiguredNameServerTag != null) {
            TLink addLnk = new TLink("/SITE/GENS", "JOIN", null, din, 2);
            int cc = addLnk.execute(500, true);
            addLnk.close();
            return cc;
        }
        return 90;
    }
}

