/*
 * Decompiled with CFR 0.152.
 */
package org.tmatesoft.svn.core;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import org.tmatesoft.svn.core.internal.util.SVNHashMap;

public class SVNErrorCode
implements Serializable {
    private String myDescription;
    private int myCategory;
    private int myCode;
    private static final Map ourErrorCodes = new SVNHashMap();
    private static final int ERR_BASE = 120000;
    private static final int ERR_CATEGORY_SIZE = 5000;
    public static final int BAD_CATEGORY = 125000;
    public static final int XML_CATEGORY = 130000;
    public static final int IO_CATEGORY = 135000;
    public static final int STREAM_CATEGORY = 140000;
    public static final int NODE_CATEGORY = 145000;
    public static final int ENTRY_CATEGORY = 150000;
    public static final int WC_CATEGORY = 155000;
    public static final int FS_CATEGORY = 160000;
    public static final int REPOS_CATEGORY = 165000;
    public static final int RA_CATEGORY = 170000;
    public static final int RA_DAV_CATEGORY = 175000;
    public static final int RA_LOCAL_CATEGORY = 180000;
    public static final int SVNDIFF_CATEGORY = 185000;
    public static final int APMOD_CATEGORY = 190000;
    public static final int CLIENT_CATEGORY = 195000;
    public static final int MISC_CATEGORY = 200000;
    public static final int CL_CATEGORY = 205000;
    public static final int RA_SVN_CATEGORY = 210000;
    public static final int AUTHN_CATEGORY = 215000;
    public static final int AUTHZ_CATEGORY = 220000;
    public static final SVNErrorCode UNKNOWN = new SVNErrorCode(200000, 4900, "Unknown error");
    public static final SVNErrorCode IO_ERROR = new SVNErrorCode(200000, 4899, "Generic IO error");
    public static final SVNErrorCode BAD_CONTAINING_POOL = new SVNErrorCode(125000, 0, "Bad parent pool passed to svn_make_pool()");
    public static final SVNErrorCode BAD_FILENAME = new SVNErrorCode(125000, 1, "Bogus filename");
    public static final SVNErrorCode BAD_URL = new SVNErrorCode(125000, 2, "Bogus URL");
    public static final SVNErrorCode BAD_DATE = new SVNErrorCode(125000, 3, "Bogus date");
    public static final SVNErrorCode BAD_MIME_TYPE = new SVNErrorCode(125000, 4, "Bogus mime-type");
    public static final SVNErrorCode BAD_PROPERTY_VALUE = new SVNErrorCode(125000, 5, "Wrong or unexpected property value");
    public static final SVNErrorCode BAD_VERSION_FILE_FORMAT = new SVNErrorCode(125000, 6, "Version file format not correct");
    public static final SVNErrorCode BAD_RELATIVE_PATH = new SVNErrorCode(125000, 7, "Path is not an immediate child of the specified directory");
    public static final SVNErrorCode BAD_UUID = new SVNErrorCode(125000, 8, "Bogus UUID");
    public static final SVNErrorCode XML_ATTRIB_NOT_FOUND = new SVNErrorCode(130000, 0, "No such XML tag attribute");
    public static final SVNErrorCode XML_MISSING_ANCESTRY = new SVNErrorCode(130000, 1, "<delta-pkg> is missing ancestry");
    public static final SVNErrorCode XML_UNKNOWN_ENCODING = new SVNErrorCode(130000, 2, "Unrecognized binary data encoding; can't decode");
    public static final SVNErrorCode XML_MALFORMED = new SVNErrorCode(130000, 3, "XML data was not well-formed");
    public static final SVNErrorCode XML_UNESCAPABLE_DATA = new SVNErrorCode(130000, 4, "Data cannot be safely XML-escaped");
    public static final SVNErrorCode IO_INCONSISTENT_EOL = new SVNErrorCode(135000, 0, "Inconsistent line ending style");
    public static final SVNErrorCode IO_UNKNOWN_EOL = new SVNErrorCode(135000, 1, "Unrecognized line ending style");
    public static final SVNErrorCode IO_CORRUPT_EOL = new SVNErrorCode(135000, 2, "Line endings other than expected");
    public static final SVNErrorCode IO_UNIQUE_NAMES_EXHAUSTED = new SVNErrorCode(135000, 3, "Ran out of unique names");
    public static final SVNErrorCode IO_PIPE_FRAME_ERROR = new SVNErrorCode(135000, 4, "Framing error in pipe protocol");
    public static final SVNErrorCode IO_PIPE_READ_ERROR = new SVNErrorCode(135000, 5, "Read error in pipe");
    public static final SVNErrorCode IO_WRITE_ERROR = new SVNErrorCode(135000, 6, "Write error");
    public static final SVNErrorCode STREAM_UNEXPECTED_EOF = new SVNErrorCode(140000, 0, "Unexpected EOF on stream");
    public static final SVNErrorCode STREAM_MALFORMED_DATA = new SVNErrorCode(140000, 1, "Malformed stream data");
    public static final SVNErrorCode STREAM_UNRECOGNIZED_DATA = new SVNErrorCode(140000, 2, "Unrecognized stream data");
    public static final SVNErrorCode NODE_UNKNOWN_KIND = new SVNErrorCode(145000, 0, "Unknown svn_node_kind");
    public static final SVNErrorCode NODE_UNEXPECTED_KIND = new SVNErrorCode(145000, 1, "Unexpected node kind found");
    public static final SVNErrorCode ENTRY_NOT_FOUND = new SVNErrorCode(150000, 0, "Can't find an entry");
    public static final SVNErrorCode ENTRY_EXISTS = new SVNErrorCode(150000, 2, "Entry already exists");
    public static final SVNErrorCode ENTRY_MISSING_REVISION = new SVNErrorCode(150000, 3, "Entry has no revision");
    public static final SVNErrorCode ENTRY_MISSING_URL = new SVNErrorCode(150000, 4, "Entry has no URL");
    public static final SVNErrorCode ENTRY_ATTRIBUTE_INVALID = new SVNErrorCode(150000, 5, "Entry has an invalid attribute");
    public static final SVNErrorCode WC_OBSTRUCTED_UPDATE = new SVNErrorCode(155000, 0, "Obstructed update");
    public static final SVNErrorCode WC_UNWIND_MISMATCH = new SVNErrorCode(155000, 1, "Mismatch popping the WC unwind stack");
    public static final SVNErrorCode WC_UNWIND_EMPTY = new SVNErrorCode(155000, 2, "Attempt to pop empty WC unwind stack");
    public static final SVNErrorCode WC_UNWIND_NOT_EMPTY = new SVNErrorCode(155000, 3, "Attempt to unlock with non-empty unwind stack");
    public static final SVNErrorCode WC_LOCKED = new SVNErrorCode(155000, 4, "Attempted to lock an already-locked dir");
    public static final SVNErrorCode WC_NOT_LOCKED = new SVNErrorCode(155000, 5, "Working copy not locked; this is probably a bug, please report");
    public static final SVNErrorCode WC_INVALID_LOCK = new SVNErrorCode(155000, 6, "Invalid lock");
    public static final SVNErrorCode WC_NOT_DIRECTORY = new SVNErrorCode(155000, 7, "Path is not a working copy directory");
    public static final SVNErrorCode WC_NOT_FILE = new SVNErrorCode(155000, 8, "Path is not a working copy file");
    public static final SVNErrorCode WC_BAD_ADM_LOG = new SVNErrorCode(155000, 9, "Problem running log");
    public static final SVNErrorCode WC_PATH_NOT_FOUND = new SVNErrorCode(155000, 10, "Can't find a working copy path");
    public static final SVNErrorCode WC_NOT_UP_TO_DATE = new SVNErrorCode(155000, 11, "Working copy is not up-to-date");
    public static final SVNErrorCode WC_LEFT_LOCAL_MOD = new SVNErrorCode(155000, 12, "Left locally modified or unversioned files");
    public static final SVNErrorCode WC_SCHEDULE_CONFLICT = new SVNErrorCode(155000, 13, "Unmergeable scheduling requested on an entry");
    public static final SVNErrorCode WC_PATH_FOUND = new SVNErrorCode(155000, 14, "Found a working copy path");
    public static final SVNErrorCode WC_FOUND_CONFLICT = new SVNErrorCode(155000, 15, "A conflict in the working copy obstructs the current operation");
    public static final SVNErrorCode WC_CORRUPT = new SVNErrorCode(155000, 16, "Working copy is corrupt");
    public static final SVNErrorCode WC_CORRUPT_TEXT_BASE = new SVNErrorCode(155000, 17, "Working copy text base is corrupt");
    public static final SVNErrorCode WC_NODE_KIND_CHANGE = new SVNErrorCode(155000, 18, "Cannot change node kind");
    public static final SVNErrorCode WC_INVALID_OP_ON_CWD = new SVNErrorCode(155000, 19, "Invalid operation on the current working directory");
    public static final SVNErrorCode WC_BAD_ADM_LOG_START = new SVNErrorCode(155000, 20, "Problem on first log entry in a working copy");
    public static final SVNErrorCode WC_UNSUPPORTED_FORMAT = new SVNErrorCode(155000, 21, "Unsupported working copy format");
    public static final SVNErrorCode WC_BAD_PATH = new SVNErrorCode(155000, 22, "Path syntax not supported in this context");
    public static final SVNErrorCode WC_INVALID_SCHEDULE = new SVNErrorCode(155000, 23, "Invalid schedule");
    public static final SVNErrorCode WC_INVALID_RELOCATION = new SVNErrorCode(155000, 24, "Invalid relocation");
    public static final SVNErrorCode WC_INVALID_SWITCH = new SVNErrorCode(155000, 25, "Invalid switch");
    public static final SVNErrorCode WC_MISMATCHED_CHANGELIST = new SVNErrorCode(155000, 26, "Changelist doesn't match");
    public static final SVNErrorCode WC_CONFLICT_RESOLVER_FAILURE = new SVNErrorCode(155000, 27, "Conflict resolution failed");
    public static final SVNErrorCode WC_COPYFROM_PATH_NOT_FOUND = new SVNErrorCode(155000, 28, "Failed to locate 'copyfrom' path in working copy");
    public static final SVNErrorCode WC_CHANGELIST_MOVE = new SVNErrorCode(155000, 29, "Moving a path from one changelist to another");
    public static final SVNErrorCode FS_GENERAL = new SVNErrorCode(160000, 0, "General filesystem error");
    public static final SVNErrorCode FS_CLEANUP = new SVNErrorCode(160000, 1, "Error closing filesystem");
    public static final SVNErrorCode FS_ALREADY_OPEN = new SVNErrorCode(160000, 2, "Filesystem is already open");
    public static final SVNErrorCode FS_NOT_OPEN = new SVNErrorCode(160000, 3, "Filesystem is not open");
    public static final SVNErrorCode FS_CORRUPT = new SVNErrorCode(160000, 4, "Filesystem is corrupt");
    public static final SVNErrorCode FS_PATH_SYNTAX = new SVNErrorCode(160000, 5, "Invalid filesystem path syntax");
    public static final SVNErrorCode FS_NO_SUCH_REVISION = new SVNErrorCode(160000, 6, "Invalid filesystem revision number");
    public static final SVNErrorCode FS_NO_SUCH_TRANSACTION = new SVNErrorCode(160000, 7, "Invalid filesystem transaction name");
    public static final SVNErrorCode FS_NO_SUCH_ENTRY = new SVNErrorCode(160000, 8, "Filesystem directory has no such entry");
    public static final SVNErrorCode FS_NO_SUCH_REPRESENTATION = new SVNErrorCode(160000, 9, "Filesystem has no such representation");
    public static final SVNErrorCode FS_NO_SUCH_STRING = new SVNErrorCode(160000, 10, "Filesystem has no such string");
    public static final SVNErrorCode FS_NO_SUCH_COPY = new SVNErrorCode(160000, 11, "Filesystem has no such copy");
    public static final SVNErrorCode FS_TRANSACTION_NOT_MUTABLE = new SVNErrorCode(160000, 12, "The specified transaction is not mutable");
    public static final SVNErrorCode FS_NOT_FOUND = new SVNErrorCode(160000, 13, "Filesystem has no item");
    public static final SVNErrorCode FS_ID_NOT_FOUND = new SVNErrorCode(160000, 14, "Filesystem has no such node-rev-id");
    public static final SVNErrorCode FS_NOT_ID = new SVNErrorCode(160000, 15, "String does not represent a node or node-rev-id");
    public static final SVNErrorCode FS_NOT_DIRECTORY = new SVNErrorCode(160000, 16, "Name does not refer to a filesystem directory");
    public static final SVNErrorCode FS_NOT_FILE = new SVNErrorCode(160000, 17, "Name does not refer to a filesystem file");
    public static final SVNErrorCode FS_NOT_SINGLE_PATH_COMPONENT = new SVNErrorCode(160000, 18, "Name is not a single path component");
    public static final SVNErrorCode FS_NOT_MUTABLE = new SVNErrorCode(160000, 19, "Attempt to change immutable filesystem node");
    public static final SVNErrorCode FS_ALREADY_EXISTS = new SVNErrorCode(160000, 20, "Item already exists in filesystem");
    public static final SVNErrorCode FS_ROOT_DIR = new SVNErrorCode(160000, 21, "Attempt to remove or recreate fs root dir");
    public static final SVNErrorCode FS_NOT_TXN_ROOT = new SVNErrorCode(160000, 22, "Object is not a transaction root");
    public static final SVNErrorCode FS_NOT_REVISION_ROOT = new SVNErrorCode(160000, 23, "Object is not a revision root");
    public static final SVNErrorCode FS_CONFLICT = new SVNErrorCode(160000, 24, "Merge conflict during commit");
    public static final SVNErrorCode FS_REP_CHANGED = new SVNErrorCode(160000, 25, "A representation vanished or changed between reads");
    public static final SVNErrorCode FS_REP_NOT_MUTABLE = new SVNErrorCode(160000, 26, "Tried to change an immutable representation");
    public static final SVNErrorCode FS_MALFORMED_SKEL = new SVNErrorCode(160000, 27, "Malformed skeleton data");
    public static final SVNErrorCode FS_TXN_OUT_OF_DATE = new SVNErrorCode(160000, 28, "Transaction is out of date");
    public static final SVNErrorCode FS_BERKELEY_DB = new SVNErrorCode(160000, 29, "Berkeley DB error");
    public static final SVNErrorCode FS_BERKELEY_DB_DEADLOCK = new SVNErrorCode(160000, 30, "Berkeley DB deadlock error");
    public static final SVNErrorCode FS_TRANSACTION_DEAD = new SVNErrorCode(160000, 31, "Transaction is dead");
    public static final SVNErrorCode FS_TRANSACTION_NOT_DEAD = new SVNErrorCode(160000, 32, "Transaction is not dead");
    public static final SVNErrorCode FS_UNKNOWN_FS_TYPE = new SVNErrorCode(160000, 33, "Unknown FS type");
    public static final SVNErrorCode FS_NO_USER = new SVNErrorCode(160000, 34, "No user associated with filesystem");
    public static final SVNErrorCode FS_PATH_ALREADY_LOCKED = new SVNErrorCode(160000, 35, "Path is already locked");
    public static final SVNErrorCode FS_PATH_NOT_LOCKED = new SVNErrorCode(160000, 36, "Path is not locked");
    public static final SVNErrorCode FS_BAD_LOCK_TOKEN = new SVNErrorCode(160000, 37, "Lock token is incorrect");
    public static final SVNErrorCode FS_NO_LOCK_TOKEN = new SVNErrorCode(160000, 38, "No lock token provided");
    public static final SVNErrorCode FS_LOCK_OWNER_MISMATCH = new SVNErrorCode(160000, 39, "Username does not match lock owner");
    public static final SVNErrorCode FS_NO_SUCH_LOCK = new SVNErrorCode(160000, 40, "Filesystem has no such lock");
    public static final SVNErrorCode FS_LOCK_EXPIRED = new SVNErrorCode(160000, 41, "Lock has expired");
    public static final SVNErrorCode FS_OUT_OF_DATE = new SVNErrorCode(160000, 42, "Item is out of date");
    public static final SVNErrorCode FS_UNSUPPORTED_FORMAT = new SVNErrorCode(160000, 43, "Unsupported FS format");
    public static final SVNErrorCode FS_REP_BEING_WRITTEN = new SVNErrorCode(160000, 44, "Representation is being written");
    public static final SVNErrorCode FS_TXN_NAME_TOO_LONG = new SVNErrorCode(160000, 45, "The generated transaction name is too long");
    public static final SVNErrorCode FS_NO_SUCH_NODE_ORIGIN = new SVNErrorCode(160000, 46, "Filesystem has no such node origin record");
    public static final SVNErrorCode REPOS_LOCKED = new SVNErrorCode(165000, 0, "The repository is locked, perhaps for db recovery");
    public static final SVNErrorCode REPOS_HOOK_FAILURE = new SVNErrorCode(165000, 1, "A repository hook failed");
    public static final SVNErrorCode REPOS_BAD_ARGS = new SVNErrorCode(165000, 2, "Incorrect arguments supplied");
    public static final SVNErrorCode REPOS_NO_DATA_FOR_REPORT = new SVNErrorCode(165000, 3, "A report cannot be generated because no data was supplied");
    public static final SVNErrorCode REPOS_BAD_REVISION_REPORT = new SVNErrorCode(165000, 4, "Bogus revision report");
    public static final SVNErrorCode REPOS_UNSUPPORTED_VERSION = new SVNErrorCode(165000, 5, "Unsupported repository version");
    public static final SVNErrorCode REPOS_DISABLED_FEATURE = new SVNErrorCode(165000, 6, "Disabled repository feature");
    public static final SVNErrorCode REPOS_POST_COMMIT_HOOK_FAILED = new SVNErrorCode(165000, 7, "Error running post-commit hook");
    public static final SVNErrorCode REPOS_POST_LOCK_HOOK_FAILED = new SVNErrorCode(165000, 8, "Error running post-lock hook");
    public static final SVNErrorCode REPOS_POST_UNLOCK_HOOK_FAILED = new SVNErrorCode(165000, 9, "Error running post-unlock hook");
    public static final SVNErrorCode RA_ILLEGAL_URL = new SVNErrorCode(170000, 0, "Bad URL passed to RA layer");
    public static final SVNErrorCode RA_NOT_AUTHORIZED = new SVNErrorCode(170000, 1, "Authorization failed");
    public static final SVNErrorCode RA_UNKNOWN_AUTH = new SVNErrorCode(170000, 2, "Unknown authorization method");
    public static final SVNErrorCode RA_NOT_IMPLEMENTED = new SVNErrorCode(170000, 3, "Repository access method not implemented");
    public static final SVNErrorCode RA_OUT_OF_DATE = new SVNErrorCode(170000, 4, "Item is out-of-date");
    public static final SVNErrorCode RA_NO_REPOS_UUID = new SVNErrorCode(170000, 5, "Repository has no UUID");
    public static final SVNErrorCode RA_UNSUPPORTED_ABI_VERSION = new SVNErrorCode(170000, 6, "Unsupported RA plugin ABI version");
    public static final SVNErrorCode RA_NOT_LOCKED = new SVNErrorCode(170000, 7, "Path is not locked");
    public static final SVNErrorCode RA_PARTIAL_REPLAY_NOT_SUPPORTED = new SVNErrorCode(170000, 8, "Server can only replay from the root of a repository");
    public static final SVNErrorCode RA_UUID_MISMATCH = new SVNErrorCode(170000, 9, "Repository UUID does not match expected UUID");
    public static final SVNErrorCode RA_DAV_SOCK_INIT = new SVNErrorCode(175000, 0, "RA layer failed to init socket layer");
    public static final SVNErrorCode RA_DAV_CREATING_REQUEST = new SVNErrorCode(175000, 1, "RA layer failed to create HTTP request");
    public static final SVNErrorCode RA_DAV_REQUEST_FAILED = new SVNErrorCode(175000, 2, "RA layer request failed");
    public static final SVNErrorCode RA_DAV_OPTIONS_REQ_FAILED = new SVNErrorCode(175000, 3, "RA layer didn't receive requested OPTIONS info");
    public static final SVNErrorCode RA_DAV_PROPS_NOT_FOUND = new SVNErrorCode(175000, 4, "RA layer failed to fetch properties");
    public static final SVNErrorCode RA_DAV_ALREADY_EXISTS = new SVNErrorCode(175000, 5, "RA layer file already exists");
    public static final SVNErrorCode RA_DAV_INVALID_CONFIG_VALUE = new SVNErrorCode(175000, 6, "Invalid configuration value");
    public static final SVNErrorCode RA_DAV_PATH_NOT_FOUND = new SVNErrorCode(175000, 7, "HTTP Path Not Found");
    public static final SVNErrorCode RA_DAV_PROPPATCH_FAILED = new SVNErrorCode(175000, 8, "Failed to execute WebDAV PROPPATCH");
    public static final SVNErrorCode RA_DAV_MALFORMED_DATA = new SVNErrorCode(175000, 9, "Malformed network data");
    public static final SVNErrorCode RA_DAV_RESPONSE_HEADER_BADNESS = new SVNErrorCode(175000, 10, "Unable to extract data from response header");
    public static final SVNErrorCode RA_LOCAL_REPOS_NOT_FOUND = new SVNErrorCode(180000, 0, "Couldn't find a repository");
    public static final SVNErrorCode RA_LOCAL_REPOS_OPEN_FAILED = new SVNErrorCode(180000, 1, "Couldn't open a repository");
    public static final SVNErrorCode RA_SVN_CMD_ERR = new SVNErrorCode(210000, 0, "Special code for wrapping server errors to report to client");
    public static final SVNErrorCode RA_SVN_UNKNOWN_CMD = new SVNErrorCode(210000, 1, "Unknown svn protocol command");
    public static final SVNErrorCode RA_SVN_CONNECTION_CLOSED = new SVNErrorCode(210000, 2, "Network connection closed unexpectedly");
    public static final SVNErrorCode RA_SVN_IO_ERROR = new SVNErrorCode(210000, 3, "Network read/write error");
    public static final SVNErrorCode RA_SVN_MALFORMED_DATA = new SVNErrorCode(210000, 4, "Malformed network data");
    public static final SVNErrorCode RA_SVN_REPOS_NOT_FOUND = new SVNErrorCode(210000, 5, "Couldn't find a repository");
    public static final SVNErrorCode RA_SVN_BAD_VERSION = new SVNErrorCode(210000, 6, "Client/server version mismatch");
    public static final SVNErrorCode AUTHN_CREDS_UNAVAILABLE = new SVNErrorCode(215000, 0, "Credential data unavailable");
    public static final SVNErrorCode AUTHN_NO_PROVIDER = new SVNErrorCode(215000, 1, "No authentication provider available");
    public static final SVNErrorCode AUTHN_PROVIDERS_EXHAUSTED = new SVNErrorCode(215000, 2, "All authentication providers exhausted");
    public static final SVNErrorCode AUTHN_CREDS_NOT_SAVED = new SVNErrorCode(215000, 3, "Credentials not saved");
    public static final SVNErrorCode AUTHZ_ROOT_UNREADABLE = new SVNErrorCode(220000, 0, "Read access denied for root of edit");
    public static final SVNErrorCode AUTHZ_UNREADABLE = new SVNErrorCode(220000, 1, "Item is not readable");
    public static final SVNErrorCode AUTHZ_PARTIALLY_READABLE = new SVNErrorCode(220000, 2, "Item is partially readable");
    public static final SVNErrorCode AUTHZ_INVALID_CONFIG = new SVNErrorCode(220000, 3, "Invalid authz configuration");
    public static final SVNErrorCode AUTHZ_UNWRITABLE = new SVNErrorCode(220000, 4, "Item is not writable");
    public static final SVNErrorCode SVNDIFF_INVALID_HEADER = new SVNErrorCode(185000, 0, "Svndiff data has invalid header");
    public static final SVNErrorCode SVNDIFF_CORRUPT_WINDOW = new SVNErrorCode(185000, 1, "Svndiff data contains corrupt window");
    public static final SVNErrorCode SVNDIFF_BACKWARD_VIEW = new SVNErrorCode(185000, 2, "Svndiff data contains backward-sliding source view");
    public static final SVNErrorCode SVNDIFF_INVALID_OPS = new SVNErrorCode(185000, 3, "Svndiff data contains invalid instruction");
    public static final SVNErrorCode SVNDIFF_UNEXPECTED_END = new SVNErrorCode(185000, 4, "Svndiff data ends unexpectedly");
    public static final SVNErrorCode APMOD_MISSING_PATH_TO_FS = new SVNErrorCode(190000, 0, "Apache has no path to an SVN filesystem");
    public static final SVNErrorCode APMOD_MALFORMED_URI = new SVNErrorCode(190000, 1, "Apache got a malformed URI");
    public static final SVNErrorCode APMOD_ACTIVITY_NOT_FOUND = new SVNErrorCode(190000, 2, "Activity not found");
    public static final SVNErrorCode APMOD_BAD_BASELINE = new SVNErrorCode(190000, 3, "Baseline incorrect");
    public static final SVNErrorCode APMOD_CONNECTION_ABORTED = new SVNErrorCode(190000, 4, "Input/output error");
    public static final SVNErrorCode CLIENT_VERSIONED_PATH_REQUIRED = new SVNErrorCode(195000, 0, "A path under version control is needed for this operation");
    public static final SVNErrorCode CLIENT_RA_ACCESS_REQUIRED = new SVNErrorCode(195000, 1, "Repository access is needed for this operation");
    public static final SVNErrorCode CLIENT_BAD_REVISION = new SVNErrorCode(195000, 2, "Bogus revision information given");
    public static final SVNErrorCode CLIENT_DUPLICATE_COMMIT_URL = new SVNErrorCode(195000, 3, "Attempting to commit to a URL more than once");
    public static final SVNErrorCode CLIENT_IS_BINARY_FILE = new SVNErrorCode(195000, 4, "Operation does not apply to binary file");
    public static final SVNErrorCode CLIENT_INVALID_EXTERNALS_DESCRIPTION = new SVNErrorCode(195000, 5, "Format of an svn:externals property was invalid");
    public static final SVNErrorCode CLIENT_MODIFIED = new SVNErrorCode(195000, 6, "Attempting restricted operation for modified resource");
    public static final SVNErrorCode CLIENT_IS_DIRECTORY = new SVNErrorCode(195000, 7, "Operation does not apply to directory");
    public static final SVNErrorCode CLIENT_REVISION_RANGE = new SVNErrorCode(195000, 8, "Revision range is not allowed");
    public static final SVNErrorCode CLIENT_INVALID_RELOCATION = new SVNErrorCode(195000, 9, "Inter-repository relocation not allowed");
    public static final SVNErrorCode CLIENT_REVISION_AUTHOR_CONTAINS_NEWLINE = new SVNErrorCode(195000, 10, "Author name cannot contain a newline");
    public static final SVNErrorCode CLIENT_PROPERTY_NAME = new SVNErrorCode(195000, 11, "Bad property name");
    public static final SVNErrorCode CLIENT_UNRELATED_RESOURCES = new SVNErrorCode(195000, 12, "Two versioned resources are unrelated");
    public static final SVNErrorCode CLIENT_MISSING_LOCK_TOKEN = new SVNErrorCode(195000, 13, "Path has no lock token");
    public static final SVNErrorCode CLIENT_MULTIPLE_SOURCES_DISALLOWED = new SVNErrorCode(195000, 14, "Operation does not support multiple sources");
    public static final SVNErrorCode CLIENT_NO_VERSIONED_PARENT = new SVNErrorCode(195000, 15, "No versioned parent directories");
    public static final SVNErrorCode CLIENT_NOT_READY_TO_MERGE = new SVNErrorCode(195000, 16, "Working copy and merge source not ready for reintegration");
    public static final SVNErrorCode BASE = new SVNErrorCode(200000, 0, "A problem occurred; see later errors for details");
    public static final SVNErrorCode PLUGIN_LOAD_FAILURE = new SVNErrorCode(200000, 1, "Failure loading plugin");
    public static final SVNErrorCode MALFORMED_FILE = new SVNErrorCode(200000, 2, "Malformed file");
    public static final SVNErrorCode INCOMPLETE_DATA = new SVNErrorCode(200000, 3, "Incomplete data");
    public static final SVNErrorCode INCORRECT_PARAMS = new SVNErrorCode(200000, 4, "Incorrect parameters given");
    public static final SVNErrorCode UNVERSIONED_RESOURCE = new SVNErrorCode(200000, 5, "Tried a versioning operation on an unversioned resource");
    public static final SVNErrorCode TEST_FAILED = new SVNErrorCode(200000, 6, "Test failed");
    public static final SVNErrorCode UNSUPPORTED_FEATURE = new SVNErrorCode(200000, 7, "Trying to use an unsupported feature");
    public static final SVNErrorCode BAD_PROP_KIND = new SVNErrorCode(200000, 8, "Unexpected or unknown property kind");
    public static final SVNErrorCode ILLEGAL_TARGET = new SVNErrorCode(200000, 9, "Illegal target for the requested operation");
    public static final SVNErrorCode DELTA_MD5_CHECKSUM_ABSENT = new SVNErrorCode(200000, 10, "MD5 checksum is missing");
    public static final SVNErrorCode DIR_NOT_EMPTY = new SVNErrorCode(200000, 11, "Directory needs to be empty but is not");
    public static final SVNErrorCode EXTERNAL_PROGRAM = new SVNErrorCode(200000, 12, "Error calling external program");
    public static final SVNErrorCode SWIG_PY_EXCEPTION_SET = new SVNErrorCode(200000, 13, "Python exception has been set with the error");
    public static final SVNErrorCode CHECKSUM_MISMATCH = new SVNErrorCode(200000, 14, "A checksum mismatch occurred");
    public static final SVNErrorCode CANCELLED = new SVNErrorCode(200000, 15, "The operation was interrupted");
    public static final SVNErrorCode INVALID_DIFF_OPTION = new SVNErrorCode(200000, 16, "The specified diff option is not supported");
    public static final SVNErrorCode PROPERTY_NOT_FOUND = new SVNErrorCode(200000, 17, "Property not found");
    public static final SVNErrorCode NO_AUTH_FILE_PATH = new SVNErrorCode(200000, 18, "No auth file path available");
    public static final SVNErrorCode VERSION_MISMATCH = new SVNErrorCode(200000, 19, "Incompatible library version");
    public static final SVNErrorCode MERGE_INFO_PARSE_ERROR = new SVNErrorCode(200000, 20, "Merge info parse error");
    public static final SVNErrorCode CEASE_INVOCATION = new SVNErrorCode(200000, 21, "Cease invocation of this API");
    public static final SVNErrorCode REVISION_NUMBER_PARSE_ERROR = new SVNErrorCode(200000, 22, "Revision number parse error");
    public static final SVNErrorCode ITER_BREAK = new SVNErrorCode(200000, 23, "Iteration terminated before completion");
    public static final SVNErrorCode UNKNOWN_CHANGELIST = new SVNErrorCode(200000, 24, "Unknown changelist");
    public static final SVNErrorCode RESERVED_FILENAME_SPECIFIED = new SVNErrorCode(200000, 25, "Reserved directory name in command line arguments");
    public static final SVNErrorCode UNKNOWN_CAPABILITY = new SVNErrorCode(200000, 26, "Inquiry about unknown capability");
    public static final SVNErrorCode CL_ARG_PARSING_ERROR = new SVNErrorCode(205000, 0, "Client error in parsing arguments");
    public static final SVNErrorCode CL_INSUFFICIENT_ARGS = new SVNErrorCode(205000, 1, "Not enough args provided");
    public static final SVNErrorCode CL_MUTUALLY_EXCLUSIVE_ARGS = new SVNErrorCode(205000, 2, "Mutually exclusive arguments specified");
    public static final SVNErrorCode CL_ADM_DIR_RESERVED = new SVNErrorCode(205000, 3, "Attempted command in administrative dir");
    public static final SVNErrorCode CL_LOG_MESSAGE_IS_VERSIONED_FILE = new SVNErrorCode(205000, 4, "The log message file is under version control");
    public static final SVNErrorCode CL_LOG_MESSAGE_IS_PATHNAME = new SVNErrorCode(205000, 5, "The log message is a pathname");
    public static final SVNErrorCode CL_COMMIT_IN_ADDED_DIR = new SVNErrorCode(205000, 6, "Committing in directory scheduled for addition");
    public static final SVNErrorCode CL_NO_EXTERNAL_EDITOR = new SVNErrorCode(205000, 7, "No external editor available");
    public static final SVNErrorCode CL_BAD_LOG_MESSAGE = new SVNErrorCode(205000, 8, "Something is wrong with the log message's contents");
    public static final SVNErrorCode CL_UNNECESSARY_LOG_MESSAGE = new SVNErrorCode(205000, 9, "A log message was given where none was necessary");
    public static final SVNErrorCode CL_NO_EXTERNAL_MERGE_TOOL = new SVNErrorCode(205000, 10, "No external merge tool available");
    static /* synthetic */ Class class$org$tmatesoft$svn$core$SVNErrorCode;

    public static SVNErrorCode getErrorCode(int code) {
        SVNErrorCode errorCode = (SVNErrorCode)ourErrorCodes.get(new Integer(code));
        if (errorCode == null) {
            errorCode = UNKNOWN;
        }
        return errorCode;
    }

    protected SVNErrorCode(int category, int index, String description) {
        this.myCategory = category;
        this.myCode = category + index;
        this.myDescription = description;
        ourErrorCodes.put(new Integer(this.myCode), this);
    }

    public int getCode() {
        return this.myCode;
    }

    public int getCategory() {
        return this.myCategory;
    }

    public String getDescription() {
        return this.myDescription;
    }

    public int hashCode() {
        return this.myCode;
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != (class$org$tmatesoft$svn$core$SVNErrorCode == null ? (class$org$tmatesoft$svn$core$SVNErrorCode = SVNErrorCode.class$("org.tmatesoft.svn.core.SVNErrorCode")) : class$org$tmatesoft$svn$core$SVNErrorCode)) {
            return false;
        }
        return this.myCode == ((SVNErrorCode)o).myCode;
    }

    public boolean isAuthentication() {
        return this == RA_NOT_AUTHORIZED || this == RA_UNKNOWN_AUTH || this.getCategory() == 220000 || this.getCategory() == 215000;
    }

    private void writeObject(ObjectOutputStream os) throws IOException {
        os.writeInt(this.myCode);
    }

    private void readObject(ObjectInputStream is) throws IOException {
        this.myCode = is.readInt();
    }

    private Object readResolve() {
        return ourErrorCodes.get(new Integer(this.myCode));
    }

    public String toString() {
        return this.myCode + ": " + this.myDescription;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

