/*
 * Decompiled with CFR 0.152.
 */
package ttf.doocs.clnt;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.StringTokenizer;
import org.acplt.oncrpc.OncRpcClient;
import org.acplt.oncrpc.OncRpcClientAuthUnix;
import org.acplt.oncrpc.OncRpcException;
import org.acplt.oncrpc.OncRpcProgramNotRegisteredException;
import ttf.doocs.clnt.ENSinfo;
import ttf.doocs.clnt.EqAdr;
import ttf.doocs.clnt.EqCallSingleton;
import ttf.doocs.clnt.EqData;
import ttf.doocs.clnt.EqServices;
import ttf.doocs.clnt.ens_name_param;
import ttf.doocs.clnt.ens_name_results;
import ttf.doocs.clnt.time_t;

public class ENS_DB
extends EqServices {
    private String name;
    private ENSinfo info;
    private EqData tine;
    private long lastCall;
    private static int hostNumber = 0;
    public static String localApplication = null;
    private static int debug = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ENS_DB() {
        int flag = 1;
        EqCallSingleton eqCallSingleton = EqCallSingleton.getSingleton();
        synchronized (eqCallSingleton) {
            long actTime;
            if (uid_ == 0 && gid_ == 0 && this.lastCall + 10000L < (actTime = System.currentTimeMillis())) {
                groups_ = new int[0];
                String os = System.getProperty("os.name");
                String usr = System.getProperty("user.name");
                this.lastCall = actTime;
                flag = this.readfromProperty(usr);
                if (os.equals("SunOS") && flag == 1) {
                    flag = this.readfromSystem(usr, false);
                }
                if (os.equals("Linux") && flag == 1) {
                    flag = this.readfromSystem(usr, true);
                }
                if (flag == 1) {
                    flag = this.readfromENS(usr);
                }
                if (flag == 1) {
                    uid_ = -1;
                    gid_ = -1;
                }
                if (flag == 1) {
                    System.out.println("Error in reading ENS!!!");
                }
                System.out.println("ENS: user=" + usr + " --> UID=" + uid_ + ", GID=" + gid_);
            }
        }
    }

    public EqData find(String addr) {
        int len = tine_DB_.size();
        for (int i = 0; i < len; ++i) {
            ENS_DB ei = (ENS_DB)tine_DB_.get(i);
            if (ei.name.compareTo(addr) != 0) continue;
            return ei.tine;
        }
        return null;
    }

    public ENSinfo find(EqAdr ea) {
        ENSinfo info = null;
        int len = services_.size();
        String addr0 = new String(ea.facility());
        String addr = new String(ea.facility() + "/" + ea.device());
        String addr2 = new String(ea.facility() + "/" + ea.device() + "/" + ea.location());
        for (int i = 0; i < len; ++i) {
            ENS_DB ei = (ENS_DB)services_.get(i);
            if (ei.name.equals(addr0) && ei.info.server_mask == 1) {
                return ei.info;
            }
            if (!ei.name.equals(addr) || ei.info.server_mask != 2) continue;
            return ei.info;
        }
        if (debug != 0) {
            System.out.println("find: not in DB " + ea.show_adr());
        }
        return info;
    }

    public void append(String addr, EqData data) {
        ENS_DB ei = null;
        int len = tine_DB_.size();
        for (int i = 0; i < len; ++i) {
            ei = (ENS_DB)tine_DB_.get(i);
            if (!ei.name.equals(addr)) continue;
            return;
        }
        if (ei == null) {
            ei = new ENS_DB();
        }
        ei.tine = new EqData();
        ei.tine.copy_from(data);
        ei.name = new String(addr);
        tine_DB_.add(ei);
        if (debug != 0) {
            System.out.println("ADD to TINE DB " + ei.name);
        }
    }

    public void append(EqAdr ea, ENSinfo info) {
        if (info.server_mask == 0) {
            ENS_DB ei = new ENS_DB();
            ei.info = info;
            ei.info.server_mask = 1;
            ei.name = new String(ea.facility());
            services_.add(ei);
            if (debug != 0) {
                System.out.println("ADD services DB (msk=0)" + ei.name);
            }
        } else if (info.server_mask == 1) {
            ENS_DB ei = new ENS_DB();
            ei.info = info;
            ei.name = new String(ea.facility());
            services_.add(ei);
            if (debug != 0) {
                System.out.println("ADD services DB (msk=1)" + ei.name);
            }
        } else if (info.server_mask == 2) {
            ENS_DB ei = new ENS_DB();
            ei.info = info;
            ei.name = new String(ea.facility() + "/" + ea.device());
            services_.add(ei);
            if (debug != 0) {
                System.out.println("ADD services DB (msk=2)" + ei.name);
            }
        } else if (info.server_mask == 4) {
            ENS_DB ei = new ENS_DB();
            ei.info = info;
            ei.name = new String(ea.facility() + "/" + ea.device() + "/" + ea.location());
            services_.add(ei);
            if (debug != 0) {
                System.out.println("ADD services DB (msk=4)" + ei.name);
            }
        }
    }

    public void remove(EqAdr ea, ENSinfo info) {
        ENS_DB ei = new ENS_DB();
        int len = services_.size();
        if (debug != 0) {
            System.out.println("REMOVE from services DB" + ea.show_adr());
        }
        for (int i = 0; i < len; ++i) {
            ei = (ENS_DB)services_.get(i);
            if (info.server_mask == 2) {
                if (!ei.name.equals(ea.facility() + "/" + ea.device())) continue;
                services_.remove(i);
                break;
            }
            if (!ei.name.equals(ea.facility() + "/" + ea.device() + "/" + ea.location())) continue;
            services_.remove(i);
            break;
        }
    }

    public int get_uid() {
        if (uid_ == -1) {
            return 0;
        }
        return uid_;
    }

    public int get_gid() {
        if (gid_ == -1) {
            return 0;
        }
        return gid_;
    }

    public int[] get_groups() {
        return groups_;
    }

    public String get_localhost() {
        if (localhost_ == null) {
            try {
                localhost_ = new String(InetAddress.getLocalHost().toString());
            }
            catch (SecurityException e) {
                System.out.println("SecurityException " + e.getMessage());
                System.exit(0);
            }
            catch (UnknownHostException e) {
                System.out.println("UnknownHostException " + e.getMessage());
                System.exit(0);
            }
        }
        try {
            if (localApplication == null) {
                StackTraceElement[] ste = Thread.currentThread().getStackTrace();
                localApplication = ste.length > 0 ? new String(ste[ste.length - 1] + ",-1," + System.getProperty("os.name")) : new String("jdoocs,-1," + System.getProperty("os.name"));
                System.out.println(localhost_ + "," + localApplication);
            }
        }
        catch (Exception e) {
            localApplication = new String("jdoocs");
        }
        return localhost_ + "," + localApplication;
    }

    public String get_enshost(boolean tryNext) {
        if (ens_host_ != null && !tryNext) {
            return ens_host_;
        }
        String hosts = System.getProperty("ENSHOST");
        if (hosts == null || hosts.length() < 2) {
            hosts = "enshost:enssvr2:enssvr3:localhost";
        }
        String tmp = null;
        StringTokenizer pars = new StringTokenizer(hosts, ":");
        int len = pars.countTokens();
        tmp = pars.nextToken();
        if (!tryNext) {
            if (tmp == null) {
                tmp = "enshost";
            }
            ens_host_ = new String(tmp);
            return ens_host_;
        }
        String first = tmp;
        int idx = 0;
        if (hostNumber + 1 >= len) {
            hostNumber = 0;
        }
        while (pars.hasMoreTokens() && tryNext) {
            tmp = pars.nextToken();
            if (++idx <= hostNumber) continue;
            hostNumber = idx;
            break;
        }
        ens_host_ = tmp == null ? new String(first) : new String(tmp);
        return ens_host_;
    }

    private int readfromProperty(String usr) {
        String line = null;
        String auth = System.getProperty("AUTH");
        if (auth == null) {
            return 1;
        }
        System.out.println("Property: " + auth);
        StringTokenizer pars = new StringTokenizer(auth, ":");
        line = pars.nextToken();
        if (line == null) {
            return 1;
        }
        gid_ = Integer.valueOf(line);
        if (pars.hasMoreTokens()) {
            line = pars.nextToken();
            uid_ = Integer.valueOf(line);
        } else {
            uid_ = 0;
        }
        return 0;
    }

    private int readfromENS(String usr) {
        OncRpcClient client;
        ens_name_results result = null;
        float[] f1 = new float[2];
        int[] i1 = new int[2];
        time_t[] tm = new time_t[]{};
        byte[] str = new byte[80];
        String lh = this.get_localhost();
        String localhost = lh.substring(0, lh.indexOf(47));
        lh = new String("*winauth/" + usr + "/" + localhost + "/version2");
        ens_name_param params = new ens_name_param();
        EqData ed = new EqData();
        EqAdr ea = new EqAdr(lh);
        params.eq_data = ed.get_Block();
        params.eq_name = ea.EqName();
        result = new ens_name_results();
        localhost = this.get_enshost(false);
        OncRpcClientAuthUnix auth = new OncRpcClientAuthUnix(this.get_localhost(), 0, 0);
        try {
            client = OncRpcClient.newOncRpcClient(InetAddress.getByName(localhost), 541412947, 1, 6);
            client.setTimeout(3000);
            client.setAuth(auth);
            client.call(2, params, result);
            client.close();
        }
        catch (OncRpcProgramNotRegisteredException e) {
            System.out.println("OncRpcProgramNotRegisteredException " + e.getMessage());
            localhost = this.get_enshost(true);
            try {
                client = OncRpcClient.newOncRpcClient(InetAddress.getByName(localhost), 541412947, 1, 6);
                client.setTimeout(3000);
                client.setAuth(auth);
                client.call(2, params, result);
                client.close();
            }
            catch (OncRpcProgramNotRegisteredException ex) {
                System.out.println("OncRpcProgramNotRegisteredException " + ex.getMessage());
                return 1;
            }
            catch (OncRpcException ex) {
                System.out.println("OncRpcException " + ex.getMessage());
                return 1;
            }
            catch (IOException ex) {
                System.out.println("IOException " + ex.getMessage());
                return 1;
            }
        }
        catch (OncRpcException e) {
            System.out.println("OncRpcException " + e.getMessage());
            return 1;
        }
        catch (IOException e) {
            System.out.println("IOException " + e.getMessage());
            return 1;
        }
        ed = new EqData(result.eq_data);
        if (ed.error() == 0 && ed.type() == 103) {
            if (ed.length() > 1) {
                System.out.println("ENS doesn't support auth call !!!");
                return 1;
            }
            ed.get_ustr(i1, f1, tm, str, 0);
            String st = new String(str).trim();
            uid_ = (int)f1[0];
            gid_ = (int)f1[1];
            if (uid_ == 0 && gid_ == 0) {
                uid_ = -1;
                gid_ = -1;
            }
            try {
                if (st.equals(new String(usr + ":" + localhost))) {
                    System.out.println("no groups entries");
                } else {
                    int counter = 0;
                    StringTokenizer pars = new StringTokenizer(st, " ");
                    groups_ = new int[pars.countTokens()];
                    while (pars.hasMoreTokens()) {
                        ENS_DB.groups_[counter] = Integer.valueOf(pars.nextToken());
                        ++counter;
                    }
                }
            }
            catch (NumberFormatException e) {
                System.out.println(usr + ":" + localhost + " != " + st);
                System.out.println("IOException " + e.getMessage());
                return 1;
            }
        }
        return 0;
    }

    public int readfromSystem(String usr, boolean op) {
        String line = null;
        int counter = 0;
        String tmp = null;
        String program = op ? "/usr/bin/id" : "/usr/xpg4/bin/id";
        try {
            System.out.println("program is " + program + ", user " + usr);
            Process process = Runtime.getRuntime().exec(program + " -G " + usr);
            BufferedReader in = new BufferedReader(new InputStreamReader(process.getInputStream()));
            line = in.readLine().trim();
            line = line.concat(" \u0000");
            StringTokenizer pars = new StringTokenizer(line, " ");
            tmp = pars.nextToken();
            groups_ = pars.countTokens() > 16 ? new int[16] : new int[pars.countTokens()];
            while (pars.hasMoreTokens()) {
                if (tmp != null) {
                    ENS_DB.groups_[counter] = Integer.valueOf(tmp);
                    if (++counter > 16) break;
                }
                tmp = pars.nextToken();
            }
            if (!Character.isDigit((line = (in = new BufferedReader(new InputStreamReader((process = Runtime.getRuntime().exec(program + " -g " + usr)).getInputStream()))).readLine()).charAt(0))) {
                return 1;
            }
            gid_ = Integer.valueOf(line);
            process = Runtime.getRuntime().exec(program + " -u " + usr);
            in = new BufferedReader(new InputStreamReader(process.getInputStream()));
            line = in.readLine();
            uid_ = Integer.valueOf(line);
        }
        catch (SecurityException e) {
            System.out.println("SecurityException " + e.getMessage());
            return 1;
        }
        catch (Exception e) {
            System.out.println("IOException " + e.getMessage());
            return 1;
        }
        return 0;
    }
}

