/*
 * Decompiled with CFR 0.152.
 */
package ttf.doocs.clnt;

import java.io.StringReader;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArgParser {
    private StringReader theStream;
    private char nextChar;
    private char currentChar;
    private boolean backSlashed;
    private int width;
    private int height;

    public ArgParser(String s) throws NumberFormatException {
        if (s == null || s.length() == 0) {
            throw new NumberFormatException("Empty argument, you must specify a value");
        }
        this.theStream = new StringReader(s);
        this.width = 0;
        this.height = 0;
        this.read_char();
        this.read_char();
    }

    public boolean parse_boolean() throws NumberFormatException {
        String w = this.read_word();
        if (w != null) {
            return this.get_boolean(w);
        }
        throw new NumberFormatException("boolean value expected.");
    }

    public boolean[] parse_boolean_array() throws NumberFormatException {
        Vector<String> tmp = this.parse_array();
        boolean[] ret = new boolean[tmp.size()];
        for (int l = 0; l < ret.length; ++l) {
            ret[l] = this.get_boolean(tmp.get(l));
        }
        return ret;
    }

    public boolean[] parse_boolean_image() throws NumberFormatException {
        Vector<String> tmp = this.parse_image();
        boolean[] ret = new boolean[this.width * this.height];
        for (int l = 0; l < ret.length; ++l) {
            ret[l] = this.get_boolean(tmp.get(l));
        }
        return ret;
    }

    public byte parse_char() throws NumberFormatException {
        String w = this.read_word();
        if (w != null) {
            return this.get_char(w);
        }
        throw new NumberFormatException("char value expected.");
    }

    public byte[] parse_char_array() throws NumberFormatException {
        Vector<String> tmp = this.parse_array();
        byte[] ret = new byte[tmp.size()];
        for (int l = 0; l < ret.length; ++l) {
            ret[l] = this.get_char(tmp.get(l));
        }
        return ret;
    }

    public byte[] parse_char_image() throws NumberFormatException {
        Vector<String> tmp = this.parse_image();
        byte[] ret = new byte[this.width * this.height];
        for (int l = 0; l < ret.length; ++l) {
            ret[l] = this.get_char(tmp.get(l));
        }
        return ret;
    }

    public short parse_uchar() throws NumberFormatException {
        String w = this.read_word();
        if (w != null) {
            return this.get_uchar(w);
        }
        throw new NumberFormatException("unsigned char value expected.");
    }

    public short[] parse_uchar_array() throws NumberFormatException {
        Vector<String> tmp = this.parse_array();
        short[] ret = new short[tmp.size()];
        for (int l = 0; l < ret.length; ++l) {
            ret[l] = this.get_uchar(tmp.get(l));
        }
        return ret;
    }

    public short[] parse_uchar_image() throws NumberFormatException {
        Vector<String> tmp = this.parse_image();
        short[] ret = new short[this.width * this.height];
        for (int l = 0; l < ret.length; ++l) {
            ret[l] = this.get_uchar(tmp.get(l));
        }
        return ret;
    }

    public short parse_short() throws NumberFormatException {
        String w = this.read_word();
        if (w != null) {
            return this.get_short(w);
        }
        throw new NumberFormatException("short value expected.");
    }

    public short[] parse_short_array() throws NumberFormatException {
        Vector<String> tmp = this.parse_array();
        short[] ret = new short[tmp.size()];
        for (int l = 0; l < ret.length; ++l) {
            ret[l] = this.get_short(tmp.get(l));
        }
        return ret;
    }

    public short[] parse_short_image() throws NumberFormatException {
        Vector<String> tmp = this.parse_image();
        short[] ret = new short[this.width * this.height];
        for (int l = 0; l < ret.length; ++l) {
            ret[l] = this.get_short(tmp.get(l));
        }
        return ret;
    }

    public int parse_ushort() throws NumberFormatException {
        String w = this.read_word();
        if (w != null) {
            return this.get_ushort(w);
        }
        throw new NumberFormatException("unsigned short value expected.");
    }

    public int[] parse_ushort_array() throws NumberFormatException {
        Vector<String> tmp = this.parse_array();
        int[] ret = new int[tmp.size()];
        for (int l = 0; l < ret.length; ++l) {
            ret[l] = this.get_ushort(tmp.get(l));
        }
        return ret;
    }

    public int[] parse_ushort_image() throws NumberFormatException {
        Vector<String> tmp = this.parse_image();
        int[] ret = new int[this.width * this.height];
        for (int l = 0; l < ret.length; ++l) {
            ret[l] = this.get_ushort(tmp.get(l));
        }
        return ret;
    }

    public int parse_long() throws NumberFormatException {
        String w = this.read_word();
        if (w != null) {
            return this.get_long(w);
        }
        throw new NumberFormatException("Integer value expected.");
    }

    public int[] parse_long_array() throws NumberFormatException {
        Vector<String> tmp = this.parse_array();
        int[] ret = new int[tmp.size()];
        for (int l = 0; l < ret.length; ++l) {
            ret[l] = this.get_long(tmp.get(l));
        }
        return ret;
    }

    public int[] parse_long_image() throws NumberFormatException {
        Vector<String> tmp = this.parse_image();
        int[] ret = new int[this.width * this.height];
        for (int l = 0; l < ret.length; ++l) {
            ret[l] = this.get_long(tmp.get(l));
        }
        return ret;
    }

    public long parse_ulong() throws NumberFormatException {
        String w = this.read_word();
        if (w != null) {
            return this.get_ulong(w);
        }
        throw new NumberFormatException("unsigned long value expected.");
    }

    public long[] parse_ulong_array() throws NumberFormatException {
        Vector<String> tmp = this.parse_array();
        long[] ret = new long[tmp.size()];
        for (int l = 0; l < ret.length; ++l) {
            ret[l] = this.get_ulong(tmp.get(l));
        }
        return ret;
    }

    public long[] parse_ulong_image() throws NumberFormatException {
        Vector<String> tmp = this.parse_image();
        long[] ret = new long[this.width * this.height];
        for (int l = 0; l < ret.length; ++l) {
            ret[l] = this.get_ulong(tmp.get(l));
        }
        return ret;
    }

    public float parse_float() throws NumberFormatException {
        String w = this.read_word();
        if (w != null) {
            return Float.parseFloat(w);
        }
        throw new NumberFormatException("float value expected.");
    }

    public float[] parse_float_array() throws NumberFormatException {
        Vector<String> tmp = this.parse_array();
        float[] ret = new float[tmp.size()];
        for (int l = 0; l < ret.length; ++l) {
            ret[l] = Float.parseFloat(tmp.get(l));
        }
        return ret;
    }

    public float[] parse_float_image() throws NumberFormatException {
        Vector<String> tmp = this.parse_image();
        float[] ret = new float[this.width * this.height];
        for (int l = 0; l < ret.length; ++l) {
            ret[l] = Float.parseFloat(tmp.get(l));
        }
        return ret;
    }

    public double parse_double() throws NumberFormatException {
        String w = this.read_word();
        if (w != null) {
            return Double.parseDouble(w);
        }
        throw new NumberFormatException("double value expected.");
    }

    public double[] parse_double_array() throws NumberFormatException {
        Vector<String> tmp = this.parse_array();
        double[] ret = new double[tmp.size()];
        for (int l = 0; l < ret.length; ++l) {
            ret[l] = Double.parseDouble(tmp.get(l));
        }
        return ret;
    }

    public double[] parse_double_image() throws NumberFormatException {
        Vector<String> tmp = this.parse_image();
        double[] ret = new double[this.width * this.height];
        for (int l = 0; l < ret.length; ++l) {
            ret[l] = Double.parseDouble(tmp.get(l));
        }
        return ret;
    }

    public String parse_string() throws NumberFormatException {
        String w = this.read_word();
        if (w != null) {
            return w;
        }
        throw new NumberFormatException("string expected.");
    }

    public String[] parse_string_array() throws NumberFormatException {
        Vector<String> tmp = this.parse_array();
        String[] ret = new String[tmp.size()];
        for (int l = 0; l < ret.length; ++l) {
            ret[l] = tmp.get(l);
        }
        return ret;
    }

    public String[] parse_string_image() throws NumberFormatException {
        Vector<String> tmp = this.parse_image();
        String[] ret = new String[this.width * this.height];
        for (int l = 0; l < ret.length; ++l) {
            ret[l] = tmp.get(l);
        }
        return ret;
    }

    public int get_image_width() {
        return this.width;
    }

    public int get_image_height() {
        return this.height;
    }

    private void read_char() {
        this.backSlashed = false;
        try {
            int c = this.theStream.read();
            this.currentChar = this.nextChar;
            this.nextChar = c < 0 ? (char)'\u0000' : (char)c;
        }
        catch (Exception e) {
            this.nextChar = '\u0000';
            this.currentChar = '\u0000';
        }
        if (this.currentChar == '\\' && this.nextChar == '\"') {
            this.read_char();
            this.backSlashed = true;
        }
    }

    private void jump_space() {
        while (this.currentChar <= ' ' && this.currentChar > '\u0000') {
            this.read_char();
        }
    }

    private String read_word() throws NumberFormatException {
        StringBuffer ret_word = new StringBuffer();
        this.jump_space();
        if (this.currentChar == ',' || this.currentChar == '[' || this.currentChar == ']') {
            ret_word.append(this.currentChar);
            this.read_char();
            return ret_word.toString();
        }
        if (this.currentChar == '\"' && !this.backSlashed) {
            this.read_char();
            while ((this.currentChar != '\"' || this.backSlashed) && this.currentChar != '\u0000' && this.currentChar != '\n') {
                ret_word.append(this.currentChar);
                this.read_char();
            }
            if (this.currentChar == '\u0000' || this.currentChar == '\n') {
                NumberFormatException e = new NumberFormatException("Unterminated string.");
                throw e;
            }
            this.read_char();
            return ret_word.toString();
        }
        while (this.currentChar > ' ' && this.currentChar != '[' && this.currentChar != ']' && this.currentChar != ',') {
            ret_word.append(this.currentChar);
            this.read_char();
        }
        if (ret_word.length() == 0) {
            return null;
        }
        return ret_word.toString();
    }

    private void jump_sep(String sep) throws NumberFormatException {
        String w = this.read_word();
        if (w == null) {
            throw new NumberFormatException("Separator " + sep + " expected.");
        }
        if (!w.equals(sep)) {
            throw new NumberFormatException("Separator " + sep + " expected.");
        }
    }

    private boolean is_array_end() {
        if (this.currentChar == '\u0000') {
            return true;
        }
        return this.currentChar == ']';
    }

    private Vector<String> parse_array() throws NumberFormatException {
        Vector<String> ret = new Vector<String>();
        boolean isClosed = false;
        this.jump_space();
        if (this.currentChar == '[') {
            isClosed = true;
            this.jump_sep("[");
            this.jump_space();
        }
        while (!this.is_array_end()) {
            ret.add(this.read_word());
            this.jump_space();
            if (this.is_array_end()) continue;
            this.jump_sep(",");
            this.jump_space();
        }
        if (isClosed) {
            this.jump_sep("]");
        }
        return ret;
    }

    private Vector<String> parse_image() throws NumberFormatException {
        Vector<String> ret = this.parse_array();
        this.jump_space();
        this.width = ret.size();
        this.height = 1;
        while (this.currentChar == '[') {
            Vector<String> tmp = this.parse_array();
            if (tmp.size() != this.width) {
                throw new NumberFormatException("All lines in an image must have the same size.");
            }
            ret.addAll(tmp);
            ++this.height;
            this.jump_space();
        }
        return ret;
    }

    private boolean get_boolean(String w) throws NumberFormatException {
        if (w.equalsIgnoreCase("true") || w.equalsIgnoreCase("1")) {
            return true;
        }
        if (w.equalsIgnoreCase("false") || w.equalsIgnoreCase("0")) {
            return false;
        }
        throw new NumberFormatException("invalid boolean value " + w + " [true,false or 0,1].");
    }

    private long get_number(String w, String type, long min, long max) throws NumberFormatException {
        long ret;
        int conv_base = 10;
        if (w.startsWith("0x") || w.startsWith("0X")) {
            w = w.substring(2);
            conv_base = 16;
        }
        if ((ret = Long.parseLong(w, conv_base)) < min || ret > max) {
            throw new NumberFormatException(type + " value " + ret + " out of range [" + min + "," + max + "].");
        }
        return ret;
    }

    private byte get_char(String w) throws NumberFormatException {
        if (w.startsWith("'")) {
            if (w.endsWith("'") && w.length() == 3) {
                return (byte)w.charAt(1);
            }
            throw new NumberFormatException("Invalid char value for input string " + w);
        }
        return (byte)this.get_number(w, "char", -128L, 127L);
    }

    private short get_uchar(String w) throws NumberFormatException {
        return (short)this.get_number(w, "unsigned char", 0L, 255L);
    }

    private short get_short(String w) throws NumberFormatException {
        return (short)this.get_number(w, "short", -32768L, 32767L);
    }

    private int get_ushort(String w) throws NumberFormatException {
        return (int)this.get_number(w, "unsigned short", 0L, 65535L);
    }

    private int get_long(String w) throws NumberFormatException {
        return (int)this.get_number(w, "long", Integer.MIN_VALUE, Integer.MAX_VALUE);
    }

    private long get_ulong(String w) throws NumberFormatException {
        return this.get_number(w, "unsigned long", 0L, 0xFFFFFFFFL);
    }

    private static void print_array(boolean[] a) {
        System.out.print("Length=" + a.length + ": ");
        for (int i = 0; i < a.length; ++i) {
            System.out.print(a[i]);
            System.out.print(" ");
        }
        System.out.println();
    }

    private static void print_array(byte[] a) {
        System.out.print("Length=" + a.length + ": ");
        for (int i = 0; i < a.length; ++i) {
            System.out.print(a[i]);
            System.out.print(" ");
        }
        System.out.println();
    }

    private static void print_array(short[] a) {
        System.out.print("Length=" + a.length + ": ");
        for (int i = 0; i < a.length; ++i) {
            System.out.print(a[i]);
            System.out.print(" ");
        }
        System.out.println();
    }

    private static void print_array(int[] a) {
        System.out.print("Length=" + a.length + ": ");
        for (int i = 0; i < a.length; ++i) {
            System.out.print(a[i]);
            System.out.print(" ");
        }
        System.out.println();
    }

    private static void print_array(float[] a) {
        System.out.print("Length=" + a.length + ": ");
        for (int i = 0; i < a.length; ++i) {
            System.out.print(a[i]);
            System.out.print(" ");
        }
        System.out.println();
    }

    private static void print_array(double[] a) {
        System.out.print("Length=" + a.length + ": ");
        for (int i = 0; i < a.length; ++i) {
            System.out.print(a[i]);
            System.out.print(" ");
        }
        System.out.println();
    }

    private static void print_array(String[] a) {
        System.out.print("Length=" + a.length + ": ");
        for (int i = 0; i < a.length; ++i) {
            System.out.print(a[i]);
            System.out.print(" ");
        }
        System.out.println();
    }
}

