/*
 * Decompiled with CFR 0.152.
 */
package gov.aps.jca.dbr;

import gov.aps.jca.CAStatusException;
import gov.aps.jca.dbr.DBR;
import gov.aps.jca.dbr.DBRType;
import gov.aps.jca.dbr.DBR_Double;
import gov.aps.jca.dbr.STS;
import gov.aps.jca.dbr.Severity;
import gov.aps.jca.dbr.Status;
import java.io.PrintStream;

public class DBR_STS_Double
extends DBR_Double
implements STS {
    public static final DBRType TYPE = new DBRType("DBR_STS_DOUBLE", 13, DBR_STS_Double.class);
    protected Status _status;
    protected Severity _severity;

    public DBR_STS_Double() {
        this(1);
    }

    public DBR_STS_Double(int count) {
        this(new double[count]);
    }

    public DBR_STS_Double(double[] value) {
        super(value);
    }

    public DBRType getType() {
        return TYPE;
    }

    public Status getStatus() {
        return this._status;
    }

    public void setStatus(int status) {
        this.setStatus(Status.forValue(status));
    }

    public void setStatus(Status status) {
        if (status == null) {
            throw new IllegalArgumentException("Illegal status: null");
        }
        this._status = status;
    }

    public Severity getSeverity() {
        return this._severity;
    }

    public void setSeverity(int severity) {
        this.setSeverity(Severity.forValue(severity));
    }

    public void setSeverity(Severity severity) {
        if (severity == null) {
            throw new IllegalArgumentException("Illegal severity: null");
        }
        this._severity = severity;
    }

    public void printInfo(PrintStream out) {
        super.printInfo(out);
        out.println("STATUS   : " + this.getStatus().getName());
        out.println("SEVERITY : " + this.getSeverity().getName());
    }

    public DBR convert(DBRType convertType) throws CAStatusException {
        DBR dbr = super.convert(convertType);
        if (dbr.isSTS()) {
            STS sts = (STS)((Object)dbr);
            sts.setSeverity(this._severity);
            sts.setStatus(this._status);
        }
        return dbr;
    }
}

