/*
 * Decompiled with CFR 0.152.
 */
package gov.aps.jca.dbr;

import gov.aps.jca.CAStatusException;
import gov.aps.jca.dbr.DBR;
import gov.aps.jca.dbr.DBRType;
import gov.aps.jca.dbr.DBR_TIME_Short;
import gov.aps.jca.dbr.GR;
import gov.aps.jca.dbr.TimeStamp;
import java.io.PrintStream;

public class DBR_GR_Short
extends DBR_TIME_Short
implements GR {
    public static final DBRType TYPE = new DBRType("DBR_GR_SHORT", 22, DBR_GR_Short.class);
    protected String _unit = "";
    protected Short _udl = ZEROS;
    protected Short _ldl = ZEROS;
    protected Short _ual = ZEROS;
    protected Short _uwl = ZEROS;
    protected Short _lwl = ZEROS;
    protected Short _lal = ZEROS;

    public DBR_GR_Short() {
        this(1);
    }

    public DBR_GR_Short(int count) {
        this(new short[count]);
    }

    public DBR_GR_Short(short[] value) {
        super(value);
    }

    public DBRType getType() {
        return TYPE;
    }

    public String getUnits() {
        return this._unit;
    }

    public void setUnits(String unit) {
        this._unit = unit;
    }

    public Number getUpperDispLimit() {
        return this._udl;
    }

    public void setUpperDispLimit(Number limit) {
        this._udl = new Short(limit.shortValue());
    }

    public Number getLowerDispLimit() {
        return this._ldl;
    }

    public void setLowerDispLimit(Number limit) {
        this._ldl = new Short(limit.shortValue());
    }

    public Number getUpperAlarmLimit() {
        return this._ual;
    }

    public void setUpperAlarmLimit(Number limit) {
        this._ual = new Short(limit.shortValue());
    }

    public Number getUpperWarningLimit() {
        return this._uwl;
    }

    public void setUpperWarningLimit(Number limit) {
        this._uwl = new Short(limit.shortValue());
    }

    public Number getLowerWarningLimit() {
        return this._lwl;
    }

    public void setLowerWarningLimit(Number limit) {
        this._lwl = new Short(limit.shortValue());
    }

    public Number getLowerAlarmLimit() {
        return this._lal;
    }

    public void setLowerAlarmLimit(Number limit) {
        this._lal = new Short(limit.shortValue());
    }

    public void printInfo(PrintStream out) {
        super.printInfo(out);
        out.println("UNITS    : " + this.getUnits());
        out.println("UDL      : " + this.getUpperDispLimit());
        out.println("LDL      : " + this.getLowerDispLimit());
        out.println("UAL      : " + this.getUpperAlarmLimit());
        out.println("UWL      : " + this.getUpperWarningLimit());
        out.println("LWL      : " + this.getLowerWarningLimit());
        out.println("LAL      : " + this.getLowerAlarmLimit());
    }

    public DBR convert(DBRType convertType) throws CAStatusException {
        DBR dbr = super.convert(convertType);
        if (dbr.isGR()) {
            GR gr = (GR)((Object)dbr);
            gr.setUnits(this.getUnits());
            gr.setUpperDispLimit(this.getUpperDispLimit());
            gr.setLowerDispLimit(this.getLowerDispLimit());
            gr.setUpperAlarmLimit(this.getUpperAlarmLimit());
            gr.setUpperWarningLimit(this.getUpperWarningLimit());
            gr.setLowerWarningLimit(this.getLowerWarningLimit());
            gr.setLowerAlarmLimit(this.getLowerAlarmLimit());
        }
        return dbr;
    }

    public TimeStamp getTimeStamp() {
        return super.getTimeStamp();
    }

    public void setTimeStamp(TimeStamp stamp) {
        super.setTimeStamp(stamp);
    }
}

