/*
 * Decompiled with CFR 0.152.
 */
package gov.aps.jca.dbr;

import gov.aps.jca.CAStatusException;
import gov.aps.jca.dbr.DBR;
import gov.aps.jca.dbr.DBRType;
import gov.aps.jca.dbr.DBR_TIME_Double;
import gov.aps.jca.dbr.GR;
import gov.aps.jca.dbr.PRECISION;
import gov.aps.jca.dbr.TimeStamp;
import java.io.PrintStream;

public class DBR_GR_Double
extends DBR_TIME_Double
implements GR,
PRECISION {
    public static final DBRType TYPE = new DBRType("DBR_GR_DOUBLE", 27, DBR_GR_Double.class);
    protected String _unit = "";
    protected Double _udl = ZEROD;
    protected Double _ldl = ZEROD;
    protected Double _ual = ZEROD;
    protected Double _uwl = ZEROD;
    protected Double _lwl = ZEROD;
    protected Double _lal = ZEROD;
    protected short _precision;

    public DBR_GR_Double() {
        this(1);
    }

    public DBR_GR_Double(int count) {
        this(new double[count]);
    }

    public DBR_GR_Double(double[] value) {
        super(value);
    }

    public DBRType getType() {
        return TYPE;
    }

    public short getPrecision() {
        return this._precision;
    }

    public void setPrecision(short prec) {
        this._precision = prec;
    }

    public String getUnits() {
        return this._unit;
    }

    public void setUnits(String unit) {
        this._unit = unit;
    }

    public Number getUpperDispLimit() {
        return this._udl;
    }

    public void setUpperDispLimit(Number limit) {
        this._udl = new Double(limit.doubleValue());
    }

    public Number getLowerDispLimit() {
        return this._ldl;
    }

    public void setLowerDispLimit(Number limit) {
        this._ldl = new Double(limit.doubleValue());
    }

    public Number getUpperAlarmLimit() {
        return this._ual;
    }

    public void setUpperAlarmLimit(Number limit) {
        this._ual = new Double(limit.doubleValue());
    }

    public Number getUpperWarningLimit() {
        return this._uwl;
    }

    public void setUpperWarningLimit(Number limit) {
        this._uwl = new Double(limit.doubleValue());
    }

    public Number getLowerWarningLimit() {
        return this._lwl;
    }

    public void setLowerWarningLimit(Number limit) {
        this._lwl = new Double(limit.doubleValue());
    }

    public Number getLowerAlarmLimit() {
        return this._lal;
    }

    public void setLowerAlarmLimit(Number limit) {
        this._lal = new Double(limit.doubleValue());
    }

    public void printInfo(PrintStream out) {
        super.printInfo(out);
        out.println("PRECISION: " + this.getPrecision());
        out.println("UNITS    : " + this.getUnits());
        out.println("UDL      : " + this.getUpperDispLimit());
        out.println("LDL      : " + this.getLowerDispLimit());
        out.println("UAL      : " + this.getUpperAlarmLimit());
        out.println("UWL      : " + this.getUpperWarningLimit());
        out.println("LWL      : " + this.getLowerWarningLimit());
        out.println("LAL      : " + this.getLowerAlarmLimit());
    }

    public DBR convert(DBRType convertType) throws CAStatusException {
        DBR dbr = super.convert(convertType);
        if (dbr.isGR()) {
            GR gr = (GR)((Object)dbr);
            gr.setUnits(this.getUnits());
            gr.setUpperDispLimit(this.getUpperDispLimit());
            gr.setLowerDispLimit(this.getLowerDispLimit());
            gr.setUpperAlarmLimit(this.getUpperAlarmLimit());
            gr.setUpperWarningLimit(this.getUpperWarningLimit());
            gr.setLowerWarningLimit(this.getLowerWarningLimit());
            gr.setLowerAlarmLimit(this.getLowerAlarmLimit());
        }
        if (dbr.isPRECSION()) {
            PRECISION prec = (PRECISION)((Object)dbr);
            prec.setPrecision(this.getPrecision());
        }
        return dbr;
    }

    public TimeStamp getTimeStamp() {
        return super.getTimeStamp();
    }

    public void setTimeStamp(TimeStamp stamp) {
        super.setTimeStamp(stamp);
    }
}

