/*
 * Decompiled with CFR 0.152.
 */
package gov.aps.jca.cas;

import gov.aps.jca.CAException;
import gov.aps.jca.CAStatus;
import gov.aps.jca.cas.ProcessVariable;
import gov.aps.jca.cas.ProcessVariableReadCallback;
import gov.aps.jca.cas.ProcessVariableWriteCallback;
import gov.aps.jca.cas.ServerMonitor;
import gov.aps.jca.dbr.DBR;
import java.io.PrintStream;
import java.util.Map;
import java.util.TreeMap;

public class ServerChannel {
    protected ProcessVariable processVariable;
    protected int sid;
    protected int cid;
    protected Map monitors;
    protected boolean destroyed = false;

    public ServerChannel(ProcessVariable processVariable, int cid, int sid, String userName, String hostName) {
        if (processVariable == null) {
            throw new IllegalArgumentException("non null process variable expected.");
        }
        this.cid = cid;
        this.sid = sid;
        this.processVariable = processVariable;
        this.monitors = new TreeMap();
        processVariable.registerChannel(this);
    }

    public ProcessVariable getProcessVariable() {
        return this.processVariable;
    }

    public int getCID() {
        return this.cid;
    }

    public int getSID() {
        return this.sid;
    }

    public CAStatus read(DBR value, ProcessVariableReadCallback asyncReadCallback) throws CAException {
        return this.processVariable.read(value, asyncReadCallback);
    }

    public CAStatus write(DBR value, ProcessVariableWriteCallback asyncWriteCallback) throws CAException {
        return this.processVariable.write(value, asyncWriteCallback);
    }

    public boolean readAccess() {
        return true;
    }

    public boolean writeAccess() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerMonitor(ServerMonitor monitor) {
        Map map = this.monitors;
        synchronized (map) {
            this.monitors.put(new Integer(monitor.getIOID()), monitor);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterMonitor(ServerMonitor monitor) {
        Map map = this.monitors;
        synchronized (map) {
            this.monitors.remove(new Integer(monitor.getIOID()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServerMonitor getMonitor(int ioid) {
        Map map = this.monitors;
        synchronized (map) {
            return (ServerMonitor)this.monitors.get(new Integer(ioid));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroyAllMonitors() {
        ServerMonitor[] sms;
        Map map = this.monitors;
        synchronized (map) {
            if (this.monitors.size() == 0) {
                return;
            }
            sms = new ServerMonitor[this.monitors.size()];
            this.monitors.values().toArray(sms);
        }
        for (int i = 0; i < sms.length; ++i) {
            sms[i].destroy();
        }
    }

    public synchronized void destroy() {
        if (this.destroyed) {
            return;
        }
        this.destroyed = true;
        this.destroyAllMonitors();
        this.processVariable.unregisterChannel(this);
    }

    public void printInfo() throws IllegalStateException {
        this.printInfo(System.out);
    }

    public void printInfo(PrintStream out) throws IllegalStateException {
        out.println("CLASS        : " + this.getClass().getName());
        out.println("PV           : " + this.processVariable);
        out.println("READ ACCESS  : " + this.readAccess());
        out.println("WRITE ACCESS : " + this.writeAccess());
    }
}

