/*
 * Decompiled with CFR 0.152.
 */
package daq;

import daq.RunCtlTags;
import daq.bit_descr;
import daq.chan_descr;
import daq.dim_descr;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Vector;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class chan_descriptions
extends DefaultHandler
implements RunCtlTags {
    public Vector<chan_descr> chans;
    private int error;
    private chan_descr chan;
    private dim_descr dims;
    private bit_descr bits;
    boolean rootf;
    boolean chanf;
    boolean stream;
    boolean ev_type;
    boolean count;
    boolean dtype;
    boolean prop_name;
    boolean daq_name;
    boolean prop_desc;
    boolean units;
    boolean max_size;
    boolean bit;
    boolean bit_name;
    boolean bit_desc;
    boolean dim;
    boolean dim_name;
    boolean dim_desc;
    boolean dim_units;
    boolean sb_name;
    private String Content;
    private int conv_error = 0;
    private String input_str = null;

    public chan_descriptions(String string) {
        this.input_str = string;
    }

    public int parse_chan_descr(String string) {
        this.input_str = string;
        return this.parse_chan_descr();
    }

    public void print(int n) {
        int n2 = n;
        int n3 = n;
        if (n < 0) {
            n2 = 0;
        }
        if (this.chans != null && this.chans.size() > 0) {
            n3 = n < 0 ? this.chans.size() : ++n3;
            for (int i = n2; i < n3; ++i) {
                Object object;
                int n4;
                chan_descr chan_descr2 = this.chans.elementAt(i);
                System.out.println("--------------[" + i + "]-----------------");
                System.out.println(" stream   : " + chan_descr2.stream);
                int n5 = chan_descr2.ev_type;
                boolean bl = false;
                for (n4 = 0; n4 < 32; ++n4) {
                    if ((n5 >> n4 & 1) == 0) continue;
                    if (!bl) {
                        System.out.print("event types: (" + chan_descr2.ev_type + ")");
                    }
                    System.out.print(" " + event_types_a[n4][0]);
                }
                System.out.println("");
                n5 = chan_descr2.dtype;
                bl = false;
                for (n4 = 0; n4 < 32; ++n4) {
                    if ((n5 >> n4 & 1) == 0) continue;
                    if (!bl) {
                        System.out.print("data type: (" + chan_descr2.dtype + ")");
                    }
                    System.out.print(" " + sblock_types_a[n4][0]);
                }
                System.out.println("");
                System.out.println("\tcount  :" + chan_descr2.count);
                System.out.println("\tprop   :" + chan_descr2.prop_name);
                System.out.println("\tname   :" + chan_descr2.daq_name);
                System.out.println("\tdesc   :" + chan_descr2.prop_desc);
                System.out.println("\tunits  :" + chan_descr2.units);
                System.out.println("\tmax_sz :" + chan_descr2.max_size);
                if (chan_descr2.nbits != 0) {
                    System.out.println("\t\t# bits :" + chan_descr2.nbits);
                    for (n4 = 0; n4 < chan_descr2.bits.size(); ++n4) {
                        object = chan_descr2.bits.elementAt(n4);
                        System.out.println("\t\tbit    : " + ((bit_descr)object).bit);
                        System.out.println("\t\tname   : " + ((bit_descr)object).bit_name);
                        System.out.println("\t\tdesc   : " + ((bit_descr)object).bit_desc);
                    }
                } else if (chan_descr2.bits != null && chan_descr2.bits.size() != 0) {
                    System.out.println("ERROR: bits = 0, but bits.size() > 0");
                }
                if (chan_descr2.ndims != 0) {
                    System.out.println("\t\t# dims : " + chan_descr2.ndims);
                    for (n4 = 0; n4 < chan_descr2.dims.size(); ++n4) {
                        object = chan_descr2.dims.elementAt(n4);
                        System.out.println("\t\tid     : " + ((dim_descr)object).dim);
                        System.out.println("\t\tname   : " + ((dim_descr)object).dim_name);
                        System.out.println("\t\tdesc   : " + ((dim_descr)object).dim_desc);
                        System.out.println("\t\tunits  : " + ((dim_descr)object).units);
                    }
                    continue;
                }
                if (chan_descr2.dims == null || chan_descr2.dims.size() == 0) continue;
                System.out.println("ERROR: dims = 0, but dims.size() > 0");
            }
        } else {
            System.out.println("No descriptions found");
        }
    }

    public void startDocument() throws SAXException {
        this.chans = null;
        this.chan = null;
        this.dims = null;
        this.bits = null;
    }

    public void endDocument() throws SAXException {
        this.rootf = true;
        this.chanf = false;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        int n;
        if (string3.equalsIgnoreCase(TTF2_CHAN_DESCR_TAGS[0])) {
            this.rootf = true;
            this.chanf = false;
            this.chans = new Vector();
            this.chan = null;
            return;
        }
        if (this.rootf && string3.equalsIgnoreCase(TTF2_CHAN_DESCR_TAGS[1])) {
            this.chanf = true;
            this.chan = new chan_descr();
            this.chan.stream = 0;
            this.chan.ev_type = 0;
            this.chan.count = 0;
            this.chan.dtype = 0;
            this.chan.prop_name = null;
            this.chan.daq_name = null;
            this.chan.prop_desc = null;
            this.chan.units = null;
            this.chan.max_size = 0;
            this.chan.nbits = 0;
            this.chan.bits = null;
            this.chan.ndims = 0;
            this.chan.dims = null;
            this.chan.sb_name = null;
            this.stream = false;
            this.ev_type = false;
            this.count = false;
            this.dtype = false;
            this.prop_name = false;
            this.daq_name = false;
            this.prop_desc = false;
            this.units = false;
            this.dim_units = false;
            this.max_size = false;
            this.bit = false;
            this.bit_name = false;
            this.bit_desc = false;
            this.dim = false;
            this.dim_name = false;
            this.dim_desc = false;
            this.dim_units = false;
            this.sb_name = false;
            return;
        }
        if (this.dim) {
            if (this.chan.dims == null) {
                this.chan.dims = new Vector();
            }
            this.dims = new dim_descr();
            this.chan.dims.add(this.dims);
            ++this.chan.ndims;
            n = this.get_int(this.Content);
            if (this.conv_error == 0) {
                this.dims.dim = n;
            }
            this.dim = false;
        }
        if (this.bit) {
            if (this.chan.bits == null) {
                this.chan.bits = new Vector();
            }
            this.bits = new bit_descr();
            this.chan.bits.add(this.bits);
            ++this.chan.nbits;
            n = this.get_int(this.Content);
            if (this.conv_error == 0) {
                this.bits.bit = n;
            }
            this.bit = false;
        }
        this.Content = new String();
        if (this.rootf && this.chanf) {
            if (string3.equalsIgnoreCase(TTF2_CHAN_DESCR_TAGS[2])) {
                this.ev_type = true;
            } else if (string3.equalsIgnoreCase(TTF2_CHAN_DESCR_TAGS[3])) {
                this.stream = true;
            } else if (string3.equalsIgnoreCase(TTF2_CHAN_DESCR_TAGS[18])) {
                this.count = true;
            } else if (string3.equalsIgnoreCase(TTF2_CHAN_DESCR_TAGS[17])) {
                this.dtype = true;
            } else if (string3.equalsIgnoreCase(TTF2_CHAN_DESCR_TAGS[4])) {
                this.prop_name = true;
            } else if (string3.equalsIgnoreCase(TTF2_CHAN_DESCR_TAGS[5])) {
                this.daq_name = true;
            } else if (string3.equalsIgnoreCase(TTF2_CHAN_DESCR_TAGS[6])) {
                this.prop_desc = true;
            } else if (string3.equalsIgnoreCase(TTF2_CHAN_DESCR_TAGS[7])) {
                this.units = true;
            } else if (string3.equalsIgnoreCase(TTF2_CHAN_DESCR_TAGS[8])) {
                this.max_size = true;
            } else if (string3.equalsIgnoreCase(TTF2_CHAN_DESCR_TAGS[9])) {
                this.bit = true;
            } else if (string3.equalsIgnoreCase(TTF2_CHAN_DESCR_TAGS[10])) {
                this.bit_name = true;
            } else if (string3.equalsIgnoreCase(TTF2_CHAN_DESCR_TAGS[11])) {
                this.bit_desc = true;
            } else if (string3.equalsIgnoreCase(TTF2_CHAN_DESCR_TAGS[12])) {
                this.dim = true;
            } else if (string3.equalsIgnoreCase(TTF2_CHAN_DESCR_TAGS[13])) {
                this.dim_name = true;
            } else if (string3.equalsIgnoreCase(TTF2_CHAN_DESCR_TAGS[14])) {
                this.dim_desc = true;
            } else if (string3.equalsIgnoreCase(TTF2_CHAN_DESCR_TAGS[15])) {
                this.dim_units = true;
            } else if (string3.equalsIgnoreCase(TTF2_CHAN_DESCR_TAGS[16])) {
                this.sb_name = true;
            }
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (this.rootf && this.chanf) {
            int n;
            if (this.Content.trim().equals("")) {
                this.Content = new String("Not set");
            }
            if (this.ev_type) {
                n = this.get_int(this.Content);
                if (this.conv_error == 0) {
                    this.chan.ev_type = n;
                }
                this.ev_type = false;
            }
            if (this.stream) {
                n = this.get_int(this.Content);
                if (this.conv_error == 0) {
                    this.chan.stream = n;
                }
                this.stream = false;
            }
            if (this.count) {
                n = this.get_int(this.Content);
                if (this.conv_error == 0) {
                    this.chan.count = n;
                }
                this.count = false;
            }
            if (this.dtype) {
                n = this.get_int(this.Content);
                if (this.conv_error == 0) {
                    this.chan.dtype = n;
                }
                this.dtype = false;
            }
            if (this.prop_name) {
                this.chan.prop_name = new String(this.Content);
                this.prop_name = false;
            }
            if (this.daq_name) {
                this.chan.daq_name = new String(this.Content);
                this.daq_name = false;
            }
            if (this.prop_desc) {
                this.chan.prop_desc = new String(this.Content);
                this.prop_desc = false;
            }
            if (this.units) {
                this.chan.units = new String(this.Content);
                this.units = false;
            }
            if (this.max_size) {
                n = this.get_int(this.Content);
                if (this.conv_error == 0) {
                    this.chan.max_size = n;
                }
                this.max_size = true;
            }
            if (this.bits != null && this.bit_name) {
                this.bits.bit_name = new String(this.Content);
                this.bit_name = false;
            }
            if (this.bits != null && this.bit_desc) {
                this.bits.bit_desc = new String(this.Content);
                this.bit_desc = false;
            }
            if (this.dims != null && this.dim_name) {
                this.dims.dim_name = new String(this.Content);
                this.dim_name = false;
            }
            if (this.dims != null && this.dim_desc) {
                this.dims.dim_desc = new String(this.Content);
                this.dim_desc = false;
            }
            if (this.dims != null && this.dim_units) {
                this.dims.units = new String(this.Content);
                this.dim_units = false;
            }
            if (this.sb_name) {
                this.chan.sb_name = new String(this.Content);
                this.sb_name = false;
            }
            if (string3.equalsIgnoreCase(TTF2_CHAN_DESCR_TAGS[1]) && this.chan != null && this.chans != null) {
                this.chans.add(this.chan);
                this.chan = null;
                this.chanf = false;
            }
        }
    }

    public void characters(char[] cArray, int n, int n2) {
        this.Content = this.Content + new String(cArray, n, n2);
    }

    public int get_int(String string) {
        this.conv_error = 0;
        if (string.endsWith("\n")) {
            string = string.substring(0, string.indexOf("\n"));
        } else if (string.startsWith("\n")) {
            string = string.substring(string.indexOf("\n"));
        }
        try {
            Integer n = new Integer(string);
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            this.conv_error = -1;
            return -1;
        }
    }

    public float get_float(String string) {
        this.conv_error = 0;
        try {
            Float f = new Float(string);
            return f.floatValue();
        }
        catch (NumberFormatException numberFormatException) {
            this.conv_error = -1;
            return -1.0f;
        }
    }

    public int parse_chan_descr() {
        Object object;
        Object object2;
        Object object3;
        this.error = 0;
        if (this.input_str == null) {
            return -3;
        }
        String string = null;
        if (this.input_str.indexOf("<") == -1) {
            System.out.println("Reading file: " + this.input_str);
            object3 = new File(this.input_str);
            if (((File)object3).exists() && ((File)object3).canRead()) {
                object2 = null;
                try {
                    object2 = new BufferedReader(new FileReader((File)object3));
                    object = new StringBuffer();
                    char[] cArray = new char[512];
                    try {
                        int n = 0;
                        while ((n = ((Reader)object2).read(cArray)) > -1) {
                            ((StringBuffer)object).append(cArray, 0, n);
                        }
                    }
                    catch (IOException iOException) {
                        return -4;
                    }
                    string = new String(((StringBuffer)object).toString());
                }
                catch (FileNotFoundException fileNotFoundException) {
                    return -5;
                }
                if (object2 != null) {
                    try {
                        ((BufferedReader)object2).close();
                    }
                    catch (IOException iOException) {
                        return -6;
                    }
                }
            }
        } else {
            string = new String(this.input_str);
        }
        try {
            object2 = SAXParserFactory.newInstance();
            object3 = ((SAXParserFactory)object2).newSAXParser();
        }
        catch (Exception exception) {
            System.err.println("error: Unable to instantiate parser ");
            this.error = -1;
            return this.error;
        }
        object2 = string.lastIndexOf(0) != -1 ? string.substring(0, string.lastIndexOf(0)) : string;
        object = new StringReader((String)object2);
        try {
            ((SAXParser)object3).parse(new InputSource((Reader)object), (DefaultHandler)this);
        }
        catch (SAXException sAXException) {
            this.error = -1;
        }
        catch (IOException iOException) {
            this.error = -2;
        }
        return this.error;
    }
}

