/*
 * Decompiled with CFR 0.152.
 */
package daq;

public class SBHeader {
    public int time_up = 0;
    public int time_low = 0;
    public int ltotal = 0;
    public int mpulse = 0;
    public String server = null;
    public int tmask = 0;
    public int status = 0;
    public int nchan = 0;
    int TTF2_SVR_LNAME = 48;
    int my_size = this.TTF2_SVR_LNAME + 28;

    public int size() {
        return this.my_size;
    }

    public void clear() {
        this.time_up = 0;
        this.time_low = 0;
        this.ltotal = 0;
        this.mpulse = 0;
        this.server = null;
        this.tmask = 0;
        this.status = 0;
        this.nchan = 0;
    }

    public static int BytesToInt(byte[] byArray, int n) {
        int n2 = ((byArray[n++] & 0xFF) << 24) + ((byArray[n++] & 0xFF) << 16) + ((byArray[n++] & 0xFF) << 8) + (byArray[n] & 0xFF);
        return n2;
    }

    public boolean is_valid() {
        return this.ltotal != 0;
    }

    public void print() {
        if (this.is_valid()) {
            System.out.println("SBHeader: " + this.server + " len: " + this.ltotal + " #chan: " + this.nchan + " " + this.time_up + ":" + this.time_low + "_" + this.mpulse + " tmask: " + this.tmask + " status: " + this.status);
        } else {
            System.out.println("SBHeader NOT SET");
        }
    }

    public boolean fill(byte[] byArray) {
        if (byArray == null || byArray.length < this.my_size) {
            return true;
        }
        int n = 0;
        this.time_up = SBHeader.BytesToInt(byArray, n);
        if (this.time_up <= 0) {
            this.ltotal = 0;
            return true;
        }
        this.time_low = SBHeader.BytesToInt(byArray, n += 4);
        this.ltotal = SBHeader.BytesToInt(byArray, n += 4);
        this.mpulse = SBHeader.BytesToInt(byArray, n += 4);
        this.server = new String(byArray, n += 4, this.TTF2_SVR_LNAME);
        this.server = this.server.substring(0, this.server.indexOf(0));
        this.tmask = SBHeader.BytesToInt(byArray, n += this.TTF2_SVR_LNAME);
        this.status = SBHeader.BytesToInt(byArray, n += 4);
        this.nchan = SBHeader.BytesToInt(byArray, n += 4);
        return false;
    }
}

