/*
 * Decompiled with CFR 0.152.
 */
package daq;

public class ChannelHeader {
    public String chname = null;
    public int dtype = 0;
    public int error = 0;
    public int ldata = -1;
    int TTF2_CHAN_LNAME = 32;
    int my_size = this.TTF2_CHAN_LNAME + 12;

    public int size() {
        return this.my_size;
    }

    public void clear() {
        this.chname = null;
        this.dtype = 0;
        this.error = 0;
        this.ldata = -1;
    }

    public static int BytesToInt(byte[] byArray, int n) {
        int n2 = ((byArray[n++] & 0xFF) << 24) + ((byArray[n++] & 0xFF) << 16) + ((byArray[n++] & 0xFF) << 8) + (byArray[n] & 0xFF);
        return n2;
    }

    public boolean is_valid() {
        return this.ldata >= 0 && this.dtype > 0;
    }

    public void print() {
        if (this.is_valid()) {
            System.out.println("ChannelHeader: " + this.chname + " len: " + this.ldata + " dtype:" + this.dtype + " error: " + this.error);
        } else {
            System.out.println("ChaanelHeader NOT SET");
        }
    }

    public boolean fill(byte[] byArray) {
        if (byArray == null || byArray.length < this.my_size) {
            return true;
        }
        int n = 0;
        this.chname = new String(byArray, n, this.TTF2_CHAN_LNAME);
        this.chname = this.chname.substring(0, this.chname.indexOf(0));
        this.dtype = ChannelHeader.BytesToInt(byArray, n += this.TTF2_CHAN_LNAME);
        this.error = ChannelHeader.BytesToInt(byArray, n += 4);
        this.ldata = ChannelHeader.BytesToInt(byArray, n += 4);
        if (this.ldata < 0 || this.ldata > 0 && this.dtype == 0) {
            System.out.println("LDATA:" + this.ldata + " DTYEP:" + this.dtype);
            this.clear();
            return true;
        }
        return false;
    }
}

