/*
 * Decompiled with CFR 0.152.
 */
import DOOCSComponents.DOOCSParameter;
import DOOCSComponents.DOOCSPlugin;
import TangoComponents.ITangoComponent;
import TangoComponents.ITangoErrorHistory;
import editor.undo.SetProperty;
import fr.esrf.tangoatk.core.AEntityList;
import fr.esrf.tangoatk.core.AttributeList;
import fr.esrf.tangoatk.core.ConnectionException;
import fr.esrf.tangoatk.core.IErrorListener;
import fr.esrf.tangoatk.core.INumberSpectrum;
import fr.esrf.tangoatk.widget.attribute.MultiNumberSpectrumViewer;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.event.MouseInputListener;
import tangoatk.jddd.addresses.TangoAdrList;
import tangoatk.jddd.utils.TangoErrorHistory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DOOCSTangoMultiNumberSpectrumViewer
extends MultiNumberSpectrumViewer
implements ITangoComponent,
DOOCSPlugin {
    private String doocsToolTipText = null;
    private boolean doocsScale = true;
    private String doocsLayer = "NONE";
    private boolean doocsRunMode = false;
    private Rectangle m_initialBounds;
    private AttributeList list;
    private double refresh_rate = 1.0;
    private TangoAdrList adrList;

    public DOOCSTangoMultiNumberSpectrumViewer() {
        this.setPreferredSize(new Dimension(440, 200));
        this.setSize(new Dimension(400, 200));
        this.list = new AttributeList();
        this.adrList = new TangoAdrList();
        this.adrList.add("Axis", DOOCSParameter.ParameterTypes.CHOICE, DOOCSParameter.Levels.NORMAL, "The Axis to be used for the attribute", "Y1 Axis");
    }

    public void setRunMode(boolean bRun) {
        this.doocsRunMode = bRun;
        if (bRun) {
            this.list.setRefreshInterval((int)(this.refresh_rate * 1000.0));
            this.list.startRefresher();
        } else {
            this.list.stopRefresher();
        }
    }

    public boolean isRunMode() {
        return this.doocsRunMode;
    }

    public void setFullDoocsAddress(String address) {
        this.adrList.setFullAddress(address);
        this.clearModel();
        List<String> relationList = this.adrList.getAdrRelation("Axis");
        for (int i = 0; i < relationList.size(); i += 2) {
            String adr = relationList.get(i);
            String axis = relationList.get(i + 1);
            String axis_ident = "Y1";
            if (axis.equalsIgnoreCase("Y2 Axis")) {
                axis_ident = "Y2";
            } else if (axis.equalsIgnoreCase("X Axis")) {
                axis_ident = "X";
            }
            try {
                this.addNumberSpectrumModel((INumberSpectrum)this.list.add(adr), axis_ident);
                continue;
            }
            catch (ConnectionException ex) {
                Logger.getLogger(DOOCSTangoMultiNumberSpectrumViewer.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public String getFullDoocsAddress() {
        return this.adrList.getFullAddress();
    }

    public void setDoocsAddress(String param, String address) {
        this.adrList.setAddress((AEntityList)this.list, param, address);
        this.clearModel();
        for (int i = 0; i < this.list.size(); ++i) {
            this.addNumberSpectrumModel((INumberSpectrum)this.list.get(i));
        }
    }

    public ImageIcon getIcon() {
        return new ImageIcon(((Object)((Object)this)).getClass().getResource("icons/MultiNumberSpectrumViewer.gif"));
    }

    public void addDOOCSMouseListener(MouseInputListener ml) {
        this.addMouseListener(ml);
        this.addMouseMotionListener(ml);
    }

    public void setDnDText(String str) {
    }

    public String getDnDText() {
        return null;
    }

    public String toString() {
        return this.getName();
    }

    public void setInitialBounds(Rectangle bounds) {
        this.m_initialBounds = bounds;
    }

    public Rectangle getInitialBounds() {
        return this.m_initialBounds;
    }

    public void setDoocsScale(boolean scale) {
        this.doocsScale = scale;
    }

    public boolean getDoocsScale() {
        return this.doocsScale;
    }

    public void setDoocsLayer(String layer) {
        this.doocsLayer = layer;
    }

    public String getDoocsLayer() {
        return this.doocsLayer;
    }

    public void setDoocsToolTipText(String ttt) {
        this.doocsToolTipText = ttt;
    }

    public String getDoocsToolTipText() {
        return this.doocsToolTipText;
    }

    public Vector<SetProperty> flipHorizontal(Vector<SetProperty> change) {
        return change;
    }

    public Vector<SetProperty> flipVertical(Vector<SetProperty> change) {
        return change;
    }

    public Vector<SetProperty> rotateLeft(Vector<SetProperty> change) {
        return change;
    }

    public Vector<SetProperty> rotateRight(Vector<SetProperty> change) {
        return change;
    }

    public DOOCSParameter[] getDOOCSParameterList() {
        DOOCSParameter[] parameters1 = new DOOCSParameter[]{new DOOCSParameter("name", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("updateTime", DOOCSParameter.ParameterTypes.DOUBLE, DOOCSParameter.Levels.NORMAL, "Set the refresh rate for the widget in seconds"), new DOOCSParameter("toolTipText", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("layer", DOOCSParameter.ParameterTypes.LAYER, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("scale", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.SCALE), new DOOCSParameter("bounds", DOOCSParameter.ParameterTypes.BOUNDS, DOOCSParameter.Levels.SCALE, "Tooltip")};
        DOOCSParameter[] parameters2 = this.adrList.getDOOCSParameterList();
        DOOCSParameter[] parameters = new DOOCSParameter[parameters1.length + parameters2.length];
        System.arraycopy(parameters1, 0, parameters, 0, parameters1.length);
        System.arraycopy(parameters2, 0, parameters, parameters1.length, parameters2.length);
        return parameters;
    }

    public String[] getDOOCSPropertyAllowedValues(String parameter) {
        if (parameter.startsWith("Axis")) {
            String[] allowedValues = new String[]{"Y1 Axis", "Y2 Axis", "X Axis"};
            return allowedValues;
        }
        String[] allowedValues = new String[]{"ill.ParameterName"};
        return allowedValues;
    }

    public StringBuffer getDOOCSXmlStructure() {
        StringBuffer xmlStructure = new StringBuffer("<DOOCSTangoMultiNumberSpectrumViewer ");
        xmlStructure.append("name=\"" + DOOCSParameter.correct((String)this.getName()) + "\" ");
        xmlStructure.append("bounds=\"" + DOOCSParameter.getDoocsBounds((Rectangle)this.getBounds()) + "\">");
        DOOCSParameter[] param = this.getDOOCSParameterList();
        for (int i = 0; i < param.length; ++i) {
            if (param[i].parameter.equalsIgnoreCase("name") || param[i].parameter.equalsIgnoreCase("bounds")) continue;
            xmlStructure.append("<" + param[i].parameter + ">");
            if (this.getDOOCSParameter(param[i].parameter) != null) {
                xmlStructure.append(DOOCSParameter.correct((String)this.getDOOCSParameter(param[i].parameter).toString()));
            }
            xmlStructure.append("</" + param[i].parameter + ">");
        }
        xmlStructure.append("</DOOCSTangoMultiNumberSpectrumViewer>\n");
        return xmlStructure;
    }

    public void setDOOCSParameter(String parameter, String value) {
        if (parameter.equalsIgnoreCase("name")) {
            this.setName(value);
        } else if (parameter.startsWith("adr") && !parameter.equalsIgnoreCase("adr")) {
            this.setDoocsAddress(parameter, value);
        } else if (parameter.startsWith("Axis")) {
            this.setAxis(parameter, value);
        } else if (parameter.equalsIgnoreCase("updateTime")) {
            this.setUpdateTime(Double.parseDouble(value));
        } else if (parameter.equalsIgnoreCase("toolTipText")) {
            this.setDoocsToolTipText(value);
        } else if (parameter.equalsIgnoreCase("layer")) {
            this.setDoocsLayer(value);
        } else if (parameter.equalsIgnoreCase("scale")) {
            this.setDoocsScale(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("bounds")) {
            this.setBounds(DOOCSParameter.convertToBounds((String)value));
        } else if (parameter.equalsIgnoreCase("size")) {
            this.setSize(DOOCSParameter.convertToSize((String)value));
        } else if (parameter.equalsIgnoreCase("runMode")) {
            this.setRunMode(Boolean.parseBoolean(value));
        } else {
            System.out.println("DOOCSOval.setDOOCSParameter: wrong parameter " + parameter);
        }
        this.repaint();
    }

    public Object getDOOCSParameter(String parameter) {
        if (parameter.equalsIgnoreCase("name")) {
            return this.getName();
        }
        if (parameter.startsWith("adr") && !parameter.equalsIgnoreCase("adr")) {
            return this.adrList.getAddress(parameter);
        }
        if (parameter.startsWith("Axis")) {
            return this.getAxis(parameter);
        }
        if (parameter.equalsIgnoreCase("updateTime")) {
            return this.getUpdateTime();
        }
        if (parameter.equalsIgnoreCase("toolTipText")) {
            return this.getDoocsToolTipText();
        }
        if (parameter.equalsIgnoreCase("layer")) {
            return this.getDoocsLayer();
        }
        if (parameter.equalsIgnoreCase("scale")) {
            return this.getDoocsScale();
        }
        if (parameter.equalsIgnoreCase("bounds")) {
            return DOOCSParameter.getDoocsBounds((Rectangle)this.getBounds());
        }
        if (parameter.equalsIgnoreCase("size")) {
            return DOOCSParameter.getDoocsSize((Dimension)this.getSize());
        }
        if (parameter.equalsIgnoreCase("runMode")) {
            return this.isRunMode();
        }
        System.out.println("DOOCSOval.getDOOCSParameter: wrong parameter " + parameter);
        return null;
    }

    public void addTangoErrorListener(ITangoErrorHistory eh) {
        this.list.addErrorListener((IErrorListener)((TangoErrorHistory)eh).getErrorListener());
    }

    public void setUpdateTime(double up) {
        this.refresh_rate = up;
    }

    public double getUpdateTime() {
        return this.refresh_rate;
    }

    public void setAxis(String parameter, String axe) {
        this.adrList.setParameter(parameter, axe);
    }

    public String getAxis(String parameter) {
        String axis = this.adrList.getParameter(parameter);
        if (axis == null) {
            axis = "Y1 Axis";
        }
        return axis;
    }
}

