/*
 * Decompiled with CFR 0.152.
 */
import DOOCSComponents.DOOCSParameter;
import DOOCSComponents.DOOCSPlugin;
import TangoComponents.ITangoComponent;
import TangoComponents.ITangoErrorHistory;
import editor.undo.SetProperty;
import fr.esrf.tangoatk.core.AEntityList;
import fr.esrf.tangoatk.core.CommandList;
import fr.esrf.tangoatk.core.IErrorListener;
import fr.esrf.tangoatk.widget.command.CommandComboViewer;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.event.MouseInputListener;
import tangoatk.jddd.addresses.TangoAdrList;
import tangoatk.jddd.utils.TangoErrorHistory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DOOCSTangoCommandComboViewer
extends CommandComboViewer
implements ITangoComponent,
DOOCSPlugin {
    private String doocsToolTipText = null;
    private boolean doocsScale = true;
    private String doocsLayer = "NONE";
    private boolean doocsRunMode = false;
    private Rectangle m_initialBounds;
    private CommandList list;
    private double refresh_rate = 1.0;
    private TangoAdrList adrList;
    private boolean border = false;
    private boolean description = true;
    private boolean infoButton = false;
    private boolean cancelButton = false;
    private boolean deviceButton = false;

    public DOOCSTangoCommandComboViewer() {
        this.setPreferredSize(new Dimension(100, 50));
        this.setSize(new Dimension(100, 50));
        this.list = new CommandList();
        this.adrList = new TangoAdrList();
        this.adrList.use_command_names();
    }

    public void setRunMode(boolean bRun) {
        this.doocsRunMode = bRun;
        if (bRun) {
            // empty if block
        }
    }

    public boolean isRunMode() {
        return this.doocsRunMode;
    }

    public void setFullDoocsAddress(String address) {
        CommandList new_list = new CommandList();
        this.adrList.setFullAddress((AEntityList)new_list, address);
        this.setModel(new_list);
        this.list = new_list;
    }

    public String getFullDoocsAddress() {
        return this.adrList.getFullAddress();
    }

    public void setDoocsAddress(String param, String address) {
        CommandList new_list = new CommandList();
        this.adrList.setAddress((AEntityList)new_list, param, address);
        this.setModel(new_list);
        this.list = new_list;
    }

    public ImageIcon getIcon() {
        return new ImageIcon(((Object)((Object)this)).getClass().getResource("icons/CommandComboViewer.gif"));
    }

    public void addDOOCSMouseListener(MouseInputListener ml) {
        this.addMouseListener(ml);
        this.addMouseMotionListener(ml);
    }

    public void setDnDText(String str) {
    }

    public String getDnDText() {
        return null;
    }

    public String toString() {
        return this.getName();
    }

    public void setInitialBounds(Rectangle bounds) {
        this.m_initialBounds = bounds;
    }

    public Rectangle getInitialBounds() {
        return this.m_initialBounds;
    }

    public void setDoocsScale(boolean scale) {
        this.doocsScale = scale;
    }

    public boolean getDoocsScale() {
        return this.doocsScale;
    }

    public void setDoocsLayer(String layer) {
        this.doocsLayer = layer;
    }

    public String getDoocsLayer() {
        return this.doocsLayer;
    }

    public void setDoocsToolTipText(String ttt) {
        this.doocsToolTipText = ttt;
    }

    public String getDoocsToolTipText() {
        return this.doocsToolTipText;
    }

    public Vector<SetProperty> flipHorizontal(Vector<SetProperty> change) {
        return change;
    }

    public Vector<SetProperty> flipVertical(Vector<SetProperty> change) {
        return change;
    }

    public Vector<SetProperty> rotateLeft(Vector<SetProperty> change) {
        return change;
    }

    public Vector<SetProperty> rotateRight(Vector<SetProperty> change) {
        return change;
    }

    public DOOCSParameter[] getDOOCSParameterList() {
        DOOCSParameter[] parameters1 = new DOOCSParameter[]{new DOOCSParameter("name", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("borderVisible", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.NORMAL, "Enable the command box border"), new DOOCSParameter("descriptionVisible", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.NORMAL, "Enable input parameter description, in the input pane"), new DOOCSParameter("infoButtonVisible", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.NORMAL, "Enable command info button, in the input pane"), new DOOCSParameter("cancelButtonVisible", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.NORMAL, "Enable command cancel button, in the input pane"), new DOOCSParameter("deviceButtonVisible", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.NORMAL, "Enable the device info button, in the input pane"), new DOOCSParameter("toolTipText", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("layer", DOOCSParameter.ParameterTypes.LAYER, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("scale", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.SCALE), new DOOCSParameter("bounds", DOOCSParameter.ParameterTypes.BOUNDS, DOOCSParameter.Levels.SCALE, "Tooltip")};
        DOOCSParameter[] parameters2 = this.adrList.getDOOCSParameterList();
        DOOCSParameter[] parameters = new DOOCSParameter[parameters1.length + parameters2.length];
        System.arraycopy(parameters1, 0, parameters, 0, parameters1.length);
        System.arraycopy(parameters2, 0, parameters, parameters1.length, parameters2.length);
        return parameters;
    }

    public String[] getDOOCSPropertyAllowedValues(String parameter) {
        return null;
    }

    public StringBuffer getDOOCSXmlStructure() {
        StringBuffer xmlStructure = new StringBuffer("<DOOCSTangoCommandComboViewer ");
        xmlStructure.append("name=\"" + DOOCSParameter.correct((String)this.getName()) + "\" ");
        xmlStructure.append("bounds=\"" + DOOCSParameter.getDoocsBounds((Rectangle)this.getBounds()) + "\">");
        DOOCSParameter[] param = this.getDOOCSParameterList();
        for (int i = 0; i < param.length; ++i) {
            if (param[i].parameter.equalsIgnoreCase("name") || param[i].parameter.equalsIgnoreCase("bounds")) continue;
            xmlStructure.append("<" + param[i].parameter + ">");
            if (this.getDOOCSParameter(param[i].parameter) != null) {
                xmlStructure.append(DOOCSParameter.correct((String)this.getDOOCSParameter(param[i].parameter).toString()));
            }
            xmlStructure.append("</" + param[i].parameter + ">");
        }
        xmlStructure.append("</DOOCSTangoCommandComboViewer>\n");
        return xmlStructure;
    }

    public void setDOOCSParameter(String parameter, String value) {
        if (parameter.equalsIgnoreCase("name")) {
            this.setName(value);
        } else if (parameter.startsWith("adr") && !parameter.equalsIgnoreCase("adr")) {
            this.setDoocsAddress(parameter, value);
        } else if (parameter.equalsIgnoreCase("borderVisible")) {
            this.setBorderVisible(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("descriptionVisible")) {
            this.setDescriptionVisible(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("infoButtonVisible")) {
            this.setInfoButtonVisible(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("cancelButtonVisible")) {
            this.setCancelButtonVisible(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("deviceButtonVisible")) {
            this.setDeviceButtonVisible(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("toolTipText")) {
            this.setDoocsToolTipText(value);
        } else if (parameter.equalsIgnoreCase("layer")) {
            this.setDoocsLayer(value);
        } else if (parameter.equalsIgnoreCase("scale")) {
            this.setDoocsScale(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("bounds")) {
            this.setBounds(DOOCSParameter.convertToBounds((String)value));
        } else if (parameter.equalsIgnoreCase("size")) {
            this.setSize(DOOCSParameter.convertToSize((String)value));
        } else if (parameter.equalsIgnoreCase("runMode")) {
            this.setRunMode(Boolean.parseBoolean(value));
        } else {
            System.out.println("DOOCSOval.setDOOCSParameter: wrong parameter " + parameter);
        }
        this.repaint();
    }

    public Object getDOOCSParameter(String parameter) {
        if (parameter.equalsIgnoreCase("name")) {
            return this.getName();
        }
        if (parameter.startsWith("adr") && !parameter.equalsIgnoreCase("adr")) {
            return this.adrList.getAddress(parameter);
        }
        if (parameter.equalsIgnoreCase("borderVisible")) {
            return this.getBorderVisible();
        }
        if (parameter.equalsIgnoreCase("descriptionVisible")) {
            return this.getDescriptionVisible();
        }
        if (parameter.equalsIgnoreCase("infoButtonVisible")) {
            return this.getInfoButtonVisible();
        }
        if (parameter.equalsIgnoreCase("cancelButtonVisible")) {
            return this.getCancelButtonVisible();
        }
        if (parameter.equalsIgnoreCase("deviceButtonVisible")) {
            return this.getDeviceButtonVisible();
        }
        if (parameter.equalsIgnoreCase("toolTipText")) {
            return this.getDoocsToolTipText();
        }
        if (parameter.equalsIgnoreCase("layer")) {
            return this.getDoocsLayer();
        }
        if (parameter.equalsIgnoreCase("scale")) {
            return this.getDoocsScale();
        }
        if (parameter.equalsIgnoreCase("bounds")) {
            return DOOCSParameter.getDoocsBounds((Rectangle)this.getBounds());
        }
        if (parameter.equalsIgnoreCase("size")) {
            return DOOCSParameter.getDoocsSize((Dimension)this.getSize());
        }
        if (parameter.equalsIgnoreCase("runMode")) {
            return this.isRunMode();
        }
        System.out.println("DOOCSOval.getDOOCSParameter: wrong parameter " + parameter);
        return null;
    }

    public void addTangoErrorListener(ITangoErrorHistory eh) {
        this.list.addErrorListener((IErrorListener)((TangoErrorHistory)eh).getErrorListener());
    }

    public void setBorderVisible(boolean b) {
        this.border = b;
        super.setBorderVisible(this.border);
    }

    public boolean getBorderVisible() {
        return this.border;
    }

    public void setDescriptionVisible(boolean b) {
        this.description = b;
        super.setDescriptionVisible(this.description);
    }

    public boolean getDescriptionVisible() {
        return this.description;
    }

    public void setInfoButtonVisible(boolean b) {
        this.infoButton = b;
        super.setInfoButtonVisible(this.infoButton);
    }

    public boolean getInfoButtonVisible() {
        return this.infoButton;
    }

    public void setCancelButtonVisible(boolean b) {
        this.cancelButton = b;
        super.setCancelButtonVisible(this.cancelButton);
    }

    public boolean getCancelButtonVisible() {
        return this.cancelButton;
    }

    public void setDeviceButtonVisible(boolean b) {
        this.deviceButton = b;
        super.setDeviceButtonVisible(this.deviceButton);
    }

    public boolean getDeviceButtonVisible() {
        return this.deviceButton;
    }
}

