/*
 * Decompiled with CFR 0.152.
 */
package ttf.doocs.clnt;

import de.desy.tine.client.TLink;
import de.desy.tine.client.TLinkCallback;
import de.desy.tine.dataUtils.TDataType;
import java.util.ArrayList;
import java.util.Iterator;
import ttf.doocs.clnt.BadItem;
import ttf.doocs.clnt.ENSinfo;
import ttf.doocs.clnt.EpicsMonitorItem;
import ttf.doocs.clnt.EqAdr;
import ttf.doocs.clnt.EqCall;
import ttf.doocs.clnt.EqCallback;
import ttf.doocs.clnt.EqData;
import ttf.doocs.clnt.MonitorItem;
import ttf.doocs.clnt.TangoMonitorItem;
import ttf.doocs.clnt.TineMonitorItem;

public class Monitoring
extends Thread
implements Runnable {
    private static boolean monDebug = false;
    private EqCall eq;
    private int delay;
    public static final ArrayList comp = new ArrayList();
    private static long lastPrint;
    private static long lastRun;
    private static volatile boolean threadIsRunning;

    public Monitoring(EqCall call) {
        this.eq = call;
        this.delay = 33;
        this.setName("DOOCS Monitor");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int get_monitor(EqAdr adr, EqData src, EqData dst, ENSinfo info, int mode, float ref_rate, EqCallback callBack, Object userData) {
        MonitorItem reuseIt = null;
        ArrayList arrayList = comp;
        synchronized (arrayList) {
            MonitorItem cL;
            int len = comp.size();
            for (int i = 0; i < len; ++i) {
                cL = (MonitorItem)comp.get(i);
                boolean flag = false;
                if (callBack == null && cL.adr.show_adr().equals(adr.show_adr())) {
                    flag = true;
                }
                if (cL.adr == adr && src == cL.id && !cL.once) {
                    reuseIt = cL;
                    if (cL.update) {
                        flag = true;
                    }
                }
                if (!flag) continue;
                cL.time = System.currentTimeMillis();
                MonitorItem monitorItem = cL;
                synchronized (monitorItem) {
                    dst.copy_from(cL.result);
                }
                return 0;
            }
            cL = reuseIt != null ? reuseIt : new MonitorItem();
            cL.time = System.currentTimeMillis();
            cL.adr = adr;
            cL.id.copy_from(src);
            cL.info = info;
            cL.callBackFct = callBack;
            cL.userDataObj = userData;
            cL.result = dst;
            cL.rate = ref_rate;
            cL.once = mode == 1;
            cL.count = 5;
            if (reuseIt == null) {
                comp.add(cL);
            } else {
                cL.update = true;
            }
        }
        long tm = System.currentTimeMillis();
        if (!threadIsRunning || lastRun + 30000L < tm) {
            if (!this.isAlive()) {
                this.start();
            }
            threadIsRunning = true;
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int tango_get_monitor(EqAdr adr, EqData dataIn, EqData dataOut, ENSinfo info, int mode, float rate, EqCallback callBack, Object userData) {
        boolean reuseIt = false;
        ArrayList arrayList = comp;
        synchronized (arrayList) {
            MonitorItem cL;
            int len = comp.size();
            for (int i = 0; i < len; ++i) {
                cL = (MonitorItem)comp.get(i);
                if (callBack == null && cL.adr.show_adr().equals(adr.show_adr())) {
                    cL.time = System.currentTimeMillis();
                    MonitorItem monitorItem = cL;
                    synchronized (monitorItem) {
                        dataOut.copy_from(cL.result);
                    }
                    return 0;
                }
                if (cL.adr != adr || dataIn != cL.id) continue;
                System.out.println("Reuse monitor for " + adr.show_adr());
                reuseIt = true;
                break;
            }
            if (!reuseIt) {
                cL = new TangoMonitorItem(adr, dataIn, dataOut, info, mode, rate, callBack, userData);
                comp.add(cL);
            }
        }
        long tm = System.currentTimeMillis();
        if (!threadIsRunning || lastRun + 10000L < tm) {
            threadIsRunning = true;
            this.start();
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int tine_get_monitor(EqAdr adr, EqData dataIn, EqData dataOut, ENSinfo info, int mode, float rate, EqCallback callBack, Object userData) {
        MonitorItem cL;
        MonitorItem reuseIt = null;
        ArrayList arrayList = comp;
        synchronized (arrayList) {
            int len = comp.size();
            for (int i = 0; i < len; ++i) {
                cL = (MonitorItem)comp.get(i);
                boolean flag = false;
                if (callBack == null && cL.adr.show_adr().equals(adr.show_adr())) {
                    flag = true;
                }
                if (cL.adr == adr) {
                    reuseIt = cL;
                }
                if (!flag) continue;
                cL.time = System.currentTimeMillis();
                MonitorItem monitorItem = cL;
                synchronized (monitorItem) {
                    dataOut.copy_from(cL.result);
                }
                return 0;
            }
            cL = reuseIt != null ? reuseIt : new TineMonitorItem();
            cL.adr = adr;
            cL.id.copy_from(dataIn);
            cL.result = dataOut;
            cL.info = info;
            cL.callBackFct = callBack;
            cL.userDataObj = userData;
            cL.time = System.currentTimeMillis();
            comp.add(cL);
        }
        TDataType dout = adr.tData;
        if (dout == null) {
            if (dataOut.type() != 0) {
                int l = dataOut.array_length();
                if (l < 1) {
                    l = adr.location().contains("*") ? 1000 : dataOut.length();
                }
                dout = new TDataType(l, this.eq.convertDoocsToTineFormat(dataOut));
                cL.first = false;
            } else {
                dout = new TDataType(16384, 254);
                cL.first = true;
            }
            adr.tData = dout;
        } else {
            cL.first = false;
        }
        String adrStr = "/" + adr.facility() + "/" + adr.device() + "/" + adr.location();
        ((TineMonitorItem)cL).link = new TLink(adrStr, adr.property(), dout, null, 1);
        int sts = ((TineMonitorItem)cL).link.attach(mode & 0xFF, (TLinkCallback)cL, (int)rate * 1000);
        if (monDebug) {
            System.out.println("new TINE Mon=" + cL.adr.show_adr());
        }
        if (sts < 0) {
            String errStr = ((TineMonitorItem)cL).link.getError(sts);
            ((TineMonitorItem)cL).link.cancel();
            ((TineMonitorItem)cL).link = null;
            dataOut.error(100, "Can't create TINE link");
            if (monDebug) {
                System.out.println("Can't create TINE link=" + cL.adr.show_adr());
            }
        }
        long tm = System.currentTimeMillis();
        if (!threadIsRunning) {
            threadIsRunning = true;
            this.start();
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int epics_get_monitor(EqAdr adr, EqData dataIn, EqData dataOut, ENSinfo info, int mode, float rate, EqCallback callBack, Object userData) {
        MonitorItem cL;
        int sts = 0;
        MonitorItem reuseIt = null;
        ArrayList arrayList = comp;
        synchronized (arrayList) {
            int len = comp.size();
            for (int i = 0; i < len; ++i) {
                cL = (MonitorItem)comp.get(i);
                boolean flag = false;
                if (callBack == null && cL.adr.show_adr().equals(adr.show_adr())) {
                    flag = true;
                }
                if (cL.adr == adr) {
                    reuseIt = cL;
                }
                if (!flag) continue;
                cL.time = System.currentTimeMillis();
                MonitorItem monitorItem = cL;
                synchronized (monitorItem) {
                    dataOut.copy_from(cL.result);
                }
                return 0;
            }
            cL = reuseIt != null ? reuseIt : new EpicsMonitorItem();
            cL.adr = adr;
            cL.id.copy_from(dataIn);
            cL.result = dataOut;
            cL.info = info;
            cL.callBackFct = callBack;
            cL.userDataObj = userData;
            cL.time = System.currentTimeMillis();
            comp.add(cL);
        }
        if (EqCall.context == null) {
            EqCall.createContext(adr);
        }
        if ((sts = info.file_or_ch == null ? ((EpicsMonitorItem)cL).setMonitor(adr.file()) : ((EpicsMonitorItem)cL).setMonitor(new String(info.file_or_ch).trim())) == 0) {
            ((EpicsMonitorItem)cL).destroy();
            dataOut.error(100, "Can't set EPICS monitor");
            if (monDebug) {
                System.out.println("Can't set EPICS monitor=" + cL.adr.show_adr());
            }
        } else if (monDebug) {
            System.out.println("new EPICS Mon=" + cL.adr.show_adr());
        }
        long tm = System.currentTimeMillis();
        if (!threadIsRunning || lastRun + 30000L < tm) {
            if (!this.isAlive()) {
                this.start();
            }
            threadIsRunning = true;
        }
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int clear_monitor(EqAdr adr) {
        ArrayList arrayList = comp;
        synchronized (arrayList) {
            int len = comp.size();
            for (int i = 0; i < len; ++i) {
                MonitorItem cL = (MonitorItem)comp.get(i);
                if (cL.adr != adr) continue;
                switch (cL.info.protocol) {
                    case 1: {
                        break;
                    }
                    case 4: {
                        if (cL == null) break;
                        ((TangoMonitorItem)cL).cancel();
                        if (!monDebug) break;
                        System.out.println("cancel TANGO Mon=" + cL.adr.show_adr());
                        break;
                    }
                    case 2: {
                        if (cL == null || ((TineMonitorItem)cL).link == null) break;
                        ((TineMonitorItem)cL).link.cancel();
                        if (!monDebug) break;
                        System.out.println("cancel TINE Mon=" + cL.adr.show_adr());
                        break;
                    }
                    case 3: {
                        ((EpicsMonitorItem)cL).cancel();
                        if (!monDebug) break;
                        System.out.println("cancel TINE Mon=" + cL.adr.show_adr());
                        break;
                    }
                }
                cL.markRemove = true;
                return 0;
            }
        }
        return 1;
    }

    public int set_option(EqAdr adr, int param, EqData data) {
        int len = comp.size();
        for (int i = 0; i < len; ++i) {
            MonitorItem cL = (MonitorItem)comp.get(i);
            if (cL.adr != adr) continue;
            switch (param) {
                case 16: {
                    int val = data.get_int();
                    if (val < 10) {
                        val = 10;
                    }
                    this.delay = val;
                    break;
                }
                case 17: {
                    int val = data.get_int();
                    if (val < this.delay) {
                        return 1;
                    }
                    cL.live_time = val;
                    break;
                }
                case 100: {
                    cL.count = 1;
                    cL.once = false;
                    break;
                }
                case 110: {
                    cL.count = 5;
                    cL.once = false;
                    break;
                }
                case 120: {
                    cL.count = 10;
                    cL.once = false;
                    break;
                }
                case 130: {
                    cL.count = 100;
                    cL.once = false;
                }
                case 140: {
                    cL.once = true;
                }
            }
            return 0;
        }
        return 1;
    }

    public String get_option(EqAdr adr, int param) {
        Object opt = null;
        int len = comp.size();
        for (int i = 0; i < len; ++i) {
            MonitorItem cL = (MonitorItem)comp.get(i);
            if (cL.adr != adr) continue;
            switch (param) {
                case 16: {
                    if (cL.once) {
                        return new String("Once");
                    }
                    if (cL.count == 100) {
                        return new String("Slow");
                    }
                    if (cL.count == 10) {
                        return new String("Normal");
                    }
                    if (cL.count == 5) {
                        return new String("Fast");
                    }
                    if (cL.count == 1) {
                        return new String("Ultra");
                    }
                }
                case 17: {
                    return new String(String.valueOf(cL.live_time));
                }
            }
        }
        return null;
    }

    public void disconnect() {
        int len = comp.size();
        for (int i = 0; i < len; ++i) {
            MonitorItem cL = (MonitorItem)comp.get(i);
            switch (cL.info.protocol) {
                case 1: {
                    break;
                }
                case 4: {
                    ((TangoMonitorItem)cL).cancel();
                    break;
                }
                case 2: {
                    ((TineMonitorItem)cL).link.cancel();
                    break;
                }
                case 3: {
                    ((EpicsMonitorItem)cL).destroy();
                    break;
                }
            }
            cL.update = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateData(long tm) {
        int doocsOn;
        int epicsCh;
        int tineCh;
        int doocsCh;
        int len;
        block18: {
            len = 0;
            doocsCh = 0;
            tineCh = 0;
            epicsCh = 0;
            doocsOn = 0;
            boolean tineOn = false;
            try {
                len = comp.size();
                block10: for (int i = 0; i < len && i < (len = comp.size()); ++i) {
                    lastRun = System.currentTimeMillis();
                    MonitorItem cL = (MonitorItem)comp.get(i);
                    switch (cL.info.protocol) {
                        case 1: {
                            ++doocsCh;
                            if (!cL.update || !cL.status) continue block10;
                            ++doocsOn;
                            --cL.counter;
                            long upd = (long)(cL.rate * 1000.0f);
                            long dt = cL.tLastRead + upd - tm;
                            if (dt >= 0L) continue block10;
                            cL.counter = cL.count;
                            this.eq.get(cL.adr, cL.id, cL.result);
                            MonitorItem monitorItem = cL;
                            synchronized (monitorItem) {
                                cL.tLastRead = System.currentTimeMillis();
                                if (cL.result.error() != 0 && cL.status && !cL.once) {
                                    if (cL.Err != null) {
                                        boolean bl = true;
                                    }
                                    cL.status = false;
                                    cL.Err = new BadItem();
                                    cL.Err.set(cL.adr);
                                }
                                if (cL.once && cL.result.error() == 0) {
                                    cL.update = false;
                                }
                                if (cL.callBackFct != null && cL.callBackFct instanceof EqCallback) {
                                    cL.callBackFct.dataCallback(cL.result, cL.userDataObj);
                                    if (monDebug && cL.result.type() == 0) {
                                        System.out.println("ZERO, req data=" + cL.id.get_string());
                                        System.out.println("ADR =" + cL.adr.show_adr());
                                        System.out.println("ENS =" + cL.info.toString());
                                    }
                                    if (cL.once) {
                                        cL.markRemove = true;
                                        cL.update = false;
                                    }
                                }
                                continue block10;
                            }
                        }
                        case 2: {
                            ++tineCh;
                            continue block10;
                        }
                        case 3: {
                            ++epicsCh;
                            continue block10;
                        }
                    }
                }
            }
            catch (Exception e) {
                if (!monDebug) break block18;
                System.out.println("Update!! " + e.toString());
            }
        }
        if (monDebug && lastPrint + 10000L < tm) {
            System.out.println("Tot chan=" + len + " DOOCS chan=" + doocsCh + " DOOCS on=" + doocsOn + " TINE chan=" + tineCh + " EPICS chan=" + epicsCh);
            lastPrint = tm;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        int i = 0;
        while (true) {
            try {
                while (true) {
                    Monitoring.sleep(this.delay);
                    lastRun = System.currentTimeMillis();
                    ArrayList arrayList = comp;
                    synchronized (arrayList) {
                        MonitorItem cL;
                        Iterator it = comp.iterator();
                        while (it.hasNext()) {
                            cL = (MonitorItem)it.next();
                            if (!cL.markRemove) continue;
                            if (cL.Err != null) {
                                cL.Err.stopFlag = true;
                            }
                            it.remove();
                        }
                        int len = comp.size();
                        for (i = 0; i < len; ++i) {
                            cL = (MonitorItem)comp.get(i);
                            if (cL == null) continue;
                            if (cL.callBackFct == null) {
                                long delta = lastRun - cL.time;
                                if (delta > cL.live_time) {
                                    cL.markRemove = true;
                                    cL.update = false;
                                } else {
                                    cL.update = true;
                                }
                            }
                            if (cL.status || cL.Err == null || cL.Err.isAlive() || cL.Err.stopFlag) continue;
                            cL.status = true;
                            cL.update = true;
                            cL.time = System.currentTimeMillis();
                            cL.Err.stopFlag = true;
                            cL.Err = null;
                            System.out.println("Error recover thread terminated, data ok: " + cL.adr.show_adr() + ", data=" + cL.result.get_string());
                        }
                    }
                    this.updateData(lastRun);
                }
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    public static void printAllMonitors() {
        int len = comp.size();
        for (int i = 0; i < len; ++i) {
            MonitorItem cL = (MonitorItem)comp.get(i);
            String tmp = cL.result != null ? cL.result.get_string() : "";
            System.out.println("Monitor (" + i + ") Sts:" + cL.status + " Upd:" + cL.update + " Adr:" + cL.adr.show_adr() + " = " + tmp + "; Req=" + cL.id.get_string() + "; User=" + cL.userDataObj);
        }
    }

    static {
        threadIsRunning = false;
    }
}

