/*
 * Decompiled with CFR 0.152.
 */
package gov.aps.jca;

import gov.aps.jca.CASeverity;
import gov.aps.jca.ValuedEnum;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class CAStatus
extends ValuedEnum {
    private static Map _map;
    public static final CAStatus NORMAL;
    public static final CAStatus MAXIOC;
    public static final CAStatus UKNHOST;
    public static final CAStatus UKNSERV;
    public static final CAStatus SOCK;
    public static final CAStatus CONN;
    public static final CAStatus ALLOCMEM;
    public static final CAStatus UKNCHAN;
    public static final CAStatus UKNFIELD;
    public static final CAStatus TOLARGE;
    public static final CAStatus TIMEOUT;
    public static final CAStatus NOSUPPORT;
    public static final CAStatus STRTOBIG;
    public static final CAStatus DISCONNCHID;
    public static final CAStatus BADTYPE;
    public static final CAStatus CHIDNOTFND;
    public static final CAStatus CHIDRETRY;
    public static final CAStatus INTERNAL;
    public static final CAStatus DBLCLFAIL;
    public static final CAStatus GETFAIL;
    public static final CAStatus PUTFAIL;
    public static final CAStatus ADDFAIL;
    public static final CAStatus BADCOUNT;
    public static final CAStatus BADSTR;
    public static final CAStatus DISCONN;
    public static final CAStatus DBLCHNL;
    public static final CAStatus EVDISALLOW;
    public static final CAStatus BUILDGET;
    public static final CAStatus NEEDSFP;
    public static final CAStatus OVEVFAIL;
    public static final CAStatus BADMONID;
    public static final CAStatus NEWADDR;
    public static final CAStatus NEWCONN;
    public static final CAStatus NOCACTX;
    public static final CAStatus DEFUNCT;
    public static final CAStatus EMPTYSTR;
    public static final CAStatus NOREPEATER;
    public static final CAStatus NOCHANMSG;
    public static final CAStatus DLCKREST;
    public static final CAStatus SERVBEHIND;
    public static final CAStatus NOCAST;
    public static final CAStatus BADMASK;
    public static final CAStatus IODONE;
    public static final CAStatus IOINPROGESS;
    public static final CAStatus BADSYNCGRP;
    public static final CAStatus PUTCBINPROG;
    public static final CAStatus NORDACCESS;
    public static final CAStatus NOWTACCESS;
    public static final CAStatus ANACHRONISM;
    public static final CAStatus NOSEARCHADDR;
    public static final CAStatus NOCONVERT;
    public static final CAStatus BADCHID;
    public static final CAStatus BADFUNCPTR;
    public static final CAStatus ISATTACHED;
    public static final CAStatus UNAVAILINSERV;
    public static final CAStatus CHANDESTROY;
    public static final CAStatus BADPRIORITY;
    public static final CAStatus NOTTHREADED;
    public static final CAStatus ARRAY16KCLIENT;
    public static final CAStatus CONNSEQTMO;
    public static final CAStatus UNRESPTMO;
    static CAStatus[] _cachedTypesByValue;
    private CASeverity _severity;
    private String _msg;
    public static final int CA_M_MSG_NO = 65528;
    public static final int CA_M_SEVERITY = 7;
    public static final int CA_M_LEVEL = 3;
    public static final int CA_M_SUCCESS = 1;
    public static final int CA_M_ERROR = 2;
    public static final int CA_M_SEVERE = 4;
    public static final int CA_S_MSG_NO = 13;
    public static final int CA_S_SEVERITY = 3;
    public static final int CA_V_MSG_NO = 3;
    public static final int CA_V_SEVERITY = 0;
    public static final int CA_V_SUCCESS = 0;

    protected CAStatus(String name, int value, CASeverity severity, String msg) {
        super(name, value, _map);
        this._severity = severity;
        this._msg = msg;
    }

    public boolean isSuccessful() {
        return this._severity.isSuccessful();
    }

    public boolean isError() {
        return this._severity.isError();
    }

    public boolean isFatal() {
        return this._severity.isFatal();
    }

    public CASeverity getSeverity() {
        return this._severity;
    }

    public String getMessage() {
        return this._msg;
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.getName() + "=" + this.getValue() + "," + this._severity.getName() + "=" + this._severity.getValue() + "]=" + this.getMessage();
    }

    public static CAStatus forName(String name) {
        return (CAStatus)_map.get(name);
    }

    public static final CAStatus forValue(int value) {
        if (value >= 0 && value < _cachedTypesByValue.length) {
            return _cachedTypesByValue[value];
        }
        return null;
    }

    public final int getStatusCode() {
        return this.getValue() << 3 & 0xFFF8 | this.getSeverity().getValue() << 0 & 7;
    }

    public static final CAStatus forStatusCode(int value) {
        return CAStatus.forValue((value & 0xFFF8) >> 3);
    }

    static {
        CAStatus t;
        _map = new HashMap();
        NORMAL = new CAStatus("NORMAL", 0, CASeverity.SUCCESS, "Normal successful completion");
        MAXIOC = new CAStatus("MAXIOC", 1, CASeverity.ERROR, "Maximum simultaneous IOC connections exceeded");
        UKNHOST = new CAStatus("UKNHOST", 2, CASeverity.ERROR, "Unknown internet host");
        UKNSERV = new CAStatus("UKNSERV", 3, CASeverity.ERROR, "Unknown internet service");
        SOCK = new CAStatus("SOCK", 4, CASeverity.ERROR, "Unable to allocate a new socket");
        CONN = new CAStatus("CONN", 5, CASeverity.WARNING, "Unable to connect to internet host or service");
        ALLOCMEM = new CAStatus("ALLOCMEM", 6, CASeverity.WARNING, "Unable to allocate additional dynamic memory");
        UKNCHAN = new CAStatus("UKNCHAN", 7, CASeverity.WARNING, "Unknown IO channel");
        UKNFIELD = new CAStatus("UKNFIELD", 8, CASeverity.WARNING, "Record field specified inappropriate for channel specified");
        TOLARGE = new CAStatus("TOLARGE", 9, CASeverity.WARNING, "The requested transfer is greater than available memory or EPICS_CA_MAX_ARRAY_BYTES");
        TIMEOUT = new CAStatus("TIMEOUT", 10, CASeverity.WARNING, "User specified timeout on IO operation expired");
        NOSUPPORT = new CAStatus("NOSUPPORT", 11, CASeverity.WARNING, "Sorry, that feature is planned but not supported at this time");
        STRTOBIG = new CAStatus("STRTOBIG", 12, CASeverity.WARNING, "The supplied string is unusually large");
        DISCONNCHID = new CAStatus("DISCONNCHID", 13, CASeverity.ERROR, "The request was ignored because the specified channel is disconnected");
        BADTYPE = new CAStatus("BADTYPE", 14, CASeverity.ERROR, "The data type specifed is invalid");
        CHIDNOTFND = new CAStatus("CHIDNOTFND", 15, CASeverity.INFO, "Remote Channel not found");
        CHIDRETRY = new CAStatus("CHIDRETRY", 16, CASeverity.INFO, "Unable to locate all user specified channels");
        INTERNAL = new CAStatus("INTERNAL", 17, CASeverity.FATAL, "Channel Access Internal Failure");
        DBLCLFAIL = new CAStatus("DBLCLFAIL", 18, CASeverity.WARNING, "The requested local DB operation failed");
        GETFAIL = new CAStatus("GETFAIL", 19, CASeverity.WARNING, "Could not perform a database value get for that channel");
        PUTFAIL = new CAStatus("PUTFAIL", 20, CASeverity.WARNING, "Could not perform a database value put for that channel");
        ADDFAIL = new CAStatus("ADDFAIL", 21, CASeverity.WARNING, "Could not perform a database monitor add for that channel");
        BADCOUNT = new CAStatus("BADCOUNT", 22, CASeverity.WARNING, "Count requested inappropriate for that channel");
        BADSTR = new CAStatus("BADSTR", 23, CASeverity.ERROR, "The supplied string has improper format");
        DISCONN = new CAStatus("DISCONN", 24, CASeverity.WARNING, "Virtual circuit disconnect");
        DBLCHNL = new CAStatus("DBLCHNL", 25, CASeverity.WARNING, "Identical process variable name on multiple servers");
        EVDISALLOW = new CAStatus("EVDISALLOW", 26, CASeverity.ERROR, "The CA routine called is inappropriate for use within an event handler");
        BUILDGET = new CAStatus("BUILDGET", 27, CASeverity.WARNING, "Database value get for that channel failed during channel search");
        NEEDSFP = new CAStatus("NEEDSFP", 28, CASeverity.WARNING, "Unable to initialize without the vxWorks VX_FP_TASK task option set");
        OVEVFAIL = new CAStatus("OVEVFAIL", 29, CASeverity.WARNING, "Event queue overflow has prevented first pass event after event add");
        BADMONID = new CAStatus("BADMONID", 30, CASeverity.ERROR, "bad monitor subscription identifier");
        NEWADDR = new CAStatus("NEWADDR", 31, CASeverity.WARNING, "Remote channel has new network address");
        NEWCONN = new CAStatus("NEWCONN", 32, CASeverity.INFO, "New or resumed network connection");
        NOCACTX = new CAStatus("NOCACTX", 33, CASeverity.WARNING, "Specified task isnt a member of a CA context");
        DEFUNCT = new CAStatus("DEFUNCT", 34, CASeverity.FATAL, "Attempt to use defunct CA feature failed");
        EMPTYSTR = new CAStatus("EMPTYSTR", 35, CASeverity.WARNING, "The supplied string is empty");
        NOREPEATER = new CAStatus("NOREPEATER", 36, CASeverity.WARNING, "Unable to spawn the CA repeater thread- auto reconnect will fail");
        NOCHANMSG = new CAStatus("NOCHANMSG", 37, CASeverity.WARNING, "No channel id match for search reply- search reply ignored");
        DLCKREST = new CAStatus("DLCKREST", 38, CASeverity.WARNING, "Reseting dead connection- will try to reconnect");
        SERVBEHIND = new CAStatus("SERVBEHIND", 39, CASeverity.WARNING, "Server (IOC) has fallen behind or is not responding- still waiting");
        NOCAST = new CAStatus("NOCAST", 40, CASeverity.WARNING, "No internet interface with broadcast available");
        BADMASK = new CAStatus("BADMASK", 41, CASeverity.ERROR, "The monitor selection mask supplied is empty or inappropriate");
        IODONE = new CAStatus("IODONE", 42, CASeverity.INFO, "IO operations have completed");
        IOINPROGESS = new CAStatus("IOINPROGESS", 43, CASeverity.INFO, "IO operations are in progress");
        BADSYNCGRP = new CAStatus("BADSYNCGRP", 44, CASeverity.ERROR, "Invalid synchronous group identifier");
        PUTCBINPROG = new CAStatus("PUTCBINPROG", 45, CASeverity.ERROR, "Put callback timed out");
        NORDACCESS = new CAStatus("NORDACCESS", 46, CASeverity.WARNING, "Read access denied");
        NOWTACCESS = new CAStatus("NOWTACCESS", 47, CASeverity.WARNING, "Write access denied");
        ANACHRONISM = new CAStatus("ANACHRONISM", 48, CASeverity.ERROR, "Sorry, that anachronistic feature of CA is no longer supported");
        NOSEARCHADDR = new CAStatus("NOSEARCHADDR", 49, CASeverity.WARNING, "The search/beacon request address list was empty after initialization");
        NOCONVERT = new CAStatus("NOCONVERT", 50, CASeverity.WARNING, "Data conversion between client's type and the server's type failed");
        BADCHID = new CAStatus("BADCHID", 51, CASeverity.ERROR, "Invalid channel identifier");
        BADFUNCPTR = new CAStatus("BADFUNCPTR", 52, CASeverity.ERROR, "Invalid function pointer");
        ISATTACHED = new CAStatus("ISATTACHED", 53, CASeverity.WARNING, "Thread is already attached to a client context");
        UNAVAILINSERV = new CAStatus("UNAVAILINSERV", 54, CASeverity.WARNING, "No support in service");
        CHANDESTROY = new CAStatus("CHANDESTROY", 55, CASeverity.WARNING, "User destroyed channel");
        BADPRIORITY = new CAStatus("BADPRIORITY", 56, CASeverity.ERROR, "Priority out of range");
        NOTTHREADED = new CAStatus("NOTTHREADED", 57, CASeverity.ERROR, "Preemptive callback not enabled - additional threads may not join");
        ARRAY16KCLIENT = new CAStatus("ARRAY16KCLIENT", 58, CASeverity.WARNING, "Client's protocol revision does not support transfers exceeding 16k bytes");
        CONNSEQTMO = new CAStatus("CONNSEQTMO", 59, CASeverity.WARNING, "Virtual circuit connection sequence aborted");
        UNRESPTMO = new CAStatus("UNRESPTMO", 60, CASeverity.WARNING, "Virtual circuit connection unresponsive");
        int maxValue = 0;
        Iterator it = _map.values().iterator();
        while (it.hasNext()) {
            t = (CAStatus)it.next();
            if (t.getValue() <= maxValue) continue;
            maxValue = t.getValue();
        }
        _cachedTypesByValue = new CAStatus[maxValue + 1];
        it = _map.values().iterator();
        while (it.hasNext()) {
            t = (CAStatus)it.next();
            if (t.getValue() < 0) continue;
            CAStatus._cachedTypesByValue[t.getValue()] = t;
        }
    }
}

