/*
 * Decompiled with CFR 0.152.
 */
package jsvnbrowser;

import editor.StartParameters;
import editor.dialogs.AuthenticationEditor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import jsvnbrowser.JSVNBrowser;
import jsvnbrowser.JSVNFileInfo;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNException;
import org.tmatesoft.svn.core.SVNLogEntry;
import org.tmatesoft.svn.core.SVNNodeKind;
import org.tmatesoft.svn.core.SVNProperties;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.ISVNAuthenticationManager;
import org.tmatesoft.svn.core.internal.io.dav.DAVRepositoryFactory;
import org.tmatesoft.svn.core.io.ISVNDeltaConsumer;
import org.tmatesoft.svn.core.io.ISVNEditor;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.io.diff.SVNDeltaGenerator;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

public class JSVNList
extends JTree
implements TreeExpansionListener,
TreeSelectionListener,
MouseListener,
DragSourceListener,
DropTargetListener,
DragGestureListener {
    private DefaultTreeModel m_tmTreeModel;
    protected SVNRepository repository = null;
    private JSVNBrowser browser;
    private String repositoryPath = null;
    static DataFlavor localObjectFlavor;
    static DataFlavor[] supportedFlavors;
    DragSource dragSource;
    DropTarget dropTarget;
    TreeNode dropTargetNode = null;
    TreeNode draggedNode = null;
    String from = null;

    public JSVNList(JSVNBrowser jsvn) {
        this.browser = jsvn;
        this.getSelectionModel().setSelectionMode(1);
        this.getRepository(StartParameters.getInstance().getSvnRepository());
        this.setCellRenderer(new DnDTreeCellRenderer());
        this.setModel(new DefaultTreeModel(new DefaultMutableTreeNode("default")));
        this.dragSource = new DragSource();
        this.dragSource.createDefaultDragGestureRecognizer(this, 2, this);
        this.dropTarget = new DropTarget(this, this);
    }

    public JSVNList(JSVNBrowser jsvn, String path) {
        this.browser = jsvn;
        this.repositoryPath = path;
        this.getSelectionModel().setSelectionMode(1);
        this.getRepository(this.repositoryPath);
        this.setCellRenderer(new DnDTreeCellRenderer());
        this.setModel(new DefaultTreeModel(new DefaultMutableTreeNode("default")));
        this.dragSource = new DragSource();
        this.dragSource.createDefaultDragGestureRecognizer(this, 2, this);
        this.dropTarget = new DropTarget(this, this);
    }

    private void getRepository(String repositoryPath) {
        DAVRepositoryFactory.setup();
        try {
            this.repository = SVNRepositoryFactory.create((SVNURL)SVNURL.parseURIEncoded((String)repositoryPath));
            this.repository.getRepositoryRoot(true);
        }
        catch (SVNException svne) {
            String repos = (String)JOptionPane.showInputDialog(this, "SVN Repository path is wrong.\nSet new path:", "Settings", 3, null, null, repositoryPath);
            if (repos != null && repos.startsWith("http://")) {
                StartParameters startParams = StartParameters.getInstance();
                startParams.setSvnRepository(repos);
                startParams.save(startParams.getWidth(), startParams.getHeight(), startParams.getDividerHor1(), startParams.getDividerHor2(), startParams.getDividerVer1());
                this.getRepository(repos);
                return;
            }
            this.repository = null;
            return;
        }
    }

    private boolean authenticate() {
        boolean OK = true;
        StartParameters startParams = StartParameters.getInstance();
        String name = startParams.getSvnName();
        String password = startParams.getSvnPassword();
        if (name == null || password == null) {
            AuthenticationEditor aeditor = new AuthenticationEditor(name, password);
            String[] tmp = aeditor.showDialog(this.browser);
            name = tmp[0];
            password = tmp[1];
            if (password.equalsIgnoreCase("CANCEL")) {
                return !OK;
            }
            startParams.setSvnName(name);
            startParams.setSvnPassword(password);
        }
        ISVNAuthenticationManager authManager = SVNWCUtil.createDefaultAuthenticationManager((String)name, (String)password);
        this.repository.setAuthenticationManager(authManager);
        return OK;
    }

    public void initTree() {
        String rootName = this.repositoryPath;
        if (rootName == null) {
            rootName = StartParameters.getInstance().getSvnRepository();
        }
        rootName = rootName.substring(rootName.lastIndexOf("/") + 1);
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(rootName);
        this.m_tmTreeModel = new DefaultTreeModel(root);
        this.setModel(this.m_tmTreeModel);
        this.m_tmTreeModel.setAsksAllowsChildren(true);
        this.listEntries("", root);
        this.expandRow(0);
        this.addTreeExpansionListener(this);
        this.addTreeSelectionListener(this);
        this.addMouseListener(this);
        this.setToolTipText("");
    }

    public Vector getDirectories(String path) {
        Vector<String> directories = new Vector<String>();
        try {
            Collection entries = this.repository.getDir(path, -1L, null, (Collection)null);
            for (SVNDirEntry entry : entries) {
                if (entry.getKind() != SVNNodeKind.DIR) continue;
                directories.add(entry.getName() + "/");
            }
        }
        catch (SVNException svne) {
            System.err.println("JSVNList.getDirectories(String path): " + svne.getMessage());
        }
        return directories;
    }

    private void listEntries(String path, DefaultMutableTreeNode root) {
        try {
            String nt;
            DefaultMutableTreeNode node;
            int i;
            boolean inserted;
            DefaultMutableTreeNode element;
            Collection entries = this.repository.getDir(path, -1L, null, (Collection)null);
            root.removeAllChildren();
            int directoryCounter = 0;
            for (SVNDirEntry entry : entries) {
                element = new DefaultMutableTreeNode(entry.getName());
                if (entry.getKind() != SVNNodeKind.DIR) continue;
                inserted = false;
                for (i = 0; i < root.getChildCount(); ++i) {
                    node = (DefaultMutableTreeNode)root.getChildAt(i);
                    nt = node.getUserObject().toString();
                    if (nt.compareToIgnoreCase(entry.getName()) <= 0) continue;
                    root.insert(element, i);
                    inserted = true;
                    break;
                }
                if (!inserted) {
                    root.add(element);
                }
                ++directoryCounter;
            }
            for (SVNDirEntry entry : entries) {
                element = new DefaultMutableTreeNode(entry.getName());
                if (entry.getKind() != SVNNodeKind.FILE) continue;
                element.setAllowsChildren(false);
                if (!this.browser.selectedFileType.equalsIgnoreCase("All Files (*.*)") && (!this.browser.selectedFileType.equalsIgnoreCase("xml Files") || !entry.getName().endsWith(".xml")) && (!this.browser.selectedFileType.equalsIgnoreCase("Images") || !entry.getName().endsWith(".gif") && !entry.getName().endsWith(".jpg") && !entry.getName().endsWith("jpeg") && !entry.getName().endsWith("png") && !entry.getName().endsWith("bmp"))) continue;
                inserted = false;
                for (i = directoryCounter; i < root.getChildCount(); ++i) {
                    node = (DefaultMutableTreeNode)root.getChildAt(i);
                    nt = node.getUserObject().toString();
                    if (nt.compareToIgnoreCase(entry.getName()) <= 0) continue;
                    root.insert(element, i);
                    inserted = true;
                    break;
                }
                if (inserted || !root.getAllowsChildren()) continue;
                root.add(element);
            }
        }
        catch (SVNException svne) {
            System.err.println("JSVNList.listEntries(): " + svne.getMessage());
        }
    }

    public void dirUp() {
        TreePath selPath = this.getSelectionPath();
        if (selPath != null && selPath.getParentPath() != null && !selPath.getParentPath().getLastPathComponent().toString().equalsIgnoreCase("Root")) {
            this.collapsePath(selPath.getParentPath());
        }
    }

    public void newDir() {
        TreePath selPath = this.getSelectionPath();
        if (selPath != null && ((DefaultMutableTreeNode)selPath.getLastPathComponent()).getAllowsChildren() && this.authenticate()) {
            String path = this.getSVNPath(selPath);
            String folderName = JOptionPane.showInputDialog(this.browser, (Object)"Folder Name:");
            if (folderName != null && folderName.length() > 0) {
                try {
                    ISVNEditor editor = this.repository.getCommitEditor("directory added", null);
                    editor.openRoot(-1L);
                    editor.openDir(path, -1L);
                    editor.addDir(path + "/" + folderName, null, -1L);
                    editor.closeDir();
                    editor.closeDir();
                    editor.closeDir();
                    System.out.println("The directory was added: " + editor.closeEdit());
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)selPath.getLastPathComponent();
                    this.listEntries(path, node);
                    this.m_tmTreeModel.nodeStructureChanged(node);
                    this.expandPath(selPath);
                }
                catch (SVNException svne) {
                    if (svne.getMessage().contains("Authentication")) {
                        JOptionPane.showMessageDialog(this.browser, "Authentication exception.");
                        StartParameters.getInstance().setSvnPassword(null);
                    }
                    System.err.println("JSVNList.newDir(): " + svne.getMessage());
                }
            }
        }
    }

    public boolean fileSave(String str) {
        boolean OK = true;
        byte[] contents = str.getBytes();
        TreePath selPath = this.getSelectionPath();
        String fileName = this.browser.getFileName();
        if (selPath != null && fileName != null) {
            String path;
            if (((DefaultMutableTreeNode)selPath.getLastPathComponent()).getAllowsChildren()) {
                path = this.getSVNPath(selPath);
            } else {
                selPath = selPath.getParentPath();
                path = this.getSVNPath(selPath);
                this.setSelectionPath(selPath);
            }
            if (fileName != null && !fileName.equalsIgnoreCase(".xml") && fileName.length() > 4) {
                try {
                    String filePath = path + "/" + fileName;
                    SVNNodeKind nodeKind = this.repository.checkPath(filePath, -1L);
                    if (nodeKind == SVNNodeKind.NONE && this.authenticate()) {
                        String logMessage = JOptionPane.showInputDialog(this.browser, "Log Message:", "Save File", 3);
                        if (logMessage == null) {
                            return !OK;
                        }
                        if (logMessage.length() >= 2) {
                            ISVNEditor editor = this.repository.getCommitEditor(logMessage, null);
                            editor.openRoot(-1L);
                            editor.openDir(path, -1L);
                            editor.addFile(filePath, null, -1L);
                            editor.applyTextDelta(filePath, null);
                            SVNDeltaGenerator deltaGenerator = new SVNDeltaGenerator();
                            String checksum = deltaGenerator.sendDelta(filePath, (InputStream)new ByteArrayInputStream(contents), (ISVNDeltaConsumer)editor, true);
                            editor.closeFile(filePath, checksum);
                            editor.closeDir();
                            editor.closeDir();
                            System.out.println(fileName + " file was added: " + editor.closeEdit());
                            DefaultMutableTreeNode node = (DefaultMutableTreeNode)selPath.getLastPathComponent();
                            this.listEntries(path, node);
                            this.m_tmTreeModel.nodeStructureChanged(node);
                            this.expandPath(selPath);
                            SVNDirEntry entry = this.repository.info(path, -1L);
                            this.browser.fileInfo = new JSVNFileInfo("/svn/" + filePath, entry.getAuthor(), entry.getDate(), entry.getSize(), entry.getRevision(), null, null);
                            return OK;
                        }
                        JOptionPane.showMessageDialog(this.browser, "Please enter Log Message.");
                        return this.fileSave(str);
                    }
                    if (nodeKind == SVNNodeKind.DIR || nodeKind == SVNNodeKind.UNKNOWN) {
                        JOptionPane.showMessageDialog(this.browser, "Can't save to a directory.");
                    }
                    if (nodeKind == SVNNodeKind.FILE) {
                        this.fileSaveTo(str, filePath, null);
                        return OK;
                    }
                }
                catch (SVNException svne) {
                    if (svne.getMessage().contains("Authentication")) {
                        JOptionPane.showMessageDialog(this.browser, "Authentication exception.");
                        StartParameters.getInstance().setSvnPassword(null);
                    }
                    System.err.println("JSVNList.fileSave(): " + svne.getMessage());
                }
            } else {
                JOptionPane.showMessageDialog(this.browser, "Please enter file name.");
            }
        } else {
            JOptionPane.showMessageDialog(this.browser, "Please select correct file path first.");
        }
        return !OK;
    }

    public JSVNFileInfo fileSaveTo(String xmlstr, String filePath, String versionDate) {
        if (xmlstr != null && filePath != null) {
            try {
                int option;
                SVNDirEntry entry = this.repository.info(filePath, -1L);
                if (versionDate != null && !entry.getDate().toString().equalsIgnoreCase(versionDate) && (option = JOptionPane.showConfirmDialog(this.browser, "<html>Edited version is older than version in SVN.<br>Do you really want to save?</html>", "Please Confirm", 0)) == 1) {
                    return null;
                }
            }
            catch (SVNException svne) {
                System.err.println("JSVNList.fileSaveTo(): " + svne.getMessage());
            }
            byte[] contents = xmlstr.getBytes();
            String path = "";
            String fileName = filePath;
            if (filePath.contains("/")) {
                path = filePath.substring(0, filePath.lastIndexOf("/"));
                fileName = filePath.substring(filePath.lastIndexOf("/") + 1);
            }
            if (this.authenticate()) {
                String logMessage = JOptionPane.showInputDialog(this.browser, "Log Message:", "Save File", 3);
                if (logMessage == null) {
                    return null;
                }
                if (logMessage.length() >= 2) {
                    JSVNFileInfo fInfo = this.fileOpen(filePath, -1L);
                    ByteArrayInputStream oldData = new ByteArrayInputStream(fInfo.buf);
                    try {
                        ISVNEditor editor = this.repository.getCommitEditor(logMessage, null);
                        editor.openRoot(-1L);
                        editor.openDir(path, -1L);
                        editor.openFile(filePath, -1L);
                        editor.applyTextDelta(filePath, null);
                        SVNDeltaGenerator deltaGenerator = new SVNDeltaGenerator();
                        String checksum = deltaGenerator.sendDelta(filePath, (InputStream)oldData, 0L, (InputStream)new ByteArrayInputStream(contents), (ISVNDeltaConsumer)editor, true);
                        editor.closeFile(filePath, checksum);
                        editor.closeDir();
                        editor.closeDir();
                        System.out.println(fileName + " file contents changed: " + editor.closeEdit());
                        SVNDirEntry entry = this.repository.info(filePath, -1L);
                        this.browser.fileInfo = fInfo = new JSVNFileInfo("/svn/" + filePath, entry.getAuthor(), entry.getDate(), entry.getSize(), entry.getRevision(), null, null);
                        return fInfo;
                    }
                    catch (SVNException svne) {
                        if (svne.getMessage().contains("Authentication")) {
                            JOptionPane.showMessageDialog(this.browser, "Authentication exception.");
                            StartParameters.getInstance().setSvnPassword(null);
                        }
                        System.err.println("JSVNList.fileSaveTo(): " + svne.getMessage());
                    }
                } else {
                    JOptionPane.showMessageDialog(this.browser, "Please enter Log Message.");
                    return this.fileSaveTo(xmlstr, filePath, versionDate);
                }
            }
        }
        return null;
    }

    public JSVNFileInfo fileOpen(String filePath, long revision) {
        JSVNFileInfo fInfo = null;
        SVNProperties fileProperties = new SVNProperties();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        SVNDirEntry entry = null;
        try {
            this.repository.getFile(filePath, revision, fileProperties, (OutputStream)baos);
            entry = this.repository.info(filePath, revision);
            byte[] buf = baos.toByteArray();
            fInfo = new JSVNFileInfo("/svn/" + filePath, entry.getAuthor(), entry.getDate(), entry.getSize(), entry.getRevision(), buf, null);
        }
        catch (SVNException svne) {
            // empty catch block
        }
        return fInfo;
    }

    public void fileDelete() {
        TreePath selPath = this.getSelectionPath();
        if (selPath != null) {
            int option = JOptionPane.showConfirmDialog(this.browser, "Do you really want to delete " + this.getSVNPath(selPath) + "?", "Please Confirm", 0);
            if (option == 0 && this.authenticate()) {
                try {
                    String filePath = this.getSVNPath(selPath);
                    String path = "";
                    String fileName = filePath;
                    if (filePath.contains("/")) {
                        path = filePath.substring(0, filePath.lastIndexOf("/"));
                        fileName = filePath.substring(filePath.lastIndexOf("/") + 1);
                    }
                    ISVNEditor editor = this.repository.getCommitEditor("file removed", null);
                    editor.openRoot(-1L);
                    if (filePath.contains("/")) {
                        editor.openDir(path, -1L);
                    }
                    editor.deleteEntry(filePath, -1L);
                    if (filePath.contains("/")) {
                        editor.closeDir();
                    }
                    editor.closeDir();
                    System.out.println(fileName + " file was removed: " + editor.closeEdit());
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)selPath.getParentPath().getLastPathComponent();
                    this.listEntries(path, node);
                    this.m_tmTreeModel.nodeStructureChanged(node);
                }
                catch (SVNException svne) {
                    if (svne.getMessage().contains("Authentication")) {
                        JOptionPane.showMessageDialog(this.browser, "Authentication exception.");
                        StartParameters.getInstance().setSvnPassword(null);
                    }
                    System.err.println("JSVNList.fileDelete(): " + svne.getMessage());
                }
            }
        } else {
            JOptionPane.showMessageDialog(this.browser, "No file selected.");
        }
    }

    public void goHome() {
        this.collapseRow(0);
        this.expandRow(0);
    }

    private String getSVNPath(TreePath treePath) {
        String path = "";
        if (treePath != null) {
            for (int i = 1; i < treePath.getPathCount(); ++i) {
                path = path + treePath.getPathComponent(i);
                if (i + 1 >= treePath.getPathCount()) continue;
                path = path + "/";
            }
        }
        return path;
    }

    public void openPath(String path) {
        Object[] nodes;
        int i;
        String fullPath = "";
        TreePath root = this.getPathForRow(0);
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)root.getLastPathComponent();
        while (path.contains("/")) {
            for (i = 0; i < node.getChildCount(); ++i) {
                if (!node.getChildAt(i).toString().equalsIgnoreCase(path.substring(0, path.indexOf("/")))) continue;
                fullPath = fullPath + path.substring(0, path.indexOf("/") + 1);
                node = (DefaultMutableTreeNode)node.getChildAt(i);
                this.listEntries(fullPath, node);
                this.m_tmTreeModel.nodeStructureChanged(node);
                nodes = this.m_tmTreeModel.getPathToRoot(node);
                this.expandPath(new TreePath(nodes));
            }
            path = path.substring(path.indexOf("/") + 1);
        }
        for (i = 0; i < node.getChildCount(); ++i) {
            if (!node.getChildAt(i).toString().equalsIgnoreCase(path)) continue;
            fullPath = fullPath + path;
            node = (DefaultMutableTreeNode)node.getChildAt(i);
            this.listEntries(fullPath, node);
            this.m_tmTreeModel.nodeStructureChanged(node);
            nodes = this.m_tmTreeModel.getPathToRoot(node);
            this.expandPath(new TreePath(nodes));
            this.setSelectionPath(new TreePath(nodes));
        }
    }

    public void reloadTree() {
    }

    private void fileMove(String from, String to) {
        if (from != null && to != null) {
            String destination = null;
            destination = from.contains("/") ? to + from.substring(from.lastIndexOf("/")) : to + "/" + from;
            if (this.authenticate()) {
                try {
                    Collection logEntries = this.repository.log(new String[]{from}, null, 0L, -1L, true, true);
                    Object[] leArray = logEntries.toArray();
                    String logMessage = ((SVNLogEntry)leArray[leArray.length - 1]).getMessage();
                    long sRev = ((SVNLogEntry)leArray[leArray.length - 1]).getRevision();
                    long headRev = this.repository.getLatestRevision();
                    ISVNEditor editor = this.repository.getCommitEditor(logMessage, null);
                    editor.openRoot(headRev);
                    editor.deleteEntry(from, headRev);
                    editor.openDir(to, -1L);
                    editor.addFile(destination, from, sRev);
                    editor.closeFile(destination, null);
                    editor.closeDir();
                    editor.closeDir();
                    System.out.println(from + " moved to " + to + ": " + editor.closeEdit());
                }
                catch (SVNException svne) {
                    if (svne.getMessage().contains("Authentication")) {
                        JOptionPane.showMessageDialog(this.browser, "Authentication exception.");
                        StartParameters.getInstance().setSvnPassword(null);
                    }
                    System.err.println("JSVNList.fileSaveTo(): " + svne.getMessage());
                }
            }
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        String path = this.getSVNPath(e.getPath());
        if (!this.isSelectionEmpty() && !((DefaultMutableTreeNode)e.getPath().getLastPathComponent()).getAllowsChildren()) {
            SVNProperties fileProperties = new SVNProperties();
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            SVNDirEntry entry = null;
            Collection logEntries = null;
            try {
                this.repository.getFile(path, -1L, fileProperties, (OutputStream)baos);
                entry = this.repository.info(path, -1L);
                logEntries = this.repository.log(new String[]{path}, null, 0L, -1L, true, true);
                byte[] buf = baos.toByteArray();
                JSVNFileInfo fInfo = new JSVNFileInfo("/svn/" + path, entry.getAuthor(), entry.getDate(), entry.getSize(), entry.getRevision(), buf, logEntries);
                this.browser.fileSelected(fInfo);
            }
            catch (SVNException svne) {
                System.err.println("JSVNList.valueChanged(): " + svne.getMessage());
            }
        } else {
            this.browser.fileSelected(null);
            this.browser.updateLabels(path);
        }
    }

    @Override
    public void treeExpanded(TreeExpansionEvent e) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)e.getPath().getLastPathComponent();
        String path = this.getSVNPath(e.getPath());
        if (node.isLeaf()) {
            this.listEntries(path, node);
        }
        this.m_tmTreeModel.nodeStructureChanged(node);
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.browser.dialogType == 0 && e.getClickCount() == 2) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getSelectionPath().getLastPathComponent();
            String path = this.getSVNPath(this.getSelectionPath());
            if (!node.getAllowsChildren() && path.endsWith(".xml")) {
                JSVNFileInfo fInfo;
                this.browser.fileInfo = fInfo = this.fileOpen(path, -1L);
                if (fInfo != null) {
                    this.browser.dispose();
                }
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void dragGestureRecognized(DragGestureEvent dge) {
        Point clickPoint = dge.getDragOrigin();
        TreePath path = this.getPathForLocation(clickPoint.x, clickPoint.y);
        this.from = this.getSVNPath(path);
        if (path == null) {
            return;
        }
        this.draggedNode = (TreeNode)path.getLastPathComponent();
        RJLTransferable trans = new RJLTransferable(this.draggedNode);
        this.dragSource.startDrag(dge, Cursor.getDefaultCursor(), trans, this);
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dsde) {
        this.dropTargetNode = null;
        this.draggedNode = null;
        this.from = null;
        this.repaint();
    }

    @Override
    public void dragEnter(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragExit(DragSourceEvent dse) {
    }

    @Override
    public void dragOver(DragSourceDragEvent dsde) {
    }

    @Override
    public void dropActionChanged(DragSourceDragEvent dsde) {
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        dtde.acceptDrag(3);
    }

    @Override
    public void dragExit(DropTargetEvent dte) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        Point dragPoint = dtde.getLocation();
        TreePath path = this.getPathForLocation(dragPoint.x, dragPoint.y);
        this.dropTargetNode = path == null ? null : (TreeNode)path.getLastPathComponent();
        this.repaint();
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        Point dropPoint = dtde.getLocation();
        TreePath path = this.getPathForLocation(dropPoint.x, dropPoint.y);
        boolean dropped = false;
        try {
            dtde.acceptDrop(2);
            Object droppedObject = dtde.getTransferable().getTransferData(localObjectFlavor);
            DefaultMutableTreeNode dropNode = (DefaultMutableTreeNode)path.getLastPathComponent();
            String to = null;
            to = !dropNode.getAllowsChildren() ? this.getSVNPath(path.getParentPath()) : this.getSVNPath(path);
            String compare = this.from;
            if (this.from.contains("/")) {
                compare = this.from.substring(0, this.from.lastIndexOf("/"));
            }
            if (!compare.equalsIgnoreCase(to) && !this.from.equalsIgnoreCase(to)) {
                MutableTreeNode droppedNode = null;
                if (droppedObject instanceof MutableTreeNode) {
                    droppedNode = (MutableTreeNode)droppedObject;
                    ((DefaultTreeModel)this.getModel()).removeNodeFromParent(droppedNode);
                } else {
                    droppedNode = new DefaultMutableTreeNode(droppedObject);
                }
                if (!dropNode.getAllowsChildren()) {
                    DefaultMutableTreeNode parent = (DefaultMutableTreeNode)dropNode.getParent();
                    int index = parent.getIndex(dropNode);
                    ((DefaultTreeModel)this.getModel()).insertNodeInto(droppedNode, parent, index);
                    this.fileMove(this.from, to);
                } else {
                    ((DefaultTreeModel)this.getModel()).insertNodeInto(droppedNode, dropNode, dropNode.getChildCount());
                    this.fileMove(this.from, to);
                }
                this.openPath(to);
                dropped = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        dtde.dropComplete(dropped);
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dtde) {
    }

    static {
        try {
            localObjectFlavor = new DataFlavor("application/x-java-jvm-local-objectref");
        }
        catch (ClassNotFoundException cnfe) {
            cnfe.printStackTrace();
        }
        supportedFlavors = new DataFlavor[]{localObjectFlavor};
    }

    class DnDTreeCellRenderer
    extends DefaultTreeCellRenderer {
        boolean isTargetNode;
        boolean isTargetNodeLeaf;
        boolean isLastItem;
        int BOTTOM_PAD = 30;

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean isExpanded, boolean isLeaf, int row, boolean hasFocus) {
            this.isTargetNode = value == JSVNList.this.dropTargetNode;
            this.isTargetNodeLeaf = this.isTargetNode && !((TreeNode)value).getAllowsChildren();
            super.getTreeCellRendererComponent(tree, value, isSelected, isExpanded, isLeaf, row, hasFocus);
            if (isLeaf) {
                this.setToolTipText(value.toString());
            } else {
                this.setToolTipText(null);
            }
            return this;
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.isTargetNode) {
                g.setColor(Color.black);
                if (this.isTargetNodeLeaf) {
                    g.drawLine(0, 0, this.getSize().width, 0);
                } else {
                    g.drawRect(0, 0, this.getSize().width - 1, this.getSize().height - 1);
                }
            }
        }
    }

    class RJLTransferable
    implements Transferable {
        Object object;

        public RJLTransferable(Object o) {
            this.object = o;
        }

        @Override
        public Object getTransferData(DataFlavor df) throws UnsupportedFlavorException, IOException {
            if (this.isDataFlavorSupported(df)) {
                return this.object;
            }
            throw new UnsupportedFlavorException(df);
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor df) {
            return df.equals(localObjectFlavor);
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return supportedFlavors;
        }
    }
}

