/*
 * Decompiled with CFR 0.152.
 */
package editor;

import DOOCSComponents.DOOCSParameter;
import editor.ColorIcon;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import xmlparser.IntegerParser;

public class PropsTableCellRenderer
implements TableCellRenderer {
    JLabel label = new JLabel();
    JCheckBox checkbox;

    public PropsTableCellRenderer() {
        this.label.setIconTextGap(4);
        this.checkbox = new JCheckBox();
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value != null) {
            String type = table.getModel().getValueAt(row, 2).toString();
            this.label.setFont(new Font("arial", 0, 12));
            this.label.setIcon(null);
            this.label.setToolTipText(value.toString());
            if (DOOCSParameter.compareRegex(type, value.toString())) {
                this.label.setForeground(Color.BLACK);
            } else {
                this.label.setForeground(Color.RED);
            }
            if (type.equalsIgnoreCase("COLOR")) {
                this.label.setText(" [" + value + "]");
                this.label.setIcon(new ColorIcon(DOOCSParameter.convertToColor(value.toString())));
                this.label.setToolTipText("RGB value: " + value);
                return this.label;
            }
            if (type.equalsIgnoreCase("FONT")) {
                String fontString = value.toString();
                this.label.setText(" " + fontString);
                int komma1 = fontString.indexOf(",");
                int komma2 = fontString.indexOf(",", komma1 + 1);
                String name = fontString.substring(0, komma1);
                int style = IntegerParser.parseInt(fontString.substring(komma1 + 1, komma2));
                this.label.setFont(new Font(name, style, 12));
                return this.label;
            }
            if (type.equalsIgnoreCase("BOUNDS") || type.equalsIgnoreCase("POINTS") || type.equalsIgnoreCase("GRID") || type.equalsIgnoreCase("SIZE")) {
                this.label.setText(" [" + value + "]");
                return this.label;
            }
            if (type.equalsIgnoreCase("DOOCSADDRESS")) {
                this.label.setText(" " + value.toString());
                return this.label;
            }
            if (type.equalsIgnoreCase("BOOLEAN") || type.equalsIgnoreCase("BORDER")) {
                if (value.toString().equalsIgnoreCase("true")) {
                    this.checkbox.setSelected(true);
                } else {
                    this.checkbox.setSelected(false);
                }
                this.checkbox.setToolTipText(value.toString());
                return this.checkbox;
            }
            if (type.equalsIgnoreCase("CHOICE")) {
                ImageIcon icon = null;
                URL imageUrl = this.getClass().getResource("icons/choiceIcons/" + value.toString() + ".gif");
                if (imageUrl != null) {
                    icon = new ImageIcon(imageUrl);
                } else {
                    imageUrl = this.getClass().getResource("icons/choiceIcons/" + value.toString() + ".png");
                    if (imageUrl != null) {
                        icon = new ImageIcon(imageUrl);
                    }
                }
                this.label.setIcon(icon);
                this.label.setText(" " + value.toString());
                return this.label;
            }
            this.label.setText(" " + value.toString());
            return this.label;
        }
        return null;
    }
}

