/*
 * Decompiled with CFR 0.152.
 */
package editor;

import DOOCSComponents.DOOCSParameter;
import editor.PropsTable;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;

public class PropsTableCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    JComponent textEditor = new JTextField();
    JComponent checkbox = new JCheckBox();
    JComponent comboboxLayer;
    JComponent comboboxChoice;
    JComponent comboboxAlignX;
    JComponent comboboxAlignY;
    String type;

    public PropsTableCellEditor() {
        ((JCheckBox)this.checkbox).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PropsTableCellEditor.this.fireEditingStopped();
            }
        });
        this.comboboxLayer = new JComboBox<Object>(new Object[]{"NONE", "EDIT", "VACUUM", "MAGNETS", "BEAM_DIAG", "RF"});
        ((JComboBox)this.comboboxLayer).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PropsTableCellEditor.this.fireEditingStopped();
            }
        });
        this.comboboxAlignX = new JComboBox<Object>(new Object[]{"LEFT", "CENTER", "RIGHT"});
        ((JComboBox)this.comboboxAlignX).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PropsTableCellEditor.this.fireEditingStopped();
            }
        });
        this.comboboxAlignY = new JComboBox<Object>(new Object[]{"TOP", "CENTER", "BOTTOM"});
        ((JComboBox)this.comboboxAlignY).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PropsTableCellEditor.this.fireEditingStopped();
            }
        });
        this.type = null;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
        this.type = table.getModel().getValueAt(row, 2).toString();
        if (this.type.equalsIgnoreCase("BOOLEAN")) {
            if (value.toString().equalsIgnoreCase("true")) {
                ((JCheckBox)this.checkbox).setSelected(true);
            } else {
                ((JCheckBox)this.checkbox).setSelected(false);
            }
            return this.checkbox;
        }
        if (this.type.equalsIgnoreCase("LAYER")) {
            ((JComboBox)this.comboboxLayer).setSelectedItem(table.getValueAt(row, col));
            return this.comboboxLayer;
        }
        if (this.type.equalsIgnoreCase("CHOICE")) {
            this.comboboxChoice = new JComboBox<Object>(((PropsTable)table).getOptionList(row));
            if (this.comboboxChoice != null) {
                ((JComboBox)this.comboboxChoice).setRenderer(new DefaultListCellRenderer(){

                    @Override
                    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                        Component comp = super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                        JLabel label = new JLabel();
                        if (value != null) {
                            label.setOpaque(true);
                            label.setForeground(comp.getForeground());
                            label.setBackground(comp.getBackground());
                            ImageIcon icon = null;
                            URL imageUrl = this.getClass().getResource("icons/choiceIcons/" + value.toString() + ".gif");
                            if (imageUrl != null) {
                                icon = new ImageIcon(imageUrl);
                            } else {
                                imageUrl = this.getClass().getResource("icons/choiceIcons/" + value.toString() + ".png");
                                if (imageUrl != null) {
                                    icon = new ImageIcon(imageUrl);
                                }
                            }
                            label.setIcon(icon);
                            label.setText(" " + value.toString());
                        }
                        return label;
                    }
                });
                ((JComboBox)this.comboboxChoice).setSelectedItem(table.getValueAt(row, col));
                ((JComboBox)this.comboboxChoice).addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        PropsTableCellEditor.this.fireEditingStopped();
                    }
                });
                return this.comboboxChoice;
            }
        } else {
            if (this.type.equalsIgnoreCase("ALIGNX")) {
                ((JComboBox)this.comboboxAlignX).setSelectedItem(table.getValueAt(row, col));
                return this.comboboxAlignX;
            }
            if (this.type.equalsIgnoreCase("ALIGNY")) {
                ((JComboBox)this.comboboxAlignY).setSelectedItem(table.getValueAt(row, col));
                return this.comboboxAlignY;
            }
            ((JTextField)this.textEditor).setText((String)value);
            return this.textEditor;
        }
        return null;
    }

    @Override
    public Object getCellEditorValue() {
        if (this.type.equalsIgnoreCase("BOOLEAN")) {
            return ((JCheckBox)this.checkbox).isSelected();
        }
        if (this.type.equalsIgnoreCase("LAYER")) {
            return ((JComboBox)this.comboboxLayer).getSelectedItem().toString();
        }
        if (this.type.equalsIgnoreCase("CHOICE")) {
            if (((JComboBox)this.comboboxChoice).getSelectedItem() != null) {
                return ((JComboBox)this.comboboxChoice).getSelectedItem().toString();
            }
            return null;
        }
        if (this.type.equalsIgnoreCase("ALIGNX")) {
            return ((JComboBox)this.comboboxAlignX).getSelectedItem().toString();
        }
        if (this.type.equalsIgnoreCase("ALIGNY")) {
            return ((JComboBox)this.comboboxAlignY).getSelectedItem().toString();
        }
        String text = ((JTextField)this.textEditor).getText();
        if (!DOOCSParameter.compareRegex(this.type, text)) {
            Toolkit.getDefaultToolkit().beep();
        }
        return text;
    }
}

