/*
 * Decompiled with CFR 0.152.
 */
package editor;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import ttf.doocs.clnt.EqAdr;
import ttf.doocs.clnt.EqCall;
import ttf.doocs.clnt.EqData;

public class DoocsTreeView
extends JTree
implements TreeExpansionListener,
MouseListener {
    private DefaultTreeModel tmTreeModel;
    private DefaultMutableTreeNode tnRoot = new DefaultMutableTreeNode("DeviceTree");
    private JPopupMenu pupTreeMenu;
    private JMenuItem sortMenuItem;
    private boolean m_bSingleSort;

    public DoocsTreeView() {
        this.tmTreeModel = new DefaultTreeModel(this.tnRoot, true);
        this.setCellRenderer(new DoocsCellRenderer());
        this.setModel(this.tmTreeModel);
        this.expandPath(new TreePath(this.tnRoot));
        this.addTreeExpansionListener(this);
        this.appendChildren(this.tnRoot, "*///", 0);
        this.m_bSingleSort = false;
        this.addMouseListener(this);
        this.pupTreeMenu = new JPopupMenu();
        this.sortMenuItem = new JMenuItem("Sort subelements alphabetically");
        this.sortMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DoocsTreeView.this.sortMenuItemActionPerformed(evt);
            }
        });
        this.pupTreeMenu.add(this.sortMenuItem);
    }

    public void addML() {
        this.addMouseListener(this);
    }

    public void removeML() {
        this.removeMouseListener(this);
    }

    public void setDoocsAddr(String doocsAddress) {
        if (doocsAddress != null && doocsAddress.length() > 3 && !doocsAddress.startsWith("/")) {
            TreePath path = new TreePath(this.tnRoot);
            TreeNode node = (TreeNode)path.getLastPathComponent();
            while (doocsAddress != null && doocsAddress.contains("/")) {
                String tmpAddress = doocsAddress.substring(0, doocsAddress.indexOf("/"));
                doocsAddress = doocsAddress.substring(doocsAddress.indexOf("/") + 1);
                if (node.getChildCount() < 0) continue;
                Enumeration<? extends TreeNode> e = node.children();
                while (e.hasMoreElements()) {
                    TreeNode n = e.nextElement();
                    if (!n.toString().equalsIgnoreCase(tmpAddress)) continue;
                    node = (TreeNode)(path = path.pathByAddingChild(n)).getLastPathComponent();
                    if (node.isLeaf()) {
                        this.setSelectionPath(path);
                        Object[] aoObjects = this.getSelectionPath().getPath();
                        this.appendChildren((MutableTreeNode)this.getLastSelectedPathComponent(), this.getAddress(aoObjects), aoObjects.length);
                    }
                    this.expandPath(path);
                }
            }
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                if (!n.toString().startsWith(doocsAddress + " ")) continue;
                path = path.pathByAddingChild(n);
                this.setSelectionPath(path);
            }
            this.scrollPathToVisible(path);
        }
    }

    public String getDoocsAddr() {
        if (this.getSelectionPath() == null || this.getSelectionPath().getPath() == null) {
            return null;
        }
        return this.getAddress(this.getSelectionPath().getPath());
    }

    public String getDoocsAddresses(String sSeperator) {
        StringBuffer sAddresses = new StringBuffer("");
        TreePath[] atpTreePaths = this.getSelectionPaths();
        for (int nCount = 0; nCount < atpTreePaths.length; ++nCount) {
            if (nCount == atpTreePaths.length - 1) {
                sAddresses.append(this.expandAddresses(atpTreePaths[nCount].getPath(), sSeperator));
                continue;
            }
            sAddresses.append(this.expandAddresses(atpTreePaths[nCount].getPath(), sSeperator) + sSeperator);
        }
        return sAddresses.toString();
    }

    public String getDoocsAddresses() {
        return this.getDoocsAddresses("/");
    }

    protected String expandAddresses(Object[] aoObjects, String sSeperator) {
        if (aoObjects.length != 3) {
            return this.getAddress(aoObjects);
        }
        System.out.println("Main node for Drag 'n Drop seleted:");
        StringBuffer sAddrList = new StringBuffer("");
        String sAddress = this.getAddress(aoObjects);
        String[] asAddrParts = sAddress.split("/");
        Vector<NameContainer> vAddresses = this.getSubElements(sAddress);
        if (asAddrParts.length > 1) {
            String sPrefix = asAddrParts[0] + "/" + asAddrParts[1] + "/";
            for (int nCount = 0; nCount < vAddresses.size(); ++nCount) {
                sAddrList.append(sPrefix + vAddresses.get(nCount).getName() + "/*");
                if (nCount == vAddresses.size() - 1) continue;
                sAddrList.append(sSeperator);
            }
        }
        return sAddrList.toString();
    }

    protected Vector<NameContainer> getSubElements(String sAddress) {
        EqAdr eaAddress = new EqAdr(sAddress);
        EqCall ecCall = new EqCall();
        EqData edInData = ecCall.names(eaAddress);
        Vector<NameContainer> vAdresses = new Vector<NameContainer>();
        if (edInData.error() != 0) {
            System.out.println("Error ( " + edInData.error() + " )");
        } else {
            for (int nCount = 0; nCount < edInData.array_length(); ++nCount) {
                vAdresses.add(new NameContainer(this.translateName(edInData.get_string_arg(nCount)).trim(), edInData.get_ustr((int)nCount).i1_data));
            }
        }
        if (this.m_bSingleSort) {
            Collections.sort(vAdresses, new Comparator<NameContainer>(){

                @Override
                public int compare(NameContainer s1, NameContainer s2) {
                    return s1.getName().compareToIgnoreCase(s2.getName());
                }
            });
        }
        this.m_bSingleSort = false;
        return vAdresses;
    }

    protected String translateName(String name) {
        boolean bSpace = false;
        String returnStr = null;
        byte[] abString = name.getBytes();
        for (int i = 0; i < abString.length; ++i) {
            if (abString[i] >= 32) continue;
            abString[i] = 32;
        }
        returnStr = new String(abString);
        return returnStr.replaceAll("\\s+", " ");
    }

    protected void appendChildren(MutableTreeNode tnParent, String sAddress, int nDepth) {
        Vector<NameContainer> vAdresses = this.getSubElements(sAddress);
        for (int nCount = 0; nCount < vAdresses.size(); ++nCount) {
            DefaultMutableTreeNode tnTemp = new DefaultMutableTreeNode(vAdresses.get(nCount));
            tnTemp.setAllowsChildren(nDepth != 4);
            this.tmTreeModel.insertNodeInto(tnTemp, tnParent, tnParent.getChildCount());
        }
    }

    protected String getAddress(Object[] aoObjects) {
        StringBuffer sAddress = new StringBuffer("");
        for (int nCount = 1; nCount < 5; ++nCount) {
            if (nCount == aoObjects.length) {
                sAddress.append("*");
            } else if (nCount < aoObjects.length) {
                if (nCount < 4) {
                    sAddress.append(aoObjects[nCount].toString());
                } else {
                    sAddress.append(aoObjects[nCount].toString().split(" ")[0]);
                }
            }
            if (nCount >= 4) continue;
            sAddress.append("/");
        }
        return sAddress.toString();
    }

    @Override
    public void treeExpanded(TreeExpansionEvent e) {
        int nCount;
        this.setSelectionPath(e.getPath());
        if (nCount > 0) {
            for (nCount = this.tmTreeModel.getChildCount((MutableTreeNode)this.getLastSelectedPathComponent()); nCount > 0; --nCount) {
                this.tmTreeModel.removeNodeFromParent((MutableTreeNode)this.tmTreeModel.getChild((MutableTreeNode)this.getLastSelectedPathComponent(), nCount - 1));
            }
        }
        Object[] aoObjects = this.getSelectionPath().getPath();
        this.appendChildren((MutableTreeNode)this.getLastSelectedPathComponent(), this.getAddress(aoObjects), aoObjects.length);
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.isMetaDown()) {
            this.setSelectionPath(this.getPathForLocation(e.getX(), e.getY()));
            this.pupTreeMenu.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    protected void sortMenuItemActionPerformed(ActionEvent e) {
        if (this.getSelectionPath() != null) {
            TreeExpansionEvent eTreeExp = new TreeExpansionEvent(this, this.getSelectionPath());
            this.m_bSingleSort = true;
            if (!this.isExpanded(this.getSelectionPath())) {
                this.expandPath(this.getSelectionPath());
            } else {
                this.treeExpanded(eTreeExp);
            }
        }
    }

    protected static class NameContainer
    implements Comparable<NameContainer> {
        protected String m_name;
        protected int m_type;

        NameContainer(String name, int type) {
            this.m_name = name;
            this.m_type = type;
        }

        NameContainer(String name) {
            this.m_name = name;
            this.m_type = 0;
        }

        @Override
        public int compareTo(NameContainer other) {
            return this.m_name.compareTo(other.getName());
        }

        public String toString() {
            return this.m_name;
        }

        public int getType() {
            return this.m_type;
        }

        public String getName() {
            return this.m_name;
        }
    }

    protected static class DoocsCellRenderer
    extends DefaultTreeCellRenderer {
        private ImageIcon iiFacilityIcon = new ImageIcon(this.getClass().getResource("icons/doocstree/facility.png"));
        private ImageIcon iiFacilityIconOpen = new ImageIcon(this.getClass().getResource("icons/doocstree/facility_open.png"));
        private ImageIcon iiDeviceIcon = new ImageIcon(this.getClass().getResource("icons/doocstree/device.png"));
        private ImageIcon iiDeviceIconOpen = new ImageIcon(this.getClass().getResource("icons/doocstree/device_open.png"));
        private ImageIcon iiLocationIcon = new ImageIcon(this.getClass().getResource("icons/doocstree/location.png"));
        private ImageIcon iiLocationIconOpen = new ImageIcon(this.getClass().getResource("icons/doocstree/location_open.png"));
        private ImageIcon iiPropertyIcon = new ImageIcon(this.getClass().getResource("icons/doocstree/property_light.png"));
        private ImageIcon iiStringIcon = new ImageIcon(this.getClass().getResource("icons/doocstree/string.png"));
        private ImageIcon iiIntIcon = new ImageIcon(this.getClass().getResource("icons/doocstree/integer.png"));
        private ImageIcon iiFloatIcon = new ImageIcon(this.getClass().getResource("icons/doocstree/float.png"));
        private ImageIcon iiBoolIcon = new ImageIcon(this.getClass().getResource("icons/doocstree/bool.png"));
        private ImageIcon iiFISIcon = new ImageIcon(this.getClass().getResource("icons/doocstree/fis.png"));
        private ImageIcon iiIFFFIcon = new ImageIcon(this.getClass().getResource("icons/doocstree/ifff.png"));
        private ImageIcon iiIIIIIcon = new ImageIcon(this.getClass().getResource("icons/doocstree/iiii.png"));
        private ImageIcon iiTDSIcon = new ImageIcon(this.getClass().getResource("icons/doocstree/tds.png"));
        private ImageIcon iiTTIIIcon = new ImageIcon(this.getClass().getResource("icons/doocstree/ttii.png"));
        private ImageIcon iiUSTRIcon = new ImageIcon(this.getClass().getResource("icons/doocstree/ustr.png"));
        private ImageIcon iiXYIcon = new ImageIcon(this.getClass().getResource("icons/doocstree/xy.png"));
        private ImageIcon iiXYTIcon = new ImageIcon(this.getClass().getResource("icons/doocstree/xyt.png"));
        private ImageIcon iiYTIcon;
        private ImageIcon iiSPECTRUMIcon = new ImageIcon(this.getClass().getResource("icons/doocstree/spectrum.png"));
        private ImageIcon iiA_USTRIcon;
        private ImageIcon iiA_FISIcon;
        private ImageIcon iiA_IntIcon;
        private ImageIcon iiA_FloatIcon;
        private ImageIcon iiA_TDSIcon;
        private ImageIcon iiA_TDSiIcon;
        private ImageIcon iiA_ByteIcon;
        private ImageIcon iiA_XYIcon;

        public DoocsCellRenderer() {
            this.iiYTIcon = new ImageIcon(this.getClass().getResource("icons/doocstree/yt.png"));
            this.iiA_USTRIcon = new ImageIcon(this.getClass().getResource("icons/doocstree/a_ustr.png"));
            this.iiA_FISIcon = new ImageIcon(this.getClass().getResource("icons/doocstree/a_fis.png"));
            this.iiA_IntIcon = new ImageIcon(this.getClass().getResource("icons/doocstree/a_integer.png"));
            this.iiA_FloatIcon = new ImageIcon(this.getClass().getResource("icons/doocstree/a_float.png"));
            this.iiA_ByteIcon = new ImageIcon(this.getClass().getResource("icons/doocstree/a_byte.png"));
            this.iiA_TDSIcon = new ImageIcon(this.getClass().getResource("icons/doocstree/a_tds.png"));
            this.iiA_TDSiIcon = new ImageIcon(this.getClass().getResource("icons/doocstree/a_tdsi.png"));
            this.iiA_XYIcon = new ImageIcon(this.getClass().getResource("icons/doocstree/a_xy.png"));
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            ImageIcon tempIcon = null;
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            block0 : switch (node.getUserObjectPath().length) {
                case 2: {
                    tempIcon = expanded ? this.iiFacilityIconOpen : this.iiFacilityIcon;
                    break;
                }
                case 3: {
                    tempIcon = expanded ? this.iiDeviceIconOpen : this.iiDeviceIcon;
                    break;
                }
                case 4: {
                    tempIcon = expanded ? this.iiLocationIconOpen : this.iiLocationIcon;
                    break;
                }
                case 5: {
                    switch (((NameContainer)node.getUserObject()).getType()) {
                        case 3: {
                            tempIcon = this.iiStringIcon;
                            break block0;
                        }
                        case 5: {
                            tempIcon = this.iiStringIcon;
                            break block0;
                        }
                        case 1: {
                            tempIcon = this.iiIntIcon;
                            break block0;
                        }
                        case 2: {
                            tempIcon = this.iiFloatIcon;
                            break block0;
                        }
                        case 4: {
                            tempIcon = this.iiBoolIcon;
                            break block0;
                        }
                        case 17: {
                            tempIcon = this.iiFISIcon;
                            break block0;
                        }
                        case 15: {
                            tempIcon = this.iiIFFFIcon;
                            break block0;
                        }
                        case 14: {
                            tempIcon = this.iiIIIIIcon;
                            break block0;
                        }
                        case 12: {
                            tempIcon = this.iiTDSIcon;
                            break block0;
                        }
                        case 18: {
                            tempIcon = this.iiTTIIIcon;
                            break block0;
                        }
                        case 16: {
                            tempIcon = this.iiUSTRIcon;
                            break block0;
                        }
                        case 13: {
                            tempIcon = this.iiXYIcon;
                            break block0;
                        }
                        case 11: {
                            tempIcon = this.iiXYTIcon;
                            break block0;
                        }
                        case 10: {
                            tempIcon = this.iiYTIcon;
                            break block0;
                        }
                        case 19: {
                            tempIcon = this.iiSPECTRUMIcon;
                            break block0;
                        }
                        case 103: {
                            tempIcon = this.iiA_USTRIcon;
                            break block0;
                        }
                        case 100: {
                            tempIcon = this.iiA_FloatIcon;
                            break block0;
                        }
                        case 105: {
                            tempIcon = this.iiA_IntIcon;
                            break block0;
                        }
                        case 101: {
                            tempIcon = this.iiA_TDSIcon;
                            break block0;
                        }
                        case 107: {
                            tempIcon = this.iiA_TDSiIcon;
                            break block0;
                        }
                        case 106: {
                            tempIcon = this.iiA_ByteIcon;
                            break block0;
                        }
                        case 104: {
                            tempIcon = this.iiA_FISIcon;
                            break block0;
                        }
                        case 102: {
                            tempIcon = this.iiA_XYIcon;
                            break block0;
                        }
                    }
                    tempIcon = this.iiPropertyIcon;
                }
            }
            if (tempIcon != null) {
                this.setIcon(tempIcon);
            }
            return this;
        }
    }
}

