/*
 * Decompiled with CFR 0.152.
 */
package DOOCSPlot.utils;

import DOOCSPlot.utils.PlotDataTableModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;

public class PlotDataTableCellEditor
extends AbstractCellEditor
implements TableCellEditor {
    JComponent textEditor = new JTextField();
    JComponent checkbox = new JCheckBox();
    JComponent comboboxChoice;
    String type;
    PlotDataTableModel model;
    Color currentColor;
    JButton button;
    JColorChooser colorChooser;
    JDialog dialog;
    protected static final String EDIT = "edit";

    public PlotDataTableCellEditor() {
        ((JCheckBox)this.checkbox).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PlotDataTableCellEditor.this.fireEditingStopped();
            }
        });
        this.button = new JButton();
        this.button.setActionCommand(EDIT);
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (PlotDataTableCellEditor.EDIT.equals(e.getActionCommand())) {
                    PlotDataTableCellEditor.this.button.setBackground(PlotDataTableCellEditor.this.currentColor);
                    PlotDataTableCellEditor.this.colorChooser.setColor(PlotDataTableCellEditor.this.currentColor);
                    PlotDataTableCellEditor.this.dialog.setVisible(true);
                    PlotDataTableCellEditor.this.fireEditingStopped();
                } else {
                    PlotDataTableCellEditor.this.currentColor = PlotDataTableCellEditor.this.colorChooser.getColor();
                }
            }
        };
        this.button.addActionListener(listener);
        this.button.setBorderPainted(false);
        this.colorChooser = new JColorChooser();
        this.dialog = JColorChooser.createDialog(this.button, "Pick a Color", true, this.colorChooser, listener, null);
        this.type = null;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int col) {
        if (col > 5) {
            return null;
        }
        this.model = (PlotDataTableModel)table.getModel();
        this.type = this.model.getValueAt(row, col).getClass().toString();
        if (this.type.endsWith("Boolean")) {
            if (value.toString().equalsIgnoreCase("true")) {
                ((JCheckBox)this.checkbox).setSelected(true);
            } else {
                ((JCheckBox)this.checkbox).setSelected(false);
            }
            return this.checkbox;
        }
        if (this.type.endsWith("LineStyle")) {
            this.model = (PlotDataTableModel)table.getModel();
            return (JComboBox)this.model.styleComboBox;
        }
        if (this.type.endsWith("Marks")) {
            this.model = (PlotDataTableModel)table.getModel();
            return (JComboBox)this.model.markComboBox;
        }
        if (!this.type.endsWith("String") && !this.type.endsWith("BasicStroke")) {
            if (this.type.endsWith("Boolean")) {
                return this.checkbox;
            }
            if (this.type.endsWith("Color")) {
                this.currentColor = (Color)value;
                return this.button;
            }
            if (this.type.endsWith("Float")) {
                ((JTextField)this.textEditor).setText(value.toString());
                return this.textEditor;
            }
        }
        return null;
    }

    @Override
    public Object getCellEditorValue() {
        if (this.type.endsWith("Boolean")) {
            return ((JCheckBox)this.checkbox).isSelected();
        }
        if (this.type.endsWith("LineStyle")) {
            JLabel comp = (JLabel)((JComboBox)this.model.styleComboBox).getSelectedItem();
            return comp;
        }
        if (this.type.endsWith("Marks")) {
            return ((JComboBox)this.model.markComboBox).getSelectedItem();
        }
        if (this.type.endsWith("Color")) {
            return this.currentColor;
        }
        return ((JTextField)this.textEditor).getText();
    }
}

