/*
 * Decompiled with CFR 0.152.
 */
package DOOCSPlot;

import DOOCSPlot.DOOCSPlot;
import DOOCSPlot.DOOCSPlotAxis;
import java.awt.BasicStroke;
import java.awt.Graphics;
import java.awt.Graphics2D;

public class DOOCSPlotXAxis
extends DOOCSPlotAxis {
    public DOOCSPlotXAxis() {
    }

    public DOOCSPlotXAxis(DOOCSPlot p) {
        this.plot = p;
    }

    @Override
    public void paintComponent(Graphics g) {
        int pos;
        int cw;
        String tmp;
        int ix;
        Graphics2D g2d = (Graphics2D)g;
        int markTick = 0;
        double d = this.actMin / 10.0;
        float x = 0.0f;
        float y = 0.0f;
        g2d.setColor(this.getForeground());
        g2d.setFont(this.getFont());
        BasicStroke myStroke = new BasicStroke(this.strokeSize);
        g2d.setStroke(myStroke);
        float space = this.p1X - this.p0X;
        float delx = space / (float)this.nMajorTicks;
        float delx2 = delx / (float)this.nMinorTicks;
        space = 0.0f;
        String fmt = String.format("%%.%dg", this.precision);
        int ch = g2d.getFontMetrics().getHeight();
        int chAscent = g2d.getFontMetrics().getAscent();
        for (int i = 0; i < this.nMajorTicks; ++i) {
            x = (float)this.p0X + delx * (float)i;
            ix = (int)((double)x + 0.5);
            d = this.isLog ? (d *= 10.0) : this.actMin + this.delMajor * (double)i;
            if (d == 0.0) {
                g2d.drawLine(ix, this.p1Y, ix, this.p2XY);
            }
            tmp = String.format(fmt, d);
            cw = g2d.getFontMetrics().stringWidth(tmp);
            pos = ix - cw / 2;
            if (pos < 2) {
                pos = 2;
            }
            if ((float)pos > space) {
                if (this.showText && this.spaceForText) {
                    space = pos + cw + 10;
                }
                g2d.drawString(tmp, pos, this.p1Y + ch + this.tickLength);
                markTick = 2;
            } else {
                markTick = 0;
            }
            if (this.hasGrid) {
                g2d.drawLine(ix, this.p1Y + this.tickLength + markTick, ix, this.p2XY);
            } else {
                g2d.drawLine(ix, this.p1Y, ix, this.p1Y + this.tickLength + markTick);
            }
            if (i + 1 == this.nMajorTicks) {
                space -= delx / 2.0f;
            }
            if (this.isLog) {
                int istep = 1;
                if (delx2 > -15.0f) {
                    istep = 2;
                }
                for (int j = 1; j < 10; j += istep) {
                    int ix2 = (int)(Math.log10(j) * (double)delx + (double)x + 0.5);
                    g2d.drawLine(ix2, this.p1Y, ix2, this.p1Y + this.tickLength / 2);
                }
                continue;
            }
            for (int j = 1; j < this.nMinorTicks; ++j) {
                float x2 = x + delx2 * (float)j;
                int ix2 = (int)((double)x2 + 0.5);
                g2d.drawLine(ix2, this.p1Y, ix2, this.p1Y + this.tickLength / 2);
            }
        }
        x = (float)this.p0X + delx * (float)this.nMajorTicks;
        ix = (int)((double)x + 0.5);
        g2d.drawLine(ix, this.p1Y, ix, this.p1Y + this.tickLength);
        if (this.showText && this.spaceForText) {
            tmp = String.format(fmt, this.actMax);
            cw = g2d.getFontMetrics().stringWidth(tmp);
            pos = ix - cw / 2;
            if ((float)pos > space && pos + cw <= this.plot.getWidth()) {
                g2d.drawString(tmp, pos, this.p1Y + ch + this.tickLength);
            }
            if (this.eguText != null && this.eguText.length() > 0) {
                int l = g2d.getFontMetrics().stringWidth(this.eguText);
                pos = this.plot.getWidth() - 10 - l;
                g2d.drawString(this.eguText, pos, this.p1Y + ch + chAscent + this.tickLength);
            }
        }
        g2d.drawLine(this.p0X, this.p1Y, ix, this.p1Y);
        g2d.drawLine(this.p0X, this.p2XY, ix, this.p2XY);
    }
}

