/*
 * Decompiled with CFR 0.152.
 */
package DOOCSPlot;

import DOOCSComponents.DOOCSLayeredPane;
import DOOCSComponents.DOOCSParameter;
import DOOCSPlot.DOOCSPlot;
import DOOCSPlot.DOOCSPlotHist;
import DOOCSPlot.DOOCSPlotSpectrum;
import editor.DoocsFrameCache;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import layoutmanager.ScaleConstraints;
import layoutmanager.ScaleLayout;

public class DOOCSPlotWindow
extends JFrame {
    JScrollPane scrollPane;
    DOOCSLayeredPane EditorPanel = new DOOCSLayeredPane();
    DOOCSPlot plot;
    private static String doocsAdr = null;

    public DOOCSPlotWindow(Component vcomp, DOOCSPlot.PlotType plotType, boolean isLogicPlot) {
        this.initComponents(plotType, isLogicPlot);
        this.setLocationRelativeTo(vcomp);
        int newx = this.getX() + this.getWidth() / 2;
        int newy = this.getY() + this.getHeight() / 2;
        this.setLocation(newx, newy);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DOOCSPlotWindow.this.EditorPanel.setRunMode(false);
                DoocsFrameCache.getInstance().removeDOOCSLayeredPane("Hist:" + doocsAdr);
            }
        });
        DoocsFrameCache.getInstance().addDOOCSLayeredPane("Hist:" + doocsAdr, this.EditorPanel);
    }

    private void initComponents(DOOCSPlot.PlotType plotType, boolean isLogicPlot) {
        this.setDefaultCloseOperation(2);
        switch (plotType) {
            default: {
                this.plot = new DOOCSPlotHist();
                ((DOOCSPlotHist)this.plot).setIsLogicPlot(isLogicPlot);
                this.setTitle("Plot History");
                break;
            }
            case PLOTSPECTRUM: {
                this.plot = new DOOCSPlotSpectrum();
                this.setTitle("Spectrum Plot");
            }
        }
        this.EditorPanel.setPreferredSize(new Dimension(379, 256));
        this.EditorPanel.setLayout(new ScaleLayout(new Dimension(379, 256)));
        this.EditorPanel.add((Component)this.plot, new ScaleConstraints(0, 0, 379, 256));
        this.plot.setDOOCSParameter("adr0", doocsAdr);
        this.plot.setDOOCSParameter("doubleClickPanel", "HIST_properties.xml");
        if (isLogicPlot) {
            this.plot.setDOOCSParameter("yLimitMax", "24");
            this.plot.setDOOCSParameter("yLimitMin", "0");
            this.plot.setDOOCSParameter("yMax", "16");
            this.plot.setDOOCSParameter("yMin", "0");
            this.setTitle("ShowStatusRegisterHist");
        }
        this.scrollPane = new JScrollPane(this.EditorPanel);
        this.setContentPane(this.scrollPane);
        this.EditorPanel.setRunMode(true);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DOOCSPlotWindow.this.EditorPanel.setRunMode(false);
            }
        });
        this.pack();
    }

    public static void showDaq(String adr, final Component vcomp) {
        doocsAdr = adr;
        DOOCSLayeredPane panel = DoocsFrameCache.getInstance().getDOOCSLayeredPane("DAQ:" + doocsAdr);
        if (panel != null) {
            JFrame frameComp = DOOCSParameter.getParentFrame(panel);
            frameComp.toFront();
            frameComp.requestFocus();
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new DOOCSPlotWindow(vcomp, DOOCSPlot.PlotType.PLOTSPECTRUM, false).setVisible(true);
            }
        });
    }

    public static void showDaqHist(String adr, final Component vcomp) {
        doocsAdr = adr;
        DOOCSLayeredPane panel = DoocsFrameCache.getInstance().getDOOCSLayeredPane("DAQ Hist:" + doocsAdr);
        if (panel != null) {
            JFrame frameComp = DOOCSParameter.getParentFrame(panel);
            frameComp.toFront();
            frameComp.requestFocus();
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new DOOCSPlotWindow(vcomp, DOOCSPlot.PlotType.PLOTHIST, false).setVisible(true);
            }
        });
    }

    public static void showHist(String adr, final Component vcomp) {
        doocsAdr = adr;
        DOOCSLayeredPane panel = DoocsFrameCache.getInstance().getDOOCSLayeredPane("Hist:" + doocsAdr);
        if (panel != null) {
            JFrame frameComp = DOOCSParameter.getParentFrame(panel);
            frameComp.toFront();
            frameComp.requestFocus();
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new DOOCSPlotWindow(vcomp, DOOCSPlot.PlotType.PLOTHIST, false).setVisible(true);
            }
        });
    }

    public static void showStatusRegisterHist(String adr, final Component vcomp) {
        doocsAdr = adr;
        DOOCSLayeredPane panel = DoocsFrameCache.getInstance().getDOOCSLayeredPane("Hist:" + doocsAdr);
        if (panel != null) {
            JFrame frameComp = DOOCSParameter.getParentFrame(panel);
            frameComp.toFront();
            frameComp.requestFocus();
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new DOOCSPlotWindow(vcomp, DOOCSPlot.PlotType.PLOTHIST, true).setVisible(true);
            }
        });
    }
}

