/*
 * Decompiled with CFR 0.152.
 */
package DOOCSPlot;

import DOOCSPlot.DOOCSChannel;
import DOOCSPlot.DOOCSDataContainerHist;
import daq.DAQeqData;
import daq.DAQeqResult;
import daq.DAQgetOptions;
import daq.EqDataCache;
import daq.EqDataCacheEntry;
import daq.EventUtil;
import daq.time_stamp;
import java.awt.Color;
import java.awt.Point;
import java.util.Date;
import ttf.doocs.clnt.EqAdr;
import ttf.doocs.clnt.EqCall;
import ttf.doocs.clnt.EqData;
import ttf.doocs.clnt.time_t;

public class DOOCSDataContainerHistDAQ
extends DOOCSDataContainerHist {
    protected EqAdr ea;
    protected String daqName;
    protected String expName = "Linac";
    protected String dirName = "";
    int maxLength = 0x100000;
    float[] dataArray;
    byte[] dataComment = new byte[80];
    int startT = 0;
    int stopT = 0;
    DAQeqData daqData;
    int daqStatus;
    int daqStatusOld;
    int actEventNo = 0;
    int prevEventNo = 0;
    double oldActualTime = 0.0;
    int dataAccessMode;
    time_stamp time = new time_stamp();
    boolean cacheReady;
    EventUtil ev_util;

    public DOOCSDataContainerHistDAQ(DOOCSChannel ch, String name) {
        super(ch);
        this.channel = ch;
        this.daqName = name;
        this.color = new Color(0, 0, 0);
        this.bgColor = new Color(128, 128, 128, 60);
        this.pt = new Point();
        this.ea = new EqAdr(ch.doocsAdr);
        this.ed = new EqData();
        this.data = new EqData();
        this.eq = new EqCall();
        this.dataArray = new float[this.defaultLength];
        this.dataTime[0] = new time_t();
        Date dt = new Date();
        if (this.channel.plot.doocsPlotSelection.isGlobalTimeRangeDefined()) {
            this.startT = (int)this.channel.plot.doocsPlotSelection.getGlobalTimeRangeMin();
            this.stopT = (int)this.channel.plot.doocsPlotSelection.getGlobalTimeRangeMax();
        }
        if (this.startT == 0 || this.stopT == 0) {
            this.startT = (int)(dt.getTime() / 1000L) - 1200;
            this.stopT = (int)(dt.getTime() / 1000L) - 900;
            this.channel.plot.doocsPlotSelection.setGlobalTimeRange(this.startT, this.stopT);
        }
        this.createDataCache(this.startT, this.stopT, "linac");
    }

    private void createDataCache(int startT, int stopT, String exp) {
        String[] chans = new String[]{this.daqName};
        String badSolution = "/daq/ttf2_ext/LINAC";
        this.daqData = new DAQeqData(chans, startT, stopT, exp, badSolution);
        this.cacheReady = false;
        this.prevEventNo = this.channel.plot.doocsPlotSelection.getEventActual();
        this.ev_util = new EventUtil();
        this.dataAccessMode = 2;
        this.errorMsg = "DAQ: waiting for data...";
        this.channel.chanErrorMsg = "DAQ: waiting for data...";
    }

    public void readEGU() {
        if (this.channel.doocsReadEGU) {
            String xeguText = "";
            this.descriptionMsg = this.daqName;
            this.channel.plot.doocsPlotAxisX.eguText = xeguText;
        }
    }

    @Override
    public boolean update() {
        if (this.channel == null) {
            this.channel.chanErrorMsg = this.errorMsg = "Internal ERROR! No channel defined";
            return false;
        }
        if (this.startT != (int)this.channel.plot.doocsPlotSelection.getGlobalTimeRangeMin() || this.stopT != (int)this.channel.plot.doocsPlotSelection.getGlobalTimeRangeMax()) {
            this.createDataCache(this.startT, this.stopT, "linac");
        }
        if (this.firstRead) {
            this.readEGU();
            this.firstRead = false;
            if (this.daqData.start_receiver()) {
                this.errorMsg = "Problems with start_receiver():";
            }
        }
        int status = this.daqData.status();
        if (status == 3) {
            this.errorMsg = this.daqData.get_reply();
            this.hasData = false;
        } else if (status == 5) {
            this.errorMsg = this.daqData.connect_status_string();
            this.hasData = false;
        } else if (status == 4) {
            this.errorMsg = "Error: Status unknown";
            this.hasData = false;
        } else if (status == 1) {
            this.errorMsg = "...";
            this.hasData = false;
        } else if (status == 2) {
            this.errorMsg = "DAQ: receiving data...";
            this.hasData = true;
        } else if (status == 0) {
            this.channel.chanErrorMsg = null;
            this.hasData = true;
        } else {
            this.hasData = false;
        }
        if (this.hasData) {
            int optext;
            if (!this.cacheReady) {
                int[] ev_num;
                boolean hasNoCache;
                if (status != 2 && !(hasNoCache = this.daqData.get_monitor(ev_num = new int[2], 0))) {
                    this.channel.plot.doocsPlotSelection.setEventFirst(ev_num[0]);
                    this.daqData.get_monitor(ev_num, 1);
                    this.channel.plot.doocsPlotSelection.setEventLast(ev_num[0]);
                    this.cacheReady = true;
                    this.dataAccessMode = 4;
                }
            }
            if (this.dataAccessMode == 4 && this.prevEventNo != 0 && this.channel.plot.doocsPlotSelection.getEventActual() == this.prevEventNo) {
                return false;
            }
            DAQgetOptions opt = new DAQgetOptions();
            int evt = this.channel.plot.doocsPlotSelection.getEventActual();
            if (evt != 0 && evt != this.prevEventNo) {
                optext = 1024;
                opt.set_evnum(evt);
            } else {
                optext = 512;
                double d = this.channel.plot.doocsPlotSelection.getGlobalTimeActual();
                double dUp = Math.floor(d);
                this.time.set_time((int)dUp, (int)(d - dUp) * 1000);
                opt.set_time(this.time);
            }
            opt.access = this.dataAccessMode | optext;
            DAQeqResult out = null;
            int subch = 1;
            int dtype = 0;
            int devtype = 0;
            opt.set_channel(this.daqName);
            out = this.daqData.get_monitor(opt);
            if ((out.status & 1) != 0 && out.rec != null) {
                if (out.rec.size() > 0) {
                    EqDataCacheEntry cacheEntry = (EqDataCacheEntry)out.rec.entry.get(0);
                    this.data = cacheEntry.data.data;
                    dtype = cacheEntry.data.dtype;
                    devtype = cacheEntry.data.devtype;
                    int i = this.data.error();
                    int len = this.data.array_length();
                    if (len > this.maxLength) {
                        len = this.maxLength;
                    }
                    try {
                        this.actEventNo = out.rec.event_number;
                        String evtTime = out.rec.get_time_string();
                        String comm = "No comment";
                        switch (this.data.type()) {
                            case 1013: {
                                subch = this.ev_util.get_channel_number(dtype) - 1;
                                comm = new String(this.dataComment).trim();
                                break;
                            }
                            case 103: {
                                subch = 1;
                                comm = this.data.get_string_arg(0);
                                this.dataComment = comm.getBytes();
                                this.dataStatus[0] = this.data.error();
                                long tm = this.data.get_time(0) / 1000L;
                                this.dataTime[0] = new time_t((int)tm);
                                this.dataArray[0] = this.data.get_float(1);
                            }
                        }
                        this.descriptionMsg = this.daqName + "_" + this.ev_util.get_chan_name(dtype, subch) + " T=" + evtTime;
                        if (this.actEventNo != this.prevEventNo) {
                            this.prevEventNo = this.actEventNo;
                            if (this.dataAccessMode == 4) {
                                this.channel.plot.doocsPlotSelection.setGlobalTimeActual((double)out.rec.get_time().timeup + (double)out.rec.get_time().timelow / EqDataCache.DAQ_DATA_TIME_LOW_SCALE);
                                this.channel.plot.doocsPlotSelection.setEventActual(this.actEventNo);
                            }
                            this.channel.plot.repaint(this.channel.plot.dataAreaX0, this.channel.plot.dataAreaY0, this.channel.plot.dataAreaX1 - this.channel.plot.dataAreaX0, this.channel.plot.dataAreaY1 - this.channel.plot.dataAreaY0);
                        }
                    }
                    catch (Exception e) {
                        boolean ixxx = false;
                    }
                    this.hasData = true;
                    this.errorMsg = "";
                } else {
                    this.hasData = false;
                    this.errorMsg = "No DAQ data";
                }
            } else {
                this.hasData = false;
                this.errorMsg = "End of DAQ data";
            }
        }
        this.channel.chanErrorMsg = this.errorMsg;
        this.hasNewData = this.hasData;
        return this.hasData;
    }
}

