/*
 * Decompiled with CFR 0.152.
 */
package DOOCSComponents;

import DOOCSComponents.DOOCSComponent;
import DOOCSComponents.DOOCSParameter;
import DOOCSComponents.DOOCSProgressBarUI;
import editor.EditorPanel;
import editor.undo.SetProperty;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.util.Vector;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import ttf.doocs.clnt.EqAdr;
import ttf.doocs.clnt.EqCall;
import ttf.doocs.clnt.EqCallback;
import ttf.doocs.clnt.EqData;
import xmlparser.IntegerParser;

public class DOOCSProgressBar
extends JProgressBar
implements DOOCSComponent,
EqCallback {
    private String doocsAddress = null;
    private String fullDoocsAddress = null;
    private String doocsToolTipText = null;
    private float doocsUpdateTime = 1.0f;
    private double doocsMinimum = 0.0;
    private double doocsMaximum = 100.0;
    private int doocsPrecision = 2;
    private String doocsRotate = "0";
    private boolean doocsScale = true;
    private String doocsLayer = "NONE";
    private boolean doocsRunMode = false;
    private Rectangle m_initialBounds;
    private EqCall eq = new EqCall();
    private EqData ed = new EqData();
    private EqData data = new EqData();
    private EqAdr adrData = null;
    private String errorMessage = null;
    private float value;

    public DOOCSProgressBar() {
        this.setStringPainted(true);
        this.setPreferredSize(new Dimension(120, 20));
        this.setSize(new Dimension(120, 20));
        this.setUI(new DOOCSProgressBarUI(this));
        this.setEnabled(this.doocsRunMode);
    }

    private void startMonitors() {
        if (this.adrData == null) {
            return;
        }
        if ((double)this.doocsUpdateTime == 0.0) {
            this.eq.get_monitor(this.adrData, this.ed, this.data, 1, this.doocsUpdateTime, (EqCallback)this, null);
        } else {
            this.eq.get_monitor(this.adrData, this.ed, this.data, 3, this.doocsUpdateTime, (EqCallback)this, null);
        }
    }

    @Override
    public void setDnDText(String str) {
    }

    @Override
    public String getDnDText() {
        return null;
    }

    @Override
    public String toString() {
        return this.getName();
    }

    public void setDoocsAddress(String address) {
        this.doocsAddress = address;
    }

    public String getDoocsAddress() {
        return this.doocsAddress;
    }

    @Override
    public void setFullDoocsAddress(String address) {
        if (address == null) {
            return;
        }
        if (this.fullDoocsAddress == null || !address.startsWith(this.fullDoocsAddress)) {
            this.fullDoocsAddress = address;
            if (this.adrData != null) {
                this.eq.clear_monitor(this.adrData);
            }
            this.adrData = new EqAdr(this.fullDoocsAddress);
            if (!EqAdr.isValidAdr((String)this.fullDoocsAddress)) {
                this.adrData = null;
            } else if (this.doocsRunMode) {
                this.startMonitors();
            }
        }
    }

    @Override
    public String getFullDoocsAddress() {
        return this.fullDoocsAddress;
    }

    @Override
    public void setDoocsToolTipText(String ttt) {
        this.doocsToolTipText = ttt;
    }

    @Override
    public String getDoocsToolTipText() {
        return this.doocsToolTipText;
    }

    public void setDoocsUpdateTime(float time) {
        this.doocsUpdateTime = time;
    }

    public float getDoocsUpdateTime() {
        return this.doocsUpdateTime;
    }

    public void setDoocsMinimum(double mini) {
        this.doocsMinimum = mini;
    }

    public double getDoocsMinimum() {
        return this.doocsMinimum;
    }

    public void setDoocsMaximum(double maxi) {
        this.doocsMaximum = maxi;
    }

    public double getDoocsMaximum() {
        return this.doocsMaximum;
    }

    public void setDoocsPrecision(int precision) {
        this.doocsPrecision = precision;
    }

    public int getDoocsPrecision() {
        return this.doocsPrecision;
    }

    public void setDoocsRotate(String rotate) {
        Container parent;
        this.doocsRotate = rotate;
        if (rotate.equalsIgnoreCase("0") || rotate.equalsIgnoreCase("180")) {
            this.setOrientation(0);
        } else {
            this.setOrientation(1);
        }
        int width = this.getSize().width;
        int height = this.getSize().height;
        if (!rotate.equalsIgnoreCase("0") && !rotate.equalsIgnoreCase("180") && width > height) {
            this.setSize(new Dimension(height, width));
        }
        if ((rotate.equalsIgnoreCase("0") || rotate.equalsIgnoreCase("180")) && height > width) {
            this.setSize(new Dimension(height, width));
        }
        if (!((parent = this.getParent()) == null || parent instanceof EditorPanel && parent.getWidth() == 100 && parent.getHeight() == 100)) {
            if (this.getX() < 0) {
                this.setLocation(0, this.getY());
            }
            if (this.getY() < 0) {
                this.setLocation(this.getX(), 0);
            }
            if (this.getX() + this.getWidth() > parent.getWidth()) {
                this.setLocation(parent.getWidth() - this.getWidth(), this.getY());
            }
            if (this.getY() + this.getHeight() > parent.getHeight()) {
                this.setLocation(this.getX(), parent.getHeight() - this.getHeight());
            }
        }
    }

    public String getDoocsRotate() {
        return this.doocsRotate;
    }

    @Override
    public void setDoocsScale(boolean scale) {
        this.doocsScale = scale;
    }

    @Override
    public boolean getDoocsScale() {
        return this.doocsScale;
    }

    @Override
    public void setDoocsLayer(String layer) {
        this.doocsLayer = layer;
    }

    @Override
    public String getDoocsLayer() {
        return this.doocsLayer;
    }

    @Override
    public void setRunMode(boolean bRun) {
        this.doocsRunMode = bRun;
        this.setEnabled(bRun);
        if (bRun) {
            this.startMonitors();
        } else if (this.adrData != null) {
            this.eq.clear_monitor(this.adrData);
        }
    }

    @Override
    public boolean isRunMode() {
        return this.doocsRunMode;
    }

    @Override
    public void setInitialBounds(Rectangle bounds) {
        this.m_initialBounds = bounds;
    }

    @Override
    public Rectangle getInitialBounds() {
        return this.m_initialBounds;
    }

    @Override
    public DOOCSParameter[] getDOOCSParameterList() {
        DOOCSParameter[] parameters = new DOOCSParameter[]{new DOOCSParameter("name", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("adr", DOOCSParameter.ParameterTypes.DOOCSADDRESS, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("updateTime", DOOCSParameter.ParameterTypes.FLOAT, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("border", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("textFont", DOOCSParameter.ParameterTypes.FONT, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("toolTipText", DOOCSParameter.ParameterTypes.STRING, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("maximum", DOOCSParameter.ParameterTypes.DOUBLE, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("minimum", DOOCSParameter.ParameterTypes.DOUBLE, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("precision", DOOCSParameter.ParameterTypes.INTEGER, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("barColor", DOOCSParameter.ParameterTypes.COLOR, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("bgColor", DOOCSParameter.ParameterTypes.COLOR, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("rotate", DOOCSParameter.ParameterTypes.CHOICE, DOOCSParameter.Levels.NORMAL), new DOOCSParameter("layer", DOOCSParameter.ParameterTypes.LAYER, DOOCSParameter.Levels.EXPERT), new DOOCSParameter("scale", DOOCSParameter.ParameterTypes.BOOLEAN, DOOCSParameter.Levels.SCALE), new DOOCSParameter("bounds", DOOCSParameter.ParameterTypes.BOUNDS, DOOCSParameter.Levels.SCALE)};
        return parameters;
    }

    @Override
    public String[] getDOOCSPropertyAllowedValues(String parameter) {
        if (parameter.equalsIgnoreCase("rotate")) {
            String[] allowedValues = new String[]{"0", "90", "180", "270"};
            return allowedValues;
        }
        return null;
    }

    @Override
    public StringBuffer getDOOCSXmlStructure() {
        StringBuffer xmlStructure = new StringBuffer("<DOOCSProgressBar ");
        xmlStructure.append("name=\"" + DOOCSParameter.correct(this.getName()) + "\" ");
        xmlStructure.append("bounds=\"" + DOOCSParameter.getDoocsBounds(this.getBounds()) + "\">");
        DOOCSParameter[] param = this.getDOOCSParameterList();
        for (int i = 0; i < param.length; ++i) {
            if (param[i].parameter.equalsIgnoreCase("name") || param[i].parameter.equalsIgnoreCase("bounds")) continue;
            xmlStructure.append("<" + param[i].parameter + ">");
            if (this.getDOOCSParameter(param[i].parameter) != null) {
                xmlStructure.append(DOOCSParameter.correct(this.getDOOCSParameter(param[i].parameter).toString()));
            }
            xmlStructure.append("</" + param[i].parameter + ">");
        }
        xmlStructure.append("</DOOCSProgressBar>\n");
        return xmlStructure;
    }

    @Override
    public void setDOOCSParameter(String parameter, String value) {
        if (parameter.equalsIgnoreCase("name")) {
            this.setName(value);
        } else if (parameter.equalsIgnoreCase("adr")) {
            this.setDoocsAddress(value);
        } else if (parameter.equalsIgnoreCase("updateTime")) {
            this.setDoocsUpdateTime(Float.parseFloat(value));
        } else if (parameter.equalsIgnoreCase("rotate")) {
            this.setDoocsRotate(value);
        } else if (parameter.equalsIgnoreCase("border")) {
            this.setBorderPainted(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("textFont")) {
            this.setFont(DOOCSParameter.convertToFont(value));
            this.checkBoundsForNewFont();
        } else if (parameter.equalsIgnoreCase("toolTipText")) {
            this.setDoocsToolTipText(value);
        } else if (parameter.equalsIgnoreCase("maximum")) {
            this.setDoocsMaximum(Float.parseFloat(value));
        } else if (parameter.equalsIgnoreCase("minimum")) {
            this.setDoocsMinimum(Float.parseFloat(value));
        } else if (parameter.equalsIgnoreCase("precision")) {
            this.setDoocsPrecision(IntegerParser.parseInt(value));
        } else if (parameter.equalsIgnoreCase("barColor")) {
            this.setForeground(DOOCSParameter.convertToColor(value));
        } else if (parameter.equalsIgnoreCase("bgColor")) {
            this.setBackground(DOOCSParameter.convertToColor(value));
        } else if (parameter.equalsIgnoreCase("layer")) {
            this.setDoocsLayer(value);
        } else if (parameter.equalsIgnoreCase("scale")) {
            this.setDoocsScale(Boolean.parseBoolean(value));
        } else if (parameter.equalsIgnoreCase("bounds")) {
            this.setBounds(DOOCSParameter.convertToBounds(value));
        } else if (parameter.equalsIgnoreCase("size")) {
            this.setSize(DOOCSParameter.convertToSize(value));
        } else if (parameter.equalsIgnoreCase("runMode")) {
            this.setRunMode(Boolean.parseBoolean(value));
        } else {
            System.out.println("DOOCSProgressBar.setDOOCSParameter: wrong parameter " + parameter);
        }
        this.repaint();
    }

    @Override
    public Object getDOOCSParameter(String parameter) {
        if (parameter.equalsIgnoreCase("name")) {
            return this.getName();
        }
        if (parameter.equalsIgnoreCase("adr")) {
            return this.getDoocsAddress();
        }
        if (parameter.equalsIgnoreCase("updateTime")) {
            return Float.valueOf(this.getDoocsUpdateTime());
        }
        if (parameter.equalsIgnoreCase("rotate")) {
            return this.getDoocsRotate();
        }
        if (parameter.equalsIgnoreCase("border")) {
            return this.isBorderPainted();
        }
        if (parameter.equalsIgnoreCase("textFont")) {
            return DOOCSParameter.getDoocsFont(this.getFont());
        }
        if (parameter.equalsIgnoreCase("toolTipText")) {
            return this.getDoocsToolTipText();
        }
        if (parameter.equalsIgnoreCase("maximum")) {
            return this.getDoocsMaximum();
        }
        if (parameter.equalsIgnoreCase("minimum")) {
            return this.getDoocsMinimum();
        }
        if (parameter.equalsIgnoreCase("precision")) {
            return this.getDoocsPrecision();
        }
        if (parameter.equalsIgnoreCase("barColor")) {
            return DOOCSParameter.getDoocsColor(this.getForeground());
        }
        if (parameter.equalsIgnoreCase("bgColor")) {
            return DOOCSParameter.getDoocsColor(this.getBackground());
        }
        if (parameter.equalsIgnoreCase("layer")) {
            return this.getDoocsLayer();
        }
        if (parameter.equalsIgnoreCase("scale")) {
            return this.getDoocsScale();
        }
        if (parameter.equalsIgnoreCase("bounds")) {
            return DOOCSParameter.getDoocsBounds(this.getBounds());
        }
        if (parameter.equalsIgnoreCase("size")) {
            return DOOCSParameter.getDoocsSize(this.getSize());
        }
        if (parameter.equalsIgnoreCase("runMode")) {
            return this.isRunMode();
        }
        System.out.println("DOOCSProgressBar.getDOOCSParameter: wrong parameter " + parameter);
        return null;
    }

    @Override
    public void addDOOCSMouseListener(MouseInputListener ml) {
        this.addMouseListener(ml);
        this.addMouseMotionListener(ml);
        for (int i = 0; i < this.getComponentCount(); ++i) {
            ((DOOCSComponent)((Object)this.getComponent(i))).addDOOCSMouseListener(ml);
        }
    }

    public void dataCallback(EqData dataOut, Object userData) {
        this.value = 0.0f;
        if (dataOut.error() == 0) {
            String displayedValue;
            this.errorMessage = null;
            this.value = dataOut.get_float();
            final int setValue = (int)Math.round(((double)this.value - this.doocsMinimum) * 100.0 / (this.doocsMaximum - this.doocsMinimum));
            if (this.doocsPrecision == 0) {
                displayedValue = Integer.toString(Math.round(this.value));
            } else {
                double tmp = Math.pow(10.0, this.doocsPrecision);
                double dvalue = Math.rint((double)this.value * tmp) / tmp;
                String tmpValue = Double.toString(dvalue);
                int komma = tmpValue.indexOf(".");
                for (int i = 0; i < this.doocsPrecision; ++i) {
                    if (tmpValue.substring(komma + 1).length() >= this.doocsPrecision) continue;
                    tmpValue = tmpValue + "0";
                }
                displayedValue = tmpValue;
            }
            if (setValue != this.getValue()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        DOOCSProgressBar.this.setValue(setValue);
                        DOOCSProgressBar.this.setString(displayedValue);
                    }
                });
            }
        } else if (this.errorMessage == null && this.doocsRunMode) {
            this.errorMessage = dataOut.get_string_arg();
            System.out.println(DOOCSParameter.getFullName(this) + ": " + this.fullDoocsAddress + ": " + this.errorMessage);
            this.setString(this.errorMessage);
        }
    }

    private void checkBoundsForNewFont() {
        Font f = this.getFont();
        int fontHeight = (int)f.getStringBounds("ABCT", this.getFontMetrics(f).getFontRenderContext()).getHeight();
        if (this.getBounds().getHeight() < (double)fontHeight) {
            Rectangle rbounds = this.getBounds();
            rbounds.setSize(rbounds.width, fontHeight + 2);
            this.setBounds(rbounds);
        }
    }

    @Override
    public Vector<SetProperty> flipHorizontal(Vector<SetProperty> change) {
        String oldValue = this.getDoocsRotate();
        if (oldValue.equalsIgnoreCase("90")) {
            this.setDoocsRotate("270");
        }
        if (oldValue.equalsIgnoreCase("270")) {
            this.setDoocsRotate("90");
        }
        if (!oldValue.equalsIgnoreCase(this.getDoocsRotate())) {
            change.add(new SetProperty(this, "rotate", oldValue, this.getDoocsRotate()));
        }
        return change;
    }

    @Override
    public Vector<SetProperty> flipVertical(Vector<SetProperty> change) {
        return change;
    }

    @Override
    public Vector<SetProperty> rotateLeft(Vector<SetProperty> change) {
        String oldValue = this.getDoocsRotate();
        if (oldValue.equalsIgnoreCase("0")) {
            this.setDoocsRotate("270");
        }
        if (oldValue.equalsIgnoreCase("90")) {
            this.setDoocsRotate("0");
        }
        if (oldValue.equalsIgnoreCase("180")) {
            this.setDoocsRotate("90");
        }
        if (oldValue.equalsIgnoreCase("270")) {
            this.setDoocsRotate("180");
        }
        change.add(new SetProperty(this, "rotate", oldValue, this.getDoocsRotate()));
        return change;
    }

    @Override
    public Vector<SetProperty> rotateRight(Vector<SetProperty> change) {
        String oldValue = this.getDoocsRotate();
        if (oldValue.equalsIgnoreCase("0")) {
            this.setDoocsRotate("90");
        }
        if (oldValue.equalsIgnoreCase("90")) {
            this.setDoocsRotate("180");
        }
        if (oldValue.equalsIgnoreCase("180")) {
            this.setDoocsRotate("270");
        }
        if (oldValue.equalsIgnoreCase("270")) {
            this.setDoocsRotate("0");
        }
        change.add(new SetProperty(this, "rotate", oldValue, this.getDoocsRotate()));
        return change;
    }
}

