/*
 * Decompiled with CFR 0.152.
 */
package com.cosylab.epics.caj;

import com.cosylab.epics.caj.JNIRepeater;
import com.cosylab.epics.caj.util.InetAddressUtil;
import com.cosylab.epics.caj.util.logging.ConsoleLogHandler;
import java.io.File;
import java.net.BindException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.nio.ByteBuffer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CARepeater
implements Runnable {
    public static final String CA_FORCE_NATIVE_REPEATER = "CA_FORCE_NATIVE_REPEATER";
    public static final String CA_DISABLE_REPEATER = "CA_DISABLE_REPEATER";
    private static final int COMMAND_OFFSET = 0;
    private static final int AVAILABLE_OFFSET = 12;
    private static final short CA_PROTO_VERSION = 0;
    private static final short REPEATER_REGISTER = 24;
    private static final short REPEATER_CONFIRM = 17;
    private static final short CA_PROTO_RSRV_IS_UP = 13;
    protected Logger logger = Logger.global;
    protected int repeaterPort = 5065;
    protected DatagramSocket localDatagramSocket = null;
    protected List clients = new ArrayList();
    static /* synthetic */ Class class$com$cosylab$epics$caj$CARepeater;

    public CARepeater() {
        String port = System.getProperty("EPICS_CA_REPEATER_PORT");
        if (port != null) {
            try {
                this.repeaterPort = Integer.parseInt(port);
            }
            catch (NumberFormatException nfe) {
                this.logger.log(Level.FINE, "Failed to parse repeater port '" + port + "'.", nfe);
            }
        }
        this.initialize();
    }

    public CARepeater(int repeaterPort) {
        this.repeaterPort = repeaterPort;
        this.initialize();
    }

    protected void initialize() {
        this.initializeLogger();
    }

    protected void initializeLogger() {
        String loggerName = this.getClass().getName();
        this.logger = Logger.getLogger(loggerName);
        if (System.getProperties().containsKey("CAJ_DEBUG")) {
            this.logger.setLevel(Level.FINE);
            this.logger.addHandler(new ConsoleLogHandler());
        }
    }

    public void run() {
        this.process();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerNewClient(InetSocketAddress clientAddress) {
        Object iter;
        this.logger.fine("Registering client: " + clientAddress);
        int INADDR_LOOPBACK = 2130706433;
        if (InetAddressUtil.ipv4AddressToInt(clientAddress.getAddress()) != 2130706433) {
            if (this.localDatagramSocket == null) {
                try {
                    this.localDatagramSocket = CARepeater.createDatagramSocket();
                }
                catch (Throwable th) {
                    this.logger.log(Level.FINEST, "Failed to create local test datagram socket.", th);
                }
            }
            if (this.localDatagramSocket != null) {
                boolean PORT_ANY = false;
                try {
                    this.localDatagramSocket.bind(new InetSocketAddress(clientAddress.getAddress(), 0));
                    this.localDatagramSocket.close();
                    this.localDatagramSocket = null;
                }
                catch (Throwable th) {
                    return;
                }
            } else {
                return;
            }
        }
        Client client = null;
        List th = this.clients;
        synchronized (th) {
            if (this.clients.size() != 0) {
                iter = this.clients.iterator();
                while (iter.hasNext()) {
                    Client c = (Client)iter.next();
                    if (c.getClientAddress().getPort() != clientAddress.getPort()) continue;
                    client = c;
                    break;
                }
            }
        }
        boolean newClient = false;
        if (client == null) {
            client = new Client(clientAddress);
            if (!client.connect()) {
                client.destroy();
                return;
            }
            iter = this.clients;
            synchronized (iter) {
                this.clients.add(client);
            }
            newClient = true;
        }
        if (!client.sendConfirm()) {
            iter = this.clients;
            synchronized (iter) {
                this.clients.remove(client);
            }
            client.destroy();
        }
        this.logger.fine("Client registered: " + clientAddress);
        byte[] message = new byte[16];
        ByteBuffer buffer = ByteBuffer.wrap(message);
        buffer.putShort(0, (short)0);
        this.fanOut(clientAddress, buffer);
        if (newClient) {
            this.verifyClients();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fanOut(InetSocketAddress fromAddress, ByteBuffer buffer) {
        List list = this.clients;
        synchronized (list) {
            if (this.clients.size() == 0) {
                return;
            }
            DatagramPacket packetToSend = new DatagramPacket(buffer.array(), buffer.position(), buffer.limit());
            Iterator iter = this.clients.iterator();
            while (iter.hasNext()) {
                Client client = (Client)iter.next();
                if (client.getClientAddress().equals(fromAddress) || client.send(packetToSend) || client.verify()) continue;
                client.destroy();
                iter.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void verifyClients() {
        List list = this.clients;
        synchronized (list) {
            if (this.clients.size() == 0) {
                return;
            }
            Iterator iter = this.clients.iterator();
            while (iter.hasNext()) {
                Client client = (Client)iter.next();
                if (client.verify()) continue;
                client.destroy();
                iter.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process() {
        DatagramSocket socket = null;
        try {
            this.logger.fine("Initializing CA repeater.");
            byte[] buffer = new byte[65551];
            ByteBuffer data = ByteBuffer.wrap(buffer);
            DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
            try {
                socket = CARepeater.createDatagramSocket(this.repeaterPort, true);
            }
            catch (BindException be) {
                this.logger.log(Level.FINE, "Failed to bind.", be);
                if (socket != null) {
                    socket.close();
                }
                return;
            }
            try {
                this.logger.fine("Binded to UDP socket: " + socket.getLocalSocketAddress());
                this.logger.fine("CA repeater attached and initialized.");
                while (true) {
                    InetSocketAddress receivedFrom;
                    block16: {
                        int bytesReceived;
                        block14: {
                            short address;
                            short command;
                            block15: {
                                data.clear();
                                socket.receive(packet);
                                receivedFrom = (InetSocketAddress)packet.getSocketAddress();
                                bytesReceived = packet.getLength();
                                data.limit(bytesReceived);
                                if (bytesReceived < 16) break block14;
                                command = data.getShort(0);
                                if (command != 24) break block15;
                                this.registerNewClient(receivedFrom);
                                data.position(16);
                                if (!data.hasRemaining()) {
                                    continue;
                                }
                                break block16;
                            }
                            if (command != 13 || (address = data.getShort(12)) != 0) break block16;
                            data.putInt(12, InetAddressUtil.ipv4AddressToInt(packet.getAddress()));
                            break block16;
                        }
                        if (bytesReceived == 0) {
                            this.registerNewClient(receivedFrom);
                            continue;
                        }
                    }
                    this.fanOut(receivedFrom, data);
                }
            }
            catch (Throwable th) {
                this.logger.log(Level.SEVERE, "Unexpected exception caught.", th);
            }
        }
        finally {
            if (socket != null) {
                socket.close();
            }
        }
    }

    protected static DatagramSocket createDatagramSocket() throws SocketException {
        return new DatagramSocket(null);
    }

    protected static DatagramSocket createDatagramSocket(int port, boolean reuseAddress) throws SocketException {
        DatagramSocket socket = new DatagramSocket(null);
        socket.bind(new InetSocketAddress(port));
        socket.setReuseAddress(reuseAddress);
        return socket;
    }

    protected static boolean isRepeaterRunning(int repeaterPort) {
        try {
            DatagramSocket socket = CARepeater.createDatagramSocket(repeaterPort, true);
            socket.close();
            return false;
        }
        catch (BindException be) {
            return true;
        }
        catch (Throwable th) {
            th.printStackTrace();
            return false;
        }
    }

    public static void startRepeater(final int repeaterPort) throws Throwable {
        if (System.getProperties().containsKey(CA_DISABLE_REPEATER)) {
            return;
        }
        if (System.getProperties().containsKey(CA_FORCE_NATIVE_REPEATER)) {
            JNIRepeater.repeaterInit();
            return;
        }
        if (repeaterPort <= 0) {
            throw new IllegalArgumentException("port must be > 0");
        }
        if (CARepeater.isRepeaterRunning(repeaterPort)) {
            return;
        }
        PrivilegedAction action = new PrivilegedAction(){

            public Object run() {
                String[] commandLine = new String[]{System.getProperty("java.home") + File.separator + "bin" + File.separator + "java", "-classpath", System.getProperty("java.class.path"), (class$com$cosylab$epics$caj$CARepeater == null ? (class$com$cosylab$epics$caj$CARepeater = CARepeater.class$("com.cosylab.epics.caj.CARepeater")) : class$com$cosylab$epics$caj$CARepeater).getName(), "-p", String.valueOf(repeaterPort)};
                try {
                    Runtime.getRuntime().exec(commandLine);
                }
                catch (Throwable th) {
                    System.err.println("Failed to exec '" + commandLine[0] + "', trying to start native repeater...");
                    th.printStackTrace();
                    try {
                        JNIRepeater.repeaterInit();
                    }
                    catch (Throwable th2) {
                        System.err.println("Failed to start native repeater.");
                        th.printStackTrace();
                    }
                }
                return null;
            }
        };
        Object res = AccessController.doPrivileged(action);
        if (res != null) {
            throw new Exception("Unable to init CA Repeater", (Throwable)res);
        }
    }

    public static void main(String[] argv) {
        int port = -1;
        if (argv.length >= 2 && (argv[0].equals("-p") || argv[0].equals("--port"))) {
            try {
                port = Integer.parseInt(argv[1]);
            }
            catch (NumberFormatException nfe) {
                System.err.println("Failed to parse repeater port '" + argv[1] + "'.");
            }
        }
        CARepeater repeater = port > 0 ? new CARepeater(port) : new CARepeater();
        repeater.run();
    }

    static {
        System.setProperty("java.net.preferIPv4Stack", "true");
    }

    class Client {
        private InetSocketAddress clientAddress;
        private DatagramSocket clientSocket = null;

        public Client(InetSocketAddress clientAddress) {
            this.clientAddress = clientAddress;
        }

        public boolean connect() {
            try {
                this.clientSocket = CARepeater.createDatagramSocket();
                this.clientSocket.connect(this.clientAddress);
            }
            catch (Throwable th) {
                CARepeater.this.logger.log(Level.FINEST, "Failed to connect to: " + this.clientAddress, th);
                return false;
            }
            return true;
        }

        public void destroy() {
            if (this.clientSocket != null) {
                this.clientSocket.close();
            }
        }

        public InetSocketAddress getClientAddress() {
            return this.clientAddress;
        }

        public boolean verify() {
            try {
                DatagramSocket socket = CARepeater.createDatagramSocket(this.clientAddress.getPort(), false);
                socket.close();
                CARepeater.this.logger.log(Level.FINEST, "Dead client detected: " + this.clientAddress);
                return false;
            }
            catch (Throwable th) {
                return true;
            }
        }

        public boolean send(DatagramPacket packet) {
            packet.setSocketAddress(this.clientAddress);
            try {
                CARepeater.this.logger.log(Level.FINEST, "Sending packet to: " + this.clientAddress);
                this.clientSocket.send(packet);
            }
            catch (Throwable th) {
                CARepeater.this.logger.log(Level.FINEST, "Failed to send packet to: " + this.clientAddress, th);
                return false;
            }
            return true;
        }

        public boolean sendConfirm() {
            byte[] message = new byte[16];
            ByteBuffer buffer = ByteBuffer.wrap(message);
            buffer.putShort(0, (short)17);
            buffer.putInt(12, InetAddressUtil.ipv4AddressToInt(this.clientAddress.getAddress()));
            DatagramPacket packet = new DatagramPacket(message, message.length);
            return this.send(packet);
        }
    }
}

