/*
 * Decompiled with CFR 0.152.
 */
package xmlparser;

import editor.EditorPanel;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import layoutmanager.ScaleConstraints;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import xmlparser.IntegerParser;

public class SourceCreator {
    static Document doc;
    static StringBuffer code;
    static Node rootNode;

    public static String getSourceFrame(EditorPanel panel, String classname) {
        SourceCreator.parseXmlStringBuffer(panel.getDOOCSXmlStructure(), false);
        code.append("import DOOCSComponents.*;\n");
        code.append("import java.awt.Dimension;\n");
        code.append("import javax.swing.JComponent;\n");
        code.append("import javax.swing.JScrollPane;\n");
        code.append("import javax.swing.WindowConstants;\n");
        code.append("import layoutmanager.ScaleConstraints;\n");
        code.append("import layoutmanager.ScaleLayout;\n\n");
        code.append("public class " + classname + " extends javax.swing.JFrame {\n\n");
        rootNode = doc.getLastChild().getFirstChild();
        code.append("\tJScrollPane scrollPane;\n");
        SourceCreator.getComponents(rootNode, true);
        code.append("\n\tpublic " + classname + "() {\n");
        code.append("\t\tinitComponents();\n");
        code.append("\t}\n\n");
        code.append("\tprivate void initComponents() {\n");
        code.append("\t\tsetDefaultCloseOperation(WindowConstants.EXIT_ON_CLOSE);\n");
        String name = rootNode.getAttributes().getNamedItem("name").getNodeValue();
        String dim = rootNode.getAttributes().getNamedItem("bounds").getNodeValue();
        dim = dim.substring(dim.indexOf(",") + 1);
        dim = dim.substring(dim.indexOf(",") + 1);
        code.append("\t\t" + name + ".setPreferredSize(new Dimension(" + dim + "));\n");
        SourceCreator.getProperties(rootNode, true);
        code.append("\n");
        SourceCreator.addComponents(rootNode, true);
        code.append("\n");
        code.append("\t\tscrollPane = new JScrollPane(" + name + ");\n");
        code.append("\t\tsetContentPane(scrollPane);\n");
        code.append("\t\t" + name + ".setRunMode(true);\n");
        code.append("\t\tsetTitle(\"" + classname + "\");\n\n");
        code.append("\t\taddWindowListener(new java.awt.event.WindowAdapter() {\n");
        code.append("\t\t\tpublic void windowClosing(java.awt.event.WindowEvent evt) {\n");
        code.append("\t\t\t\t" + name + ".setRunMode(false);\n");
        code.append("\t\t\t}\n");
        code.append("\t\t});\n\n");
        code.append("\t\tpack();\n");
        code.append("\t}\n");
        code.append("\n\tpublic static void main(String[] args) {\n");
        code.append("\t\tjava.awt.EventQueue.invokeLater(new Runnable() {\n");
        code.append("\t\t\tpublic void run() {\n");
        code.append("\t\t\t\tnew " + classname + "().setVisible(true);\n");
        code.append("\t\t\t}\n");
        code.append("\t\t});\n");
        code.append("\t}\n");
        code.append("\n}");
        return code.toString();
    }

    public static String getSourcePanel(EditorPanel panel, String classname) {
        SourceCreator.parseXmlStringBuffer(panel.getDOOCSXmlStructure(), false);
        code.append("import DOOCSComponents.*;\n");
        code.append("import java.awt.Dimension;\n");
        code.append("import javax.swing.JComponent;\n");
        code.append("import javax.swing.JScrollPane;\n");
        code.append("import javax.swing.WindowConstants;\n");
        code.append("import layoutmanager.ScaleConstraints;\n");
        code.append("import layoutmanager.ScaleLayout;\n\n");
        code.append("public class " + classname + " extends DOOCSLayeredPane {\n\n");
        rootNode = doc.getLastChild().getFirstChild();
        SourceCreator.getComponents(rootNode, false);
        code.append("\n\tpublic " + classname + "() {\n");
        code.append("\t\tinitComponents();\n");
        code.append("\t}\n\n");
        code.append("\tprivate void initComponents() {\n");
        String dim = rootNode.getAttributes().getNamedItem("bounds").getNodeValue();
        dim = dim.substring(dim.indexOf(",") + 1);
        dim = dim.substring(dim.indexOf(",") + 1);
        code.append("\t\tthis.setPreferredSize(new Dimension(" + dim + "));\n");
        SourceCreator.getProperties(rootNode, false);
        code.append("\n");
        SourceCreator.addComponents(rootNode, false);
        code.append("\n");
        code.append("\t\tthis.setRunMode(true);\n");
        code.append("\t}\n");
        code.append("\n}");
        return code.toString();
    }

    public static void parseXmlStringBuffer(StringBuffer xmlBuffer, boolean validating) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(validating);
            factory.setIgnoringComments(true);
            factory.setExpandEntityReferences(true);
            ByteArrayInputStream bis = new ByteArrayInputStream(xmlBuffer.toString().getBytes());
            doc = factory.newDocumentBuilder().parse(bis);
        }
        catch (SAXException e) {
            System.out.println("SAXException" + e);
        }
        catch (ParserConfigurationException e) {
            System.out.println("ParserConfigurationException" + e);
        }
        catch (IOException e) {
            System.out.println("IOException" + e);
        }
    }

    public static void getComponents(Node node, boolean isFrame) {
        if (node.getNodeName().startsWith("DOOCS")) {
            String comp = node.getNodeName();
            String name = node.getAttributes().getNamedItem("name").getNodeValue();
            if (isFrame) {
                code.append("\t" + comp + " " + name + " = " + "new " + comp + "();\n");
            } else if (node != rootNode) {
                code.append("\t" + comp + " " + name + " = " + "new " + comp + "();\n");
            }
            if (node.hasChildNodes()) {
                NodeList list = node.getChildNodes();
                for (int i = 0; i < list.getLength(); ++i) {
                    SourceCreator.getComponents(list.item(i), isFrame);
                }
            }
        }
    }

    public static void addComponents(Node node, boolean isFrame) {
        if (node.getNodeName().startsWith("DOOCS")) {
            String name = node.getAttributes().getNamedItem("name").getNodeValue();
            NodeList list = node.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                if (!list.item(i).getNodeName().startsWith("DOOCS")) continue;
                String subname = list.item(i).getAttributes().getNamedItem("name").getNodeValue();
                String constraints = "new ScaleConstraints(" + list.item(i).getAttributes().getNamedItem("bounds").getNodeValue() + ")";
                if (isFrame) {
                    code.append("\t\t" + name + ".add((JComponent)" + subname + ", " + constraints + ");\n");
                } else if (node != rootNode) {
                    code.append("\t\t" + name + ".add((JComponent)" + subname + ", " + constraints + ");\n");
                } else {
                    code.append("\t\tthis.add((JComponent)" + subname + ", " + constraints + ");\n");
                }
                SourceCreator.addComponents(list.item(i), isFrame);
            }
        }
    }

    public static void getProperties(Node node, boolean isFrame) {
        if (node.getNodeName().startsWith("DOOCS")) {
            String name = node.getAttributes().getNamedItem("name").getNodeValue();
            if (node.getNodeName().equalsIgnoreCase("DOOCSLayeredPane") || node.getNodeName().equalsIgnoreCase("DOOCSGroup") || node.getNodeName().equalsIgnoreCase("DOOCSIfCase") || node.getNodeName().equalsIgnoreCase("DOOCSSwitchCase")) {
                String dim = node.getAttributes().getNamedItem("bounds").getNodeValue();
                dim = dim.substring(dim.indexOf(",") + 1);
                dim = dim.substring(dim.indexOf(",") + 1);
                if (isFrame) {
                    code.append("\t\t" + name + ".setLayout(new ScaleLayout(new Dimension(" + dim + ")));\n");
                } else if (node != rootNode) {
                    code.append("\t\t" + name + ".setLayout(new ScaleLayout(new Dimension(" + dim + ")));\n");
                } else {
                    code.append("\t\tthis.setLayout(new ScaleLayout(new Dimension(" + dim + ")));\n");
                }
            }
            NodeList list = node.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                if (!list.item(i).getNodeName().startsWith("DOOCS")) {
                    String parameter = list.item(i).getNodeName();
                    if (list.item(i).getFirstChild() == null) continue;
                    String value = list.item(i).getFirstChild().getNodeValue();
                    if (isFrame) {
                        code.append("\t\t" + name + ".setDOOCSParameter(\"" + parameter + "\", \"" + value + "\");\n");
                        continue;
                    }
                    if (node != rootNode) {
                        code.append("\t\t" + name + ".setDOOCSParameter(\"" + parameter + "\", \"" + value + "\");\n");
                        continue;
                    }
                    code.append("\t\tthis.setDOOCSParameter(\"" + parameter + "\", \"" + value + "\");\n");
                    continue;
                }
                SourceCreator.getProperties(list.item(i), isFrame);
            }
        }
    }

    public static ScaleConstraints getConstraints(String constr) {
        int komma1 = constr.indexOf(",");
        int komma2 = constr.indexOf(",", komma1 + 1);
        int komma3 = constr.indexOf(",", komma2 + 1);
        int x = IntegerParser.parseInt(constr.substring(0, komma1));
        int y = IntegerParser.parseInt(constr.substring(komma1 + 1, komma2));
        int width = IntegerParser.parseInt(constr.substring(komma2 + 1, komma3));
        int height = IntegerParser.parseInt(constr.substring(komma3 + 1));
        ScaleConstraints newConstraints = new ScaleConstraints(x, y, width, height);
        return newConstraints;
    }

    static {
        code = new StringBuffer();
    }
}

