/*
 * Decompiled with CFR 0.152.
 */
package xmlparser;

import DOOCSComponents.DOOCSAlive;
import DOOCSComponents.DOOCSAudio;
import DOOCSComponents.DOOCSButton;
import DOOCSComponents.DOOCSButtonAdrList;
import DOOCSComponents.DOOCSCameraImage;
import DOOCSComponents.DOOCSCheckBox;
import DOOCSComponents.DOOCSColouredIndicator;
import DOOCSComponents.DOOCSComboBox;
import DOOCSComponents.DOOCSComponent;
import DOOCSComponents.DOOCSDeviceTree;
import DOOCSComponents.DOOCSDial;
import DOOCSComponents.DOOCSDynamicList;
import DOOCSComponents.DOOCSGroup;
import DOOCSComponents.DOOCSIcon;
import DOOCSComponents.DOOCSIf;
import DOOCSComponents.DOOCSIfCase;
import DOOCSComponents.DOOCSIncludeComponent;
import DOOCSComponents.DOOCSLabel;
import DOOCSComponents.DOOCSLayeredPane;
import DOOCSComponents.DOOCSLine;
import DOOCSComponents.DOOCSLocationChooser;
import DOOCSComponents.DOOCSLogicGroup;
import DOOCSComponents.DOOCSOval;
import DOOCSComponents.DOOCSParameter;
import DOOCSComponents.DOOCSProgressBar;
import DOOCSComponents.DOOCSPropertiesTable;
import DOOCSComponents.DOOCSRect;
import DOOCSComponents.DOOCSSlider;
import DOOCSComponents.DOOCSStatusRegister;
import DOOCSComponents.DOOCSSwitch;
import DOOCSComponents.DOOCSSwitchCase;
import DOOCSComponents.DOOCSTab;
import DOOCSComponents.DOOCSTabbedPane;
import DOOCSComponents.DOOCSTextArea;
import DOOCSComponents.DOOCSTextField;
import DOOCSComponents.DOOCSTimerGroup;
import DOOCSComponents.DOOCSToggleButton;
import DOOCSComponents.DOOCSTriangle;
import DOOCSComponents.DOOCSValue;
import DOOCSPlot.DOOCSPlot;
import DOOCSPlot.DOOCSPlotHist;
import DOOCSPlot.DOOCSPlotLocation;
import DOOCSPlot.DOOCSPlotSpectrum;
import DOOCSPlot.DOOCSPlotXY;
import editor.StartParameters;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.net.URLClassLoader;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import layoutmanager.ScaleConstraints;
import layoutmanager.ScaleLayout;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import ttf.doocs.clnt.EqAdr;
import xmlparser.IntegerParser;

public class DOOCSParser {
    private static String pluginPath = null;
    private static URLClassLoader newCL;

    public static void parseFile(DOOCSComponent panel, File xmlFile) {
        Document doc = DOOCSParser.parseXmlFile(xmlFile, false);
        if (doc != null) {
            Node rootNode = doc.getLastChild();
            if (!rootNode.getNodeName().equalsIgnoreCase("DOOCSLayeredPane")) {
                rootNode = rootNode.getFirstChild();
            }
            if (rootNode.getNodeName().equalsIgnoreCase("DOOCSLayeredPane")) {
                String name = rootNode.getAttributes().getNamedItem("name").getNodeValue();
                String constr = rootNode.getAttributes().getNamedItem("bounds").getNodeValue();
                ScaleConstraints newConstraints = DOOCSParser.getConstraints(constr);
                int x = newConstraints.getWidth();
                int y = newConstraints.getHeight();
                panel.setLayout(new ScaleLayout(new Dimension(x, y)));
                panel.setSize(new Dimension(x, y));
                panel.setPreferredSize(new Dimension(x, y));
                panel.setName(name);
                ((DOOCSLayeredPane)panel).setDoocsXmlFilePath(xmlFile.getPath());
                if (rootNode.hasChildNodes()) {
                    DOOCSParser.setPluginPath();
                    DOOCSParser.parseNode(rootNode, panel);
                    if (panel.getDOOCSParameter("adr") != null) {
                        ((DOOCSLayeredPane)panel).setFullDoocsAddress(panel.getDOOCSParameter("adr").toString());
                    }
                    DOOCSParser.inherit(panel);
                }
            }
        }
    }

    public static void parseStringBuffer(DOOCSComponent panel, byte[] xmlBuffer) {
        Document doc = DOOCSParser.parseXmlStringBuffer(xmlBuffer, false);
        if (doc != null) {
            Node rootNode = doc.getLastChild();
            if (!rootNode.getNodeName().equalsIgnoreCase("DOOCSLayeredPane")) {
                rootNode = rootNode.getFirstChild();
            }
            if (rootNode.getNodeName().equalsIgnoreCase("DOOCSLayeredPane")) {
                String name = rootNode.getAttributes().getNamedItem("name").getNodeValue();
                String constr = rootNode.getAttributes().getNamedItem("bounds").getNodeValue();
                ScaleConstraints newConstraints = DOOCSParser.getConstraints(constr);
                int x = newConstraints.getWidth();
                int y = newConstraints.getHeight();
                panel.setLayout(new ScaleLayout(new Dimension(x, y)));
                panel.setSize(new Dimension(x, y));
                panel.setPreferredSize(new Dimension(x, y));
                panel.setName(name);
                if (rootNode.hasChildNodes()) {
                    DOOCSParser.setPluginPath();
                    DOOCSParser.parseNode(rootNode, panel);
                    if (panel.getDOOCSParameter("adr") != null) {
                        ((DOOCSLayeredPane)panel).setFullDoocsAddress(panel.getDOOCSParameter("adr").toString());
                    }
                    DOOCSParser.inherit(panel);
                }
            }
        }
    }

    public static void setPluginPath() {
        pluginPath = StartParameters.getInstance().getPluginPath();
        if (pluginPath != null && pluginPath.length() > 0) {
            newCL = StartParameters.getInstance().getClassLoader();
        }
    }

    public static void parseNode(Node pNode, DOOCSComponent comp) {
        NodeList list = pNode.getChildNodes();
        for (int i = 0; i < list.getLength(); ++i) {
            Node subNode = list.item(i);
            String nodeName = subNode.getNodeName();
            if (nodeName.equals("#text")) continue;
            if (nodeName.startsWith("DOOCS")) {
                int y;
                String name = subNode.getAttributes().getNamedItem("name").getNodeValue();
                String constr = subNode.getAttributes().getNamedItem("bounds").getNodeValue();
                ScaleConstraints newConstraints = DOOCSParser.getConstraints(constr);
                DOOCSComponent subcomp = null;
                if (nodeName.equals("DOOCSLabel")) {
                    subcomp = new DOOCSLabel();
                } else if (nodeName.equals("DOOCSValue")) {
                    subcomp = new DOOCSValue();
                } else if (nodeName.equals("DOOCSDial")) {
                    subcomp = new DOOCSDial();
                } else if (nodeName.equals("DOOCSCheckBox")) {
                    subcomp = new DOOCSCheckBox();
                } else if (nodeName.equals("DOOCSProgressBar")) {
                    subcomp = new DOOCSProgressBar();
                } else if (nodeName.equals("DOOCSSlider")) {
                    subcomp = new DOOCSSlider();
                } else if (nodeName.equals("DOOCSButton")) {
                    subcomp = new DOOCSButton();
                } else if (nodeName.equals("DOOCSToggleButton")) {
                    subcomp = new DOOCSToggleButton();
                } else if (nodeName.equals("DOOCSPlotSpectrum")) {
                    subcomp = new DOOCSPlotSpectrum();
                } else if (nodeName.equals("DOOCSPlotHist")) {
                    subcomp = new DOOCSPlotHist();
                } else if (nodeName.equals("DOOCSPlotLocation")) {
                    subcomp = new DOOCSPlotLocation();
                } else if (nodeName.equals("DOOCSPlotXY")) {
                    subcomp = new DOOCSPlotXY();
                } else if (nodeName.equals("DOOCSIcon")) {
                    subcomp = new DOOCSIcon();
                } else if (nodeName.equals("DOOCSCameraImage")) {
                    subcomp = new DOOCSCameraImage();
                } else if (nodeName.equals("DOOCSTextField")) {
                    subcomp = new DOOCSTextField();
                } else if (nodeName.equals("DOOCSTextArea")) {
                    subcomp = new DOOCSTextArea();
                } else if (nodeName.equals("DOOCSPropertiesTable")) {
                    subcomp = new DOOCSPropertiesTable();
                } else if (nodeName.equals("DOOCSDeviceTree")) {
                    subcomp = new DOOCSDeviceTree();
                } else if (nodeName.equals("DOOCSDynamicList")) {
                    subcomp = new DOOCSDynamicList();
                } else if (nodeName.equals("DOOCSAudio")) {
                    subcomp = new DOOCSAudio();
                } else if (nodeName.equals("DOOCSRect")) {
                    subcomp = new DOOCSRect();
                } else if (nodeName.equals("DOOCSTriangle")) {
                    subcomp = new DOOCSTriangle();
                } else if (nodeName.equals("DOOCSOval")) {
                    subcomp = new DOOCSOval();
                } else if (nodeName.equals("DOOCSStatusRegister")) {
                    subcomp = new DOOCSStatusRegister();
                } else if (nodeName.equals("DOOCSColouredIndicator")) {
                    subcomp = new DOOCSColouredIndicator();
                } else if (nodeName.equals("DOOCSComboBox")) {
                    subcomp = new DOOCSComboBox();
                } else if (nodeName.equals("DOOCSLocationChooser")) {
                    subcomp = new DOOCSLocationChooser();
                } else if (nodeName.equals("DOOCSLine")) {
                    subcomp = new DOOCSLine();
                } else if (nodeName.equals("DOOCSSwitch")) {
                    subcomp = new DOOCSSwitch();
                } else if (nodeName.equals("DOOCSIf")) {
                    subcomp = new DOOCSIf();
                } else if (nodeName.equals("DOOCSTabbedPane")) {
                    subcomp = new DOOCSTabbedPane();
                } else if (nodeName.equals("DOOCSTab")) {
                    subcomp = new DOOCSTab();
                    int x = newConstraints.getWidth();
                    y = newConstraints.getHeight();
                    subcomp.setLayout(new ScaleLayout(new Dimension(x, y)));
                } else if (nodeName.equals("DOOCSIncludeComponent")) {
                    subcomp = new DOOCSIncludeComponent();
                    int x = newConstraints.getWidth();
                    y = newConstraints.getHeight();
                    subcomp.setLayout(new ScaleLayout(new Dimension(x, y)));
                } else if (nodeName.equals("DOOCSSwitchCase")) {
                    subcomp = new DOOCSSwitchCase();
                    int x = newConstraints.getWidth();
                    y = newConstraints.getHeight();
                    subcomp.setLayout(new ScaleLayout(new Dimension(x, y)));
                } else if (nodeName.equals("DOOCSIfCase")) {
                    subcomp = new DOOCSIfCase();
                    int x = newConstraints.getWidth();
                    y = newConstraints.getHeight();
                    subcomp.setLayout(new ScaleLayout(new Dimension(x, y)));
                } else if (nodeName.equals("DOOCSLayeredPane")) {
                    subcomp = new DOOCSLayeredPane();
                    int x = newConstraints.getWidth();
                    y = newConstraints.getHeight();
                    subcomp.setLayout(new ScaleLayout(new Dimension(x, y)));
                } else if (nodeName.equals("DOOCSGroup")) {
                    subcomp = new DOOCSGroup();
                    int x = newConstraints.getWidth();
                    y = newConstraints.getHeight();
                    subcomp.setLayout(new ScaleLayout(new Dimension(x, y)));
                } else if (nodeName.equals("DOOCSLogicGroup")) {
                    subcomp = new DOOCSLogicGroup();
                    int x = newConstraints.getWidth();
                    y = newConstraints.getHeight();
                    subcomp.setLayout(new ScaleLayout(new Dimension(x, y)));
                } else if (nodeName.equals("DOOCSTimerGroup")) {
                    subcomp = new DOOCSTimerGroup();
                    int x = newConstraints.getWidth();
                    y = newConstraints.getHeight();
                    subcomp.setLayout(new ScaleLayout(new Dimension(x, y)));
                } else if (nodeName.equals("DOOCSAlive")) {
                    subcomp = new DOOCSAlive();
                    int x = newConstraints.getWidth();
                    y = newConstraints.getHeight();
                    subcomp.setLayout(new ScaleLayout(new Dimension(x, y)));
                } else {
                    try {
                        if (pluginPath != null && pluginPath.length() > 0) {
                            Class<?> cl = newCL.loadClass(nodeName);
                            subcomp = (DOOCSComponent)cl.newInstance();
                        } else {
                            JOptionPane.showMessageDialog(null, "Please check your Plugin Path.\nCouldn't find " + nodeName + ".");
                        }
                    }
                    catch (ClassNotFoundException ex) {
                        System.out.println("DOOCSParser: " + ex);
                    }
                    catch (InstantiationException ex) {
                        System.out.println("DOOCSParser: " + ex);
                    }
                    catch (IllegalAccessException ex) {
                        System.out.println("DOOCSParser: " + ex);
                    }
                }
                if (subcomp == null) continue;
                subcomp.setName(name);
                ((Component)((Object)subcomp)).setBounds(DOOCSParameter.convertToBounds(constr));
                subcomp.setInitialBounds(DOOCSParameter.convertToBounds(constr));
                comp.add((Component)((Object)subcomp), newConstraints);
                DOOCSParser.parseNode(subNode, subcomp);
                continue;
            }
            String parameter = subNode.getNodeName();
            String value = null;
            if (subNode.hasChildNodes()) {
                value = subNode.getFirstChild().getNodeValue();
            }
            if (parameter.equalsIgnoreCase("adr") && value == null && comp.getDOOCSParameter("adr") != null) continue;
            if (comp instanceof DOOCSIcon) {
                if (parameter.equalsIgnoreCase("iconFile") || parameter.equalsIgnoreCase("rotate")) {
                    Rectangle iconBounds = comp.getBounds();
                    comp.setDOOCSParameter(parameter, value);
                    ((DOOCSIcon)comp).setBounds(iconBounds);
                    ((DOOCSIcon)comp).setInitialBounds(iconBounds);
                    continue;
                }
                comp.setDOOCSParameter(parameter, value);
                continue;
            }
            if (comp instanceof DOOCSButton && parameter.equalsIgnoreCase("rotate")) {
                comp.setDOOCSParameter("rotateText", value);
                continue;
            }
            if (comp instanceof DOOCSToggleButton && parameter.equalsIgnoreCase("rotate")) {
                comp.setDOOCSParameter("rotateText", value);
                continue;
            }
            comp.setDOOCSParameter(parameter, value);
        }
    }

    public static void inherit(DOOCSComponent panel) {
        for (int i = 0; i < panel.getComponentCount(); ++i) {
            DOOCSComponent comp = (DOOCSComponent)((Object)panel.getComponent(i));
            String sadr = null;
            if (comp instanceof DOOCSLogicGroup) {
                sadr = comp.getDOOCSParameter("logicAdr").toString();
                comp.setFullDoocsAddress(DOOCSParser.inheritDoocsAddress(panel, sadr));
            } else {
                if (comp.getDOOCSParameter("adr") != null) {
                    sadr = comp.getDOOCSParameter("adr").toString();
                }
                comp.setFullDoocsAddress(DOOCSParser.inheritDoocsAddress(panel, sadr));
            }
            if (comp instanceof DOOCSIfCase || comp instanceof DOOCSSwitchCase) {
                comp.setFullDoocsAddress(DOOCSParser.inheritDoocsAddress((DOOCSComponent)((Object)panel.getParent()), sadr));
            }
            if (comp instanceof DOOCSDynamicList) {
                String dynamicListAddress = comp.getFullDoocsAddress();
                ((DOOCSDynamicList)comp).layeredPane.setFullDoocsAddress(dynamicListAddress);
            }
            if (comp instanceof DOOCSButton) {
                DOOCSButtonAdrList list = ((DOOCSButton)comp).doocsAdrList;
                for (int j = 0; j < list.size(); ++j) {
                    list.setFullDoocsAddress(j, DOOCSParser.inheritDoocsAddress(panel, list.getDoocsAddress(j)));
                }
            }
            if (comp instanceof DOOCSAlive) {
                String XposAdr = ((DOOCSAlive)comp).getDoocsXposAdr();
                String YposAdr = ((DOOCSAlive)comp).getDoocsYposAdr();
                String widthAdr = ((DOOCSAlive)comp).getDoocsWidthAdr();
                String heightAdr = ((DOOCSAlive)comp).getDoocsHeightAdr();
                ((DOOCSAlive)comp).setFullDoocsXposAdr(DOOCSParser.inheritDoocsAddress(panel, XposAdr));
                ((DOOCSAlive)comp).setFullDoocsYposAdr(DOOCSParser.inheritDoocsAddress(panel, YposAdr));
                ((DOOCSAlive)comp).setFullDoocsWidthAdr(DOOCSParser.inheritDoocsAddress(panel, widthAdr));
                ((DOOCSAlive)comp).setFullDoocsHeightAdr(DOOCSParser.inheritDoocsAddress(panel, heightAdr));
            }
            if (comp instanceof DOOCSPlot && (panel instanceof DOOCSLayeredPane || panel instanceof DOOCSTabbedPane || panel instanceof DOOCSDynamicList)) {
                ((DOOCSPlot)comp).mergeBaseAdr();
            }
            if (!(comp instanceof DOOCSTabbedPane) && !(comp instanceof DOOCSLayeredPane)) continue;
            DOOCSParser.inherit(comp);
        }
    }

    public static String inheritDoocsAddress(DOOCSComponent comp, String sadr) {
        if (comp instanceof DOOCSLayeredPane || comp instanceof DOOCSTabbedPane || comp instanceof DOOCSDynamicList || comp instanceof DOOCSButton) {
            String adr = comp.getFullDoocsAddress();
            if (adr != null && adr.length() > 3 && sadr != null) {
                EqAdr ea = new EqAdr(adr);
                ea.merge(sadr);
                sadr = ea.show_adr();
            }
            if (sadr == null && adr != null) {
                sadr = adr;
            }
        }
        return sadr;
    }

    private static ScaleConstraints getConstraints(String constr) {
        int komma1 = constr.indexOf(",");
        int komma2 = constr.indexOf(",", komma1 + 1);
        int komma3 = constr.indexOf(",", komma2 + 1);
        int x = IntegerParser.parseInt(constr.substring(0, komma1));
        int y = IntegerParser.parseInt(constr.substring(komma1 + 1, komma2));
        int width = IntegerParser.parseInt(constr.substring(komma2 + 1, komma3));
        int height = IntegerParser.parseInt(constr.substring(komma3 + 1));
        ScaleConstraints newConstraints = new ScaleConstraints(x, y, width, height);
        return newConstraints;
    }

    public static Document parseXmlFile(File dddfile, boolean validating) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(validating);
            factory.setIgnoringComments(true);
            factory.setExpandEntityReferences(true);
            Document doc = factory.newDocumentBuilder().parse(dddfile);
            doc.normalize();
            return doc;
        }
        catch (SAXException e) {
            System.out.println("DOOCSParser: " + e);
        }
        catch (ParserConfigurationException e) {
            System.out.println("DOOCSParser: " + e);
        }
        catch (IOException e) {
            System.out.println("DOOCSParser: " + e);
        }
        return null;
    }

    public static Document parseXmlStringBuffer(byte[] xmlBuffer, boolean validating) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setValidating(validating);
            factory.setIgnoringComments(true);
            factory.setExpandEntityReferences(true);
            ByteArrayInputStream bis = new ByteArrayInputStream(xmlBuffer);
            Document doc = factory.newDocumentBuilder().parse(bis);
            doc.normalize();
            return doc;
        }
        catch (SAXException e) {
            System.out.println("DOOCSParser: " + e);
        }
        catch (ParserConfigurationException e) {
            System.out.println("DOOCSParser: " + e);
        }
        catch (IOException e) {
            System.out.println("DOOCSParser: " + e);
        }
        return null;
    }
}

